/*  
	Copyright (C) 2006 Salvatore Scarciglia <laas.mono@gmail.com>
	http://laas.altervista.org

    This code is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This code is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

*/
using Gdk;
using Gtk;
using System;


public class YTTrayIcon {
	private ImageMenuItem [] menuPopup = new ImageMenuItem[4];
	private static StatusIcon trayIcon;
 	private Gtk.Window	mainWin;
 	private ytApp			yta;
	
	public YTTrayIcon(Gtk.Window mwin,ytApp y) {
		mainWin = mwin;
		yta = y;
		trayIcon = new StatusIcon(new Gdk.Pixbuf(null,"yTicon.png"));
		trayIcon.PopupMenu += OnTrayIconPopup;
		trayIcon.Tooltip = "YouTranslate! 1";
		trayIcon.Visible = true;
	}
	
	private void OnTrayIconPopup (object o, EventArgs args) {
		    string [] menuTxt = {"Show YouTranslate!","Preferences","About","Quit"};
		    string [] stockIcon = {Stock.Fullscreen, Stock.Preferences, Stock.About, Stock.Quit};
      		Menu popupMenu = new Menu();
		   for(int k = 0;k<menuTxt.Length;k++){
			    menuPopup[k] = new ImageMenuItem(menuTxt[k]);
			    menuPopup[k].Image = new Gtk.Image(stockIcon[k], IconSize.Menu);
			    popupMenu.Add(menuPopup[k]);
			    menuPopup[k].Activated+=new EventHandler(this.OnPopupClick);
        	}
			popupMenu.ShowAll(); 
      		popupMenu.Popup(); 
	}
	
	private void OnPopupClick(object o, EventArgs args) {
		ImageMenuItem sender = (ImageMenuItem) o;
		if(sender==menuPopup[0]) {
			mainWin.Deiconify();
			mainWin.ShowAll();
		}
		else if(sender==menuPopup[1]) {
			yta.showPrefs();
		}
		else if(sender==menuPopup[3]) {
			yta.savePrefs();
			Application.Quit();
		}
		else if(sender==menuPopup[2]) {
			yta.showAbout();
		}
		
	}
	
}