/*  
	Copyright (C) 2006 Salvatore Scarciglia <laas.mono@gmail.com>
	http://laas.altervista.org

    This code is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This code is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

*/

using System;
using System.Xml;

public class yTUserProfile {
	private string 	_language1;
	private string 	_language2;
	private int	 	_providerID;
	private string 	_filename;
	private bool	_startMode;
	private bool	_allWorkspace;
	private int		_largeKey;
	
	// Constructor
	public yTUserProfile(){
		_filename = System.Environment.GetEnvironmentVariable("HOME")+"/.ytSettings";
		_language1 = "en";
		_language2 = "en";
		_largeKey = 12;
		_startMode = false;
		_allWorkspace = false;
		_providerID = 1;
	}
		
	// Read settings		
	public void readSettings(){
		XmlDocument xdsettings = new XmlDocument();
		_providerID = 1;
 		try{
 			xdsettings.Load(_filename);
 			XmlTextReader xr = new XmlTextReader(_filename);
			while(xr.Read()){ 
				if(xr.NodeType == XmlNodeType.Element) {
					if(xr.Name=="YTSETTINGS"){
						while(xr.MoveToNextAttribute()){
							if(xr.Name=="LANG1") _language1 = xr.Value;
							else if(xr.Name=="LANG2") _language2 = xr.Value;
							else if(xr.Name=="SMODE") _startMode = getSMode(xr.Value);
							else if(xr.Name=="SHOWA") _allWorkspace = getSMode(xr.Value);
							else if(xr.Name=="LGKEY") _largeKey =  Convert.ToInt16(xr.Value);
						}
					}
				}
			}
			xr.Close();
 		}
 		catch(Exception){ 
			saveBookmarks(true);
 		}	
	}

	private bool getSMode(string s){
		if(s=="T") return true;
		else return false;
	}
	
	private string setSMode(bool s){
		if(s==true) return "T";
		else return "F";
	}
	

	// Save settings		
	public void saveBookmarks(bool firsttime){
		XmlDocument xdsettings = new XmlDocument();
 		XmlElement xe = xdsettings.CreateElement("YOUTRANSLATE");
 		xdsettings.AppendChild(xe);
 		if(!firsttime) {
			XmlElement xpe = xdsettings.CreateElement("YTSETTINGS");
 			xpe.SetAttribute("LANG1",(string)_language1);
 			xpe.SetAttribute("LANG2",(string)_language2);
 			xpe.SetAttribute("TPROV",_providerID+"");
 			xpe.SetAttribute("SMODE",setSMode(_startMode)+"");
 			xpe.SetAttribute("SHOWA",setSMode(_allWorkspace)+"");
 			xpe.SetAttribute("LGKEY",_largeKey+"");
 			xe.AppendChild(xpe);
 		}
 		xdsettings.Save(_filename);	
	}	
	
	// Public Properties :: start
	public string Language1 {
		get {return _language1;}
		set {_language1 = value;}		
	}	
	public string Language2 {
		get {return _language2;}
		set {_language2 = value;}		
	}	
	public int ProviderID {
		get {return _providerID;}
		set {_providerID = value;}		
	}		
	public bool startMode {
		get {return _startMode;}
		set {_startMode = value;}		
	}	
	public bool allWorkspace {
		get {return _allWorkspace;}
		set {_allWorkspace = value;}		
	}		
	public int largeKey {
		get {return _largeKey;}
		set {_largeKey = value;}		
	}		
	// Public Properties :: end
	
}