/*
Copyright (c) 2010 by Drake Justice <djustice.kde@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
*/

#ifndef BURNDATAIMAGETHREAD_H
#define BURNDATAIMAGETHREAD_H

#include <QProcess>
#include <QThread>
#include <QTimer>

class BurnDataImageThread : public QThread
{
    Q_OBJECT

    public:
        BurnDataImageThread(QObject* parent, const QString& device, const QStringList& files);
        void run();

    private slots:
        void processFinished(int);
        void processError(QProcess::ProcessError);
        void updateProgress();
        void cancelProcess();

    signals:
        void dataSize(int);
        void dataProgress(int);

    private:
        QString m_device;

        QStringList m_fileList;

        QProcess m_process;
        QProcess m_genisoProcess;
        QProcess m_wodimProcess;

        QTimer m_timer;

        int m_imageSize;

        bool m_hadError;
        bool m_wasCanceled;
};

#endif // BURNDATAIMAGETHREAD_H
