/*
   Copyright (C) 2008-2011 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <http://www.gnu.org/licenses/>.
*/
#ifndef tabbase_h
#define tabbase_h

#include <QtGui/QWidget>

class QLabel;
class QVBoxLayout;
namespace KoverArtist { class Project; };


/** The base class for side tab-pages.
 */
class TabBase: public QWidget
{
   typedef QWidget Inherited;
   Q_OBJECT

public:
   TabBase(KoverArtist::Project* project, QWidget* parent = 0);
   virtual ~TabBase();

   /** Returns the project. */
   KoverArtist::Project* project() { return mProject; }
   const KoverArtist::Project* project() const { return mProject; }

signals:
   /** Emitted when something was changed. */
   void changed();

public slots:
   /** Update the widget from the project. */
   virtual void updateContents() = 0;

protected:
   /** Create a caption label line. The label is automatically
    *  appended to the main box-layout.
    */
   virtual QLabel* createCaption(const QString& text);

   /** Create a line with the @ref QWidget widget and the @ref QString
    *  text as a label. The @ref Qt::Alignment alignment align may be either
    *  @ref Qt::AlignLeft to place the label left of the widget, or
    *  @ref Qt::AlignRight to place the label right of the widget.
    *  The label is returned.
    */
   virtual QLabel* createLine(QWidget* widget, const QString& text,
                              Qt::Alignment align);

private:
   TabBase(const TabBase&);
   TabBase& operator=(const TabBase&);

protected:
   KoverArtist::Project* mProject;
   QVBoxLayout* mMainBox;
   QFont mFntCaption;
};

#endif /*tabbase_h*/
