/**
 * ===========================================
 * LibBase : a free Java utility library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libbase
 *
 * (C) Copyright 2007,2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * GenericObjectTable
 * ------------
 * (C) Copyright 2006, by Pentaho Corporation.
 */



package org.pentaho.reporting.libraries.base.util;

/**
 * A generic table storing objects in an fast array backend. This generic class provides public getter and setters
 * for the contents of the table.
 *
 * @author Thomas Morgner
 */
public class GenericObjectTable extends ObjectTable
{
  private static final long serialVersionUID = 4870219010677984960L;

  /**
   * Creates a new object table.
   */
  public GenericObjectTable ()
  {
  }

  /**
   * Creates a new table.
   *
   * @param increment the row and column size increment.
   */
  public GenericObjectTable(final int increment)
  {
    super(increment);
  }

  /**
   * Creates a new table.
   *
   * @param rowIncrement the row size increment.
   * @param colIncrement the column size increment.
   */
  public GenericObjectTable(final int rowIncrement, final int colIncrement)
  {
    super(rowIncrement, colIncrement);
  }

  /**
   * Returns the object from a particular cell in the table. Returns null, if
   * there is no object at the given position.
   * <p/>
   * Note: throws IndexOutOfBoundsException if row or column is negative.
   *
   * @param row    the row index (zero-based).
   * @param column the column index (zero-based).
   * @return The object.
   */
  public Object getObject (final int row, final int column)
  {
    return super.getObject(row, column);
  }

  /**
   * Sets the object for a cell in the table.  The table is expanded if
   * necessary.
   *
   * @param row    the row index (zero-based).
   * @param column the column index (zero-based).
   * @param object the object.
   */
  public void setObject (final int row, final int column, final Object object)
  {
    super.setObject(row, column, object);
  }

  /**
   * Copys the contents of the old column to the new column.
   *
   * @param oldColumn the index of the old (source) column
   * @param newColumn the index of the new column
   */
  public void copyColumn (final int oldColumn, final int newColumn)
  {
    super.copyColumn(oldColumn, newColumn);
  }

  /**
   * Copys the contents of the old row to the new row. This uses raw access to
   * the data and is remarkably faster than manual copying.
   *
   * @param oldRow the index of the old row
   * @param newRow the index of the new row
   */
  public void copyRow (final int oldRow, final int newRow)
  {
    super.copyRow(oldRow, newRow);
  }
}

