/* 
 * $Id: ox11menu.h,v 1.7 2003/02/16 12:43:37 isizaka Exp isizaka $
 * 
 * This file is part of "Ngraph for X11".
 * 
 * Copyright (C) 2002, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for X11" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for X11" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/**
 *
 * $Log: ox11menu.h,v $
 * Revision 1.7  2003/02/16 12:43:37  isizaka
 * for release 6.13.18
 *
 * Revision 1.6  2002/07/06 08:57:25  isizaka
 * change to GPL.
 *
 * Revision 1.5  2001/07/14 17:44:50  isizaka
 * for 6.03.14
 *
 * Revision 1.4  2001/03/23 12:17:43  isizaka
 * for 6.3.13
 *
 * Revision 1.3  1999/04/15 12:14:26  isizaka
 * for release 6.03.01
 *
 * Revision 1.2  1999/03/20 12:32:54  isizaka
 * minor change
 *
 * Revision 1.1  1999/03/17 13:28:24  isizaka
 * Initial revision
 *
 *
 **/

#define LINETOLIMIT 500
#define X11FONTCASH 20 /* must be greater than 1 */
#define X11COLORDEPTH 2

#define CW_USEDEFAULT -100000

#define ERRRUN 100
#define ERRCMAP 101
#define ERRFONT 102

#define ISOOTHER 0
#define ISO8859 1
#define ISO10646 2

extern int globallock;
extern struct savedstdio x11iosave;

extern void mx11displaydialog(char *str);
extern void mx11displaystatus(char *str);
extern int mx11putstderr(char *s);
extern int mx11printfstderr(char *fmt,...);
extern int mx11interrupt(void);
extern int mx11inputyn(char *mes);

struct extprinter {
  char *name;
  char *driver;
  char *ext;
  char *option;
  struct extprinter *next;
};

struct prnprinter {
  char *name;
  char *driver;
  char *option;
  char *prn;
  struct prnprinter *next;
};

struct script {
  char *name;
  char *script;
  char *option;
  struct script *next;
};

struct fontlocal {
  char *fontalias;
  Font font;
  XFontStruct *fontstruct;
  int fontsize,fonttype,fontdir;
  int iso;
};

struct mxlocal {
  Drawable win; 
  GC gc;
  int scrollx,scrolly;
  int autoredraw,redrawf,ruler,backingstore;
  int windpi;
  int grid;
  Colormap cmap;
  int privatecolor,cdepth;
  double pixel_dot;
  int offsetx,offsety;
  int cpx,cpy;
  struct fontmap *fontmaproot;
  int loadfont;
  int loadfontf;
  char *fontalias;
  double fontsize,fontspace,fontcos,fontsin;
  struct fontlocal font[X11FONTCASH];
  XPoint points[LINETOLIMIT];
  Region region;
  int linetonum;
  int lock;
  int minus_hyphen;
  int font_slant;
};

struct menulocal {
  char *editor;
  char *browser;
  char *gpl;
  struct objlist *obj;
  char *inst;
  struct objlist *outputobj;
  int output;
  struct objlist *GRAobj;
  int GRAoid;
  char *GRAinst;
  int GC;
  int PaperWidth,PaperHeight;
  int LeftMargin,TopMargin;
  int PaperZoom;
  struct narray drawrable;
  struct extprinter *extprinterroot;
  struct prnprinter *prnprinterroot;
  struct script *scriptroot;
  int menuheight,menuwidth,menux,menuy;
  int fileheight,filewidth,filex,filey,fileopen;
  int axisheight,axiswidth,axisx,axisy,axisopen;
  int legendheight,legendwidth,legendx,legendy,legendopen;
  int mergeheight,mergewidth,mergex,mergey,mergeopen;
  int dialogheight,dialogwidth,dialogx,dialogy,dialogopen;
  int coordheight,coordwidth,coordx,coordy,coordopen;
  int exwindpi,exwinwidth,exwinheight,exwinbackingstore;
  int framex,framey;
  char *fileopendir;
  char *graphloaddir;
  char *expanddir;
  int expand;
  int ignorepath;
  int expandtofullpath;
  int changedirectory;
  int savehistory;
  int savepath,savewithdata,savewithmerge;
  struct narray *mathlist;
  struct narray *ngpfilelist;
  struct narray *ngpdirlist;
  struct narray *datafilelist;
  int scriptconsole,addinconsole;
  int mouseclick;
  int statusb;
  int showtip;
  int movechild;
};

enum {NORMAL=0,BOLD,ITALIC,BOLDITALIC};

struct fontmap;

struct fontmap {
  char *fontalias;
  char *fontname;
  int type;
  int twobyte;
  struct fontmap *next;
};

extern struct menulocal menulocal;
extern struct mxlocal *mxlocal;
extern int menulock;
struct fontmap;

void initwindowconfig();
int mx11windowconfig();
int mxd2p(int r);
int mxd2px(int x);
int mxd2py(int y);
int mxp2d(int r);
unsigned long RGB(int R,int G,int B);
void mxsaveGC(GC gc,Drawable d,int scrollx,int scrolly,
              struct mxlocal *mxsave,int dpi,
              Region region);
void mxrestoreGC(struct mxlocal *mxsave);
void mx_redraw(struct objlist *obj,char *inst);
void mx_inslist(struct objlist *obj,char *inst,
                struct objlist *aobj,char *ainst,char *afield,int addn);
void mx_dellist(struct objlist *obj,char *inst,int deln);
void menuadddrawrable(struct objlist *parent,struct narray *drawrable);
