/*--------------------------------------------------------------
	PostScript library           libstdps
		Written  by H.Goto , Aug. 1994
		Modified by H.Goto , Feb. 1997
--------------------------------------------------------------*/

/*--------------------------------------------------------------------
  Copyright (C) 1994-1997  Hideaki Goto

        All Rights Reserved

  Permission to use, copy, modify, and distribute this software and
  its documentation for any purpose is hereby granted without fee,
  provided that (i) the above copyright notice and this permission
  notice appear in all copies and in supporting documentation, (ii)
  the name of the author, Hideaki Goto, may not be used in any
  advertising or otherwise to promote the sale, use or other
  dealings in this software without prior written authorization
  from the author, (iii) this software may not be used for
  commercial products without prior written permission from the
  author, and (iv) the notice of the modification is specified in
  case of that the modified copies of this software are distributed.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
  THE AUTHOR WILL NOT BE RESPONSIBLE FOR ANY DAMAGE CAUSED BY THIS
  SOFTWARE.
--------------------------------------------------------------------*/


#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include	"stdps.h"


static int	papersize = 0x04;


/*------------------------------------------------------
    Set paper-size
------------------------------------------------------*/

int stdps_setsize(char *sizestr){
	int	sz;
	sz = -1;
	if ( 0 == strcmp(sizestr,"A4") )  sz = 0x04;
	if ( 0 == strcmp(sizestr,"a4") )  sz = 0x04;
	if ( sz != -1 ){
		papersize = sz;
		return(0);
	}
	return(-1);
}


/*------------------------------------------------------
    Write header infomation and macros
------------------------------------------------------*/

int	stdps_header(FILE *fp){
	int	rc;
	rc = fputs( \
		"%!PS-Adobe-2.0\n" \
		"%\n" \
		"%\n" \
		"\n" ,fp);
	if ( EOF == rc )  return(-1);
	switch ( papersize ){
	    case 0x04:
		rc = fputs( \
			"% A4-Size 295x208mm (200dpi)\n" \
			"0.0 839.4 translate 0.36135 -0.36135 scale\n" ,fp);
		break;
	}
	if ( EOF == rc )  return(-1);
	rc = fputs( \
		"% Mini mode\n" \
		"% 42.700000 797.000000 translate 0.300 -0.300 scale\n\n" \
		"% A4->B5 (on A4-paper)\n" \
		"% 100 100 translate 0.865 0.865 scale\n" \
		"% A4-Frame Box\n" \
		"% 2 setlinewidth newpath 0 0 moveto 0 2322 lineto 1638 2322 lineto 1638 0 lineto closepath stroke\n" \
		"% B5-Frame Box\n" \
		"% 2 setlinewidth newpath 0 0 moveto 0 2008 lineto 1416 2008 lineto 1416 0 lineto closepath stroke\n" \
		"\n" \
		"% X-Y Exchange.\n" \
		"% -1 1 scale 90 rotate\n\n" \
			,fp);
	if ( EOF == rc )  return(-1);

	rc = fputs( \
		"% Some useful macros\n" \
		"/sqrmark\n" \
    		"    { 2 mul neg dup 0 exch 0 exch neg dup dup 0 exch 2 div neg dup\n" \
		"        rmoveto rlineto rlineto rlineto closepath stroke } def\n" \
		"/framebox\n" \
    		"    { newpath 1 sub neg 0 exch dup neg 0 exch 5 -1 roll 0 4 2 roll\n" \
		"        8 -2 roll moveto rlineto rlineto rlineto closepath stroke } def\n" \
		"/filledbox\n" \
    		"    { newpath 1 sub neg 0 exch dup neg 0 exch 5 -1 roll 0 4 2 roll\n" \
		"        8 -2 roll moveto rlineto rlineto rlineto closepath fill } def\n" \
		"\n" \
			,fp );
	if ( EOF == rc )  return(-1);

	rc = fputs( \
		"% Initial defs.\n" \
		"0 setlinecap 0 setlinejoin\n\n\n" \
		"% ---\n\n" ,fp);
	if ( EOF == rc )  return(-1);

	return(0);
}


/*------------------------------------------------------
    Write "showpage" and other terminating strings.
------------------------------------------------------*/

int	stdps_end(FILE *fp){
	int	rc;
	rc = fputs("\nshowpage\n%end\n",fp);
	if ( EOF == rc )  return(-1);
	return(0);
}




