/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PluginManagerAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: PluginManagerAttributes::PluginManagerAttributes
//
// Purpose: 
//   Init utility for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void PluginManagerAttributes::Init()
{

    PluginManagerAttributes::SelectAll();
}

// ****************************************************************************
// Method: PluginManagerAttributes::PluginManagerAttributes
//
// Purpose: 
//   Copy utility for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void PluginManagerAttributes::Copy(const PluginManagerAttributes &obj)
{
    name = obj.name;
    type = obj.type;
    version = obj.version;
    id = obj.id;
    category = obj.category;
    enabled = obj.enabled;

    PluginManagerAttributes::SelectAll();
}

// Type map format string
const char *PluginManagerAttributes::TypeMapFormatString = PLUGINMANAGERATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t PluginManagerAttributes::TmfsStruct = {PLUGINMANAGERATTRIBUTES_TMFS};


// ****************************************************************************
// Method: PluginManagerAttributes::PluginManagerAttributes
//
// Purpose: 
//   Default constructor for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PluginManagerAttributes::PluginManagerAttributes() : 
    AttributeSubject(PluginManagerAttributes::TypeMapFormatString)
{
    PluginManagerAttributes::Init();
}

// ****************************************************************************
// Method: PluginManagerAttributes::PluginManagerAttributes
//
// Purpose: 
//   Constructor for the derived classes of PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PluginManagerAttributes::PluginManagerAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    PluginManagerAttributes::Init();
}

// ****************************************************************************
// Method: PluginManagerAttributes::PluginManagerAttributes
//
// Purpose: 
//   Copy constructor for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PluginManagerAttributes::PluginManagerAttributes(const PluginManagerAttributes &obj) : 
    AttributeSubject(PluginManagerAttributes::TypeMapFormatString)
{
    PluginManagerAttributes::Copy(obj);
}

// ****************************************************************************
// Method: PluginManagerAttributes::PluginManagerAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PluginManagerAttributes::PluginManagerAttributes(const PluginManagerAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    PluginManagerAttributes::Copy(obj);
}

// ****************************************************************************
// Method: PluginManagerAttributes::~PluginManagerAttributes
//
// Purpose: 
//   Destructor for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PluginManagerAttributes::~PluginManagerAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: PluginManagerAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PluginManagerAttributes& 
PluginManagerAttributes::operator = (const PluginManagerAttributes &obj)
{
    if (this == &obj) return *this;

    PluginManagerAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: PluginManagerAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PluginManagerAttributes::operator == (const PluginManagerAttributes &obj) const
{
    // Create the return value
    return ((name == obj.name) &&
            (type == obj.type) &&
            (version == obj.version) &&
            (id == obj.id) &&
            (category == obj.category) &&
            (enabled == obj.enabled));
}

// ****************************************************************************
// Method: PluginManagerAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PluginManagerAttributes::operator != (const PluginManagerAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: PluginManagerAttributes::TypeName
//
// Purpose: 
//   Type name method for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
PluginManagerAttributes::TypeName() const
{
    return "PluginManagerAttributes";
}

// ****************************************************************************
// Method: PluginManagerAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PluginManagerAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const PluginManagerAttributes *tmp = (const PluginManagerAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: PluginManagerAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PluginManagerAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new PluginManagerAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: PluginManagerAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PluginManagerAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new PluginManagerAttributes(*this);
    else
        retval = new PluginManagerAttributes;

    return retval;
}

// ****************************************************************************
// Method: PluginManagerAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
PluginManagerAttributes::SelectAll()
{
    Select(ID_name,     (void *)&name);
    Select(ID_type,     (void *)&type);
    Select(ID_version,  (void *)&version);
    Select(ID_id,       (void *)&id);
    Select(ID_category, (void *)&category);
    Select(ID_enabled,  (void *)&enabled);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PluginManagerAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PluginManagerAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    PluginManagerAttributes defaultObject;
    bool addToParent = false;
    // Create a node for PluginManagerAttributes.
    DataNode *node = new DataNode("PluginManagerAttributes");

    if(completeSave || !FieldsEqual(ID_name, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("name", name));
    }

    if(completeSave || !FieldsEqual(ID_type, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("type", type));
    }

    if(completeSave || !FieldsEqual(ID_version, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("version", version));
    }

    if(completeSave || !FieldsEqual(ID_id, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("id", id));
    }

    if(completeSave || !FieldsEqual(ID_category, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("category", category));
    }

    if(completeSave || !FieldsEqual(ID_enabled, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("enabled", enabled));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: PluginManagerAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
PluginManagerAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("PluginManagerAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("name")) != 0)
        SetName(node->AsStringVector());
    if((node = searchNode->GetNode("type")) != 0)
        SetType(node->AsStringVector());
    if((node = searchNode->GetNode("version")) != 0)
        SetVersion(node->AsStringVector());
    if((node = searchNode->GetNode("id")) != 0)
        SetId(node->AsStringVector());
    if((node = searchNode->GetNode("category")) != 0)
        SetCategory(node->AsStringVector());
    if((node = searchNode->GetNode("enabled")) != 0)
        SetEnabled(node->AsIntVector());
    // Ensure that the category vector will be at least as long as the id vector.
    // This is import for supporting legacy config files.
    while(category.size() < id.size())
        category.push_back("?");

}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
PluginManagerAttributes::SetName(const stringVector &name_)
{
    name = name_;
    Select(ID_name, (void *)&name);
}

void
PluginManagerAttributes::SetType(const stringVector &type_)
{
    type = type_;
    Select(ID_type, (void *)&type);
}

void
PluginManagerAttributes::SetVersion(const stringVector &version_)
{
    version = version_;
    Select(ID_version, (void *)&version);
}

void
PluginManagerAttributes::SetId(const stringVector &id_)
{
    id = id_;
    Select(ID_id, (void *)&id);
}

void
PluginManagerAttributes::SetCategory(const stringVector &category_)
{
    category = category_;
    Select(ID_category, (void *)&category);
}

void
PluginManagerAttributes::SetEnabled(const intVector &enabled_)
{
    enabled = enabled_;
    Select(ID_enabled, (void *)&enabled);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const stringVector &
PluginManagerAttributes::GetName() const
{
    return name;
}

stringVector &
PluginManagerAttributes::GetName()
{
    return name;
}

const stringVector &
PluginManagerAttributes::GetType() const
{
    return type;
}

stringVector &
PluginManagerAttributes::GetType()
{
    return type;
}

const stringVector &
PluginManagerAttributes::GetVersion() const
{
    return version;
}

stringVector &
PluginManagerAttributes::GetVersion()
{
    return version;
}

const stringVector &
PluginManagerAttributes::GetId() const
{
    return id;
}

stringVector &
PluginManagerAttributes::GetId()
{
    return id;
}

const stringVector &
PluginManagerAttributes::GetCategory() const
{
    return category;
}

stringVector &
PluginManagerAttributes::GetCategory()
{
    return category;
}

const intVector &
PluginManagerAttributes::GetEnabled() const
{
    return enabled;
}

intVector &
PluginManagerAttributes::GetEnabled()
{
    return enabled;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
PluginManagerAttributes::SelectName()
{
    Select(ID_name, (void *)&name);
}

void
PluginManagerAttributes::SelectType()
{
    Select(ID_type, (void *)&type);
}

void
PluginManagerAttributes::SelectVersion()
{
    Select(ID_version, (void *)&version);
}

void
PluginManagerAttributes::SelectId()
{
    Select(ID_id, (void *)&id);
}

void
PluginManagerAttributes::SelectCategory()
{
    Select(ID_category, (void *)&category);
}

void
PluginManagerAttributes::SelectEnabled()
{
    Select(ID_enabled, (void *)&enabled);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PluginManagerAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
PluginManagerAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_name:     return "name";
    case ID_type:     return "type";
    case ID_version:  return "version";
    case ID_id:       return "id";
    case ID_category: return "category";
    case ID_enabled:  return "enabled";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PluginManagerAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
PluginManagerAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_name:     return FieldType_stringVector;
    case ID_type:     return FieldType_stringVector;
    case ID_version:  return FieldType_stringVector;
    case ID_id:       return FieldType_stringVector;
    case ID_category: return FieldType_stringVector;
    case ID_enabled:  return FieldType_intVector;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: PluginManagerAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
PluginManagerAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_name:     return "stringVector";
    case ID_type:     return "stringVector";
    case ID_version:  return "stringVector";
    case ID_id:       return "stringVector";
    case ID_category: return "stringVector";
    case ID_enabled:  return "intVector";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PluginManagerAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PluginManagerAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const PluginManagerAttributes &obj = *((const PluginManagerAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_name:
        {  // new scope
        retval = (name == obj.name);
        }
        break;
    case ID_type:
        {  // new scope
        retval = (type == obj.type);
        }
        break;
    case ID_version:
        {  // new scope
        retval = (version == obj.version);
        }
        break;
    case ID_id:
        {  // new scope
        retval = (id == obj.id);
        }
        break;
    case ID_category:
        {  // new scope
        retval = (category == obj.category);
        }
        break;
    case ID_enabled:
        {  // new scope
        retval = (enabled == obj.enabled);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PluginManagerAttributes::GetIndexByID
//
// Purpose: 
//   Find the index of a plugin by its ID, or -1 if it does not exist
//
// Programmer: Jeremy Meredith
// Creation:   September  7, 2001
//
// ****************************************************************************

int
PluginManagerAttributes::GetIndexByID(const std::string &s) const
{
    for (size_t i=0; i<id.size(); i++)
    {
        if (id[i] == s)
            return i;
    }
    // not found -- return -1
    return -1;
}

// ****************************************************************************
// Method: PluginManagerAttributes::AddPlugin
//
// Purpose: 
//   Add a new plugin.
//
// Programmer: Jeremy Meredith
// Creation:   September  7, 2001
//
// Modifications:
//    Jeremy Meredith, Wed Nov  5 12:51:11 PST 2003
//    Added ability to disable plugins by default.
//
//    Brad Whitlock, Thu Feb  4 15:26:46 PST 2010
//    I added a category field.
//
// ****************************************************************************

void 
PluginManagerAttributes::AddPlugin(const std::string &n,
                                   const std::string &t,
                                   const std::string &v,
                                   const std::string &i,
                                   bool e)
{
    name.push_back(n);
    type.push_back(t);
    version.push_back(v);
    id.push_back(i);
    category.push_back("?");
    enabled.push_back(e);
    SelectAll();
}

// ****************************************************************************
// Method: PluginManagerAttributes::RemovePlugin
//
// Purpose: 
//   Add a new plugin.
//
// Programmer: Jeremy Meredith
// Creation:   September 27, 2001
//
// Modifications:
//   Brad Whitlock, Thu Feb  4 15:27:03 PST 2010
//   I added a category.
//
// ****************************************************************************

void 
PluginManagerAttributes::RemovePlugin(const std::string &s)
{
    int index = GetIndexByID(s);
    if (index<0)
        return;

    name   .erase(name     .begin() + index);
    type   .erase(type     .begin() + index);
    version.erase(version  .begin() + index);
    id     .erase(id       .begin() + index);
    category.erase(category.begin() + index);
    enabled.erase(enabled  .begin() + index);
    SelectAll();
}

// ****************************************************************************
// Method: PluginManagerAttributes::UniqueCategories
//
// Purpose: 
//   Get the list of unique category names for a given plugin type.
//
// Programmer: Brad Whitlock
// Creation:   Thu Feb  4 15:31:40 PST 2010
//
// Modifications:
//
// ****************************************************************************
#include <algorithm>
void 
PluginManagerAttributes::UniqueCategories(const std::string &t, stringVector &c) const
{
    c.clear();
    for(size_t i = 0; i < type.size(); ++i)
    {
        if(type[i] == t)
        {
            if(i < category.size() &&
               category[i] != "?" &&
               std::find(c.begin(), c.end(), category[i]) == c.end())
                c.push_back(category[i]);
        }
    }
    std::sort(c.begin(), c.end());
}

// ****************************************************************************
// Method: PluginManagerAttributes::GetPluginCategoryName
//
// Purpose: 
//   Get the category name for the specified plugin.
//
// Programmer: Brad Whitlock
// Creation:   Thu Feb  4 15:31:40 PST 2010
//
// Modifications:
//
// ****************************************************************************

std::string
PluginManagerAttributes::GetPluginCategoryName(const std::string &s) const
{
    std::string c("?");
    int index = GetIndexByID(s);
    if(index >= 0 && index < category.size())
    {
        c = category[index];
    }
    return c;
}

// ****************************************************************************
// Method: PluginManagerAttributes::SetPluginCategoryName
//
// Purpose: 
//   Sets the category name for the specified plugin.
//
// Programmer: Brad Whitlock
// Creation:   Thu Feb  4 15:31:40 PST 2010
//
// Modifications:
//
// ****************************************************************************

void
PluginManagerAttributes::SetPluginCategoryName(const std::string &s, const std::string &c)
{
    int index = GetIndexByID(s);
    if(index >= 0 && index < category.size())
    {
        category[index] = c;
        SelectCategory();
    }
}

// ****************************************************************************
// Method: PluginManagerAttributes::PluginCategoryNameNotSet
//
// Purpose: 
//   Returns whether the category name has been set.
//
// Programmer: Brad Whitlock
// Creation:   Thu Feb  4 15:31:40 PST 2010
//
// Modifications:
//
// ****************************************************************************

bool
PluginManagerAttributes::PluginCategoryNameNotSet(const std::string &s) const
{
    return GetPluginCategoryName(s) == "?";
}

