"""
File:		Settings.py
Purpose:	Settings handler

Author:		Copyright 2006-2010 Xavion

License:	This file is part of Q7Z.

			Q7Z is free software: you can redistribute it and/or modify
			it under the terms of the GNU Lesser General Public License as published by
			the Free Software Foundation, either version 3 of the License, or
			(at your option) any later version.

			Q7Z is distributed in the hope that it will be useful,
			but WITHOUT ANY WARRANTY; without even the implied warranty of
			MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
			GNU Lesser General Public License for more details.

			You should have received a copy of the GNU Lesser General Public License
			along with Q7Z.  If not, see <http://www.gnu.org/licenses/>.
"""


### Imports

# App 1
import	Import

# Python
try :
	import	os, platform, sys
	from subprocess import *
	from datetime import date
except :
	Import.slException("Python")

# PyQt4
try :
	from	PyQt4	import QtCore, QtNetwork
except :
	Import.slException("PyQt4")

# App 2
import	Display, File, Main


### Variables

# Author
Author					= QtCore.QObject()
Author.sName			= "Xavion"
Author.Email			= QtCore.QObject()
Author.Email.sUser		= "Q7Z@"
Author.Email.sDomain	= "Xavion.name"

# Application
Application				= QtCore.QObject()
Application.sName		= "Q7Z"
Application.sVersion	= "0.9.1"
Application.sDomain		= "k7z.sourceforge.net"
Application.sWebsite	= "http://" + Application.sDomain
Application.sCurrent	= "/7Z/" + Application.sName + "/Current.txt"
Application.sAbout1		=	Application.sName + " v" + Application.sVersion + "\n"
Application.sAbout2		=	"\nQ7Z is a P7Zip GUI for Linux.  It was designed by " + Author.sName + ".\n" \
							"\nP7Zip is a high-compression file archiver.  It was designed by Igor Pavlov.\n" \
							"\nSeek further information or send feedback via the 'Help' menu.\n"
Application.sUsage		=	"\nUsage:\n\t" + \
							Application.sName + ".pyw [commands] [files]\n" \
							"\nCommands:\n\n" \
							"\tc: Create archive\n" \
							"\te: Extract archive\n" \
							"\tt: Test archive\n\n" \
							"\tCreate:\n" \
							"\tL: List file\n" \
							"\td: 'Default' profile\n" \
							"\tf: 'Flash' profile\n" \
							"\tl: 'Local' profile\n" \
							"\tr: 'Remote' profile\n" \
							"\ts: 'Storage' profile\n\n" \
							"\tExtract:\n" \
							"\tb: Beneath\n\n" \
							"\ti: Invisible\n" \
							"\tu: No auto updates\n" \
							"\tv: Verbose\n" \
							"\th: Help\n"

# Qt
QtCore.QCoreApplication.setApplicationName(Application.sName)
QtCore.QCoreApplication.setOrganizationName(Author.sName)
QtCore.QCoreApplication.setOrganizationDomain(Application.sDomain)

# Operating system
sOS					= platform.system()

# Environment
Env				= QtCore.QObject()
Env.sDate		= date.today().isoformat()
Env.sUser		= os.getenv('USER') or ""
Env.sLogName	= os.getenv('LOGNAME') or ""
Env.sHome		= os.getenv('HOME') or ""
Env.sProxy		= os.getenv('http_proxy') or ""
#Env.sKDESV		= os.getenv('KDE_SESSION_VERSION') or ""

if not len(Env.sUser) :
	Env.sUser	= Env.sLogName

if not len(Env.sHome) :
	Env.sHome	= os.path.expanduser('~')
	#Env.sHome	= '/home/' + Env.sUser

# Path
Path				= QtCore.QObject()
Path.App			= QtCore.QObject()
Path.App.sPrefix	= ""
Path.App.sSBin		= ""
Path.App.sInstall	= "/share/" + Application.sName
Path.App.sConfig	= Env.sHome + '/.config/' + Author.sName + "/" + Application.sName
Path.KDE				= QtCore.QObject()
Path.KDE.sAutoStart		= ""
Path.KDE.sConfig		= ""
Path.KDE.sPrefix		= ""
Path.KDE.sLocalPrefix	= ""
Path.Xfce				= QtCore.QObject()
Path.Xfce.sAutoStart	= Env.sHome + '/.config/autostart/'
Path.Sys			= QtCore.QObject()
Path.Sys.sPrefix	= "/usr"
Path.Sys.sSBin		= Path.Sys.sPrefix + "/sbin"
Path.Sys.sBin		= Path.Sys.sPrefix + "/bin"
Path.Local			= QtCore.QObject()
Path.Local.sPrefix	= Env.sHome + "/.local"
Path.Local.sSBin	= Path.Local.sPrefix + "/sbin"
Path.Local.sBin		= Path.Local.sPrefix + "/bin"
Path.Proxy			= QtNetwork.QNetworkProxy()

# Init
Init				= QtCore.QObject()
#Init.bVerbose		= False
#Init.bInvisible	= False
Init.bAutoUpdate	= True
Init.bAutoQuit		= False
Init.Create						= QtCore.QObject()
Init.Create.sProfile		= "Default"
Init.Create.sList			= ""
Init.Extract					= QtCore.QObject()
Init.Extract.bBeneath	= False

# Timer
Timer					= QtCore.QObject()
Timer.Process			= QtCore.QObject()
Timer.Process.iPause	= 500
Timer.Process.iWaitMax	= 100

# Exec
Exec			= QtCore.QObject()
Exec.bKilled	= False
Exec.sCommand	= ""
Exec.P7Zip		= QtCore.QObject()
Exec.P7Zip.CLI	= QtCore.QObject()
Exec.P7Zip.GUI	= QtCore.QObject()
Exec.Tar		= QtCore.QObject()

# Message
Message					= QtCore.QObject()
Message.iClear			= 0
Message.iTitle			= 1
Message.iStatus			= 2
Message.iTray			= 3
Message.iTrayTip		= 4
Message.iInformation	= 5
Message.iWarning		= 6
Message.iError			= 7
Message.iQuestion		= 8

# Input
Input			= QtCore.QObject()
Input.iNumArgs	= len(sys.argv)

# String-lists
List				= QtCore.QObject()
List.slFiles		= []

# Operations
Operation					= QtCore.QObject()
Operation.iAny			= 0
Operation.iCreate		= 1
Operation.iExtract	= 2
Operation.iTest			= 3
Operation.iActive		= Operation.iAny

# Setting
Settings				= QtCore.QSettings()
User					= QtCore.QObject()
User.Appearance			= QtCore.QObject()
User.Appearance.bARC	= False
User.Syntax				= QtCore.QObject()
User.Syntax.sExclusions	= "*.svn *Trash* *.sys"
#User.smCurrent			= QtGui.QSessionManager()

URL					= QtCore.QObject()
URL.sDoc			= Application.sWebsite + "/7Z/Doc/HTML/"
URL.sP7Zip		= "http://p7zip.sourceforge.net/"
URL.sQt			= "http://www.trolltech.com/products/qt"
URL.sPyQt		= "http://www.riverbankcomputing.co.uk/software/pyqt/intro"
URL.sPython		= "http://www.python.org/"
URL.sTar			= "http://www.gnu.org/software/tar/"
URL.sMake		= "http://www.gnu.org/software/make/"
URL.sEric		= "http://eric-ide.python-projects.org/"


### Slots

# Inits
def slInits() :

	slLoad()
	slView()
	slVariables()
	slFiles()
	slServiceMenus(False)

	# Display
	Display.slInits()


# Variables
def slVariables() :

	# Linux
	if sOS == "Linux" :

		slPaths()
		slProxy()

		# Verbose
		File.slVariables()

	# Others
	else :

		# Reject
		print("\nUnfortunately, your OS is not yet supported by " + Application.sName + " v" + Application.sVersion + ".")
		print("Please email the author, specifying your system details.\n")

		# Exit
		sys.exit()


# Paths
def slPaths() :

		# KDE Configs
		pShell = Popen(["which", "kde-config"], stdout=PIPE, stderr=PIPE)
		Path.KDE.sConfig3 = bytes.decode(pShell.communicate()[0]).rstrip('\n')
		pShell = Popen(["which", "kde4-config"], stdout=PIPE, stderr=PIPE)
		Path.KDE.sConfig4 = bytes.decode(pShell.communicate()[0]).rstrip('\n')

		# KDE 4
		if len(Path.KDE.sConfig4) :
			Env.sKDESV = '4'
			Path.KDE.sConfig = Path.KDE.sConfig4
			pShell = Popen([Path.KDE.sConfig, "--prefix"], stdout=PIPE, stderr=PIPE)
			Path.KDE.sPrefix = bytes.decode(pShell.communicate()[0]).rstrip('\n')
			pShell = Popen([Path.KDE.sConfig, "--localprefix"], stdout=PIPE, stderr=PIPE)
			Path.KDE.sLocalPrefix = bytes.decode(pShell.communicate()[0]).rstrip('\n')
			#pShell = Popen([Path.KDE.sConfig, "--qt-binaries"], stdout=PIPE, stderr=PIPE)
			#Path.Sys.sBin = bytes.decode(pShell.communicate()[0]).rstrip('\n')
		# KDE 3
		elif len(Path.KDE.sConfig3) :
			Env.sKDESV = '3'
			Path.KDE.sConfig = Path.KDE.sConfig3
			pShell = Popen([Path.KDE.sConfig, "--prefix"], stdout=PIPE, stderr=PIPE)
			Path.KDE.sPrefix = bytes.decode(pShell.communicate()[0]).rstrip('\n')
			pShell = Popen([Path.KDE.sConfig, "--localprefix"], stdout=PIPE, stderr=PIPE)
			Path.KDE.sLocalPrefix = bytes.decode(pShell.communicate()[0]).rstrip('\n')
		# Unknown
		else :
			Env.sKDESV = '?'
			Path.KDE.sConfig = ""
			Path.KDE.sPrefix = '/usr'
			Path.KDE.sLocalPrefix = Env.sHome + '/.kde4/'
			#Path.Sys.sBin = Path.Sys.sPrefix + '/bin'

		# Misc
		Path.KDE.sAutoStart = Path.KDE.sLocalPrefix + "/Autostart/"

		# Installation
		# KDE
		if QtCore.QFile.exists(Path.Sys.sPrefix + Path.App.sInstall + "/Source/") :
			Path.App.sPrefix	= Path.Sys.sPrefix
			Path.App.sSBin		= Path.App.sPrefix + "/sbin"
		# User
		elif QtCore.QFile.exists(Path.Local.sPrefix + Path.App.sInstall + "/Source/") :
			Path.App.sPrefix	= Path.Local.sPrefix
			Path.App.sSBin		= Path.App.sPrefix + "/sbin"
		# Local
		else :
			Path.App.sPrefix	= os.path.realpath(os.path.dirname(__file__)) + "/.."
			Path.App.sSBin		= Path.App.sPrefix + "/Bin"
			Path.App.sInstall	= ""


# Proxy
def slProxy() :

	if len(Env.sProxy) :

		sProxy = Env.sProxy

		# Type
		#Path.Proxy.setType(QtNetwork.QNetworkProxy.HttpProxy)
		Path.Proxy.setType(QtNetwork.QNetworkProxy.HttpCachingProxy)

		# Protocol supplied
		if sProxy.count("://") :
			sProxy = sProxy.split("://", 1)[1]

		# Username and password supplied
		if sProxy.count('@') :
			slProxy = sProxy.split('@', 1)
			sLogin = slProxy[0]
			sProxy = slProxy[1]
			slLogin = sLogin.split(':', 1)
			Path.Proxy.setUser(slLogin[0])
			Path.Proxy.setPassword(slLogin[1])

		# Port supplied
		if sProxy.count(':') :
			slProxy = sProxy.split(':', 1)
			Path.Proxy.setHostName(slProxy[0])
			Path.Proxy.setPort(int(slProxy[1].split('/', 1)[0]))
		else :
			Path.Proxy.setHostName(sProxy.split('/', 1)[0])
			Path.Proxy.setPort(int(80))

		# Temp
		#Path.Proxy.setApplicationProxy(Path.Proxy)


# Files
def slFiles() :

	bRet = True

	# Commands
	Exec.Tar.sCommand		= "tar"

	# Static
	# Tar
	pShell = Popen(["which", Exec.Tar.sCommand], stdout=PIPE, stderr=PIPE)
	if not len(bytes.decode(pShell.communicate()[0])) :
		bRet = False
		Display.slNoBinary("Tar", URL.sTar)

	# Messages
	File.slMessage(Message.iInformation, "The optional commands will now be found and selected.")

	# Dynamic
	# P7Zip-GUI
	Exec.P7Zip.GUI.sCommand, Exec.P7Zip.GUI.sArgs = File.slChooseBinary("P7Zip-GUI", "")
	if not len(Exec.P7Zip.GUI.sCommand) :
		Exec.P7Zip.GUI.bUse = False
		#Display.slNoBinary("P7Zip-GUI", URL.sP7Zip)
	else :
		Exec.P7Zip.GUI.bUse = True
	# P7Zip-CLI
	Exec.P7Zip.CLI.sCommand, Exec.P7Zip.CLI.sArgs = File.slChooseBinary("P7Zip-CLI", "")
	if not len(Exec.P7Zip.CLI.sCommand) :
		bRet = False
		Display.slNoBinary("P7Zip-CLI", URL.sP7Zip)

	return bRet


# Verbose
def slVerbose() :

	Import.Init.bVerbose = Main.uiMain.aVerbose.isChecked()
	Main.uiMain.aAReview.setEnabled(Import.Init.bVerbose)

	File.slAbout()
	Display.slMessage(Message.iStatus, "Verbose mode was toggled")


# History
def slHistory() :

	# Create
	Main.uiMain.cobCSwitches.clear()
	Main.uiMain.cbSDir.clear()
	Main.uiMain.cbCDDir.clear()
	Main.uiMain.cobCName.clear()

	# Extract
	Main.uiMain.cbArchive.clear()
	Main.uiMain.cbEDDir.clear()
	Main.uiMain.cobEName.clear()

	Display.slMessage(Message.iStatus, "Form history was cleared")


# AutoQuit
def slAutoQuit() :
	Init.bAutoQuit = Main.uiMain.aAutoQuit.isChecked()


# Load
def slLoad() :

	# Visible?
	# TODO: Try to use the local 'bInvisible' instead
	if not Import.Init.bInvisible :

		Settings.beginGroup("Main Window")
		oItems = Settings.value("Geometry")
		if oItems :
			Main.mwMain.restoreGeometry(oItems)
		Settings.endGroup()

		# Staying?
		if not Init.bAutoQuit :

			Settings.beginGroup("MRU Create")
			oItems = Settings.value("Switches")
			if oItems :
				Main.uiMain.cobCSwitches.addItems(oItems)
			oItems = Settings.value("Source Dir")
			if oItems and Main.uiMain.cbSDir.isEnabled() :
				Main.uiMain.cbSDir.addItems(oItems)
			oItems = Settings.value("Destination Dir")
			if oItems :
				Main.uiMain.cbCDDir.addItems(oItems)
			oItems = Settings.value("Archive Name")
			if oItems :
				Main.uiMain.cobCName.addItems(oItems)
			Settings.endGroup()

			Settings.beginGroup("MRU Extract")
			oItems = Settings.value("Source Archive")
			if oItems and Main.uiMain.cbArchive.isEnabled() :
				Main.uiMain.cbArchive.addItems(oItems)
			oItems = Settings.value("Destination Dir")
			if oItems :
				Main.uiMain.cbEDDir.addItems(oItems)
			oItems = Settings.value("Folder Name")
			if oItems :
				Main.uiMain.cobEName.addItems(oItems)
			Settings.endGroup()

			# Clear combo-boxes
			Main.uiMain.cobCSwitches.clearEditText()
			Main.uiMain.cbSDir.clearEditText()
			Main.uiMain.cbCDDir.clearEditText()
			Main.uiMain.cobCName.clearEditText()
			Main.uiMain.cbArchive.clearEditText()
			Main.uiMain.cbEDDir.clearEditText()
			Main.uiMain.cobEName.clearEditText()

# Save
def slSave() :

	# Visible?
	# TODO: Try to use the local 'bInvisible' instead
	if not Import.Init.bInvisible :

		Settings.beginGroup("Main Window")
		Settings.setValue("Geometry", Main.mwMain.saveGeometry())
		Settings.endGroup()

		# Deprecated
		Settings.beginGroup("Geometry")
		Settings.remove("")
		Settings.endGroup()

		# Staying?
		if not Init.bAutoQuit :

			Settings.beginGroup("MRU Create")
			oItems = []
			for iEntry in range(0, Main.uiMain.cobCSwitches.count()) :
				oItems.append(Main.uiMain.cobCSwitches.itemText(iEntry))
			Settings.setValue("Switches", oItems)
			oItems = []
			for iEntry in range(0, Main.uiMain.cbSDir.count()) :
				oItems.append(Main.uiMain.cbSDir.itemText(iEntry))
			Settings.setValue("Source Dir", oItems)
			oItems = []
			for iEntry in range(0, Main.uiMain.cbCDDir.count()) :
				oItems.append(Main.uiMain.cbCDDir.itemText(iEntry))
			Settings.setValue("Destination Dir", oItems)
			oItems = []
			for iEntry in range(0, Main.uiMain.cobCName.count()) :
				oItems.append(Main.uiMain.cobCName.itemText(iEntry))
			Settings.setValue("Archive Name", oItems)
			Settings.endGroup()

			Settings.beginGroup("MRU Extract")
			oItems = []
			for iEntry in range(0, Main.uiMain.cbArchive.count()) :
				oItems.append(Main.uiMain.cbArchive.itemText(iEntry))
			Settings.setValue("Source Archive", oItems)
			oItems = []
			for iEntry in range(0, Main.uiMain.cbEDDir.count()) :
				oItems.append(Main.uiMain.cbEDDir.itemText(iEntry))
			Settings.setValue("Destination Dir", oItems)
			oItems = []
			for iEntry in range(0, Main.uiMain.cobEName.count()) :
				oItems.append(Main.uiMain.cobEName.itemText(iEntry))
			Settings.setValue("Folder Name", oItems)
			Settings.endGroup()


# View
def slView() :

	Settings.beginGroup("Syntax")
	oItems = Settings.value("Exclusions")
	if oItems :
		User.Syntax.sExclusions = oItems.strip()
	Settings.endGroup()

	# Visible?
	# TODO: Try to use the local 'bInvisible' instead
	if not Import.Init.bInvisible :

		Main.uiSettings.leExclExt.setText(User.Syntax.sExclusions)

		# KDE 4 service menus
		sDestPath = "/share/kde4/services/ServiceMenus/"

		# Check Top Level
		if QtCore.QFile.exists(Path.KDE.sLocalPrefix + sDestPath + Application.sName + ".marker.top") :
			Main.uiSettings.cbKTopLevel.setCheckState(QtCore.Qt.Checked)
		else :
			Main.uiSettings.cbKTopLevel.setCheckState(QtCore.Qt.Unchecked)

		# Enable
		#Main.uiSettings.gbKonq.setEnabled(True)

# Accept
def slAccept() :

	# Syntax
	User.Syntax.sExclusions = Main.uiSettings.leExclExt.displayText().replace(',','').replace(';','').strip()

	Settings.beginGroup("Syntax")
	Settings.setValue("Exclusions", User.Syntax.sExclusions)
	Settings.endGroup()

	# User service menus
	slServiceMenus(True)

	# Commands
	#slFiles()


# Dialog
def slDialog() :

	# View
	slView()

	# Modal
	Main.dSettings.exec_()


# User service menus
def slServiceMenus(bGUI) :

	sBackupPath = Path.App.sPrefix + Path.App.sInstall + "/Desktop"

	# Gnome service menus
	sDestPath = "/.gnome2/nautilus-scripts/Archiving/" + Application.sName

	# Create directory
	dDestPath = QtCore.QDir(Env.sHome + sDestPath)
	if not dDestPath.exists() :

		# Messages
		#File.slMessage(Message.iInformation, "Service Menus (Gnome) = " + Env.sHome + sDestPath)

		dDestPath.mkpath(Env.sHome + sDestPath)
		dDestPath.mkpath(Env.sHome + sDestPath + "/Create/")
		dDestPath.mkpath(Env.sHome + sDestPath + "/Extract/")

		# Copy files
		pShell = Popen("cp -r " + sBackupPath + "/Gnome/* " + Env.sHome + sDestPath, shell=True, stdout=PIPE, stderr=PIPE)
		pShell.communicate()[0]

	# Xfce service menus
	sDestPath = "/.config/Thunar"

	# Create directory
	dDestPath = QtCore.QDir(Env.sHome + sDestPath)
	if not dDestPath.exists() :

		dDestPath.mkpath(Env.sHome + sDestPath)

	if not QtCore.QFile.exists(Env.sHome + sDestPath + "/uca.xml." + Application.sName) :

		# Messages
		#File.slMessage(Message.iInformation, "Service Menus (Xfce) = " + Env.sHome + sDestPath)

		QtCore.QFile.copy(sBackupPath + "/Xfce/uca.xml",  Env.sHome + sDestPath + "/uca.xml." + Application.sName)

	# Use GUI settings?
	if bGUI :

		# Top Level?
		if Main.uiSettings.cbKTopLevel.isChecked() :
			sFileExt = ".top"
		else :
			sFileExt = ""

		# KDE 4 service menus
		sDestPath = "/share/kde4/services/ServiceMenus/"

		# Messages
		#File.slMessage(Message.iInformation, "Service Menus (KDE 4) = " + Path.KDE.sLocalPrefix + sDestPath)

		# Remove current entries
		pShell = Popen("rm -f " + Path.KDE.sLocalPrefix + sDestPath + Application.sName + "*", shell=True, stdout=PIPE, stderr=PIPE)
		pShell.communicate()[0]

		# Create directory
		dDestPath = QtCore.QDir(Path.KDE.sLocalPrefix + sDestPath)
		if not dDestPath.exists() :
			dDestPath.mkpath(Path.KDE.sLocalPrefix + sDestPath)

		# Copy files
		QtCore.QFile.copy(sBackupPath + "/KDE/" + Application.sName + "-Create.desktop" + sFileExt, Path.KDE.sLocalPrefix + sDestPath + Application.sName + "-Create.desktop")
		QtCore.QFile.copy(sBackupPath + "/KDE/" + Application.sName + "-Extract.desktop" + sFileExt, Path.KDE.sLocalPrefix + sDestPath + Application.sName + "-Extract.desktop")
		QtCore.QFile.copy(sBackupPath + "/KDE/" + Application.sName + ".marker", Path.KDE.sLocalPrefix + sDestPath + Application.sName + ".marker" + sFileExt)
