#!/usr/bin/perl
use strict;
use lib 'blib/lib';
use lib 'blib/arch';
use Rast;


if (@ARGV ne 1) {
    print "usage: $0 <dbpath>\n";
    exit;
}
my $dbpath = @ARGV[0];

die "dbpath is not found.\n"
    unless $dbpath;

my $ret = Rast->create($dbpath, {
    encoding => 'euc_jp',
    preserve_text => 1,
    properties => [
		   [
		    "filename",
		    RAST_TYPE_STRING,
		    RAST_PROPERTY_FLAG_SEARCH
		    ],
		   [
		    "title",
		    RAST_TYPE_STRING,
		    RAST_PROPERTY_FLAG_TEXT_SEARCH | RAST_PROPERTY_FLAG_FULL_TEXT_SEARCH
		    ],
		   [
		    "last_modified",
		    RAST_TYPE_DATE,
		    RAST_PROPERTY_FLAG_SEARCH
		    ],
		   [
		    "filesize",
		    RAST_TYPE_UINT,
		    RAST_PROPERTY_FLAG_SEARCH
		    ]
		   ],
		});


print "create status: $ret\n";
exit;
