/* 
   Bluetooth device FirmWare loader
   Copyright (C) 2001-2002 Maxim Krasnyansky <maxk@qualcomm.com>
   Copyright (C) 2002 Marcel Holtmann <marcel@holtmann.org>
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 2 as
   published by the Free Software Foundation;
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF THIRD PARTY RIGHTS.
   IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) AND AUTHOR(S) BE LIABLE FOR ANY CLAIM,
   OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER
   RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
   NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE
   USE OR PERFORMANCE OF THIS SOFTWARE.
   
   ALL LIABILITY, INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PATENTS, COPYRIGHTS,
   TRADEMARKS OR OTHER RIGHTS, RELATING TO USE OF THIS SOFTWARE IS DISCLAIMED.
*/

/*
 * $Id: devinfo.c,v 1.3 2002/10/28 00:24:51 holtmann Exp $
 */

#include "bluefw.h"

extern int bcm_usb_loader(devio_t io, devinfo_t *info);
extern int bt3c_pccard_loader(devio_t io, devinfo_t *info);

devinfo_t devinfo_table[] = {
	// Broadcomm BCM2033
	{ 0x0a5c, 0x2033, bcm_usb_loader, "BCM2033-FW.bin", "BCM2033-MD.hex" },

#ifdef BT3C_SUPPORT
	// 3Com Bluetooth PCMCIA card
	{ 0x0101, 0x0040, bt3c_pccard_loader, "BT3CPCC.bin" },
#endif

	{ 0 }
};
