/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.util;

import org.exolab.adaptx.util.HashMapEntryIterator;
import org.exolab.adaptx.util.HashMapKeyIterator;
import org.exolab.adaptx.util.Iterator;

public class HashMap {
    public static final int DEFAULT_SIZE = 17;
    private Bucket[] table = null;
    private int elementCount = 0;

    public HashMap() {
        this(17);
    }

    public HashMap(int n) {
        if (n <= 0) {
            n = 17;
        }
        this.table = new Bucket[n];
        int n2 = 0;
        while (n2 < n) {
            this.table[n2] = new Bucket();
            ++n2;
        }
    }

    private void addEntry(Object object, Object object2) {
        int n = this.hashCode(object);
        Entry entry = new Entry(n, object, object2);
        Bucket bucket = this.table[n % this.table.length];
        if (bucket.entry == null) {
            bucket.entry = entry;
        } else {
            Entry entry2 = bucket.entry;
            while (entry2 != null) {
                if (n <= entry2.hash) {
                    if (entry2.prev != null) {
                        entry2.prev.next = entry;
                        entry.prev = entry2.prev;
                    } else {
                        bucket.entry = entry;
                    }
                    entry.next = entry2;
                    break;
                }
                if (entry2.next == null) {
                    entry2.next = entry;
                    entry.prev = entry2;
                    break;
                }
                entry2 = entry2.next;
            }
        }
        ++bucket.size;
        ++this.elementCount;
    }

    public void clear() {
        int n = 0;
        while (n < this.table.length) {
            this.table[n].size = 0;
            this.table[n].entry = null;
            ++n;
        }
        this.elementCount = 0;
    }

    public boolean containsKey(Object object) {
        if (this.elementCount == 0) {
            return false;
        }
        return this.findEntry(object) != null;
    }

    public boolean containsValue(Object object) {
        if (this.elementCount == 0) {
            return false;
        }
        boolean bl = object == null;
        int n = 0;
        while (n < this.table.length) {
            Entry entry = this.table[n].entry;
            while (entry != null) {
                if (bl ? entry.getValue() == null : object.equals(entry.getValue())) {
                    return true;
                }
                entry = entry.next;
            }
            ++n;
        }
        return false;
    }

    public Iterator entries() {
        return new HashMapEntryIterator(this.table);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof HashMap) {
            HashMap hashMap = (HashMap)object;
            if (hashMap.size() != this.size()) {
                return false;
            }
            Iterator iterator = hashMap.entries();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                if (entry.equals(this.findEntry(entry.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Entry findEntry(Object object) {
        if (this.elementCount == 0) {
            return null;
        }
        return this.findEntry(object, this.hashCode(object));
    }

    private Entry findEntry(Object object, int n) {
        if (this.elementCount == 0) {
            return null;
        }
        int n2 = n % this.table.length;
        Entry entry = this.table[n2].entry;
        boolean bl = object == null;
        while (entry != null) {
            if (bl) {
                if (entry.getKey() == null) {
                    return entry;
                }
            } else if (n == entry.hash) {
                if (entry.getKey().equals(object)) {
                    return entry;
                }
            } else if (n < entry.hash) break;
            entry = entry.next;
        }
        return null;
    }

    public Object get(Object object) {
        Entry entry = this.findEntry(object);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.table.length) {
            Entry entry = this.table[n2].entry;
            while (entry != null) {
                n += entry.hashCode();
                entry = entry.next;
            }
            ++n2;
        }
        return n;
    }

    private int hashCode(Object object) {
        int n;
        int n2 = n = object == null ? 0 : object.hashCode();
        if (n < 0) {
            n = -n;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Iterator keys() {
        return new HashMapKeyIterator(this.table);
    }

    public void put(Object object, Object object2) {
        Entry entry = this.findEntry(object);
        if (entry == null) {
            this.addEntry(object, object2);
        } else {
            entry.setValue(object2);
        }
    }

    public Object remove(Object object) {
        if (this.elementCount == 0) {
            return null;
        }
        int n = this.hashCode(object);
        Bucket bucket = this.table[n % this.table.length];
        Entry entry = bucket.entry;
        boolean bl = object == null;
        while (entry != null) {
            if (bl) {
                if (entry.getKey() == null) {
                    break;
                }
            } else {
                if (n < entry.hash) {
                    return null;
                }
                if (entry.getKey().equals(object)) break;
            }
            entry = entry.next;
        }
        Object object2 = null;
        if (entry != null) {
            if (entry.prev != null) {
                entry.prev.next = entry.next;
            } else {
                bucket.entry = entry.next;
            }
            if (entry.next != null) {
                entry.next.prev = entry.prev;
            }
            object2 = entry.getValue();
            --bucket.size;
            --this.elementCount;
        }
        return object2;
    }

    public int size() {
        return this.elementCount;
    }

    class Bucket {
        int size = 0;
        Entry entry = null;

        Bucket() {
        }
    }

    class Entry {
        int hash = 0;
        Object key = null;
        Object value = null;
        Entry next = null;
        Entry prev = null;

        public Entry(int n, Object object, Object object2) {
            this.hash = n;
            this.key = object;
            this.value = object2;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof Entry) {
                Entry entry = (Entry)object;
                if (this.key == null) {
                    if (entry.getKey() != null) {
                        return false;
                    }
                    if (!this.key.equals(entry.getKey())) {
                        return false;
                    }
                }
                if (this.value == null) {
                    return entry.getValue() == null;
                }
                return this.value.equals(entry.getValue());
            }
            return false;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            int n = this.key == null ? 0 : this.key.hashCode();
            int n2 = this.value == null ? 0 : this.value.hashCode();
            return n ^ n2;
        }

        public void setValue(Object object) {
            this.value = object;
        }
    }
}

