/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ARef;
import clojure.lang.IFn;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentStack;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.LockingTransaction;
import clojure.lang.PersistentQueue;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.Var;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;

public class Agent
extends ARef {
    volatile Object state;
    AtomicReference<IPersistentStack> q = new AtomicReference<PersistentQueue>(PersistentQueue.EMPTY);
    volatile ISeq errors = null;
    public static final ExecutorService pooledExecutor = Executors.newFixedThreadPool(2 + Runtime.getRuntime().availableProcessors());
    public static final ExecutorService soloExecutor = Executors.newCachedThreadPool();
    static final ThreadLocal<IPersistentVector> nested = new ThreadLocal();

    public static void shutdown() {
        soloExecutor.shutdown();
        pooledExecutor.shutdown();
    }

    public Agent(Object state) throws Exception {
        this(state, null);
    }

    public Agent(Object state, IPersistentMap meta) throws Exception {
        super(meta);
        this.setState(state);
    }

    boolean setState(Object newState) throws Exception {
        this.validate(newState);
        boolean ret = this.state != newState;
        this.state = newState;
        return ret;
    }

    public Object deref() throws Exception {
        if (this.errors != null) {
            throw new Exception("Agent has errors", (Exception)RT.first(this.errors));
        }
        return this.state;
    }

    public ISeq getErrors() {
        return this.errors;
    }

    public void clearErrors() {
        this.errors = null;
    }

    public Object dispatch(IFn fn, ISeq args, boolean solo) {
        if (this.errors != null) {
            throw new RuntimeException("Agent has errors", (Exception)RT.first(this.errors));
        }
        Action action = new Action(this, fn, args, solo);
        Agent.dispatchAction(action);
        return this;
    }

    static void dispatchAction(Action action) {
        LockingTransaction trans = LockingTransaction.getRunning();
        if (trans != null) {
            trans.enqueue(action);
        } else if (nested.get() != null) {
            nested.set(nested.get().cons(action));
        } else {
            action.agent.enqueue(action);
        }
    }

    void enqueue(Action action) {
        boolean queued = false;
        IPersistentCollection prior = null;
        while (!queued) {
            prior = this.q.get();
            queued = this.q.compareAndSet((IPersistentStack)prior, (IPersistentStack)prior.cons(action));
        }
        if (prior.count() == 0) {
            action.execute();
        }
    }

    public int getQueueCount() {
        return this.q.get().count();
    }

    public static int releasePendingSends() {
        IPersistentVector sends = nested.get();
        if (sends == null) {
            return 0;
        }
        for (int i = 0; i < sends.count(); ++i) {
            Action a = (Action)sends.valAt(i);
            a.agent.enqueue(a);
        }
        nested.set(PersistentVector.EMPTY);
        return sends.count();
    }

    static class Action
    implements Runnable {
        final Agent agent;
        final IFn fn;
        final ISeq args;
        final boolean solo;

        public Action(Agent agent, IFn fn, ISeq args, boolean solo) {
            this.agent = agent;
            this.args = args;
            this.fn = fn;
            this.solo = solo;
        }

        void execute() {
            if (this.solo) {
                soloExecutor.execute(this);
            } else {
                pooledExecutor.execute(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void doRun(Action action) {
            try {
                Var.pushThreadBindings(RT.map(RT.AGENT, action.agent));
                nested.set(PersistentVector.EMPTY);
                boolean hadError = false;
                try {
                    Object oldval = action.agent.state;
                    Object newval = action.fn.applyTo(RT.cons(action.agent.state, action.args));
                    action.agent.setState(newval);
                    action.agent.notifyWatches(oldval, newval);
                }
                catch (Throwable e) {
                    action.agent.errors = RT.cons(e, action.agent.errors);
                    hadError = true;
                }
                if (!hadError) {
                    Agent.releasePendingSends();
                }
                boolean popped = false;
                IPersistentCollection next = null;
                while (!popped) {
                    IPersistentStack prior = action.agent.q.get();
                    next = prior.pop();
                    popped = action.agent.q.compareAndSet(prior, (IPersistentStack)next);
                }
                if (next.count() > 0) {
                    ((Action)next.peek()).execute();
                }
            }
            finally {
                nested.set(null);
                Var.popThreadBindings();
            }
        }

        public void run() {
            Action.doRun(this);
        }
    }
}

