#include "pch.h"
#include "shark.h"

#if CRYPTOPP_GCC_DIAGNOSTIC_AVAILABLE
# pragma GCC diagnostic ignored "-Wmissing-braces"
#endif

NAMESPACE_BEGIN(CryptoPP)

const byte SHARK::Enc::sbox[256] = {
177, 206, 195, 149,  90, 173, 231,   2,  77,  68, 251, 145,  12, 135, 161,  80, 
203, 103,  84, 221,  70, 143, 225,  78, 240, 253, 252, 235, 249, 196,  26, 110, 
 94, 245, 204, 141,  28,  86,  67, 254,   7,  97, 248, 117,  89, 255,   3,  34, 
138, 209,  19, 238, 136,   0,  14,  52,  21, 128, 148, 227, 237, 181,  83,  35, 
 75,  71,  23, 167, 144,  53, 171, 216, 184, 223,  79,  87, 154, 146, 219,  27, 
 60, 200, 153,   4, 142, 224, 215, 125, 133, 187,  64,  44,  58,  69, 241,  66, 
101,  32,  65,  24, 114,  37, 147, 112,  54,   5, 242,  11, 163, 121, 236,   8, 
 39,  49,  50, 182, 124, 176,  10, 115,  91, 123, 183, 129, 210,  13, 106,  38, 
158,  88, 156, 131, 116, 179, 172,  48, 122, 105, 119,  15, 174,  33, 222, 208, 
 46, 151,  16, 164, 152, 168, 212, 104,  45,  98,  41, 109,  22,  73, 118, 199, 
232, 193, 150,  55, 229, 202, 244, 233,  99,  18, 194, 166,  20, 188, 211,  40, 
175,  47, 230,  36,  82, 198, 160,   9, 189, 140, 207,  93,  17,  95,   1, 197, 
159,  61, 162, 155, 201,  59, 190,  81,  25,  31,  63,  92, 178, 239,  74, 205, 
191, 186, 111, 100, 217, 243,  62, 180, 170, 220, 213,   6, 192, 126, 246, 102, 
108, 132, 113,  56, 185,  29, 127, 157,  72, 139,  42, 218, 165,  51, 130,  57, 
214, 120, 134, 250, 228,  43, 169,  30, 137,  96, 107, 234,  85,  76, 247, 226, 
};

const byte SHARK::Dec::sbox[256] = {
 53, 190,   7,  46,  83, 105, 219,  40, 111, 183, 118, 107,  12, 125,  54, 139, 
146, 188, 169,  50, 172,  56, 156,  66,  99, 200,  30,  79,  36, 229, 247, 201, 
 97, 141,  47,  63, 179, 101, 127, 112, 175, 154, 234, 245,  91, 152, 144, 177, 
135, 113, 114, 237,  55,  69, 104, 163, 227, 239,  92, 197,  80, 193, 214, 202, 
 90,  98,  95,  38,   9,  93,  20,  65, 232, 157, 206,  64, 253,   8,  23,  74, 
 15, 199, 180,  62,  18, 252,  37,  75, 129,  44,   4, 120, 203, 187,  32, 189, 
249,  41, 153, 168, 211,  96, 223,  17, 151, 137, 126, 250, 224, 155,  31, 210, 
103, 226, 100, 119, 132,  43, 158, 138, 241, 109, 136, 121, 116,  87, 221, 230, 
 57, 123, 238, 131, 225,  88, 242,  13,  52, 248,  48, 233, 185,  35,  84,  21, 
 68,  11,  77, 102,  58,   3, 162, 145, 148,  82,  76, 195, 130, 231, 128, 192, 
182,  14, 194, 108, 147, 236, 171,  67, 149, 246, 216,  70, 134,   5, 140, 176, 
117,   0, 204, 133, 215,  61, 115, 122,  72, 228, 209,  89, 173, 184, 198, 208, 
220, 161, 170,   2,  29, 191, 181, 159,  81, 196, 165,  16,  34, 207,   1, 186, 
143,  49, 124, 174, 150, 218, 240,  86,  71, 212, 235,  78, 217,  19, 142,  73, 
 85,  22, 255,  59, 244, 164, 178,   6, 160, 167, 251,  27, 110,  60,  51, 205, 
 24,  94, 106, 213, 166,  33, 222, 254,  42,  28, 243,  10,  26,  25,  39,  45, 
};

const word64 SHARK::Enc::cbox[8][256] = {
/* box 0 */
W64LIT(0x060d838f16f3a365),
W64LIT(0xa68857ee5cae56f6),
W64LIT(0xebf516353c2c4d89),
W64LIT(0x652174be88e85bdc),
W64LIT(0x0d4e9a8086c17921),
W64LIT(0x27ba7d33cffa58a1),
W64LIT(0x88d9e104a237b530),
W64LIT(0x693b8755a4fbe816),
W64LIT(0xdac9591826b254a0),
W64LIT(0x45c2e369fb336af3),
W64LIT(0xa96e1fb87b3e4ef4),
W64LIT(0xb7578f1435eb7ef0),
W64LIT(0x839af80b32056f74),
W64LIT(0xae37f55cc71f277a),
W64LIT(0xa4208538fdff37d5),
W64LIT(0x35991e74ad3cdb6f),
W64LIT(0xba191594b32a07d1),
W64LIT(0x5344d1772e572b7b),
W64LIT(0xe7efe5de103ffe43),
W64LIT(0xa3796fdc41de5e5b),
W64LIT(0x2cf9643c5fc882e5),
W64LIT(0xffdbf6fd48196d22),
W64LIT(0x33949dfbbbcf780a),
W64LIT(0x7d15679dd0cec8bd),
W64LIT(0x5f5e229c024498b1),
W64LIT(0x1223634762c683ce),
W64LIT(0xdcc4da973041f7c5),
W64LIT(0x0b43190f9032da44),
W64LIT(0xc05598eddfc5a6e2),
W64LIT(0x9e5fd31a7753f4b8),
W64LIT(0x9afa8243c0f136fe),
W64LIT(0xcc4f6b06f3d61528),
W64LIT(0xdf38612a3bc25c0d),
W64LIT(0x43cf60e6edc0c996),
W64LIT(0xcfb3d0bbf855bee0),
W64LIT(0x96e071a8ece28534),
W64LIT(0x21b7febcd909fbc4),
W64LIT(0x8ed4628bb4c41655),
W64LIT(0x30682646b04cd3c2),
W64LIT(0xb5ff5dc294ba1fd3),
W64LIT(0x75aac52f4b7fb931),
W64LIT(0xe809ad8837afe641),
W64LIT(0x0eb2213d8d42d2e9),
W64LIT(0x9852509561a057dd),
W64LIT(0xaa92a40570bde53c),
W64LIT(0x7b18e412c63d6bd8),
W64LIT(0xa7dc3e85f67c9c1d),
W64LIT(0xd8618bce87e33583),
W64LIT(0xe34ab487a79d3c05),
W64LIT(0x20e397d773db312f),
W64LIT(0x05f138321d7008ad),
W64LIT(0x17d25b757fb68b63),
W64LIT(0x8a7133d20366d413),
W64LIT(0x0000000000000000),
W64LIT(0xeaa17f5e96fe8762),
W64LIT(0xc101f18675176c09),
W64LIT(0xbebc44cd0488c597),
W64LIT(0xdb9d30738c609e4b),
W64LIT(0xabc6cd6eda6f2fd7),
W64LIT(0x5aaf1aae1f34901c),
W64LIT(0xb00e65f089ca177e),
W64LIT(0xd47b7825abf08649),
W64LIT(0x924520f15b404772),
W64LIT(0x1686321ed5644188),
W64LIT(0x618425e73f4a999a),
W64LIT(0xe21eddec0d4ff6ee),
W64LIT(0xd787c398a0732d81),
W64LIT(0x1f6df9c7e407faef),
W64LIT(0x79b036c4676c0afb),
W64LIT(0x0fe6485627901802),
W64LIT(0x9cf701ccd602959b),
W64LIT(0xbfe82da6ae5a0f7c),
W64LIT(0x990639fecb729d36),
W64LIT(0xca42e889e525b64d),
W64LIT(0xb3f2de4d8249bcb6),
W64LIT(0x4033db5be643625e),
W64LIT(0x4167b2304c91a8b5),
W64LIT(0x108bb191c397e2ed),
W64LIT(0x1834132358269361),
W64LIT(0x541d3b93927642f5),
W64LIT(0x90edf227fa112651),
W64LIT(0x1dc52b1145569bcc),
W64LIT(0xe6bb8cb5baed34a8),
W64LIT(0xd276fbaabd03252c),
W64LIT(0x313c4f2d1a9e1929),
W64LIT(0xfd73242be9480c01),
W64LIT(0x9baeeb286a23fc15),
W64LIT(0xc9be5334eea61d85),
W64LIT(0xc70c720963e4cf6c),
W64LIT(0x3eda077b3d0e012b),
W64LIT(0x97b418c346304fdf),
W64LIT(0x32c0f490111db2e1),
W64LIT(0x2ba08ed8e3e9eb6b),
W64LIT(0x8b255ab9a9b41ef8),
W64LIT(0x91b99b4c50c3ecba),
W64LIT(0xfe8f9f96e2cba7c9),
W64LIT(0x3a7f56228aacc36d),
W64LIT(0xb15a0c9b2318dd95),
W64LIT(0x5953a11314b73bd4),
W64LIT(0xf3c10516640adee8),
W64LIT(0xedf895ba2adfeeec),
W64LIT(0xadcb4ee1cc9c8cb2),
W64LIT(0xde6c0841911096e6),
W64LIT(0x84c312ef8e2406fa),
W64LIT(0xa83a76d3d1ec841f),
W64LIT(0x1c91427aef845127),
W64LIT(0x3665a5c9a6bf70a7),
W64LIT(0xf6303d24797ad645),
W64LIT(0xcd1b026d5904dfc3),
W64LIT(0x1bc8a89e53a538a9),
W64LIT(0x7ee9dc20db4d6375),
W64LIT(0x51ec03a18f064a58),
W64LIT(0xc4f0c9b4686764a4),
W64LIT(0xdd90b3fc9a933d2e),
W64LIT(0x7a4c8d796cefa133),
W64LIT(0x73a746a05d8c1a54),
W64LIT(0x0759eae4bc21698e),
W64LIT(0xc8ea3a5f4474d76e),
W64LIT(0x38d784f42bfda24e),
W64LIT(0x231f2c6a78589ae7),
W64LIT(0xc3a92350d4460d2a),
W64LIT(0x72f32fcbf75ed0bf),
W64LIT(0xbd40ff700f0b6e5f),
W64LIT(0x157a89a3dee7ea40),
W64LIT(0x873fa95285a7ad32),
W64LIT(0x4d7d41db60821b7f),
W64LIT(0x1e3990ac4ed53004),
W64LIT(0x0a1770643ae010af),
W64LIT(0x9311499af1928d99),
W64LIT(0x64751dd5223a9137),
W64LIT(0xfa2acecf5569658f),
W64LIT(0x7c410ef67a1c0256),
W64LIT(0x56b5e945332723d6),
W64LIT(0x6f3604dab2084b73),
W64LIT(0xe95dc4e39d7d2caa),
W64LIT(0x13770a2cc8144925),
W64LIT(0xbc14961ba5d9a4b4),
W64LIT(0xb9e5ae29b8a9ac19),
W64LIT(0xf169d7c0c55bbfcb),
W64LIT(0x2446c68ec479f369),
W64LIT(0x806643b63986c4bc),
W64LIT(0x7fbdb54b719fa99e),
W64LIT(0x04a55159b7a2c246),
W64LIT(0xee042e07215c4524),
W64LIT(0x5bfb73c5b5e65af7),
W64LIT(0x0c1af3eb2c13b3ca),
W64LIT(0xa22d06b7eb0c94b0),
W64LIT(0xb8b1c742127b66f2),
W64LIT(0x285c3565e86a40a3),
W64LIT(0x3b2b3f49207e0986),
W64LIT(0x3c72d5ad9c5f6008),
W64LIT(0x770217f9ea2ed812),
W64LIT(0xfc274d40439ac6ea),
W64LIT(0x4fd5930dc1d37a5c),
W64LIT(0x2e51b6eafe99e3c6),
W64LIT(0x6b93558305aa8935),
W64LIT(0x19607a48f2f4598a),
W64LIT(0x08bfa2b29bb1718c),
W64LIT(0x3f8e6e1097dccbc0),
W64LIT(0x3983ed9f812f68a5),
W64LIT(0xac9f278a664e4659),
W64LIT(0x82ce916098d7a59f),
W64LIT(0xc2fd4a3b7e94c7c1),
W64LIT(0x66ddcf03836bf014),
W64LIT(0xe1e2665106cc5d26),
W64LIT(0x74feac44e1ad73da),
W64LIT(0x8d28d936bf47bd9d),
W64LIT(0x62789e5a34c93252),
W64LIT(0x81322add93540e57),
W64LIT(0xcb1681e24ff77ca6),
W64LIT(0x2512afe56eab3982),
W64LIT(0xd18a4017b6808ee4),
W64LIT(0x705bfd1d560fb19c),
W64LIT(0x4b70c2547671b81a),
W64LIT(0x49d81082d720d939),
W64LIT(0xe0b60f3aac1e97cd),
W64LIT(0x4e81fa666b01b0b7),
W64LIT(0x951cca15e7612efc),
W64LIT(0x463e58d4f0b0c13b),
W64LIT(0x632cf7319e1bf8b9),
W64LIT(0x5ca2992109c73379),
W64LIT(0xf764544fd3a81cae),
W64LIT(0x6ac73ce8af7843de),
W64LIT(0x9f0bba71dd813e53),
W64LIT(0x85977b8424f6cc11),
W64LIT(0x5807c878be65f13f),
W64LIT(0x686fee3e0e2922fd),
W64LIT(0x78e45fafcdbec010),
W64LIT(0x6ccabf67b98be0bb),
W64LIT(0x11dfd8fa69452806),
W64LIT(0xcee7b9d05287740b),
W64LIT(0x50b86aca25d480b3),
W64LIT(0x5df6f04aa315f992),
W64LIT(0x5e0a4bf7a896525a),
W64LIT(0x03fcbbbd0b83abc8),
W64LIT(0x8f800be01e16dcbe),
W64LIT(0xd32292c117d1efc7),
W64LIT(0xe5473708b16e9f60),
W64LIT(0x224b4501d28a500c),
W64LIT(0xfb7ea7a4ffbbaf64),
W64LIT(0x3d26bcc6368daae3),
W64LIT(0x866bc0392f7567d9),
W64LIT(0x3731cca20c6dba4c),
W64LIT(0xb603e67f9f39b41b),
W64LIT(0xa1d1bd0ae08f3f78),
W64LIT(0xd935e2a52d31ff68),
W64LIT(0xaf639c376dcded91),
W64LIT(0x0154696baad2caeb),
W64LIT(0xecacfcd1800d2407),
W64LIT(0xf03dbeab6f897520),
W64LIT(0x02a8d2d6a1516123),
W64LIT(0xf498eff2d82bb766),
W64LIT(0x710f9476fcdd7b77),
W64LIT(0xf8821c19f43804ac),
W64LIT(0xf9d675725eeace47),
W64LIT(0x1a9cc1f5f977f242),
W64LIT(0x5210b81c8485e190),
W64LIT(0x6d9ed60c13592a50),
W64LIT(0xf2956c7dced81403),
W64LIT(0xbb4d7cff19f8cd3a),
W64LIT(0x4c2928b0ca50d194),
W64LIT(0x6e626db118da8198),
W64LIT(0xe4135e631bbc558b),
W64LIT(0x9da368a77cd05f70),
W64LIT(0xa574ec53572dfd3e),
W64LIT(0x09ebcbd93163bb67),
W64LIT(0x4a24ab3fdca372f1),
W64LIT(0x429b098d4712037d),
W64LIT(0x57e1802e99f5e93d),
W64LIT(0xef50476c8b8e8fcf),
W64LIT(0xa085d4614a5df593),
W64LIT(0x34cd771f07ee1184),
W64LIT(0xc6581b62c9360587),
W64LIT(0x2dad0d57f51a480e),
W64LIT(0x898d886f08e57fdb),
W64LIT(0xd6d3aaf30aa1e76a),
W64LIT(0x76567e9240fc12f9),
W64LIT(0xb4ab34a93e68d538),
W64LIT(0xb2a6b726289b765d),
W64LIT(0x8c7cb05d15957776),
W64LIT(0x554952f838a4881e),
W64LIT(0xd52f114e01224ca2),
W64LIT(0x60d04c8c95985371),
W64LIT(0x6789a66829b93aff),
W64LIT(0x2f05df81544b292d),
W64LIT(0x476a31bf5a620bd0),
W64LIT(0xf5cc869972f97d8d),
W64LIT(0x488c79e97df213d2),
W64LIT(0x44968a0251e1a018),
W64LIT(0x26ee14586528924a),
W64LIT(0xd0de297c1c52440f),
W64LIT(0xc5a4a0dfc2b5ae4f),
W64LIT(0x29085c0e42b88a48),
W64LIT(0x142ee0c8743520ab),
W64LIT(0x2af4e7b3493b2180),
W64LIT(0x9448a37e4db3e417),
/* box 1 */
W64LIT(0xe2795ba105ba30ce),
W64LIT(0x65b5d634f5e0fbdd),
W64LIT(0x2d7d7f1464dd8c55),
W64LIT(0xeefbf778add1c20b),
W64LIT(0x1eb0fbd1f11968e7),
W64LIT(0xe6073f45ce30cd8d),
W64LIT(0x21ffd3cdccb67e90),
W64LIT(0xdf0941cfa750a262),
W64LIT(0xc61df5b1b75ef18a),
W64LIT(0xc5c7defa9dc337c6),
W64LIT(0x2581b729073c83d3),
W64LIT(0xa5e97513167173cf),
W64LIT(0xdd3673bd381526b9),
W64LIT(0xe8baa1eef91ebb93),
W64LIT(0x3b314cf8f625eb34),
W64LIT(0x579d4bc8d5fc5df8),
W64LIT(0xbb598ec2e7681b28),
W64LIT(0xc8a06b1a80708794),
W64LIT(0x1c8fc9a36e5cec3c),
W64LIT(0xf60a5a3f0807d374),
W64LIT(0x1ace9f353a9395a4),
W64LIT(0x7e9e50387aab2cee),
W64LIT(0xb5e41069d0466d36),
W64LIT(0x8cea6ee3b92602d9),
W64LIT(0xf952ddad8af1e7fd),
W64LIT(0xb19a748d1bcc9075),
W64LIT(0x2464ae10b2e4c144),
W64LIT(0xfcc9a070f4a35829),
W64LIT(0xfa88f6e6a06c21b1),
W64LIT(0x2c98662dd105cec2),
W64LIT(0x9065a740d77aeee5),
W64LIT(0xcb7a4051aaed41d8),
W64LIT(0x55a279ba4ab9d923),
W64LIT(0x27be855b98790708),
W64LIT(0xbabc97fb52b059bf),
W64LIT(0xa19711f7ddfb8e8c),
W64LIT(0x047e64e4cb8afd43),
W64LIT(0xc386886cc90c4e5e),
W64LIT(0xc422c7c3281b7551),
W64LIT(0xfb6defdf15b46326),
W64LIT(0x01e51939b5d84297),
W64LIT(0x5cbba8be9c809432),
W64LIT(0x6f762c7b09447080),
W64LIT(0xcee13d8cd4bffe0c),
W64LIT(0x54476083ff619bb4),
W64LIT(0x6e933542bc9c3217),
W64LIT(0x4af79b520e78f353),
W64LIT(0x98996f7db49be163),
W64LIT(0xa07208ce6823cc1b),
W64LIT(0x2b3c29823012f5cd),
W64LIT(0x93bf8c0bfde728a9),
W64LIT(0x2225f886e62bb8dc),
W64LIT(0x7f7b4901cf736e79),
W64LIT(0x0000000000000000),
W64LIT(0x023f32729f4584db),
W64LIT(0xd5cabb805bf4293f),
W64LIT(0x07a44fafe1173b0f),
W64LIT(0xe95fb8d74cc6f904),
W64LIT(0x7b052de504f9933a),
W64LIT(0x6aed51a67716cf54),
W64LIT(0x68d263d4e8534b8f),
W64LIT(0xa96bd9cabe1a810a),
W64LIT(0x1d6ad09adb84aeab),
W64LIT(0x0d67b5e01db3b052),
W64LIT(0x52063615abaee22c),
W64LIT(0x8f3045a893bbc495),
W64LIT(0xd8ad0e604647996d),
W64LIT(0xaf2a8f5cead5f892),
W64LIT(0x3017af8ebf5922fe),
W64LIT(0x4034611df2dc780e),
W64LIT(0x721cfce1d2c0de2b),
W64LIT(0x28e602c91a8f3381),
W64LIT(0xe1a370ea2f27f682),
W64LIT(0x29031bf0af577116),
W64LIT(0x1914b47e100e53e8),
W64LIT(0x567852f160241f6f),
W64LIT(0x793a1f979bbc17e1),
W64LIT(0xef1eee411809809c),
W64LIT(0x6211999b14f7c0d2),
W64LIT(0x059b7ddd7e52bfd4),
W64LIT(0x43ee4a56d841be42),
W64LIT(0xf1ae1590e910e87b),
W64LIT(0x33cd84c595c4e4b2),
W64LIT(0x4b12826bbba0b1c4),
W64LIT(0xeb608aa5d3837ddf),
W64LIT(0x201acaf4796e3c07),
W64LIT(0xbf27ea262ce2e66b),
W64LIT(0x58c5cc5a570a6971),
W64LIT(0x37b3e0215e4e19f1),
W64LIT(0xab54ebb8215f05d1),
W64LIT(0x8ed55c9126638602),
W64LIT(0x9aa65d0f2bde65b8),
W64LIT(0xd7f589f2c4b1ade4),
W64LIT(0x5039046734eb66f7),
W64LIT(0x6cac073023d9b6cc),
W64LIT(0x51dc1d5e81332460),
W64LIT(0x17a92ad5272025f6),
W64LIT(0x47902eb213cb4301),
W64LIT(0x1b2b860c8f4bd733),
W64LIT(0x4f6ce68f702a4c87),
W64LIT(0xcf0424b56167bc9b),
W64LIT(0x997c76440143a3f4),
W64LIT(0x7ae034dcb121d1ad),
W64LIT(0x100d657ac6371ef9),
W64LIT(0x0ac3fa4ffca48b5d),
W64LIT(0xdeec58f61288e0f5),
W64LIT(0x265b9c622da1459f),
W64LIT(0xdcd36a848dcd642e),
W64LIT(0xe4380d3751754956),
W64LIT(0x13d74e31ecaad8b5),
W64LIT(0xfd2cb949417b1abe),
W64LIT(0x9624f1d683b5977d),
W64LIT(0x4675378ba6130196),
W64LIT(0x0b26e376497cc9ca),
W64LIT(0x41d1782447043a99),
W64LIT(0xe39c4298b0627259),
W64LIT(0xcd3b16c7fe223840),
W64LIT(0x7787813cac9261ff),
W64LIT(0x492db01924e5351f),
W64LIT(0x5afafe28c84fedaa),
W64LIT(0x8b4e214c583139d6),
W64LIT(0xccde0ffe4bfa7ad7),
W64LIT(0x76629805194a2368),
W64LIT(0x7ca1624ae5eea835),
W64LIT(0x61cbb2d03e6a069e),
W64LIT(0x48c8a920913d7788),
W64LIT(0x8068c23a114df01c),
W64LIT(0xd38bed160f3b50a7),
W64LIT(0x32289dfc201ca625),
W64LIT(0xc1b9ba1e5649ca85),
W64LIT(0xed21dc33874c0447),
W64LIT(0xa3a8238542be0a57),
W64LIT(0x5b1fe7117d97af3d),
W64LIT(0x3d701a6ea2ea92ac),
W64LIT(0x73f9e5d867189cbc),
W64LIT(0x9ed839ebe05498fb),
W64LIT(0x5920d563e2d22be6),
W64LIT(0xca9f59681f35034f),
W64LIT(0x11e87c4373ef5c6e),
W64LIT(0x97c1e8ef366dd5ea),
W64LIT(0xacf0a417c0483ede),
W64LIT(0xd26ef42fbae31230),
W64LIT(0xbcfdc16d067f2027),
W64LIT(0xbec2f31f993aa4fc),
W64LIT(0x45af1cc08c8ec7da),
W64LIT(0x31f2b6b70a816069),
W64LIT(0xd9481759f39fdbfa),
W64LIT(0xe5dd140ee4ad0bc1),
W64LIT(0xa6335e583cecb583),
W64LIT(0x38eb67b3dcb82d78),
W64LIT(0xf5d07174229a1538),
W64LIT(0x5f6183f5b61d527e),
W64LIT(0x0f58879282f63489),
W64LIT(0x164c33ec92f86761),
W64LIT(0x444a05f93956854d),
W64LIT(0x818ddb03a495b28b),
W64LIT(0x4d53d4fdef6fc85c),
W64LIT(0x8d0f77da0cfe404e),
W64LIT(0x8416a6dedac70d5f),
W64LIT(0x666ffd7fdf7d3d91),
W64LIT(0xb63e3b22fadbab7a),
W64LIT(0xf2743edbc38d2e37),
W64LIT(0xa40c6c2aa3a93158),
W64LIT(0x9f3d20d2558cda6c),
W64LIT(0xfef692026be6dcf2),
W64LIT(0x2ea7545f4e404a19),
W64LIT(0xb2405fc631515639),
W64LIT(0x23c0e1bf53f3fa4b),
W64LIT(0x83b2e9713bd03650),
W64LIT(0x0641569654cf7998),
W64LIT(0xb883a589cdf5dd64),
W64LIT(0x3ad455c143fda9a3),
W64LIT(0x925a9532483f6a3e),
W64LIT(0xaab1f28194874746),
W64LIT(0xf435684d974257af),
W64LIT(0xd1b4df64907ed47c),
W64LIT(0x390e7e8a69606fef),
W64LIT(0xd051c65d25a696eb),
W64LIT(0xb4010950659e2fa1),
W64LIT(0x0c82acd9a86bf2c5),
W64LIT(0x88940a0772acff9a),
W64LIT(0xf39127e276556ca0),
W64LIT(0xaecf96655f0dba05),
W64LIT(0x03da2b4b2a9dc64c),
W64LIT(0x3f4f281c3daf1677),
W64LIT(0x3469cb6a74d3dfbd),
W64LIT(0xf04b0ca95cc8aaec),
W64LIT(0x1f55e2e844c12a70),
W64LIT(0x4cb6cdc45ab78acb),
W64LIT(0xc05ca327e3918812),
W64LIT(0x95feda9da9285131),
W64LIT(0xb966bcb0782d9ff3),
W64LIT(0xa7d647618934f714),
W64LIT(0xd61090cb7169ef73),
W64LIT(0x71c6d7aaf85d1867),
W64LIT(0xecc4c50a329446d0),
W64LIT(0x6450cf0d4038b94a),
W64LIT(0x420b536f6d99fcd5),
W64LIT(0x75b8b34e33d7e524),
W64LIT(0xc26391557cd40cc9),
W64LIT(0xda923c12d9021db6),
W64LIT(0x4e89ffb6c5f20e10),
W64LIT(0x0919d104d6394d11),
W64LIT(0x8aab3875ede97b41),
W64LIT(0xa88ec0f30bc2c39d),
W64LIT(0xb7db221b4f03e9ed),
W64LIT(0xc7f8ec880286b31d),
W64LIT(0x2f424d66fb98088e),
W64LIT(0xe04669d39affb415),
W64LIT(0x3eaa3125887754e0),
W64LIT(0x5e849acc03c510e9),
W64LIT(0x8257f0488e0874c7),
W64LIT(0xbd18d854b3a762b0),
W64LIT(0xb3a546ff848914ae),
W64LIT(0x9ce70b997f111c20),
W64LIT(0x3c9503571732d03b),
W64LIT(0xe7e2267c7be88f1a),
W64LIT(0x63f480a2a12f8245),
W64LIT(0x602eabe98bb24409),
W64LIT(0x941bc3a41cf013a6),
W64LIT(0x678ae4466aa57f06),
W64LIT(0x1232570859729a22),
W64LIT(0x6d491e099601f45b),
W64LIT(0x5d5eb1872958d6a5),
W64LIT(0x1473019e0dbde3ba),
W64LIT(0xa24d3abcf76648c0),
W64LIT(0x85f3bfe76f1f4fc8),
W64LIT(0x08fcc83d63e10f86),
W64LIT(0x745daa77860fa7b3),
W64LIT(0x9180be7962a2ac72),
W64LIT(0x87cc8d95f05acb13),
W64LIT(0x78df06ae2e645576),
W64LIT(0x18f1ad47a5d6117f),
W64LIT(0x358cd253c10b9d2a),
W64LIT(0x0ebd9eab372e761e),
W64LIT(0xf7ef4306bddf91e3),
W64LIT(0x7023ce934d855af0),
W64LIT(0xd42fa2b9ee2c6ba8),
W64LIT(0x3656f918eb965b66),
W64LIT(0x9d0212a0cac95eb7),
W64LIT(0x2ad930bb85cab75a),
W64LIT(0x862994ac45828984),
W64LIT(0x7d447b735036eaa2),
W64LIT(0xb07f6db4ae14d2e2),
W64LIT(0x6b08489fc2ce8dc3),
W64LIT(0x9b4344369e06272f),
W64LIT(0xad15bd2e75907c49),
W64LIT(0xdb77252b6cda5f21),
W64LIT(0xea85939c665b3f48),
W64LIT(0xc945722335a8c503),
W64LIT(0x159618a7b865a12d),
W64LIT(0x69377aed5d8b0918),
W64LIT(0x8971133ec774bd0d),
W64LIT(0x53e32f2c1e76a0bb),
W64LIT(0xf8b7c4943f29a56a),
W64LIT(0xff138b3bde3e9e65),
/* box 2 */
W64LIT(0x7c6a2eb5fdabecc6),
W64LIT(0x401cda0a752bbea0),
W64LIT(0x1925217156dc57c4),
W64LIT(0x56dec6d301d70787),
W64LIT(0x41c751ff73c6ac58),
W64LIT(0xc9067697a92cb5f9),
W64LIT(0x3391c917aaa0bc85),
W64LIT(0xae0a9a4c0e742afe),
W64LIT(0xaa8ca972162a62f4),
W64LIT(0x5aa193912935df99),
W64LIT(0x86fd9135fe27e5ba),
W64LIT(0xffca074b1d3f538e),
W64LIT(0x0e3cb65d24cdfc1b),
W64LIT(0x4384b2e07fe9885d),
W64LIT(0xc73ac0ca8de149e2),
W64LIT(0x48e5bc7645972eb4),
W64LIT(0xbe0d56b46ef9ffd6),
W64LIT(0x200e6d05c0ef5f50),
W64LIT(0xe1f17dee597f7abd),
W64LIT(0x0243e31f0c2f2405),
W64LIT(0xf4ab09dd2741f567),
W64LIT(0xe4acc52547cc204f),
W64LIT(0x348f92c3b83cc272),
W64LIT(0x53837e181f645d75),
W64LIT(0xd8da319acf4c7229),
W64LIT(0x81e3cae1ecbb9b4d),
W64LIT(0xd6e687c7eb818e32),
W64LIT(0x3dad7f4a8e6d409e),
W64LIT(0x28f70b79f053cf44),
W64LIT(0x493e3783437a3c4c),
W64LIT(0xb27203f6461b27c8),
W64LIT(0xd02357e6fff0e23d),
W64LIT(0xe8d390676f2ef851),
W64LIT(0x26cbbd24d49e335f),
W64LIT(0xee1640467b5f945e),
W64LIT(0x4aa65f6949b80ab1),
W64LIT(0xb56c58225487593f),
W64LIT(0x4ffbe7a2570b5043),
W64LIT(0x0aba85633c93b411),
W64LIT(0x78ec1d8be5f5a4cc),
W64LIT(0x501b16f215a66b88),
W64LIT(0x271036d1d27321a7),
W64LIT(0x7ff2465ff769da3b),
W64LIT(0x35541936bed1d08a),
W64LIT(0xb8c886957a8893d9),
W64LIT(0x2fe950ade2cfb1b3),
W64LIT(0xf90fd76a094e3f81),
W64LIT(0x2daab3b2eee095b6),
W64LIT(0x1abd499b5c1e6139),
W64LIT(0x0c7f554228e2d81e),
W64LIT(0x425f391579049aa5),
W64LIT(0xc3bcf3f495bf01e8),
W64LIT(0xb4b7d3d7526a4bc7),
W64LIT(0x0000000000000000),
W64LIT(0xa0362c112ab9d6e5),
W64LIT(0x91e406198c364e65),
W64LIT(0x454162c16b98e452),
W64LIT(0x139fa4126a4fe3d5),
W64LIT(0x01db8bf506ed12f8),
W64LIT(0x9a85088fb648e88c),
W64LIT(0x3ab3249e9cf13e69),
W64LIT(0xd57eef2de143b8cf),
W64LIT(0xb1ea6b1c4cd91135),
W64LIT(0x7aaffe94e9da80c9),
W64LIT(0xad92f2a604b61c03),
W64LIT(0xa3ae44fb207be018),
W64LIT(0xeb4bf88d65ecceac),
W64LIT(0xc0249b1e9f7d3715),
W64LIT(0xa8cf4a6d1a0546f1),
W64LIT(0xc6e14b3f8b0c5b1a),
W64LIT(0xce182d43bbb0cb0e),
W64LIT(0xfc526fa117fd6573),
W64LIT(0x8c471456c2b451ab),
W64LIT(0xac497953025b0efb),
W64LIT(0x0486333e185e480a),
W64LIT(0x18feaa845031453c),
W64LIT(0xa1eda7e42c54c41d),
W64LIT(0x06c5d02114716c0f),
W64LIT(0x055db8cb1eb35af2),
W64LIT(0xe5774ed0412132b7),
W64LIT(0x36cc71dcb413e677),
W64LIT(0x470281de67b7c057),
W64LIT(0x58e2708e251afb9c),
W64LIT(0xa914c1981ce85409),
W64LIT(0xb3a9880340f63530),
W64LIT(0x638adfe5bf06d70d),
W64LIT(0x0b610e963a7ea6e9),
W64LIT(0x927c6ef386f47898),
W64LIT(0xed8e28ac719da2a3),
W64LIT(0x7548c33ccbfa6e2a),
W64LIT(0xf3b5520935dd8b90),
W64LIT(0x8d9c9fa3c4594353),
W64LIT(0x31d22a08a68f9880),
W64LIT(0x0da4deb72e0fcae6),
W64LIT(0x8fdf7cbcc8766756),
W64LIT(0x5dbfc8453ba9a16e),
W64LIT(0x8e04f749ce9b75ae),
W64LIT(0x83a029fee094bf48),
W64LIT(0xa4b01f2f32e79eef),
W64LIT(0x1c7899ba486f0d36),
W64LIT(0x654f0fc4ab77bb02),
W64LIT(0x7db1a540fb46fe3e),
W64LIT(0x51c09d07134b7970),
W64LIT(0xcb459588a50391fc),
W64LIT(0x3fee9c558242649b),
W64LIT(0xfe118cbe1bd24176),
W64LIT(0x76d0abd6c13858d7),
W64LIT(0x5e27a0af316b9793),
W64LIT(0x69305a868395631c),
W64LIT(0x3b68af6b9a1c2c91),
W64LIT(0x6db669b89bcb2b16),
W64LIT(0xa72877c53825a812),
W64LIT(0xd3bb3f0cf532d4c0),
W64LIT(0x6ff58aa797e40f13),
W64LIT(0x96fa5dcd9eaa3092),
W64LIT(0x2c713847e80d874e),
W64LIT(0xc57923d581ce6de7),
W64LIT(0x2b6f6393fa91f9b9),
W64LIT(0x0922ed89365182ec),
W64LIT(0x324a42e2ac4dae7d),
W64LIT(0x16c21cd974fcb927),
W64LIT(0x956235279468066f),
W64LIT(0x7b747561ef379231),
W64LIT(0x449ae9346d75f6aa),
W64LIT(0xf570822821ace79f),
W64LIT(0x5939fb7b23f7e964),
W64LIT(0x7937967ee318b634),
W64LIT(0x84be722af208c1bf),
W64LIT(0x08f9667c30bc9014),
W64LIT(0xefcdcbb37db286a6),
W64LIT(0xa6f3fc303ec8baea),
W64LIT(0xea9073786301dc54),
W64LIT(0x62515410b9ebc5f5),
W64LIT(0xd260b4f9f3dfc638),
W64LIT(0x9e033bb1ae16a086),
W64LIT(0x38f0c78190de1a6c),
W64LIT(0xc267780193521310),
W64LIT(0x80384114ea5689b5),
W64LIT(0x9b5e837ab0a5fa74),
W64LIT(0xf73361372d83c39a),
W64LIT(0x3009a1fda0628a78),
W64LIT(0xd4a564d8e7aeaa37),
W64LIT(0xfb4c347505611b84),
W64LIT(0x5b7a18642fd8cd61),
W64LIT(0x239605efca2d69ad),
W64LIT(0xf8d45c9f0fa32d79),
W64LIT(0xbb50ee7f704aa524),
W64LIT(0x392b4c7496330894),
W64LIT(0x0fe73da82220eee3),
W64LIT(0x3717fa29b2fef48f),
W64LIT(0xf26ed9fc33309968),
W64LIT(0xd73d0c32ed6c9cca),
W64LIT(0xda99d285c363562c),
W64LIT(0xde1fe1bbdb3d1e26),
W64LIT(0x738d131ddf8b0225),
W64LIT(0x292c808cf6beddbc),
W64LIT(0xbc4eb5ab62d6dbd3),
W64LIT(0x039868ea0ac236fd),
W64LIT(0xcc5bce5cb79fef0b),
W64LIT(0xb031e0e94a3403cd),
W64LIT(0xc4a2a82087237f1f),
W64LIT(0xb72fbb3d58a87d3a),
W64LIT(0xafd111b908993806),
W64LIT(0x68ebd173857871e4),
W64LIT(0x9d9b535ba4d4967b),
W64LIT(0xe9081b9269c3eaa9),
W64LIT(0x71cef002d3a42620),
W64LIT(0x93a7e50680196a60),
W64LIT(0x891aac9ddc070b59),
W64LIT(0x155a74337e3e8fda),
W64LIT(0x4e206c5751e642bb),
W64LIT(0x9721d6389847226a),
W64LIT(0x12442fe76ca2f12d),
W64LIT(0x2553d5cede5c05a2),
W64LIT(0xa275cf0e2696f2e0),
W64LIT(0x24885e3bd8b1175a),
W64LIT(0x670cecdba7589f07),
W64LIT(0x749348c9cd177cd2),
W64LIT(0x64948431ad9aa9fa),
W64LIT(0x2ab4e866fc7ceb41),
W64LIT(0xe6ef263a4be3044a),
W64LIT(0xe734adcf4d0e16b2),
W64LIT(0x903f8dec8adb5c9d),
W64LIT(0xf02d3ae33f1fbd6d),
W64LIT(0x725698e8d96610dd),
W64LIT(0x1da3124f4e821fce),
W64LIT(0x1719972c7211abdf),
W64LIT(0x11dc470d6660c7d0),
W64LIT(0xec55a3597770b05b),
W64LIT(0xbfd6dd416814ed2e),
W64LIT(0x57054d26073a157f),
W64LIT(0x1e3b7aa544402933),
W64LIT(0x5ffc2b5a3786856b),
W64LIT(0x61c93cfab329f308),
W64LIT(0x3e3517a084af7663),
W64LIT(0xf6e8eac22b6ed162),
W64LIT(0x1007ccf8608dd528),
W64LIT(0x66d7672ea1b58dff),
W64LIT(0x8b594f82d0282f5c),
W64LIT(0x1fe0f15042ad3bcb),
W64LIT(0x4b7dd49c4f551849),
W64LIT(0x4c638f485dc966be),
W64LIT(0xcfc3a6b6bd5dd9f6),
W64LIT(0x46d90a2b615ad2af),
W64LIT(0x8565f9dff4e5d347),
W64LIT(0x94b9bed292851497),
W64LIT(0xfa97bf80038c097c),
W64LIT(0xb9130d607c658121),
W64LIT(0xdc5c02a4d7123a23),
W64LIT(0x224d8e1accc07b55),
W64LIT(0x87261ac0f8caf742),
W64LIT(0xd901ba6fc9a160d1),
W64LIT(0xab57228710c7700c),
W64LIT(0x21d5e6f0c6024da8),
W64LIT(0x98c6eb90ba67cc89),
W64LIT(0x827ba20be679adb0),
W64LIT(0x991d6065bc8ade71),
W64LIT(0x5546ae390b15317a),
W64LIT(0xa56b94da340a8c17),
W64LIT(0x071e5bd4129c7ef7),
W64LIT(0xe02af61b5f926845),
W64LIT(0x6b73b9998fba4719),
W64LIT(0xdfc46a4eddd00cde),
W64LIT(0x770b2023c7d54a2f),
W64LIT(0x7e29cdaaf184c8c3),
W64LIT(0xba8b658a76a7b7dc),
W64LIT(0x9c40d8aea2398483),
W64LIT(0x9fd8b044a8fbb27e),
W64LIT(0xdb425970c58e44d4),
W64LIT(0xe269150453bd4c40),
W64LIT(0x3c76f4bf88805266),
W64LIT(0xf1f6b11639f2af95),
W64LIT(0x549d25cc0df82382),
W64LIT(0x4db804bd5b247446),
W64LIT(0x8a82c477d6c53da4),
W64LIT(0x5258f5ed19894f8d),
W64LIT(0x6e2e015291091deb),
W64LIT(0xc1ff10eb999025ed),
W64LIT(0xbd953e5e643bc92b),
W64LIT(0xc8ddfd62afc1a701),
W64LIT(0x5c6443b03d44b396),
W64LIT(0x6c6de24d9d2639ee),
W64LIT(0x1481ffc678d39d22),
W64LIT(0xd1f8dc13f91df0c5),
W64LIT(0xca9e1e7da3ee8304),
W64LIT(0xdd878951d1ff28db),
W64LIT(0x6012b70fb5c4e1f0),
W64LIT(0x1b66c26e5af373c1),
W64LIT(0xe3b29ef155505eb8),
W64LIT(0x70157bf7d54934d8),
W64LIT(0x2e32db58e422a34b),
W64LIT(0x6aa8326c895755e1),
W64LIT(0xb6f430c85e456fc2),
W64LIT(0xfd89e4541110778b),
W64LIT(0x88c12768daea19a1),
W64LIT(0xcd8045a9b172fdf3),
/* box 3 */
W64LIT(0x99183e616655b742),
W64LIT(0xb2872032a50d6860),
W64LIT(0x0946f63b060528ef),
W64LIT(0x36612b9a141ef07d),
W64LIT(0x0634da84dd49579b),
W64LIT(0xfc9c9e9b486c8a57),
W64LIT(0xa63fe3c0744e6fd0),
W64LIT(0xf1515758d8b46bf9),
W64LIT(0x3e82559fcd5197ff),
W64LIT(0x92e12d262bc40177),
W64LIT(0xc3bb433a5a7752c5),
W64LIT(0x21c3852a5183267a),
W64LIT(0x39130725cf528f09),
W64LIT(0x9ba7db1d2dc12998),
W64LIT(0xc58f99be873e055e),
W64LIT(0xd9d424498f32656c),
W64LIT(0x27f75fae8cca71e1),
W64LIT(0x59b91019a8fc3430),
W64LIT(0xce768af9caafb36b),
W64LIT(0x9d930199f0887e03),
W64LIT(0x63b07a7ef3706a8e),
W64LIT(0xb5167288a70e7096),
W64LIT(0x40cc1a28e967d22e),
W64LIT(0x4d01d3eb79bf3380),
W64LIT(0x9e896cdb6456afb4),
W64LIT(0x2548bad2c75eef3b),
W64LIT(0xa79a6bfeab0420bd),
W64LIT(0x9f2ce4e5bb1ce0d9),
W64LIT(0x32ea146282c3393c),
W64LIT(0x6d67defff7765a97),
W64LIT(0x83775912b31080eb),
W64LIT(0xf5da68a04e69a2b8),
W64LIT(0x1196743498d4819c),
W64LIT(0x0bf913474d91b635),
W64LIT(0x43d6776a7db90399),
W64LIT(0x444725d07fba1b6f),
W64LIT(0x6584a0fa2e393d15),
W64LIT(0x3f27dda1121bd892),
W64LIT(0xf6c005e2dab7730f),
W64LIT(0x56cb3ca673b04b44),
W64LIT(0x642128c4f1737278),
W64LIT(0xbf4ae9f135d589ce),
W64LIT(0xb038c54eee99f6ba),
W64LIT(0xf47fe09e9123edd5),
W64LIT(0x75b75cf069a7f3e4),
W64LIT(0xd419ed8a1fea84c2),
W64LIT(0x73838674b4eea47f),
W64LIT(0x498aec13ef62fac1),
W64LIT(0x20660d148ec96917),
W64LIT(0xa48006bc3fdaf10a),
W64LIT(0x2f1421ab55851663),
W64LIT(0x0a5c9b7992dbf958),
W64LIT(0xd1375a4c567d02ee),
W64LIT(0x0000000000000000),
W64LIT(0xc842507d17e6e4f0),
W64LIT(0xf3eeb2249320f523),
W64LIT(0xc9e7d843c8acab9d),
W64LIT(0xff86f3d9dcb25be0),
W64LIT(0xb4b3fab678443ffb),
W64LIT(0xb19d4d7031d3b9d7),
W64LIT(0x79df1d0d26355d27),
W64LIT(0x8eba90d123c86145),
W64LIT(0xaa57a23d3bdcc113),
W64LIT(0xcb583d3f83383547),
W64LIT(0xd871ac7750782a01),
W64LIT(0xe162ab529f2aa508),
W64LIT(0x38b68f1b1018c064),
W64LIT(0x237c60561a17b8a0),
W64LIT(0xa31154063dd9e9fc),
W64LIT(0x713c6308ff7a3aa5),
W64LIT(0x1a6f6773d54537a9),
W64LIT(0x08e37e05d94f6782),
W64LIT(0x357b46d880c021ca),
W64LIT(0x6cc256c1283c15fa),
W64LIT(0xcfd302c715e5fc06),
W64LIT(0xbdf50c8d7e411714),
W64LIT(0x7cf1aacb6fa2db0b),
W64LIT(0x5240035ee56d8205),
W64LIT(0x7b60f8716da1c3fd),
W64LIT(0x01a5883edf4a4f6d),
W64LIT(0xdd5f1bb119efac2d),
W64LIT(0x5474d9da3824d59e),
W64LIT(0x0f722cbfdb4c7f74),
W64LIT(0x17a2aeb0459dd607),
W64LIT(0x37c4a3a4cb54bf10),
W64LIT(0xc21ecb04853d1da8),
W64LIT(0x4273ff54a2f34cf4),
W64LIT(0xdace490b1becb4db),
W64LIT(0x6af68c45f5754261),
W64LIT(0x46f8c0ac342e85b5),
W64LIT(0x854383966e59d770),
W64LIT(0x81c8bc6ef8841e31),
W64LIT(0x3bace25984c611d3),
W64LIT(0x1033fc0a479ecef1),
W64LIT(0x1c5bbdf7080c6032),
W64LIT(0x7412d4ceb6edbc89),
W64LIT(0xa8e8474170485fc9),
W64LIT(0xb8dbbb4b37d69138),
W64LIT(0x079152ba020318f6),
W64LIT(0x72260e4a6ba4eb12),
W64LIT(0x905ec85a60509fad),
W64LIT(0x2dabc4d71e1188b9),
W64LIT(0xd092d27289374d83),
W64LIT(0x610f9f02b8e4f454),
W64LIT(0x02bfe57c4b949eda),
W64LIT(0x95707f9c29c71981),
W64LIT(0x6fd83b83bce2c44d),
W64LIT(0x5d322fe13e21fd71),
W64LIT(0x34decee65f8a6ea7),
W64LIT(0xcd6ce7bb5e7162dc),
W64LIT(0xfb0dcc214a6f92a1),
W64LIT(0x2eb1a9958acf590e),
W64LIT(0xdcfa938fc6a5e340),
W64LIT(0x669ecdb8bae7eca2),
W64LIT(0x151d4bcc0e0948dd),
W64LIT(0xfd3916a59726c53a),
W64LIT(0x581c982777b67b5d),
W64LIT(0x1bcaef4d0a0f78c4),
W64LIT(0xdfe0fecd527b32f7),
W64LIT(0x128c19760c0a502b),
W64LIT(0x84e60ba8b113981d),
W64LIT(0x3c3db0e386c50925),
W64LIT(0x7febc789fb7c0abc),
W64LIT(0x7d5422f5b0e89466),
W64LIT(0xd70380c88b345575),
W64LIT(0xbbc1d609a308408f),
W64LIT(0xe278c6100bf474bf),
W64LIT(0x5e2842a3aaff2cc6),
W64LIT(0x6b53047b2a3f0d0c),
W64LIT(0xf7658ddc05fd3c62),
W64LIT(0x9a025323f28b66f5),
W64LIT(0x8c0575ad685cff9f),
W64LIT(0x76ad31b2fd792253),
W64LIT(0x68496939bee1dcbb),
W64LIT(0x7e4e4fb7243645d1),
W64LIT(0xe44c1c94d6bd2324),
W64LIT(0xbeef61cfea9fc6a3),
W64LIT(0x91fb4064bf1ad0c0),
W64LIT(0x052eb7c64997862c),
W64LIT(0x4a9081517bbc2b76),
W64LIT(0x8f1f18effc822e28),
W64LIT(0x3a096a675b8c5ebe),
W64LIT(0xee1087ed4466da7c),
W64LIT(0x2652d79053803e8c),
W64LIT(0x7099eb36203075c8),
W64LIT(0xc7307cc2ccaa9b84),
W64LIT(0x5c97a7dfe16bb21c),
W64LIT(0x50ffe622aef91cdf),
W64LIT(0x8da0fd93b716b0f2),
W64LIT(0x69ece10761ab93d6),
W64LIT(0x31f07920161de88b),
W64LIT(0x13299148d3401f46),
W64LIT(0x031a6d4294ded1b7),
W64LIT(0xccc96f85813b2db1),
W64LIT(0x14b8c3f2d14307b0),
W64LIT(0x8659eed4fa8706c7),
W64LIT(0xba645e377c420fe2),
W64LIT(0x2920fb2f88cc41f8),
W64LIT(0x87fc66ea25cd49aa),
W64LIT(0x1ee4588b4398fee8),
W64LIT(0xecaf62910ff244a6),
W64LIT(0xf817a163deb14316),
W64LIT(0x45e2adeea0f05402),
W64LIT(0x806d345027ce515c),
W64LIT(0x576eb498acfa0429),
W64LIT(0xa5258e82e090be67),
W64LIT(0x892bc26b21cb79b3),
W64LIT(0x6e7db3bd63a88b20),
W64LIT(0x4e1bbea9ed61e237),
W64LIT(0xadc6f08739dfd9e5),
W64LIT(0x8b9427176a5fe769),
W64LIT(0xa1aeb17a764d7726),
W64LIT(0x4b35096fa4f6641b),
W64LIT(0x22d9e868c55df7cd),
W64LIT(0x55d151e4e76e9af3),
W64LIT(0x966a12debd19c836),
W64LIT(0x0dcdc9c390d8e1ae),
W64LIT(0xf24b3a1a4c6aba4e),
W64LIT(0x24ed32ec1814a056),
W64LIT(0xaf7915fb724b473f),
W64LIT(0x2885731157860e95),
W64LIT(0x9c3689a72fc2316e),
W64LIT(0x475d4892eb64cad8),
W64LIT(0xac6378b9e6959688),
W64LIT(0xa00b3944a907384b),
W64LIT(0xc695f4fc13e0d4e9),
W64LIT(0x3055f11ec957a7e6),
W64LIT(0x6215f2402c3a25e3),
W64LIT(0xde4576f38d317d9a),
W64LIT(0x9344a518f48e4e1a),
W64LIT(0x82d2d12c6c5acf86),
W64LIT(0xefb50fd39b2c9511),
W64LIT(0xe981d5574665c28a),
W64LIT(0x5f8dca9d75b563ab),
W64LIT(0xb60c1fca33d0a121),
W64LIT(0xfe237be703f8148d),
W64LIT(0xd6a608f6547e1a18),
W64LIT(0xb97e3375e89cde55),
W64LIT(0xd388bf301de99c34),
W64LIT(0x5b06f565e368aaea),
W64LIT(0xf0f4df6607fe2494),
W64LIT(0x1607268e9ad7996a),
W64LIT(0xaedc9dc5ad010852),
W64LIT(0xe0c7236c4060ea65),
W64LIT(0xea9bb815d2bb133d),
W64LIT(0x888e4a55fe8136de),
W64LIT(0x5aa37d5b3c22e587),
W64LIT(0xc104a64611e3cc1f),
W64LIT(0x515a6e1c71b353b2),
W64LIT(0xc42a118058744a33),
W64LIT(0x7708b98c22336d3e),
W64LIT(0x2a3a966d1c12904f),
W64LIT(0x8a31af29b515a804),
W64LIT(0xed0aeaafd0b80bcb),
W64LIT(0x2c0e4ce9c15bc7d4),
W64LIT(0x0c6841fd4f92aec3),
W64LIT(0x98bdb65fb91ff82f),
W64LIT(0x1f41d0b59cd2b185),
W64LIT(0xb322a80c7a47270d),
W64LIT(0xe6f3f9e89d29bdfe),
W64LIT(0x7ac5704fb2eb8c90),
W64LIT(0xa94dcf7faf0210a4),
W64LIT(0x787a9533f97f124a),
W64LIT(0xdb6bc135c4a6fbb6),
W64LIT(0x048b3ff896ddc941),
W64LIT(0xe8245d69992f8de7),
W64LIT(0xe3dd4e2ed4be3bd2),
W64LIT(0xcafdb5015c727a2a),
W64LIT(0xb7a997f4ec9aee4c),
W64LIT(0xe75671d64263f293),
W64LIT(0x2b9f1e53c358df22),
W64LIT(0x18d0820f9ed1a973),
W64LIT(0xabf22a03e4968e7e),
W64LIT(0xa2b4dc38e293a691),
W64LIT(0x673b458665ada3cf),
W64LIT(0xf9b2295d01fb0c7b),
W64LIT(0xd22d370ec2a3d359),
W64LIT(0x97cf9ae06253875b),
W64LIT(0x0ed7a48104063019),
W64LIT(0x482f642d3028b5ac),
W64LIT(0xc0a12e78cea98372),
W64LIT(0x4fbe3697322bad5a),
W64LIT(0x19750a31419be61e),
W64LIT(0x41699216362d9d43),
W64LIT(0xd5bc65b4c0a0cbaf),
W64LIT(0xe5e994aa09f76c49),
W64LIT(0xeb3e302b0df15c50),
W64LIT(0x94d5f7a2f68d56ec),
W64LIT(0x53e58b603a27cd68),
W64LIT(0x3d9838dd598f4648),
W64LIT(0x60aa173c67aebb39),
W64LIT(0x1dfe35c9d7462f5f),
W64LIT(0x4ca45bd5a6f57ced),
W64LIT(0xbc5084b3a10b5879),
W64LIT(0xfaa8441f9525ddcc),
W64LIT(0x334f9c5c5d897651),
/* box 4 */
W64LIT(0xda1687a883adf27e),
W64LIT(0xe35c9378578d9f22),
W64LIT(0x303ca4531637fa40),
W64LIT(0xa088321f74b20375),
W64LIT(0xc9863f3a9acb95e9),
W64LIT(0x5fcf47c57d0b0ed4),
W64LIT(0x4aa211e4e1280b4b),
W64LIT(0xe1a4c9ba871d1289),
W64LIT(0x4926664759f03a4f),
W64LIT(0xadfb36ede3707bca),
W64LIT(0xcf7bd1891f8ef7e1),
W64LIT(0x9735559e8f882792),
W64LIT(0x5932a976f84e6cdc),
W64LIT(0x9dc792bef547818a),
W64LIT(0x06fdeeb385456208),
W64LIT(0x46ad38771ea2cf5b),
W64LIT(0x5eb36aa41543b27b),
W64LIT(0x8b2eb33cd1bcb511),
W64LIT(0x71105ff6e598ebbc),
W64LIT(0x5441ad846f8c1463),
W64LIT(0x4c5fff57646d6943),
W64LIT(0xf3485c49f633c9b1),
W64LIT(0x9cbbbfdf9d0f3d25),
W64LIT(0x22d031a067192178),
W64LIT(0xca0248992213a4ed),
W64LIT(0x19627fb263a9c18f),
W64LIT(0x9330e1efda5dc831),
W64LIT(0x1390b89219666797),
W64LIT(0x2edf18339893e568),
W64LIT(0x6c779435d3e4c590),
W64LIT(0x53c06e568281cac4),
W64LIT(0x6ff3e3966b3cf494),
W64LIT(0xfe3b58bb61f1b10e),
W64LIT(0x77edb14560dd89b4),
W64LIT(0x02f85ac2d0908dab),
W64LIT(0x12ec95f3712edb38),
W64LIT(0x85d9c06dfea6fcaa),
W64LIT(0x90b4964c6285f935),
W64LIT(0xf1b0068b26a3441a),
W64LIT(0x729428555d40dab8),
W64LIT(0x5c4b3066c5d33fd0),
W64LIT(0x5d371d07ad9b837f),
W64LIT(0xa48d866e2167ecd6),
W64LIT(0xb661139d504937ee),
W64LIT(0xa27068dda4228ede),
W64LIT(0xf8c6b608e4b4d306),
W64LIT(0x6bf657e73ee91b37),
W64LIT(0xac871b8c8b38c765),
W64LIT(0x4ea7a595b4fde4e8),
W64LIT(0x0d7304f297c278bf),
W64LIT(0xb71d3efc38018b41),
W64LIT(0xae7f414e5ba84ace),
W64LIT(0xaf036c2f33e0f661),
W64LIT(0x0000000000000000),
W64LIT(0xb89660cc7f537e55),
W64LIT(0xa675dcacf1f7617d),
W64LIT(0x610490c74426bd2f),
W64LIT(0xc18ca2d83094be5a),
W64LIT(0x2adaac42cd460acb),
W64LIT(0x7d1f76651a122fac),
W64LIT(0xc58916a9654151f9),
W64LIT(0xedabe0297897d699),
W64LIT(0x2d5b6f90204bd46c),
W64LIT(0x26d585d132cccedb),
W64LIT(0x9f3fc87c25d70c21),
W64LIT(0xc60d610add9960fd),
W64LIT(0x80a0597dc33bafa6),
W64LIT(0xd0e44088f9625466),
W64LIT(0x1d67cbc3367c2e2c),
W64LIT(0x2c2742f1480368c3),
W64LIT(0x89d6e9fe012c38ba),
W64LIT(0xe9ae54582d42393a),
W64LIT(0x3ecbd702392db3fb),
W64LIT(0xb5e5643ee89106ea),
W64LIT(0xa882affddeed28c6),
W64LIT(0x1ae60811db71f08b),
W64LIT(0x924ccc8eb215749e),
W64LIT(0xfcc30279b1613ca5),
W64LIT(0x825803bf13ab220d),
W64LIT(0xd992f00b3b75c37a),
W64LIT(0xc8fa125bf2832946),
W64LIT(0x35453d432baaa94c),
W64LIT(0xf9ba9b698cfc6fa9),
W64LIT(0x37bd6781fb3a24e7),
W64LIT(0x791ac2144fc7c00f),
W64LIT(0x16e9218224fb349b),
W64LIT(0xdb6aaac9ebe54ed1),
W64LIT(0xd8eedd6a533d7fd5),
W64LIT(0x7c635b04725a9303),
W64LIT(0x553d80e507c4a8cc),
W64LIT(0x9a46516c184a5f2d),
W64LIT(0x14117b40f46bb930),
W64LIT(0x1ee3bc608ea41f28),
W64LIT(0x27a9a8b05a847274),
W64LIT(0x4050d6c49be7ad53),
W64LIT(0x7be298d69f574da4),
W64LIT(0x6a8a7a8656a1a798),
W64LIT(0x4d23d2360c25d5ec),
W64LIT(0x1014cf31a1be5693),
W64LIT(0xb264a7ec059cd84d),
W64LIT(0xea2a23fb959a083e),
W64LIT(0xf0cc2bea4eebf8b5),
W64LIT(0x76919c240895351b),
W64LIT(0x0b8eea4112871ab7),
W64LIT(0x47d1151676ea73f4),
W64LIT(0xbdeff9dc42ce2d59),
W64LIT(0x2ba68123a50eb664),
W64LIT(0x057999103d9d530c),
W64LIT(0xe759270902587081),
W64LIT(0xef53baeba8075b32),
W64LIT(0x4fdb88f4dcb55847),
W64LIT(0x6e8fcef70374483b),
W64LIT(0x1168e250c9f6ea3c),
W64LIT(0x1b9a2570b3394c24),
W64LIT(0x706c72978dd05713),
W64LIT(0x865db7ce467ecdae),
W64LIT(0x52bc4337eac9766b),
W64LIT(0x504419f53a59fbc0),
W64LIT(0x8f2b074d84695ab2),
W64LIT(0x6078bda62c6e0180),
W64LIT(0x43d4a167233f9c57),
W64LIT(0x0ef773512f1a49bb),
W64LIT(0x0c0f2993ff8ac410),
W64LIT(0x4bde3c858960b7e4),
W64LIT(0x66855315a92b6388),
W64LIT(0xd360372b41ba6562),
W64LIT(0x584e84179006d073),
W64LIT(0x9b3a7c0d7002e382),
W64LIT(0xa5f1ab0f492f5079),
W64LIT(0x2822f6801dd68760),
W64LIT(0x445562b5ce3242f0),
W64LIT(0xaa7af53f0e7da56d),
W64LIT(0x3c338dc0e9bd3e50),
W64LIT(0x3bb24e1204b0e0f7),
W64LIT(0xd59dd998c4ff076a),
W64LIT(0x91c8bb2d0acd459a),
W64LIT(0x84a5ed0c96ee4005),
W64LIT(0x33b8d3f0aeefcb44),
W64LIT(0x57c5da27d7542567),
W64LIT(0x32c4fe91c6a777eb),
W64LIT(0x3439102243e215e3),
W64LIT(0xc7714c6bb5d1dc52),
W64LIT(0x3fb7fa6351650f54),
W64LIT(0x87219aaf2e367101),
W64LIT(0xf5b5b2fa7376abb9),
W64LIT(0x412cfba5f3af11fc),
W64LIT(0xdceb691b06e89076),
W64LIT(0xbb12176fc78b4f51),
W64LIT(0x73e8053435086617),
W64LIT(0xe220be193fc5238d),
W64LIT(0xb09cfd2ed50c55e6),
W64LIT(0xb9ea4dad171bc2fa),
W64LIT(0x9e43e51d4d9fb08e),
W64LIT(0x36c14ae093729848),
W64LIT(0xa9fe829cb6a59469),
W64LIT(0x0405b47155d5efa3),
W64LIT(0x0af2c7207acfa618),
W64LIT(0x7e9b01c6a2ca1ea8),
W64LIT(0xdd97447a6ea02cd9),
W64LIT(0x0781c3d2ed0ddea7),
W64LIT(0x7866ef75278f7ca0),
W64LIT(0xd1986de9912ae8c9),
W64LIT(0xcb7e65f84a5b1842),
W64LIT(0xcd838b4bcf1e7a4a),
W64LIT(0xab06d85e663519c2),
W64LIT(0xd4e1f4f9acb7bbc5),
W64LIT(0xfdbf2f18d929800a),
W64LIT(0xf23471289e7b751e),
W64LIT(0xbc93d4bd2a8691f6),
W64LIT(0x3d4fa0a181f582ff),
W64LIT(0xba6e3a0eafc3f3fe),
W64LIT(0x5ab6ded540965dd8),
W64LIT(0xeb560e9afdd2b491),
W64LIT(0x0976b083c217971c),
W64LIT(0xecd7cd4810df6a36),
W64LIT(0x23ac1cc10f519dd7),
W64LIT(0xbe6b8e7ffa161c5d),
W64LIT(0x7fe72ca7ca82a207),
W64LIT(0xc0f08fb958dc02f5),
W64LIT(0x7a9eb5b7f71ff10b),
W64LIT(0xa709f1cd99bfddd2),
W64LIT(0x8dd35d8f54f9d719),
W64LIT(0x8caf70ee3cb16bb6),
W64LIT(0xe4dd50aaba804185),
W64LIT(0x83242ede7be39ea2),
W64LIT(0x98be0baec8dad286),
W64LIT(0x690e0d25ee79969c),
W64LIT(0x95cd0f5c5f18aa39),
W64LIT(0x56b9f746bf1c99c8),
W64LIT(0x7469c6e6d805b8b0),
W64LIT(0x8a529e5db9f409be),
W64LIT(0xe6250a686a10cc2e),
W64LIT(0x2fa33552f0db59c7),
W64LIT(0x42a88c064b7720f8),
W64LIT(0x6d0bb954bbac793f),
W64LIT(0x181e52d30be17d20),
W64LIT(0xbf17a31e925ea0f2),
W64LIT(0x94b1223d37501696),
W64LIT(0xe8d27939450a8595),
W64LIT(0xccffa62aa756c6e5),
W64LIT(0x383639b1bc68d1f3),
W64LIT(0xee2f978ac04fe79d),
W64LIT(0xa30c45bccc6a3271),
W64LIT(0x1f9f9101e6eca387),
W64LIT(0xb1e0d04fbd44e949),
W64LIT(0x242ddf13e25c4370),
W64LIT(0x156d56219c23059f),
W64LIT(0x88aac49f69648415),
W64LIT(0x6280e764fcfe8c2b),
W64LIT(0xdf6f1eb8be30a172),
W64LIT(0xe5a17dcbd2c8fd2a),
W64LIT(0xe0d8e4dbef55ae26),
W64LIT(0x63fcca0594b63084),
W64LIT(0xa1f41f7e1cfabfda),
W64LIT(0x295edbe1759e3bcf),
W64LIT(0x67f97e74c163df27),
W64LIT(0x038477a3b8d83104),
W64LIT(0xde1333d9d6781ddd),
W64LIT(0x3ace63736cf85c58),
W64LIT(0xd619ae3b7c27366e),
W64LIT(0x5bcaf3b428dee177),
W64LIT(0xb3188a8d6dd464e2),
W64LIT(0x1c1be6a25e349283),
W64LIT(0x017c2d616848bcaf),
W64LIT(0x8e572a2cec21e61d),
W64LIT(0xf631c559cbae9abd),
W64LIT(0x81dc741cab731309),
W64LIT(0xff4775da09b90da1),
W64LIT(0xb499495f80d9ba45),
W64LIT(0x0f8b5e304752f514),
W64LIT(0x394a14d0d4206d5c),
W64LIT(0xce07fce877c64b4e),
W64LIT(0xf4c99f9b1b3e1716),
W64LIT(0xc4f53bc80d09ed56),
W64LIT(0xc208d57b884c8f5e),
W64LIT(0x080a9de2aa5f2bb3),
W64LIT(0x314089327e7f46ef),
W64LIT(0xfa3eecca34245ead),
W64LIT(0x20286b62b789acd3),
W64LIT(0x7515eb87b04d041f),
W64LIT(0x513834945211476f),
W64LIT(0x650124b611f3528c),
W64LIT(0x17950ce34cb38834),
W64LIT(0x45294fd4a67afe5f),
W64LIT(0x21544603dfc1107c),
W64LIT(0x485a4b2631b886e0),
W64LIT(0x6872204486312a33),
W64LIT(0x647d09d779bbee23),
W64LIT(0x2551f2728a14ffdf),
W64LIT(0xd765835a146f8ac1),
W64LIT(0xd21c1a4a29f2d9cd),
W64LIT(0x99c226cfa0926e29),
W64LIT(0xfb42c1ab5c6ce202),
W64LIT(0xc374f81ae00433f1),
W64LIT(0x964978ffe7c09b3d),
W64LIT(0xf74de838a3e62612),
/* box 5 */
W64LIT(0x74b87b36b0592c6a),
W64LIT(0x3d82d75dffb4b81c),
W64LIT(0x8884246715267825),
W64LIT(0xdaf2d8a77ed4e5de),
W64LIT(0xfeb118650e53f9c7),
W64LIT(0xbd2d1aea59226b06),
W64LIT(0x26ce87f6dbabb191),
W64LIT(0x32772ecbeb66bd0a),
W64LIT(0xd4bbf82bc5104c8c),
W64LIT(0x055357720c4e03a1),
W64LIT(0xef5be62a32d0f6fd),
W64LIT(0xbe1c84c45d186aca),
W64LIT(0xacc7e4a565a1643c),
W64LIT(0x8dd7731519687b84),
W64LIT(0x11eafe4f3c830f3a),
W64LIT(0x04ef8e68a358afe5),
W64LIT(0x40ad9ca1534b930d),
W64LIT(0xe44191d4855a5c0e),
W64LIT(0x6001d20b809420f1),
W64LIT(0x73666b70173b8243),
W64LIT(0x372479b9e728beab),
W64LIT(0x45fecbd35f0590ac),
W64LIT(0x7057f55e1301838f),
W64LIT(0xff0dc17fa1455583),
W64LIT(0x0cc467b810e804da),
W64LIT(0xb9c29482fa7ac4e3),
W64LIT(0xa003831d754960e6),
W64LIT(0x8a096353be0ad5ad),
W64LIT(0xdd2cc8e1d9b64bf7),
W64LIT(0xc7dc415052bfee3e),
W64LIT(0x9f0c137421d17572),
W64LIT(0x35a93e8d4c041323),
W64LIT(0x9a5f44062d9f76d3),
W64LIT(0x71eb2c44bc172fcb),
W64LIT(0x0ff5f99614d20516),
W64LIT(0x7789e518b4632da6),
W64LIT(0xc99561dce97b476c),
W64LIT(0x5276fcc06bf29dfb),
W64LIT(0x4a0b32454bd795ba),
W64LIT(0x9274add69e2fddec),
W64LIT(0x4f5865374799961b),
W64LIT(0xb2d8e37c4df06e10),
W64LIT(0xc4eddf7e5685eff2),
W64LIT(0xb3643a66e2e6c254),
W64LIT(0xd50721316a06e0c8),
W64LIT(0x8bb5ba49111c79e9),
W64LIT(0x2bb639546455190f),
W64LIT(0xf8d3d1390627fbaa),
W64LIT(0x38d1802ff3fabbbd),
W64LIT(0xdfa18fd5729ae67f),
W64LIT(0x4ee4bc2de88f3a5f),
W64LIT(0xf72628af12f5febc),
W64LIT(0x0aa6aee4189c06b7),
W64LIT(0x0000000000000000),
W64LIT(0x9eb0ca6e8ec7d936),
W64LIT(0xcb1826e84257eae4),
W64LIT(0x187dce8520250841),
W64LIT(0xc28f16225ef1ed9f),
W64LIT(0xc333cf38f1e741db),
W64LIT(0x4220db95f8673e85),
W64LIT(0xdc9011fb76a0e7b3),
W64LIT(0x105627559395a37e),
W64LIT(0x2f59b73cc70db6ea),
W64LIT(0xe112c6a689145faf),
W64LIT(0x82228a830dba7e92),
W64LIT(0x2ee56e26681b1aae),
W64LIT(0x2a0ae04ecb43b54b),
W64LIT(0x47738ce7f4293d24),
W64LIT(0xa7dd935bd22bcecf),
W64LIT(0xd2d93177cd644ee1),
W64LIT(0xebb4684291885918),
W64LIT(0x0e49208cbbc4a952),
W64LIT(0xa550d46f79076347),
W64LIT(0x411145bbfc5d3f49),
W64LIT(0xe6ccd6e02e76f186),
W64LIT(0x4bb7eb5fe4c139fe),
W64LIT(0x5d8305567f2098ed),
W64LIT(0x95aabd90394d73c5),
W64LIT(0x25ff19d8df91b05d),
W64LIT(0x86cd04ebaee2d177),
W64LIT(0x03319e2e043a01cc),
W64LIT(0x6b1ba5f5371e8a02),
W64LIT(0x76353c021b7581e2),
W64LIT(0x64ee5c6323cc8f14),
W64LIT(0x5c3fdc4cd03634a9),
W64LIT(0x6996e2c19c32278a),
W64LIT(0x8938fd7dba30d461),
W64LIT(0x7b4d82a0a48b297c),
W64LIT(0xbfa05ddef20ec68e),
W64LIT(0x8ee6ed3b1d527a48),
W64LIT(0x61bd0b112f828cb5),
W64LIT(0x66631b5788e0229c),
W64LIT(0x55a8ec86cc9033d2),
W64LIT(0x1c9240ed837da7a4),
W64LIT(0x150570279fdba0df),
W64LIT(0x53ca25dac4e431bf),
W64LIT(0xd636bf1f6e3ce104),
W64LIT(0xcaa4fff2ed4146a0),
W64LIT(0x787c1c8ea0b128b0),
W64LIT(0xad7b3dbfcab7c878),
W64LIT(0xfc3c5f51a57f544f),
W64LIT(0xb78bb40e41be6db1),
W64LIT(0x8c6baa0fb67ed7c0),
W64LIT(0xce4b719a4e19e945),
W64LIT(0xf96f0823a93157ee),
W64LIT(0x7d2f4bfcacff2b11),
W64LIT(0x3eb34973fb8eb9d0),
W64LIT(0xe39f81922238f227),
W64LIT(0x239dd084d7e5b230),
W64LIT(0x1fa3dec38747a668),
W64LIT(0xc5510664f99343b6),
W64LIT(0xc829b8c6466deb28),
W64LIT(0x85fc9ac5aad8d0bb),
W64LIT(0xb6376d14eea8c1f5),
W64LIT(0x9d8154408afdd8fa),
W64LIT(0x3be01e01f7c0ba71),
W64LIT(0x628c953f2bb88d79),
W64LIT(0x6d796ca93f6a886f),
W64LIT(0xfa5e960dad0b5622),
W64LIT(0xe5fd48ce2a4cf04a),
W64LIT(0xe7700ffa81605dc2),
W64LIT(0x2dd4f0086c211b62),
W64LIT(0x2221099e78f31e74),
W64LIT(0xdb4e01bdd1c2499a),
W64LIT(0xf417b68116cfff70),
W64LIT(0xb506f33aea92c039),
W64LIT(0x514762ee6fc89c37),
W64LIT(0x9c3d8d5a25eb74be),
W64LIT(0x396d59355cec17f9),
W64LIT(0xccc636aee53544cd),
W64LIT(0x0b1a77feb78aaaf3),
W64LIT(0xe9392f763aa4f490),
W64LIT(0xaaa52df96dd56651),
W64LIT(0x46cf55fd5b3f9160),
W64LIT(0xa4ec0d75d611cf03),
W64LIT(0xaff67a8b619b65f0),
W64LIT(0x3415e797e312bf67),
W64LIT(0x7af15bba0b9d8538),
W64LIT(0x811314ad09807f5e),
W64LIT(0x8771ddf101f47d33),
W64LIT(0x969b23be3d777209),
W64LIT(0xd365e86d6272e2a5),
W64LIT(0x58d05224736e9b4c),
W64LIT(0xc660984afda9427a),
W64LIT(0x5414359c63869f96),
W64LIT(0xe885f66c95b258d4),
W64LIT(0x655285798cda2350),
W64LIT(0x6cc5b5b3907c242b),
W64LIT(0x6ff42b9d944625e7),
W64LIT(0xc0025116f5dd4017),
W64LIT(0xa28ec429de65cd6e),
W64LIT(0x63304c2584ae213d),
W64LIT(0x7fa20cc807d38699),
W64LIT(0x996eda2829a5771f),
W64LIT(0x1b4c50ab241f098d),
W64LIT(0x1e1f07d928510a2c),
W64LIT(0x33cbf7d14470114e),
W64LIT(0xb055a448e6dcc398),
W64LIT(0x98d2033286b3db5b),
W64LIT(0xec6a780436eaf731),
W64LIT(0xa1bf5a07da5fcca2),
W64LIT(0xbaf30aacfe40c52f),
W64LIT(0xf144e1f31a81fcd1),
W64LIT(0xe0ae1fbc2602f3eb),
W64LIT(0x14b9a93d30cd0c9b),
W64LIT(0x596c8b3edc783708),
W64LIT(0x682a3bdb33248bce),
W64LIT(0xb87e4d98556c68a7),
W64LIT(0x80afcdb7a696d31a),
W64LIT(0x5725abb267bc9e5a),
W64LIT(0x914533f89a15dc20),
W64LIT(0x5eb29b787b1a9921),
W64LIT(0x01bcd91aaf16ac44),
W64LIT(0xc1be880c5acbec53),
W64LIT(0xedd6a11e99fc5b75),
W64LIT(0x028d4734ab2cad88),
W64LIT(0x8f5a3421b244d60c),
W64LIT(0x4dd52203ecb53b93),
W64LIT(0x3f0f906954981594),
W64LIT(0xae4aa391ce8dc9b4),
W64LIT(0x3698a0a3483e12ef),
W64LIT(0xf5ab6f9bb9d95334),
W64LIT(0x082be9d0b3b0ab3f),
W64LIT(0xd1e8af59c95e4f2d),
W64LIT(0xd87f9f93d5f84856),
W64LIT(0x6e48f2873b5089a3),
W64LIT(0x2443c0c270871c19),
W64LIT(0xb1e97d5249ca6fdc),
W64LIT(0x7c9392e603e98755),
W64LIT(0x839e5399a2acd2d6),
W64LIT(0x19c1179f8f33a405),
W64LIT(0xde1d56cfdd8c4a3b),
W64LIT(0x20ac4eaad3dfb3fc),
W64LIT(0x1af089b18b09a5c9),
W64LIT(0x3a5cc71b58d61635),
W64LIT(0x444212c9f0133ce8),
W64LIT(0x72dab26ab82d2e07),
W64LIT(0x4c69fb1943a397d7),
W64LIT(0xf3c9a6c7b1ad5159),
W64LIT(0x1d2e99f72c6b0be0),
W64LIT(0xb4ba2a2045846c7d),
W64LIT(0xe22358888d2e5e63),
W64LIT(0x2887a77a606f18c3),
W64LIT(0xa8286acdc6f9cbd9),
W64LIT(0x5f0e4262d40c3565),
W64LIT(0xeee73f309dc65ab9),
W64LIT(0x9be39d1c8289da97),
W64LIT(0x1634ee099be1a113),
W64LIT(0xea08b1583e9ef55c),
W64LIT(0x9727faa49261de4d),
W64LIT(0x2c682912c337b726),
W64LIT(0xcff7a880e10f4501),
W64LIT(0x1788371334f70d57),
W64LIT(0x27725eec74bd1dd5),
W64LIT(0x3146b0e5ef5cbcc6),
W64LIT(0x099730ca1ca6077b),
W64LIT(0xf2757fdd1ebbfd1d),
W64LIT(0x6aa77cef98082646),
W64LIT(0xbb4fd3b65156696b),
W64LIT(0x569972a8c8aa321e),
W64LIT(0xa3321d337173612a),
W64LIT(0x50fbbbf4c0de3073),
W64LIT(0x5a5d1510d84236c4),
W64LIT(0xfd80864b0a69f80b),
W64LIT(0x07de1046a762ae29),
W64LIT(0xa6614a417d3d628b),
W64LIT(0xd78a6605c12a4d40),
W64LIT(0x67dfc24d27f68ed8),
W64LIT(0xbc91c3f0f634c742),
W64LIT(0xd05476436648e369),
W64LIT(0x493aac6b4fed9476),
W64LIT(0x12db606138b90ef6),
W64LIT(0xa994b3d769ef679d),
W64LIT(0x211097b07cc91fb8),
W64LIT(0x30fa69ff404a1082),
W64LIT(0x3c3e0e4750a21458),
W64LIT(0x7504a22c1f4f802e),
W64LIT(0x844043df05ce7cff),
W64LIT(0xf0f838e9b5975095),
W64LIT(0x7e1ed5d2a8c52add),
W64LIT(0x90f9eae235037064),
W64LIT(0x0662c95c0874026d),
W64LIT(0x9416648a965bdf81),
W64LIT(0xf69af1b5bde352f8),
W64LIT(0x0d78bea2bffea89e),
W64LIT(0x293b7e60cf79b487),
W64LIT(0xd9c346897aeee412),
W64LIT(0xfbe24f17021dfa66),
W64LIT(0x1367b97b97afa2b2),
W64LIT(0xab19f4e3c2c3ca15),
W64LIT(0x48867571e0fb3832),
W64LIT(0x93c874cc313971a8),
W64LIT(0x79c0c5940fa784f4),
W64LIT(0xcd7aefb44a23e889),
W64LIT(0x439c028f577192c1),
W64LIT(0x5be1cc0a77549a80),
/* box 6 */
W64LIT(0x714d28d778656928),
W64LIT(0xc88a7c6b84f64f7c),
W64LIT(0xec43cac5ab89aaca),
W64LIT(0x777fa38110dc16a3),
W64LIT(0x0f7d5c87e4213b5c),
W64LIT(0x73f051e5f3a1ef51),
W64LIT(0xea714193c330d541),
W64LIT(0x95e5f3dae016c4f3),
W64LIT(0x63d3738095a0e173),
W64LIT(0x9825d66f8ff379d6),
W64LIT(0xe8cc38a148f45338),
W64LIT(0xa840b0c025f06bb0),
W64LIT(0x944135c35f748735),
W64LIT(0x74661caa247ad31c),
W64LIT(0xe7b16426acd56864),
W64LIT(0xd1e689df6e6f0589),
W64LIT(0xa73dec47c1d150ec),
W64LIT(0x64453ecf427bdd3e),
W64LIT(0x0ed99a9e5b43789a),
W64LIT(0x7b1b402dc05be840),
W64LIT(0x0dc025b56fe5bd25),
W64LIT(0x3f183a284e22293a),
W64LIT(0xa0aba108160a6ca1),
W64LIT(0x46be033705bd4703),
W64LIT(0x86df6e94b2b10f6e),
W64LIT(0xa216d83a9dceead8),
W64LIT(0x129e5b57edc5885b),
W64LIT(0x7e3074509c445274),
W64LIT(0x7d29cb7ba8e297cb),
W64LIT(0x1611a9330eb871a9),
W64LIT(0x486799a95efe3f99),
W64LIT(0x9fb39b205828459b),
W64LIT(0xd0424fc6d10d464f),
W64LIT(0xe968feb8f79610fe),
W64LIT(0x5d6f8fb164e08b8f),
W64LIT(0xaafdc9f2ae34edc9),
W64LIT(0x02bd79328bc48679),
W64LIT(0x9b3c6944bb55bc69),
W64LIT(0x6277b5992ac2a2b5),
W64LIT(0x877ba88d0dd34ca8),
W64LIT(0xfa5263f6a531db63),
W64LIT(0x2e9fde54974164de),
W64LIT(0xcda14816d8e9f548),
W64LIT(0x675c81e476dd1881),
W64LIT(0x2a102c30743c9d2c),
W64LIT(0x37f32be07dd82e2b),
W64LIT(0x256d70b7901da670),
W64LIT(0x4ce86bcdbd83c66b),
W64LIT(0x50afaa040b0536aa),
W64LIT(0xef5a75ee9f2f6f75),
W64LIT(0xb3913c4644ada73c),
W64LIT(0x1187e47cd9634de4),
W64LIT(0xc54a59deeb13f259),
W64LIT(0x0000000000000000),
W64LIT(0x01a4c619bf6243c6),
W64LIT(0x90cec7a7bc097ec7),
W64LIT(0xf94bdcdd91971edc),
W64LIT(0x8e347f5c814b087f),
W64LIT(0xc7f720ec60d77420),
W64LIT(0x354e52d2f61ca852),
W64LIT(0x34ea94cb497eeb94),
W64LIT(0xae723b964d49143b),
W64LIT(0xf48bf968fe72a3f9),
W64LIT(0xfc60e8a0cd88a4e8),
W64LIT(0x2909931b409a5893),
W64LIT(0xbd48a6d81feedfa6),
W64LIT(0x6cae2f077181da2f),
W64LIT(0xad6b84bd79efd184),
W64LIT(0x18c833ad55fb0933),
W64LIT(0x204644cacc021c44),
W64LIT(0x392ab17e269b56b1),
W64LIT(0x14acd001857cf7d0),
W64LIT(0x8abb8d386236f18d),
W64LIT(0xeefeb3f7204d2cb3),
W64LIT(0xf636805a75b62580),
W64LIT(0x2bb4ea29cb5edeea),
W64LIT(0xc653e6f5dfb537e6),
W64LIT(0x8d2dc077b5edcdc0),
W64LIT(0x31c1a0b6156151a0),
W64LIT(0xf8ef1ac42ef55d1a),
W64LIT(0xdbb0e125d65184e1),
W64LIT(0x82509cf051ccf69c),
W64LIT(0xe33e96424fa89196),
W64LIT(0xdf3f1341352c7d13),
W64LIT(0x8f90b9453e294bb9),
W64LIT(0x1023226566010e22),
W64LIT(0xa58095754a15d695),
W64LIT(0x2c22a7661c85e2a7),
W64LIT(0xe183ef70c46c17ef),
W64LIT(0xafd6fd8ff22b57fd),
W64LIT(0x471ac52ebadf04c5),
W64LIT(0x4d4cadd402e185ad),
W64LIT(0x916a01be036b3d01),
W64LIT(0x28ad5502fff81b55),
W64LIT(0x3657edf9c2ba6ded),
W64LIT(0xd2ff36f45ac9c036),
W64LIT(0xf1a0cd15a26d19cd),
W64LIT(0xd90d98175d950298),
W64LIT(0xf7924643cad46646),
W64LIT(0xdd826a73bee8fb6a),
W64LIT(0x9d0ee212d3ecc3e2),
W64LIT(0xb6ba083b18b21d08),
W64LIT(0x3da5431ac5e6af43),
W64LIT(0x08eb11c833fa0711),
W64LIT(0x052b347d5c1fba34),
W64LIT(0x6fb7902c45271f90),
W64LIT(0x133a9d4e52a7cb9d),
W64LIT(0x6e135635fa455c56),
W64LIT(0x725497fc4cc3ac97),
W64LIT(0xf31db42729a99fb4),
W64LIT(0x846217a639758917),
W64LIT(0x4b7e26826a58fa26),
W64LIT(0x235ffbe1f8a4d9fb),
W64LIT(0xff79578bf92e6157),
W64LIT(0xda14273c6933c727),
W64LIT(0x8b1f4b21dd54b24b),
W64LIT(0x9caa240b6c8e8024),
W64LIT(0xc1c5abba086e0bab),
W64LIT(0xde9bd5588a4e3ed5),
W64LIT(0x2d86617fa3e7a161),
W64LIT(0xbff5dfea942a59df),
W64LIT(0x66f847fdc9bf5b47),
W64LIT(0x3b97c84cad5fd0c8),
W64LIT(0x3ebcfc31f1406afc),
W64LIT(0xca3705590f32c905),
W64LIT(0x24c9b6ae2f7fe5b6),
W64LIT(0x408c88616d043888),
W64LIT(0x93d7788c88afbb78),
W64LIT(0x196cf5b4ea994af5),
W64LIT(0x9a98af5d0437ffaf),
W64LIT(0x8c89066e0a8f8e06),
W64LIT(0xab590feb1156ae0f),
W64LIT(0xd7d4028906d67a02),
W64LIT(0xe4a8db0d9873addb),
W64LIT(0xc378d28883aa8dd2),
W64LIT(0x4ff1d4e6892503d4),
W64LIT(0xd670c490b9b439c4),
W64LIT(0x65e1f8d6fd199ef8),
W64LIT(0xf2b9723e96cbdc72),
W64LIT(0xb12c4574cf692145),
W64LIT(0x569d215263bc4921),
W64LIT(0x69851b7a2d9e601b),
W64LIT(0x5e76309a50464e30),
W64LIT(0x5fd2f683ef240df6),
W64LIT(0xd8a95e0ee2f7415e),
W64LIT(0xe29a505bf0cad250),
W64LIT(0x96fc4cf1d4b0014c),
W64LIT(0x8806f40ae9f277f4),
W64LIT(0x53b6152f3fa3f315),
W64LIT(0x1c47c1c9b686f0c1),
W64LIT(0x80ede5c2da0870e5),
W64LIT(0xd5697bbb8d12fc7b),
W64LIT(0xfdc42eb972eae72e),
W64LIT(0x0bf2aee3075cc2ae),
W64LIT(0x22fb3df847c69a3d),
W64LIT(0xbadeeb97c835e3eb),
W64LIT(0xdc26ac6a018ab8ac),
W64LIT(0xbcec60c1a08c9c60),
W64LIT(0x4231f153e6c0bef1),
W64LIT(0x337cd9849ea5d7d9),
W64LIT(0x5b5d04e70c59f404),
W64LIT(0x79a6391f4b9f6e39),
W64LIT(0x5212d33680c1b0d3),
W64LIT(0xb5a3b7102c14d8b7),
W64LIT(0x7f94b249232611b2),
W64LIT(0x17b56f2ab1da326f),
W64LIT(0x59e07dd5879d727d),
W64LIT(0xebd5878a7c529687),
W64LIT(0xbb7a2d8e7757a02d),
W64LIT(0x0319bf2b34a6c5bf),
W64LIT(0x5ccb49a8db82c849),
W64LIT(0x1de307d009e4b307),
W64LIT(0x49c35fb0e19c7c5f),
W64LIT(0x55849e79571a8c9e),
W64LIT(0x7abf86347f39ab86),
W64LIT(0x9273be9537cdf8be),
W64LIT(0xe615a23f13b72ba2),
W64LIT(0x6821dd6392fc23dd),
W64LIT(0x5af9c2feb33bb7c2),
W64LIT(0x06328b5668b97f8b),
W64LIT(0x44037a058e79c17a),
W64LIT(0x83f45ae9eeaeb55a),
W64LIT(0x5739e74bdcde0ae7),
W64LIT(0xfbf6a5ef1a5398a5),
W64LIT(0xe50c1d142711ee1d),
W64LIT(0x1a754a9fde3f8f4a),
W64LIT(0x7802ff06f4fd2dff),
W64LIT(0xf52f3f714110e03f),
W64LIT(0x2674cf9ca4bb63cf),
W64LIT(0x60caccaba10624cc),
W64LIT(0xb088836d700b6283),
W64LIT(0xa6992a5e7eb3132a),
W64LIT(0xa9e476d99a922876),
W64LIT(0x6b386248a65ae662),
W64LIT(0xc2dc14913cc8ce14),
W64LIT(0x76db6598afbe5565),
W64LIT(0x32d81f9d21c7941f),
W64LIT(0x21e282d373605f82),
W64LIT(0xc0616da3b70c486d),
W64LIT(0x616e0ab21e64670a),
W64LIT(0x6d0ae91ecee399e9),
W64LIT(0x27d009851bd92009),
W64LIT(0xfedd9192464c2291),
W64LIT(0x45a7bc1c311b82bc),
W64LIT(0x54205860e878cf58),
W64LIT(0xa10f6711a9682f67),
W64LIT(0x9981107630913a10),
W64LIT(0xede70cdc14ebe90c),
W64LIT(0x70e9eecec7072aee),
W64LIT(0x1f5e7ee28220357e),
W64LIT(0x2f3b184d28232718),
W64LIT(0x41284e78d2667b4e),
W64LIT(0xa424536cf5779553),
W64LIT(0xa3b21e2322aca91e),
W64LIT(0x4e5512ff36474012),
W64LIT(0x1efab8fb3d4276b8),
W64LIT(0x89a2321356903432),
W64LIT(0xcb93c340b0508ac3),
W64LIT(0x306566afaa031266),
W64LIT(0x4adae09bd53ab9e0),
W64LIT(0xc92eba723b940cba),
W64LIT(0x094fd7d18c9844d7),
W64LIT(0xcc058e0f678bb68e),
W64LIT(0xd4cdbda23270bfbd),
W64LIT(0x0a5668fab83e8168),
W64LIT(0x510b6c1db467756c),
W64LIT(0xb86392a543f16592),
W64LIT(0x048ff264e37df9f2),
W64LIT(0x3a330e55123d930e),
W64LIT(0xb235fa5ffbcfe4fa),
W64LIT(0xb9c754bcfc932654),
W64LIT(0x3c0185037a84ec85),
W64LIT(0x0c64e3acd087fee3),
W64LIT(0xe02729697b0e5429),
W64LIT(0x07964d4fd7db3c4d),
W64LIT(0x814923db656a3323),
W64LIT(0x388e776799f91577),
W64LIT(0x6a9ca4511938a5a4),
W64LIT(0x1bd18c86615dcc8c),
W64LIT(0xb407710993769b71),
W64LIT(0x150816183a1eb416),
W64LIT(0x4395374a59a2fd37),
W64LIT(0xc4ee9fc75471b19f),
W64LIT(0x5844bbcc38ff31bb),
W64LIT(0xcf1c3124532d7331),
W64LIT(0xb71ece22a7d05ece),
W64LIT(0xaccf42a4c68d9242),
W64LIT(0x97588ae86bd2428a),
W64LIT(0x75c2dab39b1890da),
W64LIT(0x9e175d39e74a065d),
W64LIT(0xf0040b0c1d0f5a0b),
W64LIT(0xceb8f73dec4f30f7),
W64LIT(0xbe5119f32b481a19),
W64LIT(0xd35bf0ede5ab83f0),
W64LIT(0x7c8d0d621780d40d),
W64LIT(0x85c6d1bf8617cad1),
/* box 7 */
W64LIT(0xb1c742127b66f2a4),
W64LIT(0xce916098d7a59fc1),
W64LIT(0xc312ef8e2406fa70),
W64LIT(0x956c7dced81403d5),
W64LIT(0x5a0c9b2318dd9520),
W64LIT(0xad0d57f51a480e8b),
W64LIT(0xe7b9d05287740b01),
W64LIT(0x0217f9ea2ed81268),
W64LIT(0x4d7cff19f8cd3a06),
W64LIT(0x44d1772e572b7b67),
W64LIT(0xfb73c5b5e65af72e),
W64LIT(0x91427aef84512705),
W64LIT(0x0c720963e4cf6c85),
W64LIT(0x87c398a0732d8117),
W64LIT(0xa17f5e96fe87620e),
W64LIT(0x50476c8b8e8fcf1d),
W64LIT(0xcb4ee1cc9c8cb225),
W64LIT(0x67b2304c91a8b59a),
W64LIT(0x54696baad2caebcd),
W64LIT(0xddcf03836bf01437),
W64LIT(0x46c68ec479f3690f),
W64LIT(0x8f9f96e2cba7c942),
W64LIT(0xe1802e99f5e93db9),
W64LIT(0x4e9a8086c179215a),
W64LIT(0xf0c9b4686764a427),
W64LIT(0xfd4a3b7e94c7c196),
W64LIT(0xfcbbbd0b83abc8a2),
W64LIT(0xebcbd93163bb6784),
W64LIT(0xf9643c5fc882e546),
W64LIT(0xc4da973041f7c5fc),
W64LIT(0x1af3eb2c13b3ca97),
W64LIT(0x6e1fb87b3e4ef4fb),
W64LIT(0x5e229c024498b1f0),
W64LIT(0xf516353c2c4d89c3),
W64LIT(0xcc869972f97d8da9),
W64LIT(0x8d886f08e57fdb2a),
W64LIT(0x1cca15e7612efc2f),
W64LIT(0x567e9240fc12f9a5),
W64LIT(0x43190f9032da44eb),
W64LIT(0xfeac44e1ad73daca),
W64LIT(0x07c878be65f13f8c),
W64LIT(0x618bce87e3358322),
W64LIT(0xf895ba2adfeeec72),
W64LIT(0x751dd5223a913758),
W64LIT(0x59eae4bc21698e7c),
W64LIT(0xff5dc294ba1fd3fe),
W64LIT(0x03e67f9f39b41b5c),
W64LIT(0x2292c117d1efc7c9),
W64LIT(0x8a4017b6808ee4a6),
W64LIT(0xd1bd0ae08f3f78b2),
W64LIT(0x135e631bbc558bf6),
W64LIT(0xee14586528924a60),
W64LIT(0x8857ee5cae56f6ce),
W64LIT(0x0000000000000000),
W64LIT(0x0e65f089ca177eed),
W64LIT(0x34132358269361db),
W64LIT(0x15679dd0cec8bd4e),
W64LIT(0x800be01e16dcbe9b),
W64LIT(0x949dfbbbcf780ae1),
W64LIT(0xe397d773db312fd1),
W64LIT(0xedf227fa1126513c),
W64LIT(0xb5e945332723d674),
W64LIT(0x53a11314b73bd441),
W64LIT(0x23634762c683cefd),
W64LIT(0x4b4501d28a500cbe),
W64LIT(0x473708b16e9f603b),
W64LIT(0x1770643ae010af26),
W64LIT(0xa746a05d8c1a54b6),
W64LIT(0x90b3fc9a933d2e31),
W64LIT(0x35e2a52d31ff68ef),
W64LIT(0xab34a93e68d53833),
W64LIT(0xd81082d720d939d3),
W64LIT(0xb86aca25d480b3c5),
W64LIT(0xdfd8fa694528065f),
W64LIT(0x4f6b06f3d615286e),
W64LIT(0x578f1435eb7ef091),
W64LIT(0x9af80b32056f740c),
W64LIT(0x92a40570bde53c59),
W64LIT(0xdbf6fd48196d228f),
W64LIT(0x1b026d5904dfc3a3),
W64LIT(0x3c4f2d1a9e19298e),
W64LIT(0xc8a89e53a538a979),
W64LIT(0x991e74ad3cdb6f50),
W64LIT(0x042e07215c4524d0),
W64LIT(0x8e6e1097dccbc076),
W64LIT(0xe071a8ece285348d),
W64LIT(0xd784f42bfda24e0a),
W64LIT(0x7d41db60821b7f0d),
W64LIT(0x85d4614a5df5937f),
W64LIT(0xbb8cb5baed34a899),
W64LIT(0x40ff700f0b6e5fb7),
W64LIT(0x2cf7319e1bf8b924),
W64LIT(0x3a76d3d1ec841f36),
W64LIT(0x4520f15b40477253),
W64LIT(0xf138321d7008ad13),
W64LIT(0x42e889e525b64ddf),
W64LIT(0x65a5c9a6bf70a7f2),
W64LIT(0x208538fdff37d5a1),
W64LIT(0x410ef67a1c025683),
W64LIT(0x18e412c63d6bd8ff),
W64LIT(0x72d5ad9c5f6008d4),
W64LIT(0x255ab9a9b41ef845),
W64LIT(0x93558305aa89356d),
W64LIT(0x70c2547671b81abc),
W64LIT(0x3604dab2084b73b3),
W64LIT(0x05df81544b292de4),
W64LIT(0xf2de4d8249bcb64f),
W64LIT(0x0bba71dd813e5309),
W64LIT(0xa368a77cd05f7066),
W64LIT(0x796fdc41de5e5bdd),
W64LIT(0xec03a18f064a5808),
W64LIT(0x085c0e42b88a4855),
W64LIT(0x274d40439ac6ea2d),
W64LIT(0x31cca20c6dba4c3f),
W64LIT(0x322add93540e5763),
W64LIT(0xb60f3aac1e97cd28),
W64LIT(0x7cb05d1595777639),
W64LIT(0xb036c4676c0afb90),
W64LIT(0x0a4bf7a896525a3d),
W64LIT(0x73242be9480c01e0),
W64LIT(0x5bfd1d560fb19c14),
W64LIT(0x7b7825abf08649b5),
W64LIT(0xb7febcd909fbc41c),
W64LIT(0x81fa666b01b0b7af),
W64LIT(0xd25b757fb68b63ee),
W64LIT(0x0d838f16f3a365b1),
W64LIT(0x6a31bf5a620bd02b),
W64LIT(0x26bcc6368daae319),
W64LIT(0x9ed60c13592a50dc),
W64LIT(0x581b62c936058748),
W64LIT(0x9cc1f5f977f242b4),
W64LIT(0x83ed9f812f68a5c7),
W64LIT(0x74ec53572dfd3e6c),
W64LIT(0xb3d0bbf855bee0cc),
W64LIT(0xacfcd1800d2407bf),
W64LIT(0x303d24797ad6450b),
W64LIT(0x7a89a3dee7ea4081),
W64LIT(0x69d7c0c55bbfcb77),
W64LIT(0x770a2cc814492530),
W64LIT(0x0f9476fcdd7b77d9),
W64LIT(0xaeeb286a23fc15d7),
W64LIT(0x2174be88e85bdc95),
W64LIT(0xde297c1c52440f6b),
W64LIT(0xd04c8c9598537186),
W64LIT(0x2ee0c8743520ab4c),
W64LIT(0x977b8424f6cc11bd),
W64LIT(0x10b81c8485e190aa),
W64LIT(0xa4a0dfc2b5ae4fea),
W64LIT(0x98eff2d82bb76664),
W64LIT(0xa8d2d6a15161236f),
W64LIT(0xd4628bb4c4165556),
W64LIT(0x682646b04cd3c243),
W64LIT(0x2d06b7eb0c94b010),
W64LIT(0x626db118da81987e),
W64LIT(0x2928b0ca50d194c0),
W64LIT(0x6df9c7e407faefa7),
W64LIT(0x1681e24ff77ca612),
W64LIT(0x4952f838a4881ed6),
W64LIT(0x76fbaabd03252c04),
W64LIT(0xc73ce8af7843dea0),
W64LIT(0xe82da6ae5a0f7cd8),
W64LIT(0xc10516640adee818),
W64LIT(0x968a0251e1a01889),
W64LIT(0x37f55cc71f277a87),
W64LIT(0xe5ae29b8a9ac1969),
W64LIT(0xcabf67b98be0bb11),
W64LIT(0xf4e7b3493b2180f7),
W64LIT(0xe9dc20db4d6375ec),
W64LIT(0x639c376dcded914a),
W64LIT(0x12afe56eab3982c2),
W64LIT(0xc2e369fb336af344),
W64LIT(0xa6b726289b765d82),
W64LIT(0x14961ba5d9a4b47a),
W64LIT(0xbc44cd0488c59715),
W64LIT(0xd3aaf30aa1e76ada),
W64LIT(0x28d936bf47bd9df4),
W64LIT(0xaf1aae1f34901ce3),
W64LIT(0x2f114e01224ca278),
W64LIT(0xe648562790180235),
W64LIT(0x24ab3fdca372f171),
W64LIT(0x52509561a057dd75),
W64LIT(0xc6cd6eda6f2fd794),
W64LIT(0xa08ed8e3e9eb6b3a),
W64LIT(0x09ad8837afe64161),
W64LIT(0xbdb54b719fa99e21),
W64LIT(0x8c79e97df213d21e),
W64LIT(0xcf60e6edc0c996f5),
W64LIT(0x5dc4e39d7d2caaac),
W64LIT(0x11499af1928d999e),
W64LIT(0x5fd31a7753f4b8c4),
W64LIT(0x01f18675176c0934),
W64LIT(0xc52b1145569bccc8),
W64LIT(0x9f278a664e4659e8),
W64LIT(0x3dbeab6f897520ba),
W64LIT(0xa2992109c7337952),
W64LIT(0x9b098d4712037d38),
W64LIT(0xc9591826b254a04d),
W64LIT(0x3b8755a4fbe81602),
W64LIT(0xbe5334eea61d857d),
W64LIT(0x51b6eafe99e3c629),
W64LIT(0x191594b32a07d1cb),
W64LIT(0x1f2c6a78589ae773),
W64LIT(0x3fa95285a7ad32d2),
W64LIT(0x5c3565e86a40a398),
W64LIT(0xb2213d8d42d2e9f8),
W64LIT(0xefe5de103ffe4354),
W64LIT(0x4ab487a79d3c058a),
W64LIT(0xcd771f07ee11849d),
W64LIT(0xbfa2b29bb1718c49),
W64LIT(0xba7d33cffa58a1ad),
W64LIT(0x6fee3e0e2922fdcf),
W64LIT(0x64544fd3a81caec6),
W64LIT(0xd9e104a237b530e7),
W64LIT(0xf32fcbf75ed0bf7b),
W64LIT(0x3e58d4f0b0c13be6),
W64LIT(0xb418c346304fdf40),
W64LIT(0xaac52f4b7fb93107),
W64LIT(0xdc3e85f67c9c1d03),
W64LIT(0xd5930dc1d37a5c62),
W64LIT(0x0639fecb729d36b8),
W64LIT(0xc0f490111db2e12c),
W64LIT(0x7ea7a4ffbbaf6451),
W64LIT(0xf6f04aa315f9929f),
W64LIT(0x6643b63986c4bcae),
W64LIT(0x6c0841911096e693),
W64LIT(0x8425e73f4a999a4b),
W64LIT(0x7133d20366d41388),
W64LIT(0x38612a3bc25c0d5e),
W64LIT(0xb99b4c50c3ecbaf1),
W64LIT(0x1d3b93927642f51b),
W64LIT(0x7f56228aacc36d65),
W64LIT(0x9d30738c609e4b80),
W64LIT(0x48a37e4db3e417e2),
W64LIT(0x8bb191c397e2ed92),
W64LIT(0x2acecf5569658f9c),
W64LIT(0xda077b3d0e012bbb),
W64LIT(0xa55159b7a2c246de),
W64LIT(0x33db5be643625e57),
W64LIT(0x821c19f43804acf3),
W64LIT(0x3990ac4ed530046a),
W64LIT(0xd675725eeace473e),
W64LIT(0x789e5a34c93252e9),
W64LIT(0x86321ed564418823),
W64LIT(0xfa8243c0f136fe1a),
W64LIT(0xe45fafcdbec0105d),
W64LIT(0x2b3f49207e0986a8),
W64LIT(0xa92350d4460d2a5b),
W64LIT(0x1eddec0d4ff6ee47),
W64LIT(0x89a66829b93afffa),
W64LIT(0x607a48f2f4598a16),
W64LIT(0x6bc0392f7567d91f),
W64LIT(0xea3a5f4474d76eb0),
W64LIT(0x5598eddfc5a6e2f9),
W64LIT(0x4c8d796cefa13332),
W64LIT(0xf701ccd602959bab),
W64LIT(0xe2665106cc5d26e5),
};

const word64 SHARK::Dec::cbox[8][256] = {
/* box 0 */
W64LIT(0xe6126af05e55aff3),
W64LIT(0x4b6c893f310b0835),
W64LIT(0xaa4c0e84ebfc8d57),
W64LIT(0xfb9b5c7bf3b3090d),
W64LIT(0x4508a6a9ccba5ce2),
W64LIT(0xe5d1d2064dc6bde9),
W64LIT(0x348343755288edde),
W64LIT(0xb684505de46b250c),
W64LIT(0xa8cede205a1e91e8),
W64LIT(0x40b89b46f9fa6acc),
W64LIT(0x8ee1ec1afab080ba),
W64LIT(0xde77d6b7408e0a45),
W64LIT(0x9a3e184c2e455802),
W64LIT(0xbe93fad23f0955ef),
W64LIT(0x3ae76ce3af39b909),
W64LIT(0xad7ee3cf6f5ea7c6),
W64LIT(0x8b51d1f5cff0b694),
W64LIT(0x70ca8d8e3c43bf99),
W64LIT(0xccdba7f8b2a8f6c9),
W64LIT(0x4c5e6474b5a922a4),
W64LIT(0x5d31adcd541ccc32),
W64LIT(0x9b7f701e8c3456a7),
W64LIT(0x2ac9cd08ecfd593a),
W64LIT(0x8fa0844858c18e1f),
W64LIT(0x32f0c66c745bc9ea),
W64LIT(0xc58d6525cbbb888f),
W64LIT(0x8c633cbe4b529c05),
W64LIT(0xf2cd9ea68aa0774b),
W64LIT(0x2cba4811ca2e7d0e),
W64LIT(0xe2e33f4dc9649778),
W64LIT(0xf4be1bbfac73537f),
W64LIT(0x22de6787379f29d9),
W64LIT(0x0956c2dd79137e46),
W64LIT(0xe061efe978868bc7),
W64LIT(0x1cc85ed90f97a85b),
W64LIT(0x31337e9a67c8dbf0),
W64LIT(0x360193d1e36af161),
W64LIT(0x7fefca4a6383e5eb),
W64LIT(0x8535fe633241e243),
W64LIT(0xc3fee03ced68acbb),
W64LIT(0x81c4abdea570dac8),
W64LIT(0x67d6c12efb25753b),
W64LIT(0xa4282112164dd980),
W64LIT(0xcf181f0ea13be4d3),
W64LIT(0xa98fb672f86f9f4d),
W64LIT(0x5c70c59ff66dc297),
W64LIT(0xb0f7d544c2b80138),
W64LIT(0x0da79760ee2246cd),
W64LIT(0x3740fb83411bffc4),
W64LIT(0x24ade29e114c0ded),
W64LIT(0xf858e48de0201b17),
W64LIT(0x0e642f96fdb154d7),
W64LIT(0xddb46e41531d185f),
W64LIT(0x25ec8accb33d0348),
W64LIT(0x0282d0a4b1e21cbf),
W64LIT(0x1bfab3928b3582ca),
W64LIT(0xaffc336bdebcbb79),
W64LIT(0x35c22b27f0f9e37b),
W64LIT(0x03c3b8f61393121a),
W64LIT(0xb8e07fcb19da71db),
W64LIT(0x99fda0ba3dd64a18),
W64LIT(0xce59775c034aea76),
W64LIT(0x49ee599b80e9148a),
W64LIT(0xfe2b6194c6f33f23),
W64LIT(0x4edcb4d0044b3e1b),
W64LIT(0xd5a3c4ce887f68bc),
W64LIT(0xdf36bee5e2ff04e0),
W64LIT(0x171c4ca0c766caa2),
W64LIT(0x0bd41279c8f162f9),
W64LIT(0xe490ba54efb7b34c),
W64LIT(0x5b4228d472cfe806),
W64LIT(0x5355825ba9ad98e5),
W64LIT(0x9f8e25a31b056e2c),
W64LIT(0xcd9acfaa10d9f86c),
W64LIT(0x88926903dc63a48e),
W64LIT(0xb40680f9558939b3),
W64LIT(0x239f0fd595ee277c),
W64LIT(0xec8710db34d5c3af),
W64LIT(0x87b72ec783a3fefc),
W64LIT(0x632794936c144db0),
W64LIT(0x46cb1e5fdf294ef8),
W64LIT(0x83467b7a1492c677),
W64LIT(0x9c4d9d5508967c36),
W64LIT(0xd6607c389bec7aa6),
W64LIT(0x165d24f26517c407),
W64LIT(0xc4cc0d7769ca862a),
W64LIT(0xcbe94ab3360adc58),
W64LIT(0x847496319030ece6),
W64LIT(0x7a5ff7a556c3d3c5),
W64LIT(0xc03d58cafefbbea1),
W64LIT(0x76b908971a909bad),
W64LIT(0x2f79f0e7d9bd6f14),
W64LIT(0x197863363ad79e75),
W64LIT(0xda86830ad7bf32ce),
W64LIT(0x5a034086d0bee6a3),
W64LIT(0x97998f2cc0671ecf),
W64LIT(0x552607428f7ebcd1),
W64LIT(0x51d752ff184f845a),
W64LIT(0xbb23c73d0a4963c1),
W64LIT(0x2b88a55a4e8c579f),
W64LIT(0xd80453ae665d2e71),
W64LIT(0xee05c07f8537df10),
W64LIT(0x423a4be248187673),
W64LIT(0xcaa822e1947bd2fd),
W64LIT(0x1abbdbc029448c6f),
W64LIT(0x96d8e77e6216106a),
W64LIT(0x6266fcc1ce654315),
W64LIT(0x89d301517e12aa2b),
W64LIT(0x730935782fd0ad83),
W64LIT(0x8085c38c0701d46d),
W64LIT(0x6b303e1cb7763d53),
W64LIT(0x3f57510c9a798f27),
W64LIT(0x4449cefb6ecb5247),
W64LIT(0x48af31c922981a2f),
W64LIT(0x98bcc8e89fa744bd),
W64LIT(0x69b2eeb8069421ec),
W64LIT(0xebb5fd90b077e93e),
W64LIT(0x6a71564e150733f6),
W64LIT(0x116fc9b9e1b5ee96),
W64LIT(0x4a2de16d937a0690),
W64LIT(0xb9a11799bbab7f7e),
W64LIT(0x9368da9157562644),
W64LIT(0x718be5dc9e32b13c),
W64LIT(0xc82af2452599ce42),
W64LIT(0xb547e8abf7f83716),
W64LIT(0x33b1ae3ed62ac74f),
W64LIT(0x799c4f534550c1df),
W64LIT(0x3e16395e38088182),
W64LIT(0x7c2c72bc7010f7f1),
W64LIT(0xf38cf6f428d179ee),
W64LIT(0xd29129850cdd422d),
W64LIT(0x41f9f3145b8b6469),
W64LIT(0x945a37dad3f40cd5),
W64LIT(0x757ab061090389b7),
W64LIT(0x6554118a4ac76984),
W64LIT(0x7d6d1aeed261f954),
W64LIT(0x01416852a2710ea5),
W64LIT(0xb27505e0735a1d87),
W64LIT(0x77f860c5b8e19508),
W64LIT(0x78dd2701e721cf7a),
W64LIT(0xe12087bbdaf78562),
W64LIT(0x86f6469521d2f059),
W64LIT(0xef44a82d2746d1b5),
W64LIT(0xbc112a768eeb4950),
W64LIT(0xc2bf886e4f19a21e),
W64LIT(0x307216c8c5b9d555),
W64LIT(0xc96b9a1787e8c0e7),
W64LIT(0xa31acc5992eff311),
W64LIT(0xa0d974af817ce10b),
W64LIT(0xdcf50613f16c16fa),
W64LIT(0xfca9b1307711239c),
W64LIT(0x57a4d7e63e9ca06e),
W64LIT(0xc64eddd3d8289a95),
W64LIT(0xa25ba40b309efdb4),
W64LIT(0x2e3898b57bcc61b1),
W64LIT(0xf5ff73ed0e025dda),
W64LIT(0xa6aaf1b6a7afc53f),
W64LIT(0xd9453bfcc42c20d4),
W64LIT(0x9d0cf507aae77293),
W64LIT(0x290a75feff6e4b20),
W64LIT(0xa7eb99e405decb9a),
W64LIT(0xa1981cfd230defae),
W64LIT(0x12ac714ff226fc8c),
W64LIT(0x743bd833ab728712),
W64LIT(0x6c02d35733d417c2),
W64LIT(0xe9372d340195f581),
W64LIT(0xf77da349bfe04165),
W64LIT(0x68f386eaa4e52f49),
W64LIT(0x211ddf71240c3bc3),
W64LIT(0x13ed191d5057f229),
W64LIT(0xe8764566a3e4fb24),
W64LIT(0xf9198cdf425115b2),
W64LIT(0xd013f921bd3f5e92),
W64LIT(0x91ea0a35e6b43afb),
W64LIT(0x0732ed4b84a22a91),
W64LIT(0xeaf495c21206e79b),
W64LIT(0x5214ea090bdc9640),
W64LIT(0x0000000000000000),
W64LIT(0xb3346db2d12b1322),
W64LIT(0x0ce6ff324c534868),
W64LIT(0xaebd5b397ccdb5dc),
W64LIT(0x0a957a2b6a806c5c),
W64LIT(0x1f0be62f1c04ba41),
W64LIT(0x14dff456d4f5d8b8),
W64LIT(0x58819022615cfa1c),
W64LIT(0x05b03def3540362e),
W64LIT(0xe3a2571f6b1599dd),
W64LIT(0x9229b2c3f52728e1),
W64LIT(0xba62af6fa8386d64),
W64LIT(0x0673851926d32434),
W64LIT(0x641579d8e8b66721),
W64LIT(0x04f155bd9731388b),
W64LIT(0x9ecf4df1b9746089),
W64LIT(0x205cb723867d3566),
W64LIT(0x102ea1eb43c4e033),
W64LIT(0x3ba604b10d48b7ac),
W64LIT(0x50963aadba3e8aff),
W64LIT(0xac3f8b9dcd2fa963),
W64LIT(0x7b1e9ff7f4b2dd60),
W64LIT(0xf63ccb1b1d914fc0),
W64LIT(0x7eaea218c1f2eb4e),
W64LIT(0x5fb37d69e5fed08d),
W64LIT(0x56e5bfb49cedaecb),
W64LIT(0x2dfb2043685f73ab),
W64LIT(0x61a54437ddf6510f),
W64LIT(0x6fc16ba1204705d8),
W64LIT(0xe75302a2fc24a156),
W64LIT(0x3dd581a82b9b9398),
W64LIT(0xdbc7eb5875ce3c6b),
W64LIT(0x90ab626744c5345e),
W64LIT(0x59c0f870c32df4b9),
W64LIT(0x6697a97c59547b9e),
W64LIT(0xfde8d962d5602d39),
W64LIT(0xd3d041d7aeac4c88),
W64LIT(0x5ef2153b478fde28),
W64LIT(0xd4e2ac9c2a0e6619),
W64LIT(0x1e4a8e7dbe75b4e4),
W64LIT(0x72485d2a8da1a326),
W64LIT(0x437b23b0ea6978d6),
W64LIT(0x159e9c047684d61d),
W64LIT(0x0f2547c45fc05a72),
W64LIT(0xf10e265099336551),
W64LIT(0x3c94e9fa89ea9d3d),
W64LIT(0xbfd292809d785b4a),
W64LIT(0x0817aa8fdb6270e3),
W64LIT(0x60e42c657f875faa),
W64LIT(0x18390b6498a690d0),
W64LIT(0x478a760d7d58405d),
W64LIT(0x284b1dac5d1f4585),
W64LIT(0xb1b6bd1660c90f9d),
W64LIT(0xd15291731f4e5037),
W64LIT(0x4d1f0c2617d82c01),
W64LIT(0xc70fb5817a599430),
W64LIT(0x6d43bb0591a51967),
W64LIT(0x6e8003f382360b7d),
W64LIT(0x1d89368bade6a6fe),
W64LIT(0x4f9ddc82a63a30be),
W64LIT(0xedc6788996a4cd0a),
W64LIT(0xab0d66d6498d83f2),
W64LIT(0x54676f102d0fb274),
W64LIT(0xc17c30985c8ab004),
W64LIT(0x3865bc471edba5b6),
W64LIT(0x3924d415bcaaab13),
W64LIT(0x951b5f8871850270),
W64LIT(0x8a10b9a76d81b831),
W64LIT(0xbd5042242c9a47f5),
W64LIT(0xa5694940b43cd725),
W64LIT(0xff6a09c664823186),
W64LIT(0x8d2254ece92392a0),
W64LIT(0xb7c5380f461a2ba9),
W64LIT(0x82071328b6e3c8d2),
W64LIT(0xd721146a399d7403),
W64LIT(0xfada342951c207a8),
W64LIT(0x262f323aa0ae1152),
W64LIT(0xf04f4e023b426bf4),
W64LIT(0x276e5a6802df1ff7),
/* box 1 */
W64LIT(0x3b4016dbfd16e203),
W64LIT(0x9a7574c51174530a),
W64LIT(0x90012e69c02ec8d3),
W64LIT(0xf44580e3d780e076),
W64LIT(0xf81dec2b49eca14b),
W64LIT(0x26cae3e8a6e3d7ef),
W64LIT(0x0962419e0c41f6ab),
W64LIT(0x54d1eb4070ebd951),
W64LIT(0x865e884b0188eec8),
W64LIT(0xdf76067ea406fe8a),
W64LIT(0x29849412e594fba0),
W64LIT(0x461569896869c0f2),
W64LIT(0xb5ddd6b3bbd6724e),
W64LIT(0x0c586cc89e6c413d),
W64LIT(0x6b0ad97054d904ea),
W64LIT(0xa135621eec62b109),
W64LIT(0x0eef7e47087ea461),
W64LIT(0xfaaafea4dffe4417),
W64LIT(0xe0ad344e80342331),
W64LIT(0xab4138b23d382ad0),
W64LIT(0x107390468e90fcff),
W64LIT(0xbe0885a2218561b9),
W64LIT(0xdbed22957d22c132),
W64LIT(0x2251c7037fc7e857),
W64LIT(0x33835ef8ba5e9c86),
W64LIT(0xb3f1e0d7f4e0a8aa),
W64LIT(0x3fdb32302432ddbb),
W64LIT(0xa719547aa3546bed),
W64LIT(0xe10c3df3cb3dab1f),
W64LIT(0x17feaf9f8aafae35),
W64LIT(0x9df84b1c154b01c0),
W64LIT(0x8364a51d93a5595e),
W64LIT(0x535cd49974d48b9b),
W64LIT(0x01a109bd4b09882e),
W64LIT(0xc4d0c529b0c51182),
W64LIT(0x2e09abcbe1aba96a),
W64LIT(0x1f3de7bccde7d0b0),
W64LIT(0x9317355b1d35a5a1),
W64LIT(0x6c87e6a950e65620),
W64LIT(0x8910ffb142ffc287),
W64LIT(0x40395fed275f1a16),
W64LIT(0x7b794936da49f815),
W64LIT(0xf269b68798b63a92),
W64LIT(0xfd27c17ddbc116dd),
W64LIT(0x8d8bdb5a9bdbfd3f),
W64LIT(0x1ba6c35714c3ef08),
W64LIT(0x6e30f426c6f4b37c),
W64LIT(0x7fe26ddd036dc7ad),
W64LIT(0x14e8b4ad57b4c347),
W64LIT(0xb985ba7b25ba3373),
W64LIT(0xe9cf75d08c75d59a),
W64LIT(0x626898ee5898f241),
W64LIT(0x5b9f9cba339cf51e),
W64LIT(0xb250e96abfe92084),
W64LIT(0x165fa622c1a6261b),
W64LIT(0xf5e4895e9c896858),
W64LIT(0xb76ac43c2dc49712),
W64LIT(0x02b7128f9612e55c),
W64LIT(0x1d8af5335bf535ec),
W64LIT(0x36b973ae28732b10),
W64LIT(0xa8572380e02347a2),
W64LIT(0xf6f2926c4192052a),
W64LIT(0x8c2ad2e7d0d27511),
W64LIT(0xd32e6ab63a6abfb7),
W64LIT(0xbd1e9e90fc9e0ccb),
W64LIT(0x03161b32dd1b6d72),
W64LIT(0x4dc03a98f23ad305),
W64LIT(0x81d3b79205b7bc02),
W64LIT(0x450372bbb572ad80),
W64LIT(0x2d1fb0f93cb0c418),
W64LIT(0x2a928f20388f96d2),
W64LIT(0x721b08a8d6080ebe),
W64LIT(0x92b63ce6563c2d8f),
W64LIT(0xeb78675f1a6730c6),
W64LIT(0x13658b74538b918d),
W64LIT(0x428e4d62b14dff4a),
W64LIT(0x88b1f60c09f64aa9),
W64LIT(0x75963771d2375c74),
W64LIT(0x7ad8408b9140703b),
W64LIT(0x57c7f072adf0b423),
W64LIT(0xe5971918121994a7),
W64LIT(0x5666f9cfe6f93c0d),
W64LIT(0x8f3cc9d50dc91863),
W64LIT(0x1e9cee0186ee589e),
W64LIT(0x8a06e4839fe4aff5),
W64LIT(0xb824b3c66eb3bb5d),
W64LIT(0xd1997839ac785aeb),
W64LIT(0x6752b5b8cab545d7),
W64LIT(0xb47cdf0ef0dffa60),
W64LIT(0x949a0a82190af76b),
W64LIT(0xc04be1c269e12e3a),
W64LIT(0xfc86c8c090c89ef3),
W64LIT(0xe3bb2f7c5d2f4e43),
W64LIT(0x6aabd0cd1fd08cc4),
W64LIT(0x2147dc31a2dc8525),
W64LIT(0xca3fbb6eb8bbb5e3),
W64LIT(0x48fa17ce60176493),
W64LIT(0x6444ae8a17ae28a5),
W64LIT(0x2b33869d73861efc),
W64LIT(0xd0387184e771d2c5),
W64LIT(0x7cf476efde76aadf),
W64LIT(0x63c9915313917a6f),
W64LIT(0xc929a05c65a0d891),
W64LIT(0xda4c2b28362b491c),
W64LIT(0xfe31da4f06da7baf),
W64LIT(0xc1eae87f22e8a614),
W64LIT(0x5c12a36337a3a7d4),
W64LIT(0x18b0d865c9d8827a),
W64LIT(0xe7200b97840b71fb),
W64LIT(0x4bec0cfcbd0c09e1),
W64LIT(0x0f4e77fa43772c4f),
W64LIT(0x4c613325b9335b2b),
W64LIT(0xf3c8bf3ad3bfb2bc),
W64LIT(0x87ff81f64a8166e6),
W64LIT(0xa38270917a705455),
W64LIT(0x1911d1d882d10a54),
W64LIT(0x44a27b06fe7b25ae),
W64LIT(0x049b24ebd9243fb8),
W64LIT(0xbb32a8f4b3a8d62f),
W64LIT(0x91a027d48b2740fd),
W64LIT(0x3d6c20bfb22038e7),
W64LIT(0xe681022acf02f9d5),
W64LIT(0xf17fadb545ad57e0),
W64LIT(0xcc138d0af78d6f07),
W64LIT(0x495b1e732b1eecbd),
W64LIT(0x38560de9200d8f71),
W64LIT(0xa9f62a3dab2acf8c),
W64LIT(0x47b46034236048dc),
W64LIT(0x8e9dc06846c0904d),
W64LIT(0xaccc076b3907781a),
W64LIT(0x32225745f15714a8),
W64LIT(0xd4a3556f3e55ed7d),
W64LIT(0xd7b54e5de34e800f),
W64LIT(0xddc114f132141bd6),
W64LIT(0x6d26ef141befde0e),
W64LIT(0x85489379dc9383ba),
W64LIT(0x0bd553119a5313f7),
W64LIT(0x786f520407529567),
W64LIT(0xcb9eb2d3f3b23dcd),
W64LIT(0xa223792c3179dc7b),
W64LIT(0x0a745aacd15a9bd9),
W64LIT(0x710d139a0b1363cc),
W64LIT(0x681cc24289c26998),
W64LIT(0x1a07caea5fca6726),
W64LIT(0x82c5aca0d8acd170),
W64LIT(0x25dcf8da7bf8ba9d),
W64LIT(0xc7c6de1b6dde7cf0),
W64LIT(0xc35dfaf0b4fa4348),
W64LIT(0xded70fc3ef0f76a4),
W64LIT(0x504acfaba9cfe6e9),
W64LIT(0xc571cc94fbcc99ac),
W64LIT(0x5ea5b1eca1b14288),
W64LIT(0xae7b15e4af159d46),
W64LIT(0xc888a9e12ea950bf),
W64LIT(0xf7539bd10a9b8d04),
W64LIT(0x962d180d8f181237),
W64LIT(0xe43610a559101c89),
W64LIT(0x772125fe4425b928),
W64LIT(0x84e99ac4979a0b94),
W64LIT(0xc667d7a626d7f4de),
W64LIT(0xefe343b4c3430f7e),
W64LIT(0xd5025cd2755c6553),
W64LIT(0xa6b85dc7e85de3c3),
W64LIT(0xd61447e0a8470821),
W64LIT(0x3e7a3b8d6f3b5595),
W64LIT(0x52fddd243fdd03b5),
W64LIT(0x8072be2f4ebe342c),
W64LIT(0x12c482c9188219a3),
W64LIT(0x9eee502ec8506cb2),
W64LIT(0xad6d0ed6720ef034),
W64LIT(0x59288e35a58e1042),
W64LIT(0xe21a26c11626c66d),
W64LIT(0x247df16730f132b3),
W64LIT(0xf0dea4080ea4dfce),
W64LIT(0x31344c772c4c79da),
W64LIT(0x4f77281764283659),
W64LIT(0x79ce5bb94c5b1d49),
W64LIT(0x0000000000000000),
W64LIT(0x73ba01159d018690),
W64LIT(0x74373ecc993ed45a),
W64LIT(0xbcbf972db79784e5),
W64LIT(0x4ed621aa2f21be77),
W64LIT(0xd95a301aeb30246e),
W64LIT(0x9c5942a15e4289ee),
W64LIT(0x37187a13637aa33e),
W64LIT(0x276bea55edea5fc1),
W64LIT(0x1c2bfc8e10fcbdc2),
W64LIT(0xed54513b5551ea22),
W64LIT(0x20e6d58ce9d50d0b),
W64LIT(0x3ae11f66b61f6a2d),
W64LIT(0x66f3bc0581bccdf9),
W64LIT(0x2cbeb94477b94c36),
W64LIT(0x99636ff7cc6f3e78),
W64LIT(0x953b033f52037f45),
W64LIT(0xb0e7fbe529fbc5d8),
W64LIT(0x60df8a61ce8a171d),
W64LIT(0x6f91fd9b8dfd3b52),
W64LIT(0xaae0310f7631a2fe),
W64LIT(0xbfa98c1f6a8ce997),
W64LIT(0x8ba7ed3ed4ed27db),
W64LIT(0x98c2664a8766b656),
W64LIT(0x062c36644f36dae4),
W64LIT(0x5570e2fd3be2517f),
W64LIT(0xead96ee2516eb8e8),
W64LIT(0x419856506c569238),
W64LIT(0x23f0cebe34ce6079),
W64LIT(0x309545ca6745f1f4),
W64LIT(0x5a3e950778957d30),
W64LIT(0x617e83dc85839f33),
W64LIT(0xfb0bf71994f7cc39),
W64LIT(0x3ccd2902f929b0c9),
W64LIT(0x70ac1a27401aebe2),
W64LIT(0xcea49f85619f8a5b),
W64LIT(0x39f704546b04075f),
W64LIT(0x0df96575d565c913),
W64LIT(0x08c3482347487e85),
W64LIT(0xd28f630b71633799),
W64LIT(0xecf558861e58620c),
W64LIT(0xc2fcf34dfff3cb66),
W64LIT(0x978c11b0c4119a19),
W64LIT(0x69bdcbffc2cbe1b6),
W64LIT(0xba93a149f8a15e01),
W64LIT(0x51ebc616e2c66ec7),
W64LIT(0x078d3fd9043f52ca),
W64LIT(0x58898788ee87986c),
W64LIT(0x4a4d0541f60581cf),
W64LIT(0xe86e7c6dc77c5db4),
W64LIT(0xee424a09884a8750),
W64LIT(0xcdb284b7bc84e729),
W64LIT(0x65e5a7375ca7a08b),
W64LIT(0x2fa8a276aaa22144),
W64LIT(0xa0946ba3a76b3927),
W64LIT(0xa5ae46f535468eb1),
W64LIT(0x35af689cf5684662),
W64LIT(0x28259dafae9d738e),
W64LIT(0xcf0596382a960275),
W64LIT(0xb6cbcd8166cd1f3c),
W64LIT(0x7e43646048644f83),
W64LIT(0x9bd47d785a7ddb24),
W64LIT(0x432f44dffa447764),
W64LIT(0x9f4f59938359e49c),
W64LIT(0x7d557f52957f22f1),
W64LIT(0x76802c430f2c3106),
W64LIT(0xdc601d4c791d93f8),
W64LIT(0x053a2d56922db796),
W64LIT(0x11d299fbc59974d1),
W64LIT(0xf9bce59602e52965),
W64LIT(0xd8fb39a7a039ac40),
W64LIT(0x340e6121be61ce4c),
W64LIT(0x5f04b851eab8caa6),
W64LIT(0x5db3aade7caa2ffa),
W64LIT(0x1549bd101cbd4b69),
W64LIT(0xff90d3f24dd3f381),
W64LIT(0xafda1c59e41c1568),
W64LIT(0xb146f25862f24df6),
W64LIT(0xa40f4f487e4f069f),
/* box 2 */
W64LIT(0xa1a35cebf8f0f94c),
W64LIT(0x2c203d650f3f095d),
W64LIT(0x1a2bdaee4084a2a7),
W64LIT(0xd32404574d7bcc68),
W64LIT(0xf785bea594a9adc4),
W64LIT(0xf2eb54456206949c),
W64LIT(0x3f5e334d0475ced1),
W64LIT(0x5994299b835d1f60),
W64LIT(0x785b7989ac204794),
W64LIT(0x025da6a2cf461a41),
W64LIT(0xdf1f3a71f01a901b),
W64LIT(0x27284f018bb77637),
W64LIT(0xe1955a6d694c5310),
W64LIT(0x24a1baf2d9d261ac),
W64LIT(0xe4fbb08d9fe36a48),
W64LIT(0x8d83618ef7cff011),
W64LIT(0x2ac72276abf5279e),
W64LIT(0xf9e32621e68eebf6),
W64LIT(0xbf323fb4d3f86f69),
W64LIT(0xbb888605b8745beb),
W64LIT(0x70dafe1e7acd2f65),
W64LIT(0xd0adf1a41f1edbf3),
W64LIT(0x1e91635f2b089625),
W64LIT(0xee2791b8864818f8),
W64LIT(0x99ce23e4c56c1484),
W64LIT(0xf33f0714ff259946),
W64LIT(0xbd6f99161cbe7528),
W64LIT(0x9f293cf761a63a47),
W64LIT(0xb80173f6ea114c70),
W64LIT(0x6543ef25d54dc62a),
W64LIT(0x39b92c5ea0bfe012),
W64LIT(0x63a4f0367187e8e9),
W64LIT(0x4c0d38a02cddf62f),
W64LIT(0x07334c4239e92319),
W64LIT(0x43bff375c3d9bdc7),
W64LIT(0xca862b4a5f9a7954),
W64LIT(0x5d2e902ae8d12be2),
W64LIT(0x137e0e280b4ac78c),
W64LIT(0xf162a1b630638307),
W64LIT(0x55af17bd3e3c4313),
W64LIT(0x358212781ddebc61),
W64LIT(0x94214e93e52e452d),
W64LIT(0xc18e592edb12063e),
W64LIT(0xec7a371a490e02b9),
W64LIT(0x4963d240da72cf77),
W64LIT(0x41e255d70c9fa786),
W64LIT(0xff0439324244c535),
W64LIT(0x88ed8b6e0160c949),
W64LIT(0x6c163be39e83a301),
W64LIT(0xc534e09fb09e32bc),
W64LIT(0x806c0cf9d78da1b8),
W64LIT(0xdba583c09b96a499),
W64LIT(0x746047af11411be7),
W64LIT(0xf40c4b56c6ccba5f),
W64LIT(0x6270a367eca4e533),
W64LIT(0xd41748157492ef71),
W64LIT(0xeff3c2e91b6b1522),
W64LIT(0x0e66988472274632),
W64LIT(0x534808ae9af66dd0),
W64LIT(0x8231aa5b18cbbbf9),
W64LIT(0xb2dd52c3f3ba3ec0),
W64LIT(0xdd429cd33f5c8a5a),
W64LIT(0x4e509e02e39bec6e),
W64LIT(0x26fc1c5016947bed),
W64LIT(0xd9f8256254d0bed8),
W64LIT(0x0955d4c64bce652b),
W64LIT(0x1610e4c8fde5fed4),
W64LIT(0x6dc268b203a0aedb),
W64LIT(0x2e7d9bc7c079131c),
W64LIT(0xc3d3ff8c14541c7f),
W64LIT(0xd64aeeb7bbd4f530),
W64LIT(0xab7f7ddee15b8bfc),
W64LIT(0x144d426a32a3e495),
W64LIT(0x8e0a947da5aae78a),
W64LIT(0x798f2ad831034a4e),
W64LIT(0x3be48afc6ff9fa53),
W64LIT(0x529c5bff07d5600a),
W64LIT(0xbee66ce54edb62b3),
W64LIT(0x931202d1dcc76634),
W64LIT(0x50c1fd5dc8937a4b),
W64LIT(0xa4cdb60b0e5fc014),
W64LIT(0x57f2b11ff17a5952),
W64LIT(0x47054ac4a8558945),
W64LIT(0x5a1ddc68d13808fb),
W64LIT(0x5cfac37b75f22638),
W64LIT(0xc207acdd897711a5),
W64LIT(0x289a84d464b33ddf),
W64LIT(0xc05a0a7f46310be4),
W64LIT(0xe6a6162f50a57009),
W64LIT(0x06e71f13a4ca2ec3),
W64LIT(0x5f733688279731a3),
W64LIT(0xeb497b5870e721a0),
W64LIT(0xb667eb7298360a42),
W64LIT(0xe3c8fccfa60a4951),
W64LIT(0xe772457ecd867dd3),
W64LIT(0x6978d103682c9a59),
W64LIT(0x0def6d77204251a9),
W64LIT(0xc90fdeb90dff6ecf),
W64LIT(0xd179a2f5823dd629),
W64LIT(0x2fa9c8965d5a1ec6),
W64LIT(0x81b85fa84aaeac62),
W64LIT(0xdc96cf82a27f8780),
W64LIT(0x602d05c523e2ff72),
W64LIT(0x19a22f1d12e1b53c),
W64LIT(0xe52fe3dc02c06792),
W64LIT(0x58407aca1e7e12ba),
W64LIT(0x61f95694bec1f2a8),
W64LIT(0x48b781114751c2ad),
W64LIT(0xaaab2e8f7c788626),
W64LIT(0x04bab9b16b8c3482),
W64LIT(0x2df46e34921c0487),
W64LIT(0x1123a88ac40cddcd),
W64LIT(0xc6bd156ce2fb2527),
W64LIT(0x7f6835cb95c9648d),
W64LIT(0x83e5f90a85e8b623),
W64LIT(0x4f84cd537eb8e1b4),
W64LIT(0x294ed785f9903005),
W64LIT(0x1cccc5fde44e8c64),
W64LIT(0xcb52781bc2b9748e),
W64LIT(0x1d1896ac796d81be),
W64LIT(0xb30901926e99331a),
W64LIT(0xad9862cd4591a53f),
W64LIT(0xc8db8de890dc6315),
W64LIT(0x7bd28c7afe45500f),
W64LIT(0x0adc213519ab72b0),
W64LIT(0xa8f6882db33e9c67),
W64LIT(0xb5ee1e81ca531dd9),
W64LIT(0x201b0343b25e552e),
W64LIT(0x4036068691bcaa5c),
W64LIT(0xae11973e17f4b2a4),
W64LIT(0x9efd6fa6fc85379d),
W64LIT(0x33650d6bb91492a2),
W64LIT(0x3a30d9adf2daf789),
W64LIT(0x0c3b3e26bd615c73),
W64LIT(0xf651edf4098aa01e),
W64LIT(0x710ead4fe7ee22bf),
W64LIT(0x3138abc9765288e3),
W64LIT(0x9d749a55aee02006),
W64LIT(0x6e4b9d4151c5b940),
W64LIT(0x84d6b548bc01953a),
W64LIT(0x360be78b4fbbabfa),
W64LIT(0xa22aa918aa95eed7),
W64LIT(0xedae644bd42d0f63),
W64LIT(0x46d119953576849f),
W64LIT(0x6497bc74486ecbf0),
W64LIT(0xfbbe808329c8f1b7),
W64LIT(0x4aea27b38817d8ec),
W64LIT(0x5626e24e6c595488),
W64LIT(0x056eeae0f6af3958),
W64LIT(0x4558ec6667139304),
W64LIT(0x448cbf37fa309ede),
W64LIT(0x6f9fce10cce6b49a),
W64LIT(0xa0770fba65d3f496),
W64LIT(0x671e49871a0bdc6b),
W64LIT(0xda71d09106b5a943),
W64LIT(0x08818797d6ed68f1),
W64LIT(0xa3fefa4937b6e30d),
W64LIT(0xb080f4613cfc2481),
W64LIT(0x763de10dde0701a6),
W64LIT(0x4dd96bf1b1fefbf5),
W64LIT(0x92c6518041e46bee),
W64LIT(0x3456412980fdb1bb),
W64LIT(0x981a70b5584f195e),
W64LIT(0x3d0395efcb33d490),
W64LIT(0xba5cd55425575631),
W64LIT(0x4b3e74e21534d536),
W64LIT(0x6af124f03a498dc2),
W64LIT(0x7ebc669a08ea6957),
W64LIT(0x30ecf898eb718539),
W64LIT(0xa922db7c2e1d91bd),
W64LIT(0x7a06df2b63665dd5),
W64LIT(0xb154a730a1df295b),
W64LIT(0xfc8dccc11021d2ae),
W64LIT(0xcfe8c1aaa935400c),
W64LIT(0x97a8bb60b74b52b6),
W64LIT(0x18767c4c8fc2b8e6),
W64LIT(0x9a47d6179709031f),
W64LIT(0x0000000000000000),
W64LIT(0xac4c319cd8b2a8e5),
W64LIT(0xb9d520a7773241aa),
W64LIT(0xdecb69206d399dc1),
W64LIT(0x1f45300eb62b9bff),
W64LIT(0x10f7fbdb592fd017),
W64LIT(0x3e8a601c9956c30b),
W64LIT(0x8502e619212298e0),
W64LIT(0xf5d818075befb785),
W64LIT(0x547b44eca31f4ec9),
W64LIT(0x9ca0c90433c32ddc),
W64LIT(0xe041093cf46f5eca),
W64LIT(0xa69010a9c119da55),
W64LIT(0xc769463d7fd828fd),
W64LIT(0xc4e0b3ce2dbd3f66),
W64LIT(0x2575e9a344f16c76),
W64LIT(0x01d453519d230dda),
W64LIT(0xfa6ad3d2b4ebfc6d),
W64LIT(0xd5c31b44e9b1e2ab),
W64LIT(0xf83775707bade62c),
W64LIT(0xbcbbca47819d78f2),
W64LIT(0xd79ebde626f7f8ea),
W64LIT(0x5bc98f394c1b0521),
W64LIT(0x2246a5e17d184f6f),
W64LIT(0x12aa5d799669ca56),
W64LIT(0x5ea765d9bab43c79),
W64LIT(0x8939d83f9c43c493),
W64LIT(0x32b15e3a24379f78),
W64LIT(0xe914ddfabfa13be1),
W64LIT(0x909bf7228ea271af),
W64LIT(0x73530bed28a838fe),
W64LIT(0xd2f05706d058c1b2),
W64LIT(0xfed06a63df67c8ef),
W64LIT(0xb43a4dd057701003),
W64LIT(0xa519e55a937ccdce),
W64LIT(0x75b414fe8c62163d),
W64LIT(0xafc5c46f8ad7bf7e),
W64LIT(0x2392f6b0e03b42b5),
W64LIT(0x386d7f0f3d9cedc8),
W64LIT(0x21cf50122f7d58f4),
W64LIT(0x9b9385460a2a0ec5),
W64LIT(0x5115ae0c55b07791),
W64LIT(0x0fb2cbd5ef044be8),
W64LIT(0xea9d2809edc42c7a),
W64LIT(0xcc613459fb505797),
W64LIT(0x426ba0245efab01d),
W64LIT(0x1599113baf80e94f),
W64LIT(0x7d3593695a8f7ecc),
W64LIT(0x0389f5f35265179b),
W64LIT(0x875f40bbee6482a1),
W64LIT(0x95f51dc2780d48f7),
W64LIT(0x7ce1c038c7ac7316),
W64LIT(0xce3c92fb34164dd6),
W64LIT(0xcdb5670866735a4d),
W64LIT(0x8ab02dccce26d308),
W64LIT(0x914fa47313817c75),
W64LIT(0x8b647e9d5305ded2),
W64LIT(0xd82c7633c9f3b302),
W64LIT(0x728758bcb58b3524),
W64LIT(0xe8c08eab2282363b),
W64LIT(0x8fdec72c3889ea50),
W64LIT(0x2b13712736d62a44),
W64LIT(0x3cd7c6be5610d94a),
W64LIT(0x37dfb4dad298a620),
W64LIT(0x868b13ea73478f7b),
W64LIT(0xb7b3b82305150798),
W64LIT(0x0b08726484887f6a),
W64LIT(0x1bff89bfdda7af7d),
W64LIT(0x77e9b25c43240c7c),
W64LIT(0xf0b6f2e7ad408edd),
W64LIT(0x17c4b79960c6f30e),
W64LIT(0x8c5732df6aecfdcb),
W64LIT(0x68ac8252f50f9783),
W64LIT(0x66ca1ad68728d1b1),
W64LIT(0x6b2577a1a76a8018),
W64LIT(0xe21caf9e3b29448b),
W64LIT(0xa74443f85c3ad78f),
W64LIT(0xfd599f908d02df74),
W64LIT(0x967ce8312a685f6c),
/* box 3 */
W64LIT(0xfa7b9775ba3af751),
W64LIT(0x03ef98cb769c2d13),
W64LIT(0x7191ce067072359e),
W64LIT(0xbab18b6bff7516a8),
W64LIT(0xe6e5ef4efbc1065e),
W64LIT(0x7bec74a3b1d0dbf4),
W64LIT(0x656b4fb907c31c4a),
W64LIT(0x4e8520f99fc86304),
W64LIT(0x8fd8df31d16dae58),
W64LIT(0x90a93fc1e60a7244),
W64LIT(0x30ad09f2b449cfc5),
W64LIT(0x8453be7e91bb5b90),
W64LIT(0x1d68a3d1c08feaad),
W64LIT(0x5c54642504b410f6),
W64LIT(0x8061383c8a9e3707),
W64LIT(0xf9940fbecca6da42),
W64LIT(0x46e1d97da982bbdf),
W64LIT(0xfc50521656f7ad77),
W64LIT(0x5e4d2704f35c2647),
W64LIT(0x8bea5973ca48c2cf),
W64LIT(0xd06323dfa34593bd),
W64LIT(0x62b651306a7a5dce),
W64LIT(0xa436b0714966d116),
W64LIT(0x4f73fb131ebc78a6),
W64LIT(0x92b07ce011e244f5),
W64LIT(0x33429139c2d5e2d6),
W64LIT(0xcee418c515565403),
W64LIT(0xd7be3d56cefcd239),
W64LIT(0x53ed83285f4789a9),
W64LIT(0xf3e9b51b0d043428),
W64LIT(0x20650e0fd8dd8a86),
W64LIT(0xb6e7f4add21aa2e4),
W64LIT(0x6d0fb63d3189c491),
W64LIT(0x0da0a42cac1bafee),
W64LIT(0x3f14eeffefba569a),
W64LIT(0x13279f361a086850),
W64LIT(0x9b225e8ea6dc878c),
W64LIT(0x6684d772715f3159),
W64LIT(0xa3ebaef824df9092),
W64LIT(0xc499a260d4f4ba69),
W64LIT(0xaa798c9693e153eb),
W64LIT(0x50021be329dba4ba),
W64LIT(0x949bb983fd2f1ed3),
W64LIT(0xdfdac4d2f8b60ae2),
W64LIT(0xf0062dd07b98193b),
W64LIT(0xafbdd13e09b024de),
W64LIT(0xb95e13a089e93bbb),
W64LIT(0x649d945386b707e8),
W64LIT(0xe4fcac6f0c2930ef),
W64LIT(0x413cc7f4c43bfa5b),
W64LIT(0x3b2668bdf49f3a0d),
W64LIT(0xe50a77858d5d2b4d),
W64LIT(0x05c45da89a517735),
W64LIT(0x3ee235156ece4d38),
W64LIT(0xfe491137a11f9bc6),
W64LIT(0xb7112f47536eb946),
W64LIT(0x07dd1e896db94184),
W64LIT(0x1ab5bd58ad36ab29),
W64LIT(0x8197e3d60bea2ca5),
W64LIT(0xab8f577c12954849),
W64LIT(0x9cff4007cb65c608),
W64LIT(0xa00436335243bd81),
W64LIT(0xfda689fcd783b6d5),
W64LIT(0xccfd5be4e2be62b2),
W64LIT(0x75a348446b575909),
W64LIT(0x17151974012d04c7),
W64LIT(0xfb8d4c9f3b4eecf3),
W64LIT(0xac5249f57f2c09cd),
W64LIT(0x9346a70a90965f57),
W64LIT(0x043286421b256c97),
W64LIT(0x27b81086b564cb02),
W64LIT(0x3569545a2e18b8f0),
W64LIT(0x6b24735edd449eb7),
W64LIT(0x2193d5e559a99124),
W64LIT(0xc7763aaba268977a),
W64LIT(0xb0cc31ce3ed7f8c2),
W64LIT(0xc939064c78ef1587),
W64LIT(0x16e3c29e80591f65),
W64LIT(0x5da2bfcf85c00b54),
W64LIT(0x5990398d9ee567c3),
W64LIT(0x67720c98f02b2afb),
W64LIT(0x54309da132fec82d),
W64LIT(0xeab39088d6aeb212),
W64LIT(0x9682faa20ac72862),
W64LIT(0xd38cbb14d5d9beae),
W64LIT(0x4c9c63d8682055b5),
W64LIT(0xd648e6bc4f88c99b),
W64LIT(0xdc355c198e2a27f1),
W64LIT(0x10c807fd6c944543),
W64LIT(0x450e41b6df1e96cc),
W64LIT(0x0b8b614f40d6f5c8),
W64LIT(0xd27a60fe54ada50c),
W64LIT(0x49583e70f2712280),
W64LIT(0x8dc19c10268598e9),
W64LIT(0x5866e2671f917c61),
W64LIT(0x79f537824638ed45),
W64LIT(0xc2b267033839e04f),
W64LIT(0xcb20456d8f072336),
W64LIT(0x2a18b4aa197f64ec),
W64LIT(0xdbe84290e3936675),
W64LIT(0x73888d27879a032f),
W64LIT(0xe8aad3a9214684a3),
W64LIT(0x6ee02ef64715e982),
W64LIT(0xa996145de57d7ef8),
W64LIT(0xc8cfdda6f99b0e25),
W64LIT(0x062bc563eccd5a26),
W64LIT(0x264ecb6c3410d0a0),
W64LIT(0xb8a8c84a089d2019),
W64LIT(0x7dc7b1c05d1d81d2),
W64LIT(0xd5a77e773914e488),
W64LIT(0x4b417d5105991431),
W64LIT(0xf62de8b39755431d),
W64LIT(0x993b1daf5134b13d),
W64LIT(0x82787b1d7d7601b6),
W64LIT(0xe321b2e66190716b),
W64LIT(0xb5086c66a4868ff7),
W64LIT(0x9ee603263c8df0b9),
W64LIT(0x349f8fb0af6ca352),
W64LIT(0x5b897aac690d5172),
W64LIT(0x7c316a2adc699a70),
W64LIT(0xd451a59db860ff2a),
W64LIT(0x706715ecf1062e3c),
W64LIT(0x838ea0f7fc021a14),
W64LIT(0x57df056a4462e53e),
W64LIT(0xcf12c32f94224fa1),
W64LIT(0xed6e8e01bb17f396),
W64LIT(0x915fe42b677e69e6),
W64LIT(0x89f31a523da0f47e),
W64LIT(0xe71334a47ab51dfc),
W64LIT(0xa860cfb76409655a),
W64LIT(0x9f10d8ccbdf9eb1b),
W64LIT(0xef77cd204cffc527),
W64LIT(0xf862d4544dd2c1e0),
W64LIT(0x8a1c82994b3cd96d),
W64LIT(0xae4b0ad488c43f7c),
W64LIT(0x98cdc645d040aa9f),
W64LIT(0x7fdef2e1aaf5b763),
W64LIT(0x4717029728f6a07d),
W64LIT(0x745593aeea2342ab),
W64LIT(0xee8116cacd8bde85),
W64LIT(0x727e56cd06ee188d),
W64LIT(0x227c4d2e2f35bc37),
W64LIT(0x977421488bb333c0),
W64LIT(0xa21d7512a5ab8b30),
W64LIT(0xbb4750817e010d0a),
W64LIT(0x6cf96dd7b0fddf33),
W64LIT(0x2801f78bee97525d),
W64LIT(0x1c9e783b41fbf10f),
W64LIT(0x9d099bed4a11ddaa),
W64LIT(0x7a1aaf4930a4c056),
W64LIT(0x32b44ad343a1f974),
W64LIT(0x3cfb763499267b89),
W64LIT(0xb2d572efc93fce73),
W64LIT(0x63408adaeb0e466c),
W64LIT(0xada4921ffe58126f),
W64LIT(0x5fbbfcee72283de5),
W64LIT(0x6ad2a8b45c308515),
W64LIT(0x0c567fc62d6fb44c),
W64LIT(0x956d62697c5b0571),
W64LIT(0x25a153a7428cfdb3),
W64LIT(0x150c5a55f6c53276),
W64LIT(0xe2d7690ce0e46ac9),
W64LIT(0xda1e997a62e77dd7),
W64LIT(0xf5c27078e1c96e0e),
W64LIT(0xc344bce9b94dfbed),
W64LIT(0x60af12119d926b7f),
W64LIT(0xa1f2edd9d337a623),
W64LIT(0xcad69e870e733894),
W64LIT(0x3770177bd9f08e41),
W64LIT(0xa5c06b9bc812cab4),
W64LIT(0x1f71e0f03767dc1c),
W64LIT(0x44f89a5c5e6a8d6e),
W64LIT(0x6159c9fb1ce670dd),
W64LIT(0x8e2e04db5019b5fa),
W64LIT(0x8805c1b8bcd4efdc),
W64LIT(0xe138f1c7967847da),
W64LIT(0x4ab7a6bb84ed0f93),
W64LIT(0x0000000000000000),
W64LIT(0x38c9f0768203171e),
W64LIT(0x1b4366b22c42b08b),
W64LIT(0x7803ec68c74cf6e7),
W64LIT(0xec9855eb3a63e834),
W64LIT(0xbe830d29e4507a3f),
W64LIT(0x2dc5aa2374c62568),
W64LIT(0xa62ff350be8ee7a7),
W64LIT(0x764cd08f1dcb741a),
W64LIT(0x8c3747faa7f1834b),
W64LIT(0x0fb9e70d5bf3995f),
W64LIT(0x55c6464bb38ad38f),
W64LIT(0xf7db3359162158bf),
W64LIT(0xd195f8352231881f),
W64LIT(0x0992226eb73ec379),
W64LIT(0x14fa81bf77b129d4),
W64LIT(0x48aee59a73053922),
W64LIT(0x2457884dc3f8e611),
W64LIT(0xffbfcadd206b8064),
W64LIT(0xb4feb78c25f29455),
W64LIT(0x864afd5f66536d21),
W64LIT(0x6f16f51cc661f220),
W64LIT(0xde2c1f3879c21140),
W64LIT(0x195a2593dbaa863a),
W64LIT(0x2e2a32e8025a087b),
W64LIT(0x432584d533d3ccea),
W64LIT(0x2c3371c9f5b23eca),
W64LIT(0xa7d928ba3ffafc05),
W64LIT(0x42d35f3fb2a7d748),
W64LIT(0x85a5659410cf4032),
W64LIT(0x0864f984364ad8db),
W64LIT(0xf21f6ef18c702f8a),
W64LIT(0xf1f0f63afaec0299),
W64LIT(0xd9f101b1147b50c4),
W64LIT(0x2fdce902832e13d9),
W64LIT(0x4d6ab832e9544e17),
W64LIT(0xe0ce2a2d170c5c78),
W64LIT(0x51f4c009a8afbf18),
W64LIT(0x68cbeb95abd8b3a4),
W64LIT(0xc15dffc84ea5cd5c),
W64LIT(0x02194321f7e836b1),
W64LIT(0x113edc17ede05ee1),
W64LIT(0x521b58c2de33920b),
W64LIT(0x9ad4856427a89c2e),
W64LIT(0x5629de80c516fe9c),
W64LIT(0x77ba0b659cbf6fb8),
W64LIT(0x238a96c4ae41a795),
W64LIT(0x12d144dc9b7c73f2),
W64LIT(0xd807da5b950f4b66),
W64LIT(0x3686cc91588495e3),
W64LIT(0x18acfe795ade9d98),
W64LIT(0x5a7fa146e8794ad0),
W64LIT(0xc680e141231c8cd8),
W64LIT(0x1e873b1ab613c7be),
W64LIT(0xf434ab9260bd75ac),
W64LIT(0xcd0b800e63ca7910),
W64LIT(0xbc9a4e0813b84c8e),
W64LIT(0x3d0dadde1852602b),
W64LIT(0x40ca1c1e454fe1f9),
W64LIT(0x0a7dbaa5c1a2ee6a),
W64LIT(0x693d307f2aaca806),
W64LIT(0x0e4f3ce7da8782fd),
W64LIT(0xbd6c95e292cc572c),
W64LIT(0x3ad0b35775eb21af),
W64LIT(0x7e28290b2b81acc1),
W64LIT(0x01f6dbea81741ba2),
W64LIT(0x87bc26b5e7277683),
W64LIT(0x393f2b9c03770cbc),
W64LIT(0xddc387f30f5e3c53),
W64LIT(0xeb454b6257daa9b0),
W64LIT(0xb323a905484bd5d1),
W64LIT(0xb13aea24bfa3e360),
W64LIT(0x315bd218353dd467),
W64LIT(0x2bee6f40980b7f4e),
W64LIT(0xe95c0843a0329f01),
W64LIT(0xc56f798a5580a1cb),
W64LIT(0xbf75d6c36524619d),
W64LIT(0x29f72c616fe349ff),
W64LIT(0xc0ab2422cfd1d6fe),
/* box 4 */
W64LIT(0x561fc423e957943c),
W64LIT(0x014287ca69079288),
W64LIT(0x2f086129dfcd1d21),
W64LIT(0xc537d4aea044fd99),
W64LIT(0xf1e8c3bfd7c8a457),
W64LIT(0x2971998a5cdf9bfb),
W64LIT(0x23fa649a2ce9e460),
W64LIT(0x3aa9e9c356a6716a),
W64LIT(0xd6efa4e7aa3d1708),
W64LIT(0x705a24b1fda5b5eb),
W64LIT(0x101e0ce2b170a9fc),
W64LIT(0x7ca821020e814caa),
W64LIT(0x0bc97ada1931ed13),
W64LIT(0x34df1711778c59ce),
W64LIT(0xd35020ef9226d2bf),
W64LIT(0x575d43e9805006b4),
W64LIT(0x91acebec9b1db840),
W64LIT(0x549b3f423b5945d9),
W64LIT(0x99a3ed9d3925163e),
W64LIT(0x7917a50a369a891d),
W64LIT(0xe372343cb4b6dc4e),
W64LIT(0x8d40e2bdd949e8fd),
W64LIT(0xcfbc29bed0728202),
W64LIT(0x969794857108ac12),
W64LIT(0xdd26de3db30cfa1b),
W64LIT(0x115c8b28d8773b74),
W64LIT(0xe9f9c92cc480a3d5),
W64LIT(0x4dc8b21b4116d0d3),
W64LIT(0x316093194f979c79),
W64LIT(0x5124bb4a0342806e),
W64LIT(0xb31408bcdef3cea8),
W64LIT(0xc1cad76cf158aaa6),
W64LIT(0x88ff66b5e1522d4a),
W64LIT(0xa8c37e8476b28a47),
W64LIT(0x15a188ea896b6c4b),
W64LIT(0xa24883940684f5dc),
W64LIT(0xda1da1545919ee49),
W64LIT(0x22b8e35045ee76e8),
W64LIT(0x6106af9925d28e9f),
W64LIT(0xef80318f4792250f),
W64LIT(0x663dd0f0cfc79acd),
W64LIT(0x302214d326900ef1),
W64LIT(0xdfa2255c61022bfe),
W64LIT(0xe6cdb0348cad19f9),
W64LIT(0x50663c806a4512e6),
W64LIT(0x65fbac5b74ced9a0),
W64LIT(0xc4755364c9436f11),
W64LIT(0x8fc419dc0b473918),
W64LIT(0x5c9439339961eba7),
W64LIT(0x3f166dcb6ebdb4dd),
W64LIT(0xba59890715ccf25e),
W64LIT(0xf0aa4475becf36df),
W64LIT(0x03c67cabbb09436d),
W64LIT(0xb99ff5acaec5b133),
W64LIT(0xf9e7c5ce75f00a29),
W64LIT(0x6df4aa2ad6f677de),
W64LIT(0xaeba8627f5a00c9d),
W64LIT(0xa573fcfdec91e18e),
W64LIT(0x7f6e5da9b5880fc7),
W64LIT(0xca03adb6e86947b5),
W64LIT(0x74a72773acb9e2d4),
W64LIT(0x604428534cd51c17),
W64LIT(0xf8a542041cf798a1),
W64LIT(0x448533a08a29ec25),
W64LIT(0x80f060c4436a8334),
W64LIT(0x0db082799a236bc9),
W64LIT(0xfa21b965cef94944),
W64LIT(0x64b92b911dc94b28),
W64LIT(0x7118a37b94a22763),
W64LIT(0xaff801ed9ca79e15),
W64LIT(0x1dae8e9b2b53c235),
W64LIT(0x13d870490a79ea91),
W64LIT(0x8a7b9dd4335cfcaf),
W64LIT(0x1f2a75faf95d13d0),
W64LIT(0xeec2b6452e95b787),
W64LIT(0xc34e2c0d23567b43),
W64LIT(0x47434f0b3120af48),
W64LIT(0xa18eff3fbd8db6b1),
W64LIT(0x98e16a57502284b6),
W64LIT(0x37196bbacc851aa3),
W64LIT(0x8e869e166240ab90),
W64LIT(0x9fda153eba3790e4),
W64LIT(0xf515c07d86d4f368),
W64LIT(0x72dedfd02fab640e),
W64LIT(0xe230b3f6ddb14ec6),
W64LIT(0x97d5134f180f3e9a),
W64LIT(0xe1f6cf5d66b80dab),
W64LIT(0xe78f37fee5aa8b71),
W64LIT(0xa30a045e6f836754),
W64LIT(0x90ee6c26f21a2ac8),
W64LIT(0xaa4785e5a4bc5ba2),
W64LIT(0x4e0eceb0fa1f93be),
W64LIT(0x94136fe4a3067df7),
W64LIT(0x7b935e6be49458f8),
W64LIT(0x9b2716fceb2bc7db),
W64LIT(0x840d63061276d40b),
W64LIT(0xed04caee959cf4ea),
W64LIT(0xea3fb5877f89e0b8),
W64LIT(0xb56df01f5de14872),
W64LIT(0x4935b1d9100a87ec),
W64LIT(0x82749ba5916452d1),
W64LIT(0x58693af1c87dbc98),
W64LIT(0x89bde17f8855bfc2),
W64LIT(0x677f573aa6c00845),
W64LIT(0xeb7d324d168e7230),
W64LIT(0x0284fb61d20ed1e5),
W64LIT(0xb190f3dd0cfd1f4d),
W64LIT(0x684b2e22eeedb269),
W64LIT(0x2bf562eb8ed14a1e),
W64LIT(0xe0b448970fbf9f23),
W64LIT(0x396f9568edaf3207),
W64LIT(0x52e2c7e1b84bc303),
W64LIT(0x77615bd817b0a1b9),
W64LIT(0x7e2cda63dc8f9d4f),
W64LIT(0xf22ebf146cc1e73a),
W64LIT(0xc08850a6985f382e),
W64LIT(0xd9dbddffe210ad24),
W64LIT(0xbfe60d0f2dd737e9),
W64LIT(0x9a659136822c5553),
W64LIT(0x87cb1fada97f9766),
W64LIT(0x4c8a35d12811425b),
W64LIT(0x83361c6ff863c059),
W64LIT(0xd212a725fb214037),
W64LIT(0x9e9892f4d330026c),
W64LIT(0x45c7b46ae32e7ead),
W64LIT(0x5baf465a7374fff5),
W64LIT(0xdc6459f7da0b6893),
W64LIT(0xd46b5f867833c6ed),
W64LIT(0x5dd6bef9f066792f),
W64LIT(0xcb412a7c816ed53d),
W64LIT(0x75e5a0b9c5be705c),
W64LIT(0xf6d3bcd63dddb005),
W64LIT(0xfb633eafa7fedbcc),
W64LIT(0xd529d84c11345465),
W64LIT(0xc9c5d11d536004d8),
W64LIT(0xdb5f269e301e7cc1),
W64LIT(0x86899867c07805ee),
W64LIT(0x3d9296aabcb36538),
W64LIT(0x2cce1d8264c45e4c),
W64LIT(0x5aedc1901a736d7d),
W64LIT(0x2e4ae6e3b6ca8fa9),
W64LIT(0x1e68f230905a8158),
W64LIT(0xdee0a2960805b976),
W64LIT(0xcd38d2df027c53e7),
W64LIT(0x6909a9e887ea20e1),
W64LIT(0x24c11bf3c6fcf032),
W64LIT(0x18110a9313480782),
W64LIT(0xa7f7079c3e9f306b),
W64LIT(0xd8995a358b173fac),
W64LIT(0x854fe4cc7b714683),
W64LIT(0xbd62f66effd9e60c),
W64LIT(0x14e30f20e06cfec3),
W64LIT(0x6e32d6816dff34b3),
W64LIT(0x217e9ffbfee73585),
W64LIT(0xc88756d73a679650),
W64LIT(0x359d90db1e8bcb46),
W64LIT(0x2645e09214f221d7),
W64LIT(0x04fd03c2511c573f),
W64LIT(0x739c581a46acf686),
W64LIT(0xb0d2741765fa8dc5),
W64LIT(0xa0cc78f5d48a2439),
W64LIT(0x5e10c2524b6f3a42),
W64LIT(0xe50bcc9f37a45a94),
W64LIT(0x53a0402bd14c518b),
W64LIT(0x413ab7a8b2322992),
W64LIT(0x203c183197e0a70d),
W64LIT(0xcc7a55156b7bc16f),
W64LIT(0x4601c8c158273dc0),
W64LIT(0xbea48ac544d0a561),
W64LIT(0x638254f8f7dc5f7a),
W64LIT(0xa6b580565798a2e3),
W64LIT(0x3cd01160d5b4f7b0),
W64LIT(0x8c026577b04e7a75),
W64LIT(0x7ad1d9a18d93ca70),
W64LIT(0x785522c05f9d1b95),
W64LIT(0x5f5245982268a8ca),
W64LIT(0x9551e82eca01ef7f),
W64LIT(0x0000000000000000),
W64LIT(0xbb1b0ecd7ccb60d6),
W64LIT(0x094d81bbcb3f3cf6),
W64LIT(0x28331e4035d80973),
W64LIT(0xf7913b1c54da228d),
W64LIT(0x6acfd5433ce3638c),
W64LIT(0x1bd77638a84144ef),
W64LIT(0x62c0d3329edbcdf2),
W64LIT(0x81b2e70e2a6d11bc),
W64LIT(0xd7ad232dc33a8580),
W64LIT(0x05bf8408381bc5b7),
W64LIT(0x33e468789d994d9c),
W64LIT(0xfedcbaa79fe51e7b),
W64LIT(0x4f4c497a93180136),
W64LIT(0x073b7f69ea151452),
W64LIT(0x0cf205b3f324f941),
W64LIT(0x382d12a284a8a08f),
W64LIT(0x1cec0951425450bd),
W64LIT(0x55d9b888525ed751),
W64LIT(0x6cb62de0bff1e556),
W64LIT(0xd1d4db8e4028035a),
W64LIT(0x25839c39affb62ba),
W64LIT(0x4af3cd72ab03c481),
W64LIT(0xa4317b3785967306),
W64LIT(0x1a95f1f2c146d667),
W64LIT(0x926a97472014fb2d),
W64LIT(0xb7e90b7e8fef9997),
W64LIT(0xcefeae74b975108a),
W64LIT(0x3e54ea0107ba2655),
W64LIT(0xd0965c44292f91d2),
W64LIT(0xab05022fcdbbc92a),
W64LIT(0xfd1ac60c24ec5d16),
W64LIT(0xfc5841c64debcf9e),
W64LIT(0xe4494b555ea3c81c),
W64LIT(0xb6ab8cb4e6e80b1f),
W64LIT(0x3beb6e093fa1e3e2),
W64LIT(0xf36c38de05c675b2),
W64LIT(0x9c1c6995013ed389),
W64LIT(0x8b391a1e5a5b6e27),
W64LIT(0xec464d24fc9b6662),
W64LIT(0xad7cfa8c4ea94ff0),
W64LIT(0x0f347918482dba2c),
W64LIT(0x9d5eee5f68394101),
W64LIT(0x7623dc127eb73331),
W64LIT(0x32a6efb2f49edf14),
W64LIT(0x2d8c9a480dc3ccc4),
W64LIT(0xb2568f76b7f45c20),
W64LIT(0x0e76fed2212a28a4),
W64LIT(0x48773613790d1564),
W64LIT(0x129af783637e7819),
W64LIT(0x080f0671a238ae7e),
W64LIT(0x365bec70a582882b),
W64LIT(0x42fccb03093b6aff),
W64LIT(0x0a8bfd1070367f9b),
W64LIT(0xff9e3d6df6e28cf3),
W64LIT(0xe8bb4ee6ad87315d),
W64LIT(0xc7b32fcf724a2c7c),
W64LIT(0xb8dd7266c7c223bb),
W64LIT(0x9328108d491369a5),
W64LIT(0x0679f8a3831286da),
W64LIT(0x270767587df5b35f),
W64LIT(0xa981f94e1fb518cf),
W64LIT(0x6b8d528955e4f104),
W64LIT(0x1667f44132622f26),
W64LIT(0x2ab7e521e7d6d896),
W64LIT(0xac3e7d4627aedd78),
W64LIT(0x7deaa6c86786de22),
W64LIT(0x1725738b5b65bdae),
W64LIT(0x4bb14ab8c2045609),
W64LIT(0x592bbd3ba17a2e10),
W64LIT(0xc20cabc74a51e9cb),
W64LIT(0x6f70514b04f8a63b),
W64LIT(0xbc2071a496de7484),
W64LIT(0x19538d597a4f950a),
W64LIT(0xf45747b7efd361e0),
W64LIT(0x43be4cc9603cf877),
W64LIT(0xc6f1a8051b4dbef4),
W64LIT(0xb42f77d534e6dafa),
W64LIT(0x40783062db35bb1a),
/* box 5 */
W64LIT(0xf5a96c292deb0a4e),
W64LIT(0x211c9df6ee653c51),
W64LIT(0x04de5ddcbeeef596),
W64LIT(0xe1e5b06f7457c19f),
W64LIT(0x74ca30f014a54fb6),
W64LIT(0xc296f9f7c5457d85),
W64LIT(0x7d4ee08a484d10b0),
W64LIT(0xae87f2d0bf9b13ad),
W64LIT(0x8df4bb480e89afb7),
W64LIT(0x2d8b7a67d9a2d61e),
W64LIT(0x0f3559c8bd712adb),
W64LIT(0x541bc7312f013338),
W64LIT(0x9ec4848b636d5164),
W64LIT(0x952f809f60f28e29),
W64LIT(0x28984d8cb28d6357),
W64LIT(0xd4b5f1dfc38e361f),
W64LIT(0x5674135f7076b373),
W64LIT(0xb791a330042172ec),
W64LIT(0xab94c53bd4b4a6e4),
W64LIT(0xf17731f59305ffd8),
W64LIT(0x39c7a621801e1dcf),
W64LIT(0x20d1f7c13ba47c8e),
W64LIT(0x5e3da912f95facaa),
W64LIT(0xb1202a82e5b80731),
W64LIT(0x13303fc36de4fed3),
W64LIT(0x2e29c43e5314168a),
W64LIT(0x861fbf5c0d1670fa),
W64LIT(0x6458b16af3f771f1),
W64LIT(0x3043765bdcf642c9),
W64LIT(0x12fd55f4b825be0c),
W64LIT(0x0a266e23d65e9f92),
W64LIT(0x6595db5d2636312e),
W64LIT(0x85bd010587a0b06e),
W64LIT(0x9bd7b3600842e42d),
W64LIT(0xaa59af0c0175e63b),
W64LIT(0x240faa1d854a8918),
W64LIT(0xf464061ef82a4a91),
W64LIT(0x5c527d7ca6282ce1),
W64LIT(0x03a2be598ab6c094),
W64LIT(0x40571b7776bdf8e9),
W64LIT(0xe4f687841f7874d6),
W64LIT(0x115febad32937e98),
W64LIT(0x5108f0da442e8671),
W64LIT(0x9cab50e53c1ad12f),
W64LIT(0x33e1c8025640825d),
W64LIT(0x87d2d56bd8d73025),
W64LIT(0xc0f92d999a32fdce),
W64LIT(0x62e938d8126e042c),
W64LIT(0x4a717554a0e3677b),
W64LIT(0x0beb0414039fdf4d),
W64LIT(0xd6da25b19cf9b654),
W64LIT(0x55d6ad06fac073e7),
W64LIT(0x632452efc7af44f3),
W64LIT(0xb5fe775e5b56f2a7),
W64LIT(0x892ae694b0675a21),
W64LIT(0x7a32030f7c1525b2),
W64LIT(0x5d9f174b73e96c3e),
W64LIT(0xc35b93c010843d5a),
W64LIT(0x373f95dee8ae77cb),
W64LIT(0xfb515fd6455b604a),
W64LIT(0xa9fb11558bc326af),
W64LIT(0x22be23af64d3fcc5),
W64LIT(0xa8367b625e026670),
W64LIT(0xb8a4faf8b9505837),
W64LIT(0x785dd7612362a5f9),
W64LIT(0x588c20a018c6d977),
W64LIT(0xea0eb47b77c81ed2),
W64LIT(0xa6ce489d36b20c74),
W64LIT(0x0c97e79137c7ea4f),
W64LIT(0x7c838abd9d8c506f),
W64LIT(0x57b97968a5b7f3ac),
W64LIT(0x6c110b277ade6e28),
W64LIT(0xc785ce1cae6ac8cc),
W64LIT(0x1581b6718c7d8b0e),
W64LIT(0x614b868198d8c4b8),
W64LIT(0x27ad14440ffc498c),
W64LIT(0xdb80a8177eff1cc4),
W64LIT(0x472bf8f242e5cdeb),
W64LIT(0x8a8858cd3ad19ab5),
W64LIT(0xf60bd270a75dcada),
W64LIT(0x43f5a52efc0b387d),
W64LIT(0x6ddc6110af1f2ef7),
W64LIT(0xf0ba5bc246c4bf07),
W64LIT(0x6fb3b57ef068aebc),
W64LIT(0x18db3bd76e7b219e),
W64LIT(0x903cb7740bdd3b60),
W64LIT(0x7bff6938a9d4656d),
W64LIT(0xbdb7cd13d27fed7e),
W64LIT(0x051337eb6b2fb549),
W64LIT(0x77688ea99e138f22),
W64LIT(0xd9ef7c7921889c8f),
W64LIT(0x077ce38534583502),
W64LIT(0xf318e59bcc727f93),
W64LIT(0xb34ffeecbacf877a),
W64LIT(0xe9ac0a22fd7ede46),
W64LIT(0xfc2dbc5371035548),
W64LIT(0x026fd46e5f77804b),
W64LIT(0xe53bedb3cab93409),
W64LIT(0xcc6eca08adf51781),
W64LIT(0xe028da58a1968140),
W64LIT(0x3a6518780aa8dd5b),
W64LIT(0xce011e66f28297ca),
W64LIT(0xa4a19cf369c58c3f),
W64LIT(0xc5ea1a72f11d4887),
W64LIT(0xc427704524dc0858),
W64LIT(0x4238cf1929ca78a2),
W64LIT(0x481ea13aff94e730),
W64LIT(0xdf5ef5cbc011e952),
W64LIT(0x80ae36eeec8f0527),
W64LIT(0x5ae3f4ce47b1593c),
W64LIT(0xcda3a03f7834575e),
W64LIT(0x71d9071b7f8afaff),
W64LIT(0xcadf43ba4c6c625c),
W64LIT(0x1623082806cb4b9a),
W64LIT(0x17ee621fd30a0b45),
W64LIT(0x448946abc8530d7f),
W64LIT(0x974054f13f850e62),
W64LIT(0x73b6d37520fd7ab4),
W64LIT(0xc8b097d4131be217),
W64LIT(0x9f09eebcb6ac11bb),
W64LIT(0x45442c9c1d924da0),
W64LIT(0x1b79858ee4cde10a),
W64LIT(0x0984d07a5ce85f06),
W64LIT(0x4cc0fce6417a12a6),
W64LIT(0x99b8670e57356466),
W64LIT(0xad254c89352dd339),
W64LIT(0x322ca2358381c282),
W64LIT(0xcfcc74512743d715),
W64LIT(0x6b6de8a24e865b2a),
W64LIT(0xda4dc220ab3e5c1b),
W64LIT(0x88e78ca365a61afe),
W64LIT(0x939e092d816bfbf4),
W64LIT(0xcb12298d99ad2283),
W64LIT(0xeed0e9a7c926eb44),
W64LIT(0x98750d3982f424b9),
W64LIT(0xd5789be8164f76c0),
W64LIT(0xbe15734a58c92dea),
W64LIT(0x49d3cb0d2a55a7ef),
W64LIT(0x67fa0f337941b165),
W64LIT(0x8c39d17fdb48ef68),
W64LIT(0x25c2c02a508bc9c7),
W64LIT(0x349d2b876218b75f),
W64LIT(0x70146d2caa4bba20),
W64LIT(0x1c05660bd095d408),
W64LIT(0xfe42683d2e74d503),
W64LIT(0x9a1ad957dd83a4f2),
W64LIT(0xf2d58fac19b33f4c),
W64LIT(0x81635cd9394e45f8),
W64LIT(0xb65cc907d1e03233),
W64LIT(0xdd3121a59f666919),
W64LIT(0x318e1c6c09370216),
W64LIT(0x8b4532faef10da6a),
W64LIT(0x191651e0bbba6141),
W64LIT(0x3f762f9361876812),
W64LIT(0xb96990cf6c9118e8),
W64LIT(0xb4331d698e97b278),
W64LIT(0xd822164ef449dc50),
W64LIT(0x84706b325261f0b1),
W64LIT(0x4eaf28881e0d92ed),
W64LIT(0x69023ccc11f1db61),
W64LIT(0x66376504ac80f1ba),
W64LIT(0x0849ba4d89291fd9),
W64LIT(0xff8f020afbb595dc),
W64LIT(0x50c59aed91efc6ae),
W64LIT(0x1dc80c3c055494d7),
W64LIT(0x1e6ab2658fe25443),
W64LIT(0x3d19fbfd3ef0e859),
W64LIT(0xfa9c35e1909a2095),
W64LIT(0x52aa4e83ce9846e5),
W64LIT(0x419a7140a37cb836),
W64LIT(0xa07fc12fd72b79a9),
W64LIT(0x68cf56fbc4309bbe),
W64LIT(0x01cd6a37d5c140df),
W64LIT(0x9253631a54aabb2b),
W64LIT(0xd06bac037d60c389),
W64LIT(0x295527bb674c2388),
W64LIT(0xd204786d221743c2),
W64LIT(0x0000000000000000),
W64LIT(0xf7c6b847729c8a05),
W64LIT(0xdcfc4b924aa729c6),
W64LIT(0xe38a64012b2041d4),
W64LIT(0xb28294db6f0ec7a5),
W64LIT(0x9d663ad2e9db91f0),
W64LIT(0x91f1dd43de1c7bbf),
W64LIT(0x6086ecb64d198467),
W64LIT(0x59414a97cd0799a8),
W64LIT(0xace826bee0ec93e6),
W64LIT(0xa56cf6c4bc04cce0),
W64LIT(0x727bb942f53c3a6b),
W64LIT(0x6e7edf4925a9ee63),
W64LIT(0x26607e73da3d0953),
W64LIT(0xe75439dd95ceb442),
W64LIT(0x7990bd56f6a3e526),
W64LIT(0xecbf3dc996516b0f),
W64LIT(0x76a5e49e4bd2cffd),
W64LIT(0x968d3ec6ea444ebd),
W64LIT(0x5b2e9ef9927019e3),
W64LIT(0x6aa082959b471bf5),
W64LIT(0xbb0644a133e698a3),
W64LIT(0x830c88b76639c5b3),
W64LIT(0xe2470e36fee1010b),
W64LIT(0xb0ed40b5307947ee),
W64LIT(0x355041b0b7d9f780),
W64LIT(0x8e560511843f6f23),
W64LIT(0x7f2134e4173a90fb),
W64LIT(0x2af799e2edfae31c),
W64LIT(0x4bbc1f63752227a4),
W64LIT(0xf8f3e18fcfeda0de),
W64LIT(0x0d5a8da6e206aa90),
W64LIT(0x2c4610500c6396c1),
W64LIT(0xde939ffc15d0a98d),
W64LIT(0xaf4a98e76a5a5372),
W64LIT(0x8f9b6f2651fe2ffc),
W64LIT(0x36f2ffe93d6f3714),
W64LIT(0x0ef833ff68b06a04),
W64LIT(0xe69953ea400ff49d),
W64LIT(0x23734998b112bc1a),
W64LIT(0x3ebb45a4b44628cd),
W64LIT(0x1ab4efb9310ca1d5),
W64LIT(0x2fe4ae0986d55655),
W64LIT(0xebc3de4ca2095e0d),
W64LIT(0x536724b41b59063a),
W64LIT(0x46e692c597248d34),
W64LIT(0x2b3af3d5383ba3c3),
W64LIT(0x3ba8724fdf699d84),
W64LIT(0xc13447ae4ff3bd11),
W64LIT(0x4d0d96d194bb5279),
W64LIT(0xfde0d664a4c21597),
W64LIT(0xd7174f864938f68b),
W64LIT(0x7eec5ed3c2fbd024),
W64LIT(0xbfd8197d8d086d35),
W64LIT(0x4f6242bfcbccd232),
W64LIT(0xa70322aae3734cab),
W64LIT(0xa3dd7f765d9db93d),
W64LIT(0x94e2eaa8b533cef6),
W64LIT(0x144cdc4659bccbd1),
W64LIT(0xc648a42b7bab8813),
W64LIT(0xf93e8bb81a2ce001),
W64LIT(0xbacb2e96e627d87c),
W64LIT(0xbc7aa72407beada1),
W64LIT(0xc97dfde3c6daa2c8),
W64LIT(0xa1b2ab1802ea3976),
W64LIT(0x1fa7d8525a23149c),
W64LIT(0x75075ac7c1640f69),
W64LIT(0xe861601528bf9e99),
W64LIT(0xa2101541885cf9e2),
W64LIT(0xef1d83901ce7ab9b),
W64LIT(0x06b189b2e19975dd),
W64LIT(0x380acc1655df5d10),
W64LIT(0x1092819ae7523e47),
W64LIT(0xd3c9125af7d6031d),
W64LIT(0xd1a6c634a8a18356),
W64LIT(0x5ff0c3252c9eec75),
W64LIT(0x82c1e280b3f8856c),
W64LIT(0xed7257fe43902bd0),
W64LIT(0x3cd491caeb31a886),
/* box 6 */
W64LIT(0x94af9eb6fad9e7df),
W64LIT(0x9208ae5e03c94ddd),
W64LIT(0x1d8de8d67158480b),
W64LIT(0xfd093cd2ba147af8),
W64LIT(0xa45ceb22e6597ccf),
W64LIT(0x9bbde6e77bf113da),
W64LIT(0xe4edf4b465fffe5c),
W64LIT(0x7125622e4e8d2a2f),
W64LIT(0x1791b81b8f68430d),
W64LIT(0xb56a63d1902195c0),
W64LIT(0xa980832b30d2ee67),
W64LIT(0x4c0a7fb384862397),
W64LIT(0xed58bc0d1dc7a05b),
W64LIT(0x5955d7f05c4d0637),
W64LIT(0xd2b9b1c8806fcf4e),
W64LIT(0x06a730e8f910aa02),
W64LIT(0xb8b60bd846aa0768),
W64LIT(0x45bf370afcbe7d90),
W64LIT(0x16f6b0375ec370a1),
W64LIT(0x892276608b81afd4),
W64LIT(0xdcccc1b5d0ec08e7),
W64LIT(0xe856949162df5f58),
W64LIT(0x82592e81a41a977e),
W64LIT(0xac8eabb74fca1164),
W64LIT(0xfac9041692afe356),
W64LIT(0x3b882d75331ba3ba),
W64LIT(0xa39cd3e6cee2e561),
W64LIT(0xd077a190d7cca9e3),
W64LIT(0x9c7dde23534a8a74),
W64LIT(0x80973ed9f3b9f1d3),
W64LIT(0xce535132209cb4e9),
W64LIT(0xaa299b5fb6dabb66),
W64LIT(0x2d7e9d426dd8d31b),
W64LIT(0x8a8b6e140d89fad5),
W64LIT(0x6ca88af83fd56224),
W64LIT(0xf5db7c4713871753),
W64LIT(0xeef1a4799bcff55a),
W64LIT(0x76e55aea6636b381),
W64LIT(0x8ee24ea4a33a367a),
W64LIT(0x25acddd7c44bbeb0),
W64LIT(0x9adaeecbaa5a2076),
W64LIT(0x0e75707d5083c7a9),
W64LIT(0x2bd9adaa94c87919),
W64LIT(0x19e4c866dfeb84a4),
W64LIT(0x129f9087f070bc0e),
W64LIT(0xd9c2e929aff4f7e4),
W64LIT(0x6f01928cb9dd3725),
W64LIT(0x39463d2d64b8c517),
W64LIT(0xebff8ce5e4d70a59),
W64LIT(0xb40d6bfd418aa66c),
W64LIT(0xf21b44833b3c8efd),
W64LIT(0x3654457ce5903112),
W64LIT(0x431807e205aed792),
W64LIT(0xb10343613e92596f),
W64LIT(0x0a1c50cdfe300b06),
W64LIT(0x778252c6b79d802d),
W64LIT(0x0cbb60250720a104),
W64LIT(0xe1e3dc281ae7015f),
W64LIT(0x0f1278518128f405),
W64LIT(0x47712752ab1d1b3d),
W64LIT(0xe24ac45c9cef545e),
W64LIT(0x1ceae0faa0f37ba7),
W64LIT(0x9814fe93fdf946db),
W64LIT(0xec3fb421cc6c93f7),
W64LIT(0x833e26ad75b1a4d2),
W64LIT(0x6b68b23c176efb8a),
W64LIT(0x4904572ffb9edc94),
W64LIT(0x4bca4777ac3dba39),
W64LIT(0x2762cd8f93e8d81d),
W64LIT(0x9eb3ce7b04e9ecd9),
W64LIT(0xc2e8311727bc15ed),
W64LIT(0xea9884c9357c39f5),
W64LIT(0xfc6e34fe6bbf4954),
W64LIT(0x13f898ab21db8fa2),
W64LIT(0xb7a47389c782f36d),
W64LIT(0x7b3932e3b0bd2129),
W64LIT(0xaf27b3c3c9c24465),
W64LIT(0xb6c37ba51629c0c1),
W64LIT(0x84fe1e695d0a3d7c),
W64LIT(0x1a4dd01259e3d1a5),
W64LIT(0xab4e9373677188ca),
W64LIT(0x90c6be06546a2b70),
W64LIT(0xf37c4cafea97bd51),
W64LIT(0x647aca6d96460f8f),
W64LIT(0x4ec46febd325453a),
W64LIT(0x3e8605e94c035cb9),
W64LIT(0x0ddc6809d68b92a8),
W64LIT(0x8bec6638dc22c979),
W64LIT(0x67d3d219104e5a8e),
W64LIT(0x2abea58645634ab5),
W64LIT(0x5b9bc7a80bee609a),
W64LIT(0x936fa672d2627e71),
W64LIT(0x7d9e020b49ad8b2b),
W64LIT(0x5832dfdc8de6359b),
W64LIT(0xc7e6198b58a4eaee),
W64LIT(0xd41e8120797f654c),
W64LIT(0xf4bc746bc22c24ff),
W64LIT(0xe084d404cb4c32f3),
W64LIT(0x48635f032a35ef38),
W64LIT(0x8757061ddb02687d),
W64LIT(0x522e8f1173d63e9d),
W64LIT(0xbcdf2b68e819cbc7),
W64LIT(0xbf76331c6e119ec6),
W64LIT(0x08d24095a9936dab),
W64LIT(0x728c7a5ac8857f2e),
W64LIT(0xd110a9bc06679a4f),
W64LIT(0x1f43f88e26fb2ea6),
W64LIT(0xb2aa5b15b89a0c6e),
W64LIT(0x4aad4f5b7d968995),
W64LIT(0x9fd4c657d542df75),
W64LIT(0x323d65cc4b23fdbd),
W64LIT(0xc38f393bf6172641),
W64LIT(0xa152c3be994183cc),
W64LIT(0x9d1ad60f82e1b9d8),
W64LIT(0xe744ecc0e3f7ab5d),
W64LIT(0x38213501b513f6bb),
W64LIT(0xade9a39b9e6122c8),
W64LIT(0x37334d50343b02be),
W64LIT(0x55eeb7d55b6da733),
W64LIT(0x970686c27cd1b2de),
W64LIT(0x427f0fced405e43e),
W64LIT(0xc026214f701f7340),
W64LIT(0x40b11f9683a68293),
W64LIT(0x02ce105857a366ad),
W64LIT(0x7e371a7fcfa5de2a),
W64LIT(0xffc72c8aedb71c55),
W64LIT(0x68c1aa489166ae8b),
W64LIT(0xc68111a7890fd942),
W64LIT(0x79f722bbe71e4784),
W64LIT(0xd579890ca8d456e0),
W64LIT(0x70426a029f261983),
W64LIT(0xb0644b4def396ac3),
W64LIT(0xdb0cf971f8579149),
W64LIT(0x5489bff98ac6949f),
W64LIT(0x046920b0aeb3ccaf),
W64LIT(0x7cf90a279806b887),
W64LIT(0x050e289c7f18ff03),
W64LIT(0x651dc24147ed3c23),
W64LIT(0x5e95ef3474f69f99),
W64LIT(0x6dcf82d4ee7e5188),
W64LIT(0x8f854688729105d6),
W64LIT(0x81f036f52212c27f),
W64LIT(0xb9d103f4970134c4),
W64LIT(0x5349873da27d0d31),
W64LIT(0x20a2f54bbb5341b3),
W64LIT(0xf0d554db6c9fe850),
W64LIT(0x07c038c428bb99ae),
W64LIT(0x30f375941c809b10),
W64LIT(0x3fe10dc59da86f15),
W64LIT(0x46162f7e7ab62891),
W64LIT(0xe623e4ec325c98f1),
W64LIT(0xfea024a63c1c2ff9),
W64LIT(0x349a5524b23357bf),
W64LIT(0x35fd5d0863986413),
W64LIT(0x96618eeead7a8172),
W64LIT(0xcb5d79ae5f844bea),
W64LIT(0x21c5fd676af8721f),
W64LIT(0x5720a78d0ccec19e),
W64LIT(0xf6726433958f4252),
W64LIT(0x8d4b56d02532637b),
W64LIT(0x24cbd5fb15e08d1c),
W64LIT(0x3aef2559e2b09016),
W64LIT(0x5afccf84da455336),
W64LIT(0x51879765f5de6b9c),
W64LIT(0x2917bdf2c36b1fb4),
W64LIT(0xa7f5f356605129ce),
W64LIT(0xc1412963a1b440ec),
W64LIT(0x3d2f1d9dca0b09b8),
W64LIT(0xa53be30e37f24f63),
W64LIT(0x5ff2e718a55dac35),
W64LIT(0xa2fbdbca1f49d6cd),
W64LIT(0xf7156c1f442471fe),
W64LIT(0x7a5e3acf61161285),
W64LIT(0xca3a71828e2f7846),
W64LIT(0x1b2ad83e8848e209),
W64LIT(0xa8e78b07e179ddcb),
W64LIT(0xef96ac554a64c6f6),
W64LIT(0x0000000000000000),
W64LIT(0x6013eadd38f5c320),
W64LIT(0x3c4815b11ba03a14),
W64LIT(0x09b548b978385e07),
W64LIT(0x226ce513ecf0271e),
W64LIT(0x63baf2a9befd9621),
W64LIT(0x44d83f262d154e3c),
W64LIT(0xcdfa4946a694e1e8),
W64LIT(0x113688f37678e90f),
W64LIT(0x859916458ca10ed0),
W64LIT(0xc52809d30f078c43),
W64LIT(0x4d6d779f552d103b),
W64LIT(0x1e24f0a2f7501d0a),
W64LIT(0x0167082cd1ab33ac),
W64LIT(0x1438a06f0960160c),
W64LIT(0xf9601c6214a7b657),
W64LIT(0xa035cb9248eab060),
W64LIT(0x50e09f4924755830),
W64LIT(0xd7b79954ff77304d),
W64LIT(0xe58afc98b454cdf0),
W64LIT(0x03a9187486085501),
W64LIT(0x62ddfa856f56a58d),
W64LIT(0xc44f01ffdeacbfef),
W64LIT(0x73eb7276192e4c82),
W64LIT(0xd6d091782edc03e1),
W64LIT(0xfbae0c3a4304d0fa),
W64LIT(0x9973f6bf2c527577),
W64LIT(0x105180dfa7d3daa3),
W64LIT(0x2605c5a34243ebb1),
W64LIT(0x91a1b62a85c118dc),
W64LIT(0xc99369f608272d47),
W64LIT(0x5d3cf740f2feca98),
W64LIT(0xcf34591ef1378745),
W64LIT(0xc8f461dad98c1eeb),
W64LIT(0x0b7b58e12f9b38aa),
W64LIT(0xe32dcc704d4467f2),
W64LIT(0x754c429ee03ee680),
W64LIT(0xd3deb9e451c4fce2),
W64LIT(0x6e669aa068760489),
W64LIT(0x66b4da35c1e56922),
W64LIT(0x4fa367c7028e7696),
W64LIT(0xba781b80110961c5),
W64LIT(0x41d617ba520db13f),
W64LIT(0x335a6de09a88ce11),
W64LIT(0xdf65d9c156e45de6),
W64LIT(0xcc9d416a773fd244),
W64LIT(0x5c5bff6c2355f934),
W64LIT(0x2870b5de12c02c18),
W64LIT(0x155fa843d8cb25a0),
W64LIT(0x78902a9736b57428),
W64LIT(0xae40bbef186977c9),
W64LIT(0x88457e4c5a2a9c78),
W64LIT(0x6a0fba10c6c5c826),
W64LIT(0x7f5012531e0eed86),
W64LIT(0x8c2c5efcf49950d7),
W64LIT(0x31947db8cd2ba8bc),
W64LIT(0x2c19956ebc73e0b7),
W64LIT(0x230bed3f3d5b14b2),
W64LIT(0x69a6a26440cd9d27),
W64LIT(0x86300e310aa95bd1),
W64LIT(0xb3cd533969313fc2),
W64LIT(0x1883c04a0e40b708),
W64LIT(0xf1b25cf7bd34dbfc),
W64LIT(0x2fb08d1a3a7bb5b6),
W64LIT(0xd8a5e1057e5fc448),
W64LIT(0xddabc99901473b4b),
W64LIT(0xde02d1ed874f6e4a),
W64LIT(0xbdb8234439b2f86b),
W64LIT(0x5647afa1dd65f232),
W64LIT(0x2ed78536ebd0861a),
W64LIT(0xe9319cbdb3746cf4),
W64LIT(0xa692fb7ab1fa1a62),
W64LIT(0x742b4ab23195d52c),
W64LIT(0x95c8969a2b72d473),
W64LIT(0x6174e2f1e95ef08c),
W64LIT(0xf807144ec50c85fb),
W64LIT(0xbe113b30bfbaad6a),
W64LIT(0xda6bf15d29fca2e5),
W64LIT(0xbb1f13acc0a25269),
/* box 7 */
W64LIT(0xc22b27f0f9e37bf9),
W64LIT(0x93fad23f0955ef09),
W64LIT(0x32ed4b84a22a91a2),
W64LIT(0x3898b57bcc61b1cc),
W64LIT(0x55825ba9ad98e5ad),
W64LIT(0xb2eeb8069421ec94),
W64LIT(0xc7eb5875ce3c6bce),
W64LIT(0x4b1dac5d1f45851f),
W64LIT(0xc16ba1204705d847),
W64LIT(0xc5380f461a2ba91a),
W64LIT(0xb908971a909bad90),
W64LIT(0x303e1cb7763d5376),
W64LIT(0xe6ff324c53486853),
W64LIT(0x6d1aeed261f95461),
W64LIT(0x0193d1e36af1616a),
W64LIT(0x51d1f5cff0b694f0),
W64LIT(0x29b2c3f52728e127),
W64LIT(0x112a768eeb4950eb),
W64LIT(0x8fb672f86f9f4d6f),
W64LIT(0xf0c66c745bc9ea5b),
W64LIT(0x3f8b9dcd2fa9632f),
W64LIT(0x65bc471edba5b6db),
W64LIT(0x4d9d5508967c3696),
W64LIT(0x3a4be24818767318),
W64LIT(0x2794936c144db014),
W64LIT(0x2af2452599ce4299),
W64LIT(0x4a8e7dbe75b4e475),
W64LIT(0x9ddc82a63a30be3a),
W64LIT(0xade29e114c0ded4c),
W64LIT(0xd1d2064dc6bde9c6),
W64LIT(0x7da349bfe04165e0),
W64LIT(0x6b9a1787e8c0e7e8),
W64LIT(0xa54437ddf6510ff6),
W64LIT(0x2254ece92392a023),
W64LIT(0x79f0e7d9bd6f14bd),
W64LIT(0x57510c9a798f2779),
W64LIT(0x346db2d12b13222b),
W64LIT(0x54118a4ac76984c7),
W64LIT(0xefca4a6383e5eb83),
W64LIT(0xca8d8e3c43bf9943),
W64LIT(0xfc336bdebcbb79bc),
W64LIT(0x3e184c2e45580245),
W64LIT(0xf495c21206e79b06),
W64LIT(0xff73ed0e025dda02),
W64LIT(0x4228d472cfe806cf),
W64LIT(0xbcc8e89fa744bda7),
W64LIT(0xab626744c5345ec5),
W64LIT(0xb6bd1660c90f9dc9),
W64LIT(0xb72ec783a3fefca3),
W64LIT(0x8be5dc9e32b13c32),
W64LIT(0x485d2a8da1a326a1),
W64LIT(0xc6788996a4cd0aa4),
W64LIT(0x40fb83411bffc41b),
W64LIT(0x08a6a9ccba5ce2ba),
W64LIT(0xf386eaa4e52f49e5),
W64LIT(0x1acc5992eff311ef),
W64LIT(0xa2571f6b1599dd15),
W64LIT(0x44a82d2746d1b546),
W64LIT(0x70c59ff66dc2976d),
W64LIT(0x8d6525cbbb888fbb),
W64LIT(0x963aadba3e8aff3e),
W64LIT(0x7c30985c8ab0048a),
W64LIT(0x607c389bec7aa6ec),
W64LIT(0xa822e1947bd2fd7b),
W64LIT(0x034086d0bee6a3be),
W64LIT(0x66fcc1ce65431565),
W64LIT(0xb37d69e5fed08dfe),
W64LIT(0x2f323aa0ae1152ae),
W64LIT(0x56c2dd79137e4613),
W64LIT(0x31adcd541ccc321c),
W64LIT(0xdff456d4f5d8b8f5),
W64LIT(0xf9f3145b8b64698b),
W64LIT(0x764566a3e4fb24e4),
W64LIT(0x0cf507aae77293e7),
W64LIT(0x59775c034aea764a),
W64LIT(0xb89b46f9fa6accfa),
W64LIT(0xe8d962d5602d3960),
W64LIT(0x17aa8fdb6270e362),
W64LIT(0x1c4ca0c766caa266),
W64LIT(0x2de16d937a06907a),
W64LIT(0x2547c45fc05a72c0),
W64LIT(0x0fb5817a59943059),
W64LIT(0x0680f9558939b389),
W64LIT(0x16395e3808818208),
W64LIT(0xac714ff226fc8c26),
W64LIT(0xa9b1307711239c11),
W64LIT(0xec8accb33d03483d),
W64LIT(0x6c893f310b08350b),
W64LIT(0xc4abdea570dac870),
W64LIT(0xba4811ca2e7d0e2e),
W64LIT(0xf155bd9731388b31),
W64LIT(0xdd2701e721cf7a21),
W64LIT(0xe94ab3360adc580a),
W64LIT(0x23c73d0a4963c149),
W64LIT(0x5cb723867d35667d),
W64LIT(0x5042242c9a47f59a),
W64LIT(0x198cdf425115b251),
W64LIT(0x0a75feff6e4b206e),
W64LIT(0xfda0ba3dd64a18d6),
W64LIT(0xcede205a1e91e81e),
W64LIT(0xd041d7aeac4c88ac),
W64LIT(0xe42c657f875faa87),
W64LIT(0x36bee5e2ff04e0ff),
W64LIT(0x6fc9b9e1b5ee96b5),
W64LIT(0x998f2cc0671ecf67),
W64LIT(0xd301517e12aa2b12),
W64LIT(0xaea218c1f2eb4ef2),
W64LIT(0xda342951c207a8c2),
W64LIT(0x61efe978868bc786),
W64LIT(0x7f701e8c3456a734),
W64LIT(0x0be62f1c04ba4104),
W64LIT(0x9129850cdd422ddd),
W64LIT(0xd6c12efb25753b25),
W64LIT(0xe33f4dc964977864),
W64LIT(0x1579d8e8b66721b6),
W64LIT(0xf860c5b8e19508e1),
W64LIT(0x7496319030ece630),
W64LIT(0x88a55a4e8c579f8c),
W64LIT(0xcf4df1b974608974),
W64LIT(0x10b9a76d81b83181),
W64LIT(0x0e26509933655133),
W64LIT(0x43bb0591a51967a5),
W64LIT(0x926903dc63a48e63),
W64LIT(0x9c4f534550c1df50),
W64LIT(0x3bd833ab72871272),
W64LIT(0xa4d7e63e9ca06e9c),
W64LIT(0xb46e41531d185f1d),
W64LIT(0x126af05e55aff355),
W64LIT(0x24d415bcaaab13aa),
W64LIT(0x1e9ff7f4b2dd60b2),
W64LIT(0x05c07f8537df1037),
W64LIT(0x467b7a1492c67792),
W64LIT(0x2087bbdaf78562f7),
W64LIT(0x819022615cfa1c5c),
W64LIT(0xcd9ea68aa0774ba0),
W64LIT(0xa79760ee2246cd22),
W64LIT(0x8343755288edde88),
W64LIT(0x58e48de0201b1720),
W64LIT(0x7216c8c5b9d555b9),
W64LIT(0x372d340195f58195),
W64LIT(0xa11799bbab7f7eab),
W64LIT(0x9f0fd595ee277cee),
W64LIT(0x676f102d0fb2740f),
W64LIT(0x9e9c047684d61d84),
W64LIT(0x49cefb6ecb5247cb),
W64LIT(0xd41279c8f162f9f1),
W64LIT(0x1f0c2617d82c01d8),
W64LIT(0x97a97c59547b9e54),
W64LIT(0xe76ce3af39b90939),
W64LIT(0xc3b8f61393121a93),
W64LIT(0x5ba40b309efdb49e),
W64LIT(0xea0a35e6b43afbb4),
W64LIT(0x5a37dad3f40cd5f4),
W64LIT(0x14ea090bdc9640dc),
W64LIT(0x5e6474b5a922a4a9),
W64LIT(0xfee03ced68acbb68),
W64LIT(0x071328b6e3c8d2e3),
W64LIT(0x5302a2fc24a15624),
W64LIT(0x85c38c0701d46d01),
W64LIT(0x3d58cafefbbea1fb),
W64LIT(0x84505de46b250c6b),
W64LIT(0x642f96fdb154d7b1),
W64LIT(0xbf886e4f19a21e19),
W64LIT(0x02d35733d417c2d4),
W64LIT(0x68da915756264456),
W64LIT(0x8710db34d5c3afd5),
W64LIT(0x0d66d6498d83f28d),
W64LIT(0x7b23b0ea6978d669),
W64LIT(0x1b5f887185027085),
W64LIT(0x3ccb1b1d914fc091),
W64LIT(0x0453ae665d2e715d),
W64LIT(0xcb1e5fdf294ef829),
W64LIT(0xf6469521d2f059d2),
W64LIT(0xb03def3540362e40),
W64LIT(0x633cbe4b529c0552),
W64LIT(0xf7d544c2b80138b8),
W64LIT(0x7ab061090389b703),
W64LIT(0x0000000000000000),
W64LIT(0xdba7f8b2a8f6c9a8),
W64LIT(0x35fe633241e24341),
W64LIT(0x21146a399d74039d),
W64LIT(0xd581a82b9b93989b),
W64LIT(0x0935782fd0ad83d0),
W64LIT(0x5ff7a556c3d3c5c3),
W64LIT(0xaf31c922981a2f98),
W64LIT(0x90ba54efb7b34cb7),
W64LIT(0x5291731f4e50374e),
W64LIT(0xc0f870c32df4b92d),
W64LIT(0x7ee3cf6f5ea7c65e),
W64LIT(0xe07fcb19da71dbda),
W64LIT(0x4eddd3d8289a9528),
W64LIT(0x13f921bd3f5e923f),
W64LIT(0xf50613f16c16fa6c),
W64LIT(0x981cfd230defae0d),
W64LIT(0x4c0e84ebfc8d57fc),
W64LIT(0x82d0a4b1e21cbfe2),
W64LIT(0x89368bade6a6fee6),
W64LIT(0xd292809d785b4a78),
W64LIT(0x47e8abf7f83716f8),
W64LIT(0x8e25a31b056e2c05),
W64LIT(0xd752ff184f845a4f),
W64LIT(0xcc0d7769ca862aca),
W64LIT(0x694940b43cd7253c),
W64LIT(0x2ea1eb43c4e033c4),
W64LIT(0xde6787379f29d99f),
W64LIT(0x181f0ea13be4d33b),
W64LIT(0x416852a2710ea571),
W64LIT(0x62af6fa8386d6438),
W64LIT(0xa0844858c18e1fc1),
W64LIT(0x337e9a67c8dbf0c8),
W64LIT(0x2c72bc7010f7f110),
W64LIT(0xbd5b397ccdb5dccd),
W64LIT(0xd8e77e6216106a16),
W64LIT(0x86830ad7bf32cebf),
W64LIT(0x4f4e023b426bf442),
W64LIT(0xe5bfb49cedaecbed),
W64LIT(0x8a760d7d58405d58),
W64LIT(0xe2ac9c2a0e66190e),
W64LIT(0xb5fd90b077e93e77),
W64LIT(0xdcb4d0044b3e1b4b),
W64LIT(0x453bfcc42c20d42c),
W64LIT(0xed191d5057f22957),
W64LIT(0xe1ec1afab080bab0),
W64LIT(0xee599b80e9148ae9),
W64LIT(0x2607428f7ebcd17e),
W64LIT(0x5d24f26517c40717),
W64LIT(0x6a09c66482318682),
W64LIT(0xa604b10d48b7ac48),
W64LIT(0xbe1bbfac73537f73),
W64LIT(0x282112164dd9804d),
W64LIT(0x7505e0735a1d875a),
W64LIT(0x73851926d32434d3),
W64LIT(0xd974af817ce10b7c),
W64LIT(0xeb99e405decb9ade),
W64LIT(0x9b5c7bf3b3090db3),
W64LIT(0xfab3928b3582ca35),
W64LIT(0x8003f382360b7d36),
W64LIT(0x94e9fa89ea9d3dea),
W64LIT(0xb1ae3ed62ac74f2a),
W64LIT(0x9acfaa10d9f86cd9),
W64LIT(0x390b6498a690d0a6),
W64LIT(0xf2153b478fde288f),
W64LIT(0x71564e150733f607),
W64LIT(0xa3c4ce887f68bc7f),
W64LIT(0xaaf1b6a7afc53faf),
W64LIT(0x1ddf71240c3bc30c),
W64LIT(0x77d6b7408e0a458e),
W64LIT(0x2b6194c6f33f23f3),
W64LIT(0xc9cd08ecfd593afd),
W64LIT(0xc85ed90f97a85b97),
W64LIT(0x8cf6f428d179eed1),
W64LIT(0x957a2b6a806c5c80),
W64LIT(0xbbdbc029448c6f44),
W64LIT(0x7863363ad79e75d7),
W64LIT(0x6e5a6802df1ff7df),
W64LIT(0xfb2043685f73ab5f),
};

NAMESPACE_END
