/**
 * =========================================
 * LibFormula : a free Java formula library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libformula/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * FormulaParsePosition.java
 * ------------
 */

package org.pentaho.reporting.libraries.formula.demo;

import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContext;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.parser.ParseException;

/**
 * Todo: Document me!
 *
 * @author : Thomas Morgner
 */
public class FormulaParsePosition
{
  public static void main(String[] args) throws EvaluationException, ParseException
  {
    final Formula f = new Formula("IF(NOT(TRUE()));\"Testing\"; \"Other\"");

    // connects the parsed formula to the context. The context provides the
    // operator and function implementations and resolves the references.
    f.initialize(new DefaultFormulaContext());

    final LValue rootReference = f.getRootReference();
    print(rootReference, 0);
  }

  public static void print (LValue lValue, int level)
  {
    System.out.println (level + " " + lValue.getClass() + " " + lValue.getParsePosition());
    final LValue[] lValues = lValue.getChildValues();
    for (int i = 0; i < lValues.length; i++)
    {
      LValue value = lValues[i];
      print (value, level +1);
    }
  }
}
