/* rnd.c -- "Random" number generator for test programs
 * Created: Wed Sep 25 10:04:32 1996 by faith@dict.org
 * Revised: Sat Mar 30 12:07:57 2002 by faith@dict.org
 * Copyright 1996, 2002 Rickard E. Faith (faith@dict.org)
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * $Id: rnd.c,v 1.3 2002/08/02 19:43:15 faith Exp $
 * 
 */

#include "maaP.h"
#include <math.h>

#define MAXRND 5000

				/* Random numbers are hard coded, since
                                   there is great variability in terms of
                                   what random(3) actually returns. */
static double rnd[MAXRND] = {
0.125341, 0.544604, 0.414346, 0.583974, 0.174296, 0.961711, 0.690130,
0.292579, 0.562515, 0.109384, 0.823356, 0.714925, 0.841857, 0.481093,
0.448740, 0.533222, 0.116015, 0.745627, 0.391775, 0.068052, 0.350539,
0.739208, 0.712224, 0.128878, 0.695183, 0.796589, 0.460657, 0.170030,
0.598239, 0.450458, 0.697441, 0.723580, 0.995062, 0.111787, 0.307554,
0.169358, 0.073498, 0.997683, 0.461937, 0.636013, 0.107068, 0.285293,
0.350938, 0.948924, 0.766386, 0.799678, 0.482146, 0.882401, 0.545306,
0.873921, 0.950452, 0.895845, 0.613129, 0.662676, 0.024722, 0.308312,
0.459265, 0.485379, 0.478342, 0.057504, 0.935837, 0.175782, 0.781084,
0.930899, 0.287569, 0.088638, 0.100257, 0.361067, 0.086321, 0.562194,
0.997080, 0.193389, 0.847487, 0.348018, 0.142314, 0.613873, 0.147696,
0.624459, 0.496274, 0.693002, 0.498380, 0.446726, 0.588847, 0.111509,
0.109403, 0.613569, 0.419821, 0.568668, 0.098948, 0.898162, 0.626172,
0.034785, 0.073945, 0.407257, 0.965684, 0.361514, 0.495895, 0.065940,
0.722581, 0.582216, 0.628134, 0.719660, 0.775606, 0.475621, 0.067678,
0.917919, 0.089494, 0.215375, 0.542379, 0.585768, 0.908377, 0.040759,
0.032494, 0.497224, 0.152267, 0.141897, 0.110793, 0.572088, 0.710564,
0.209741, 0.470251, 0.336737, 0.244526, 0.544195, 0.743994, 0.210210,
0.905709, 0.239889, 0.276150, 0.628290, 0.822105, 0.904284, 0.347950,
0.597711, 0.379905, 0.415628, 0.515630, 0.469399, 0.631003, 0.058008,
0.055166, 0.539380, 0.098767, 0.087660, 0.036604, 0.251035, 0.229557,
0.147397, 0.823123, 0.940121, 0.357138, 0.293373, 0.276858, 0.601664,
0.837569, 0.020852, 0.811873, 0.743278, 0.260741, 0.088024, 0.371568,
0.082846, 0.992308, 0.719518, 0.680556, 0.372213, 0.135147, 0.196186,
0.841612, 0.766150, 0.254195, 0.896778, 0.305530, 0.352962, 0.984438,
0.342134, 0.603997, 0.213995, 0.489531, 0.427119, 0.154117, 0.846668,
0.720493, 0.430975, 0.448332, 0.558062, 0.451827, 0.260206, 0.301340,
0.712567, 0.348229, 0.672908, 0.795413, 0.340537, 0.392427, 0.475970,
0.712750, 0.527573, 0.672156, 0.554361, 0.293723, 0.926351, 0.451140,
0.599253, 0.279313, 0.435578, 0.941387, 0.883309, 0.649573, 0.430918,
0.310429, 0.803690, 0.277586, 0.030922, 0.234665, 0.725918, 0.588984,
0.686492, 0.986124, 0.890324, 0.399059, 0.334353, 0.563232, 0.194472,
0.674890, 0.955659, 0.670442, 0.387640, 0.483232, 0.342598, 0.942001,
0.776955, 0.268949, 0.393141, 0.376209, 0.548261, 0.828719, 0.317596,
0.431571, 0.478292, 0.748514, 0.742000, 0.281982, 0.026100, 0.772922,
0.516647, 0.752018, 0.361905, 0.203138, 0.738142, 0.252229, 0.602197,
0.072494, 0.815461, 0.796669, 0.747384, 0.771120, 0.467111, 0.135024,
0.254352, 0.809709, 0.077025, 0.031307, 0.078658, 0.470166, 0.407516,
0.626919, 0.298884, 0.725112, 0.058490, 0.777176, 0.473626, 0.800490,
0.059158, 0.499725, 0.573411, 0.575805, 0.251743, 0.935317, 0.778943,
0.989885, 0.187546, 0.381140, 0.062380, 0.003007, 0.177810, 0.809764,
0.774127, 0.644921, 0.944788, 0.028479, 0.454630, 0.021813, 0.059786,
0.533287, 0.491978, 0.467302, 0.160206, 0.790862, 0.192414, 0.218696,
0.568039, 0.666039, 0.019186, 0.627197, 0.165765, 0.592598, 0.203001,
0.417508, 0.527914, 0.981944, 0.407393, 0.715460, 0.363084, 0.469773,
0.718467, 0.540894, 0.279537, 0.492594, 0.185815, 0.224324, 0.521073,
0.640444, 0.246137, 0.580859, 0.173731, 0.738115, 0.048161, 0.333938,
0.528978, 0.240575, 0.552634, 0.097016, 0.906614, 0.571820, 0.724213,
0.072379, 0.164418, 0.927214, 0.489887, 0.692332, 0.909158, 0.897280,
0.407792, 0.272242, 0.367053, 0.126260, 0.813136, 0.646590, 0.618854,
0.998951, 0.870914, 0.139927, 0.639395, 0.117051, 0.720786, 0.813126,
0.855166, 0.768946, 0.147064, 0.384144, 0.009521, 0.699698, 0.481161,
0.916135, 0.271518, 0.205374, 0.988514, 0.435936, 0.132588, 0.478401,
0.128268, 0.041746, 0.375681, 0.536060, 0.313988, 0.742733, 0.662320,
0.127124, 0.389323, 0.281173, 0.126074, 0.260237, 0.421100, 0.765469,
0.377288, 0.141885, 0.578596, 0.232455, 0.910832, 0.725659, 0.616599,
0.920353, 0.425357, 0.097760, 0.836488, 0.696876, 0.303133, 0.825002,
0.132811, 0.435721, 0.303403, 0.261079, 0.477466, 0.679083, 0.797139,
0.791454, 0.421817, 0.459459, 0.918578, 0.811140, 0.740632, 0.044653,
0.071377, 0.161732, 0.810122, 0.448665, 0.303618, 0.388718, 0.681120,
0.214450, 0.114377, 0.297719, 0.134803, 0.539735, 0.395478, 0.971291,
0.236610, 0.698611, 0.796293, 0.369421, 0.134332, 0.099696, 0.630500,
0.611798, 0.778779, 0.427640, 0.403253, 0.200596, 0.887099, 0.321831,
0.011736, 0.627731, 0.366484, 0.083113, 0.789464, 0.176606, 0.531778,
0.093081, 0.565323, 0.212898, 0.307531, 0.679701, 0.510617, 0.442334,
0.219435, 0.906095, 0.413625, 0.456045, 0.604706, 0.209919, 0.825466,
0.739038, 0.309614, 0.455967, 0.350836, 0.088394, 0.883607, 0.754089,
0.288990, 0.770706, 0.075920, 0.300725, 0.398437, 0.442404, 0.383838,
0.187901, 0.619010, 0.915616, 0.280982, 0.184334, 0.128514, 0.588513,
0.864034, 0.639130, 0.030847, 0.083469, 0.545225, 0.444473, 0.539514,
0.149931, 0.654391, 0.364981, 0.888969, 0.964006, 0.820948, 0.239806,
0.052399, 0.704554, 0.993895, 0.341389, 0.475260, 0.069815, 0.642114,
0.873697, 0.512219, 0.025952, 0.061597, 0.131229, 0.941568, 0.342579,
0.315563, 0.070082, 0.931093, 0.179597, 0.709212, 0.961940, 0.263066,
0.254437, 0.406413, 0.802581, 0.404368, 0.060804, 0.167561, 0.293338,
0.024810, 0.988509, 0.533143, 0.077209, 0.693063, 0.527038, 0.418598,
0.168323, 0.596853, 0.060712, 0.042020, 0.109073, 0.086664, 0.103617,
0.240302, 0.028233, 0.446197, 0.555865, 0.098315, 0.377289, 0.735462,
0.807527, 0.339229, 0.998528, 0.061964, 0.745642, 0.801109, 0.466333,
0.806446, 0.968670, 0.759670, 0.831256, 0.957179, 0.292814, 0.908465,
0.650242, 0.819852, 0.327063, 0.818565, 0.416705, 0.387775, 0.860585,
0.525778, 0.474440, 0.964203, 0.766080, 0.502672, 0.410399, 0.321945,
0.600987, 0.787689, 0.057407, 0.408514, 0.126918, 0.055936, 0.470478,
0.872560, 0.857044, 0.936811, 0.679006, 0.825714, 0.696482, 0.510262,
0.782893, 0.989295, 0.418728, 0.433136, 0.809147, 0.745791, 0.251701,
0.225853, 0.133566, 0.112287, 0.751631, 0.608006, 0.076489, 0.517711,
0.110679, 0.486889, 0.839656, 0.711666, 0.274578, 0.897063, 0.120180,
0.401496, 0.952999, 0.590658, 0.274056, 0.810043, 0.527469, 0.953062,
0.635758, 0.223951, 0.463325, 0.418651, 0.213246, 0.882052, 0.851787,
0.022393, 0.627843, 0.103488, 0.248246, 0.761409, 0.215774, 0.999877,
0.369416, 0.292264, 0.517587, 0.480094, 0.779153, 0.357243, 0.191760,
0.053730, 0.254307, 0.311939, 0.455226, 0.207305, 0.902597, 0.729282,
0.017348, 0.430066, 0.682344, 0.653106, 0.654017, 0.145668, 0.071757,
0.867263, 0.027721, 0.923544, 0.889656, 0.655564, 0.027032, 0.137902,
0.416973, 0.242806, 0.137778, 0.786389, 0.535070, 0.655366, 0.266483,
0.314223, 0.012609, 0.458243, 0.367953, 0.266916, 0.770182, 0.823179,
0.474221, 0.672779, 0.552460, 0.491569, 0.102845, 0.234804, 0.144675,
0.756862, 0.380473, 0.216432, 0.624124, 0.408194, 0.139976, 0.513780,
0.063757, 0.167008, 0.651682, 0.480731, 0.409814, 0.789461, 0.267120,
0.944884, 0.444827, 0.533603, 0.259106, 0.457436, 0.991845, 0.627059,
0.724351, 0.762027, 0.450238, 0.198572, 0.434806, 0.002698, 0.690141,
0.537651, 0.237503, 0.834817, 0.294513, 0.617976, 0.051249, 0.918637,
0.026169, 0.191226, 0.432417, 0.089927, 0.358234, 0.084100, 0.570657,
0.768047, 0.873560, 0.837777, 0.712931, 0.318387, 0.371379, 0.972038,
0.775823, 0.363225, 0.599097, 0.500174, 0.125252, 0.049335, 0.698746,
0.560058, 0.052033, 0.388887, 0.097709, 0.289536, 0.223704, 0.392221,
0.907512, 0.274954, 0.310858, 0.933681, 0.466179, 0.743275, 0.023608,
0.824413, 0.827375, 0.594265, 0.592460, 0.700935, 0.432042, 0.305392,
0.019322, 0.803421, 0.277429, 0.795145, 0.166646, 0.876526, 0.295319,
0.291897, 0.925861, 0.994065, 0.851955, 0.977895, 0.382952, 0.949663,
0.267431, 0.606657, 0.341884, 0.174943, 0.881610, 0.652742, 0.108624,
0.347790, 0.396018, 0.132231, 0.172202, 0.223393, 0.726496, 0.764663,
0.924328, 0.158538, 0.070054, 0.943650, 0.961959, 0.347483, 0.738795,
0.128604, 0.224010, 0.034114, 0.420502, 0.149871, 0.028179, 0.272457,
0.127766, 0.411132, 0.222120, 0.395197, 0.017788, 0.564005, 0.570139,
0.899399, 0.216747, 0.678763, 0.247188, 0.612765, 0.810995, 0.419391,
0.836157, 0.537491, 0.184053, 0.760485, 0.696029, 0.254107, 0.704135,
0.657987, 0.601591, 0.442931, 0.786592, 0.825600, 0.477045, 0.207093,
0.975471, 0.505224, 0.479550, 0.103237, 0.916356, 0.701670, 0.498434,
0.934144, 0.265675, 0.068573, 0.833543, 0.482421, 0.747336, 0.080731,
0.095186, 0.558331, 0.500122, 0.931343, 0.095822, 0.684175, 0.691828,
0.791850, 0.938282, 0.395964, 0.449837, 0.539873, 0.838894, 0.236429,
0.365474, 0.315939, 0.443523, 0.340945, 0.821163, 0.923073, 0.444182,
0.737519, 0.624743, 0.942616, 0.671663, 0.890417, 0.011189, 0.505206,
0.372839, 0.758526, 0.585937, 0.468025, 0.316856, 0.086058, 0.399368,
0.412678, 0.770234, 0.091196, 0.204528, 0.708516, 0.487160, 0.654366,
0.248389, 0.326054, 0.890795, 0.613863, 0.641993, 0.334317, 0.954808,
0.463156, 0.257390, 0.398990, 0.200675, 0.882132, 0.341606, 0.872337,
0.772549, 0.352795, 0.377543, 0.145388, 0.111321, 0.963479, 0.613413,
0.428177, 0.049538, 0.012781, 0.840856, 0.819771, 0.103977, 0.045384,
0.528287, 0.591137, 0.699749, 0.776677, 0.917191, 0.590544, 0.390539,
0.559184, 0.924861, 0.345347, 0.022340, 0.182251, 0.744338, 0.223014,
0.064384, 0.085944, 0.095352, 0.836933, 0.438739, 0.472894, 0.982321,
0.550060, 0.436374, 0.595734, 0.978237, 0.485912, 0.608514, 0.819093,
0.305683, 0.712491, 0.864477, 0.833971, 0.303628, 0.564226, 0.610647,
0.220819, 0.154770, 0.001187, 0.780003, 0.079632, 0.346534, 0.802343,
0.261883, 0.090872, 0.025357, 0.326267, 0.176815, 0.120709, 0.163200,
0.615554, 0.593603, 0.145521, 0.165614, 0.029977, 0.741255, 0.143852,
0.515888, 0.349769, 0.962945, 0.821571, 0.062261, 0.827421, 0.655542,
0.365889, 0.391647, 0.266189, 0.586708, 0.546417, 0.267376, 0.366711,
0.626049, 0.613910, 0.169054, 0.887932, 0.704782, 0.194411, 0.214199,
0.881597, 0.315120, 0.377398, 0.497151, 0.908723, 0.522919, 0.662765,
0.938700, 0.264174, 0.806617, 0.454588, 0.613943, 0.769562, 0.276160,
0.676204, 0.596983, 0.931702, 0.042092, 0.988631, 0.197891, 0.628800,
0.535048, 0.465267, 0.995512, 0.161097, 0.079177, 0.164566, 0.049029,
0.783958, 0.358977, 0.263227, 0.665555, 0.674097, 0.640626, 0.162706,
0.582820, 0.163545, 0.825472, 0.521520, 0.427719, 0.632089, 0.976108,
0.041662, 0.401651, 0.252268, 0.717865, 0.998634, 0.183970, 0.759958,
0.987265, 0.381861, 0.388758, 0.522313, 0.847128, 0.384270, 0.683410,
0.926305, 0.548835, 0.732439, 0.710263, 0.907812, 0.995666, 0.375818,
0.581909, 0.636292, 0.538525, 0.164729, 0.799837, 0.363996, 0.686248,
0.227555, 0.996085, 0.662356, 0.269217, 0.397736, 0.914624, 0.987083,
0.396371, 0.098594, 0.747041, 0.383635, 0.480455, 0.135799, 0.905948,
0.327583, 0.520069, 0.589358, 0.253888, 0.068904, 0.321796, 0.964151,
0.976716, 0.317462, 0.339969, 0.558625, 0.953754, 0.878494, 0.723354,
0.753591, 0.242490, 0.409602, 0.981146, 0.238576, 0.071959, 0.250363,
0.636312, 0.986583, 0.237446, 0.032682, 0.085177, 0.984486, 0.416318,
0.565633, 0.120285, 0.322266, 0.893216, 0.640354, 0.911623, 0.147104,
0.709258, 0.233420, 0.111255, 0.685975, 0.550882, 0.451224, 0.244600,
0.504636, 0.329718, 0.967954, 0.258227, 0.572208, 0.377557, 0.239373,
0.810783, 0.449515, 0.489736, 0.447095, 0.436099, 0.727182, 0.479778,
0.521276, 0.711668, 0.896095, 0.086909, 0.831953, 0.218361, 0.980125,
0.472307, 0.129984, 0.127228, 0.181566, 0.363404, 0.238483, 0.867541,
0.914286, 0.689707, 0.112141, 0.418922, 0.019424, 0.080095, 0.677149,
0.591632, 0.457652, 0.916522, 0.402415, 0.907167, 0.406257, 0.849510,
0.343266, 0.133439, 0.329288, 0.864542, 0.845107, 0.225383, 0.951450,
0.677060, 0.443744, 0.931575, 0.149367, 0.573728, 0.058803, 0.330933,
0.937132, 0.297286, 0.198474, 0.851418, 0.986993, 0.310615, 0.270341,
0.006417, 0.390710, 0.947489, 0.598049, 0.848362, 0.864011, 0.000464,
0.755529, 0.270268, 0.849975, 0.098795, 0.403707, 0.179263, 0.963337,
0.248814, 0.404646, 0.914787, 0.925874, 0.848390, 0.846363, 0.075241,
0.422118, 0.905166, 0.406174, 0.359250, 0.202452, 0.604648, 0.210669,
0.189444, 0.915263, 0.481009, 0.195861, 0.305974, 0.428499, 0.793910,
0.154336, 0.292509, 0.794374, 0.909866, 0.562778, 0.644349, 0.008661,
0.966485, 0.823611, 0.971998, 0.215299, 0.228257, 0.886785, 0.141173,
0.076647, 0.733148, 0.216414, 0.498765, 0.638314, 0.622588, 0.858015,
0.840765, 0.227237, 0.068684, 0.030210, 0.142500, 0.549693, 0.226071,
0.448474, 0.978191, 0.019981, 0.602810, 0.270701, 0.814355, 0.512676,
0.833479, 0.458704, 0.521337, 0.799963, 0.282315, 0.493334, 0.015262,
0.510572, 0.380120, 0.156435, 0.587219, 0.113268, 0.372849, 0.085984,
0.751581, 0.995437, 0.943999, 0.592346, 0.222673, 0.012682, 0.622556,
0.365173, 0.562375, 0.848627, 0.813647, 0.540566, 0.868608, 0.416457,
0.811267, 0.682963, 0.929133, 0.644746, 0.141667, 0.450470, 0.444709,
0.423982, 0.943804, 0.459972, 0.934554, 0.323924, 0.616407, 0.521773,
0.437191, 0.989255, 0.607757, 0.188772, 0.984692, 0.551755, 0.781119,
0.207365, 0.564438, 0.403675, 0.572539, 0.126813, 0.252302, 0.386186,
0.667379, 0.120910, 0.802643, 0.478647, 0.803873, 0.731776, 0.123393,
0.945540, 0.182246, 0.568102, 0.369523, 0.126050, 0.028074, 0.304077,
0.449973, 0.644480, 0.825851, 0.887165, 0.633736, 0.433607, 0.075937,
0.618428, 0.985363, 0.857056, 0.825793, 0.549801, 0.260731, 0.398332,
0.676614, 0.513033, 0.784518, 0.343993, 0.633943, 0.587161, 0.822640,
0.437816, 0.318937, 0.946032, 0.383356, 0.501183, 0.514134, 0.752879,
0.627232, 0.542208, 0.056956, 0.077206, 0.186689, 0.882807, 0.964370,
0.820424, 0.316414, 0.040307, 0.438852, 0.301777, 0.897363, 0.264645,
0.851578, 0.158094, 0.662977, 0.528191, 0.671126, 0.447495, 0.872184,
0.305069, 0.034656, 0.694824, 0.742885, 0.353593, 0.640856, 0.126242,
0.854776, 0.154990, 0.879121, 0.482008, 0.697199, 0.936077, 0.559214,
0.883887, 0.818884, 0.523584, 0.704312, 0.135298, 0.563891, 0.143163,
0.437075, 0.461254, 0.407809, 0.288653, 0.619347, 0.070786, 0.816845,
0.290474, 0.518281, 0.689029, 0.595543, 0.552937, 0.383853, 0.338428,
0.906530, 0.024709, 0.464670, 0.761305, 0.179699, 0.343791, 0.243313,
0.876898, 0.279868, 0.802527, 0.760785, 0.098752, 0.326110, 0.465097,
0.234050, 0.890001, 0.608260, 0.671126, 0.351255, 0.016069, 0.959779,
0.970602, 0.086854, 0.776623, 0.261076, 0.605135, 0.465652, 0.856619,
0.158072, 0.849505, 0.195047, 0.064601, 0.874213, 0.659717, 0.825906,
0.053913, 0.003508, 0.069219, 0.930810, 0.283376, 0.871746, 0.691595,
0.382127, 0.197857, 0.156692, 0.616177, 0.087858, 0.764952, 0.287303,
0.439113, 0.781021, 0.247082, 0.409715, 0.867875, 0.023705, 0.670791,
0.473010, 0.489358, 0.527410, 0.631082, 0.338862, 0.722458, 0.695683,
0.213076, 0.382175, 0.521589, 0.266988, 0.385683, 0.590809, 0.197799,
0.669058, 0.462555, 0.889394, 0.051185, 0.660412, 0.046086, 0.667363,
0.748269, 0.811038, 0.954666, 0.187382, 0.592059, 0.201748, 0.597097,
0.459935, 0.225453, 0.267888, 0.932945, 0.714811, 0.795298, 0.564027,
0.053674, 0.517756, 0.259710, 0.266750, 0.899930, 0.781300, 0.533738,
0.285613, 0.372108, 0.731537, 0.954671, 0.834663, 0.620931, 0.005857,
0.495075, 0.667017, 0.673220, 0.243344, 0.478056, 0.627886, 0.430726,
0.070115, 0.829634, 0.027823, 0.530049, 0.055087, 0.295710, 0.462995,
0.769898, 0.091009, 0.027022, 0.823572, 0.608764, 0.286732, 0.090321,
0.508695, 0.068031, 0.624059, 0.794308, 0.440140, 0.355596, 0.748979,
0.274803, 0.976527, 0.754836, 0.769878, 0.643544, 0.428055, 0.013222,
0.121600, 0.055941, 0.443948, 0.191715, 0.885574, 0.471771, 0.721764,
0.940661, 0.767481, 0.184759, 0.710559, 0.858490, 0.211780, 0.534131,
0.467254, 0.498512, 0.624453, 0.975948, 0.566543, 0.248512, 0.770256,
0.006683, 0.604109, 0.519235, 0.281486, 0.580636, 0.274071, 0.051363,
0.224180, 0.702126, 0.064585, 0.345780, 0.758066, 0.508533, 0.537494,
0.643640, 0.980304, 0.259258, 0.584302, 0.747785, 0.444017, 0.294861,
0.606274, 0.655797, 0.828992, 0.073528, 0.154309, 0.453445, 0.049477,
0.720852, 0.701958, 0.819733, 0.727535, 0.306066, 0.338968, 0.009020,
0.886702, 0.613039, 0.060383, 0.110881, 0.315164, 0.124969, 0.456661,
0.073231, 0.633502, 0.994155, 0.716871, 0.613806, 0.253413, 0.301173,
0.361590, 0.697430, 0.596034, 0.967865, 0.353227, 0.425026, 0.041393,
0.507536, 0.878472, 0.090870, 0.228388, 0.580429, 0.910603, 0.955923,
0.886495, 0.249571, 0.964943, 0.773197, 0.862609, 0.025326, 0.884078,
0.177774, 0.150295, 0.340740, 0.251004, 0.783797, 0.334895, 0.967875,
0.397603, 0.588308, 0.269048, 0.759193, 0.285738, 0.865082, 0.727058,
0.638966, 0.290108, 0.768451, 0.146502, 0.168580, 0.859321, 0.374890,
0.749009, 0.769923, 0.330813, 0.635504, 0.019494, 0.295756, 0.408701,
0.882103, 0.321082, 0.292780, 0.059877, 0.471377, 0.633519, 0.310881,
0.255174, 0.968414, 0.278756, 0.652777, 0.556722, 0.547804, 0.411970,
0.842460, 0.412886, 0.139028, 0.481426, 0.702994, 0.907479, 0.627928,
0.871574, 0.766799, 0.002819, 0.620583, 0.536723, 0.333632, 0.256087,
0.556216, 0.629388, 0.664788, 0.438320, 0.950471, 0.957568, 0.498196,
0.421848, 0.591087, 0.809077, 0.677022, 0.559500, 0.087833, 0.329799,
0.116222, 0.635638, 0.741768, 0.958683, 0.048524, 0.880796, 0.440109,
0.751519, 0.788275, 0.068037, 0.623093, 0.555074, 0.070856, 0.243676,
0.091797, 0.404488, 0.499763, 0.648013, 0.033876, 0.164551, 0.086333,
0.984347, 0.122118, 0.584529, 0.406195, 0.713205, 0.393606, 0.083217,
0.272705, 0.481440, 0.413015, 0.388927, 0.117077, 0.154784, 0.347610,
0.165601, 0.035580, 0.787718, 0.917120, 0.823855, 0.855756, 0.540213,
0.378929, 0.926612, 0.783888, 0.470725, 0.331100, 0.283651, 0.118739,
0.364976, 0.448202, 0.205071, 0.349322, 0.570320, 0.789601, 0.755517,
0.283525, 0.183207, 0.838734, 0.556230, 0.664646, 0.251749, 0.945157,
0.781723, 0.406532, 0.292767, 0.947325, 0.442112, 0.080485, 0.864445,
0.265967, 0.936241, 0.404658, 0.644895, 0.862852, 0.188546, 0.115621,
0.193952, 0.472197, 0.234360, 0.558928, 0.920399, 0.439431, 0.908250,
0.490719, 0.229032, 0.663767, 0.774244, 0.412238, 0.502501, 0.330474,
0.076884, 0.754249, 0.275631, 0.858608, 0.160782, 0.568397, 0.805933,
0.602894, 0.648883, 0.670378, 0.868861, 0.585123, 0.075036, 0.513756,
0.447976, 0.263582, 0.629377, 0.641927, 0.735779, 0.863737, 0.200855,
0.656178, 0.303168, 0.109105, 0.146898, 0.532200, 0.772872, 0.921142,
0.944438, 0.275373, 0.251615, 0.021322, 0.029622, 0.527246, 0.879930,
0.190404, 0.095643, 0.685863, 0.793299, 0.744526, 0.356241, 0.662160,
0.329649, 0.431276, 0.175916, 0.777625, 0.694858, 0.805293, 0.419552,
0.430638, 0.669030, 0.620407, 0.086816, 0.972198, 0.729513, 0.233714,
0.504398, 0.502385, 0.154855, 0.448836, 0.777758, 0.406470, 0.470158,
0.807380, 0.933716, 0.350088, 0.997784, 0.029360, 0.035951, 0.791083,
0.773886, 0.392192, 0.453243, 0.103535, 0.823468, 0.629159, 0.881160,
0.518327, 0.434452, 0.300712, 0.948964, 0.103482, 0.921119, 0.035781,
0.075680, 0.650632, 0.269494, 0.580078, 0.153017, 0.424350, 0.028914,
0.930775, 0.830820, 0.499072, 0.738155, 0.764536, 0.849160, 0.735939,
0.793896, 0.885111, 0.527022, 0.567782, 0.277303, 0.980265, 0.671316,
0.100771, 0.609423, 0.552476, 0.619098, 0.043875, 0.853188, 0.568062,
0.147357, 0.774307, 0.603843, 0.223038, 0.424939, 0.873337, 0.803116,
0.577956, 0.297687, 0.832030, 0.508731, 0.128507, 0.331102, 0.246885,
0.893044, 0.180262, 0.982825, 0.686940, 0.065374, 0.509847, 0.254721,
0.342677, 0.490112, 0.926038, 0.443448, 0.099535, 0.478513, 0.062546,
0.143410, 0.331701, 0.630608, 0.290767, 0.106008, 0.234451, 0.513805,
0.530948, 0.107789, 0.316921, 0.108903, 0.405476, 0.148951, 0.617634,
0.533983, 0.480053, 0.864519, 0.427026, 0.660316, 0.847344, 0.113966,
0.725689, 0.357191, 0.368687, 0.068366, 0.847302, 0.294725, 0.511814,
0.946837, 0.773238, 0.574359, 0.090247, 0.104940, 0.204968, 0.381014,
0.210948, 0.439419, 0.894819, 0.741896, 0.547208, 0.211740, 0.850799,
0.952683, 0.360691, 0.468433, 0.486666, 0.840744, 0.332952, 0.913692,
0.501060, 0.180296, 0.027658, 0.226749, 0.537487, 0.396346, 0.295115,
0.384789, 0.691070, 0.806928, 0.331626, 0.464309, 0.381287, 0.421873,
0.569248, 0.586255, 0.802887, 0.780196, 0.025674, 0.697706, 0.522092,
0.572882, 0.909446, 0.372891, 0.525566, 0.270137, 0.841324, 0.012232,
0.110881, 0.174276, 0.925924, 0.611941, 0.354573, 0.953582, 0.838690,
0.892059, 0.349928, 0.133805, 0.276848, 0.040998, 0.940733, 0.608474,
0.505307, 0.322020, 0.030346, 0.074556, 0.908275, 0.833233, 0.854752,
0.933950, 0.530939, 0.376844, 0.506832, 0.440385, 0.749735, 0.032398,
0.710522, 0.591059, 0.044629, 0.821403, 0.765336, 0.970554, 0.433345,
0.119908, 0.924136, 0.272035, 0.011968, 0.274064, 0.405840, 0.288815,
0.315063, 0.346572, 0.897289, 0.820370, 0.668593, 0.927635, 0.894925,
0.576868, 0.760868, 0.749677, 0.510818, 0.291807, 0.126521, 0.017650,
0.732192, 0.876256, 0.050048, 0.442714, 0.467315, 0.094677, 0.264117,
0.232651, 0.065231, 0.697462, 0.352560, 0.989367, 0.969497, 0.364527,
0.263431, 0.375337, 0.653342, 0.578493, 0.721909, 0.550631, 0.398863,
0.390502, 0.478267, 0.293788, 0.967370, 0.239135, 0.043465, 0.478188,
0.530942, 0.169986, 0.495838, 0.263134, 0.046243, 0.545885, 0.705848,
0.513558, 0.640563, 0.969965, 0.746209, 0.705793, 0.667428, 0.098769,
0.695160, 0.636925, 0.463296, 0.958590, 0.012262, 0.116638, 0.537083,
0.734171, 0.667270, 0.935946, 0.124673, 0.145536, 0.229734, 0.092043,
0.384671, 0.273200, 0.570231, 0.915613, 0.443186, 0.066068, 0.178747,
0.489429, 0.611954, 0.884595, 0.002987, 0.252516, 0.854560, 0.749196,
0.958310, 0.521987, 0.847965, 0.653469, 0.158912, 0.311261, 0.612059,
0.171174, 0.427899, 0.149143, 0.905345, 0.095169, 0.085089, 0.030018,
0.240705, 0.314824, 0.122060, 0.625377, 0.588023, 0.692291, 0.540990,
0.031209, 0.758360, 0.719736, 0.520638, 0.370313, 0.604331, 0.523624,
0.622830, 0.458891, 0.272820, 0.581140, 0.980878, 0.120785, 0.234609,
0.139790, 0.432046, 0.846668, 0.310964, 0.859945, 0.995811, 0.216309,
0.955114, 0.080900, 0.246326, 0.195819, 0.395724, 0.368387, 0.821196,
0.983747, 0.060678, 0.362186, 0.014956, 0.819037, 0.081922, 0.535594,
0.189351, 0.686253, 0.059218, 0.812181, 0.145144, 0.332039, 0.393320,
0.126022, 0.452824, 0.627929, 0.265812, 0.884870, 0.474597, 0.576776,
0.744815, 0.470408, 0.793085, 0.699929, 0.551308, 0.039411, 0.895748,
0.947032, 0.407798, 0.716944, 0.930778, 0.468475, 0.079130, 0.945734,
0.287513, 0.161052, 0.481328, 0.476863, 0.847305, 0.540546, 0.289044,
0.992449, 0.872585, 0.682364, 0.118471, 0.325408, 0.310293, 0.384283,
0.210278, 0.784889, 0.961059, 0.955093, 0.255297, 0.754144, 0.655021,
0.806605, 0.793556, 0.550769, 0.753637, 0.201353, 0.267713, 0.684415,
0.669829, 0.346843, 0.630150, 0.957341, 0.507894, 0.111478, 0.434204,
0.355199, 0.652024, 0.723248, 0.347647, 0.524609, 0.405612, 0.466118,
0.850017, 0.715904, 0.850401, 0.060295, 0.500794, 0.811461, 0.015388,
0.756091, 0.565605, 0.670409, 0.562696, 0.359161, 0.221178, 0.316333,
0.560514, 0.488891, 0.000748, 0.230343, 0.835734, 0.630898, 0.187684,
0.343628, 0.742376, 0.621888, 0.698827, 0.394400, 0.345137, 0.046474,
0.919008, 0.750748, 0.512592, 0.769025, 0.466653, 0.362994, 0.829321,
0.967447, 0.174454, 0.844709, 0.723538, 0.740059, 0.515118, 0.286234,
0.099220, 0.736296, 0.602567, 0.659734, 0.225187, 0.603316, 0.890076,
0.060921, 0.234214, 0.077761, 0.404549, 0.976590, 0.699649, 0.103376,
0.370989, 0.044785, 0.149850, 0.289997, 0.795534, 0.662443, 0.059023,
0.262187, 0.025436, 0.888343, 0.229633, 0.199891, 0.733052, 0.953171,
0.939950, 0.248170, 0.239405, 0.039170, 0.984466, 0.841972, 0.698903,
0.209653, 0.445288, 0.588980, 0.270575, 0.679502, 0.666740, 0.675124,
0.656091, 0.366389, 0.778500, 0.027081, 0.411175, 0.928350, 0.317078,
0.206709, 0.590793, 0.376101, 0.468895, 0.616229, 0.264444, 0.698528,
0.816119, 0.997496, 0.651699, 0.756069, 0.245666, 0.891104, 0.795239,
0.230132, 0.733076, 0.494142, 0.439786, 0.178364, 0.083122, 0.710360,
0.857866, 0.749863, 0.385484, 0.513957, 0.116252, 0.163984, 0.541038,
0.527427, 0.092334, 0.858116, 0.734136, 0.683126, 0.234217, 0.203031,
0.299355, 0.498661, 0.901559, 0.115474, 0.496157, 0.553258, 0.871544,
0.741823, 0.444362, 0.666783, 0.971956, 0.177438, 0.160925, 0.411741,
0.355802, 0.244047, 0.122101, 0.213668, 0.993910, 0.507585, 0.727626,
0.110162, 0.671569, 0.268664, 0.637589, 0.763903, 0.126780, 0.371725,
0.447029, 0.360996, 0.574755, 0.746384, 0.859657, 0.476314, 0.861858,
0.355814, 0.029572, 0.733402, 0.097637, 0.473934, 0.400185, 0.069593,
0.651372, 0.561110, 0.481334, 0.007175, 0.805157, 0.603435, 0.220843,
0.799067, 0.111021, 0.948469, 0.909229, 0.782590, 0.217133, 0.546818,
0.546493, 0.343913, 0.918543, 0.993522, 0.704909, 0.493299, 0.739905,
0.564566, 0.969613, 0.601764, 0.920380, 0.999185, 0.335166, 0.018017,
0.473119, 0.735351, 0.087610, 0.124492, 0.296460, 0.568944, 0.131666,
0.101617, 0.172380, 0.352509, 0.900685, 0.283401, 0.300978, 0.809914,
0.065991, 0.518111, 0.356732, 0.612483, 0.862024, 0.275276, 0.606005,
0.566933, 0.768574, 0.345910, 0.131499, 0.738187, 0.947674, 0.051879,
0.737372, 0.282840, 0.069896, 0.210491, 0.018191, 0.157507, 0.334983,
0.314651, 0.726451, 0.466649, 0.416269, 0.898831, 0.819159, 0.316953,
0.182232, 0.120137, 0.126867, 0.248222, 0.638248, 0.483600, 0.860706,
0.500272, 0.758875, 0.466711, 0.067205, 0.527449, 0.812621, 0.198704,
0.265636, 0.760296, 0.250583, 0.003008, 0.043136, 0.320479, 0.213500,
0.061327, 0.477986, 0.548483, 0.375978, 0.204437, 0.015132, 0.792247,
0.103268, 0.834291, 0.109200, 0.285500, 0.954428, 0.236067, 0.533722,
0.592677, 0.719667, 0.394428, 0.092949, 0.478543, 0.861139, 0.160154,
0.005992, 0.673760, 0.358858, 0.271628, 0.434056, 0.609441, 0.274637,
0.477192, 0.929920, 0.488137, 0.538519, 0.407906, 0.036620, 0.914497,
0.612343, 0.051752, 0.706743, 0.715611, 0.886043, 0.815944, 0.001111,
0.840471, 0.052011, 0.534833, 0.433147, 0.771678, 0.929261, 0.526096,
0.250221, 0.790400, 0.686250, 0.256213, 0.464161, 0.045108, 0.527841,
0.898216, 0.654549, 0.802478, 0.375408, 0.584469, 0.290615, 0.913927,
0.992375, 0.327234, 0.828423, 0.604718, 0.378986, 0.535167, 0.320329,
0.265029, 0.351110, 0.321440, 0.105500, 0.403121, 0.856274, 0.538647,
0.174800, 0.785535, 0.064743, 0.425020, 0.575935, 0.750994, 0.681233,
0.040096, 0.796102, 0.209074, 0.938312, 0.450650, 0.011552, 0.313720,
0.035119, 0.302167, 0.227647, 0.027494, 0.629402, 0.056071, 0.632213,
0.008388, 0.591237, 0.952542, 0.273417, 0.942348, 0.273983, 0.378916,
0.345469, 0.130256, 0.917563, 0.520269, 0.915791, 0.982307, 0.945289,
0.491726, 0.733300, 0.626522, 0.531822, 0.529402, 0.835597, 0.470134,
0.980052, 0.847149, 0.783855, 0.015172, 0.149316, 0.011502, 0.042666,
0.778718, 0.067573, 0.674879, 0.787106, 0.658810, 0.627421, 0.060522,
0.601158, 0.901404, 0.439439, 0.946627, 0.031660, 0.357002, 0.466896,
0.947451, 0.339309, 0.412185, 0.439178, 0.072609, 0.038707, 0.971000,
0.602011, 0.874304, 0.441134, 0.582063, 0.721453, 0.224989, 0.597235,
0.870769, 0.236491, 0.639901, 0.649487, 0.304063, 0.314780, 0.436593,
0.962873, 0.942202, 0.497115, 0.564031, 0.843605, 0.936554, 0.510658,
0.875266, 0.293556, 0.977554, 0.822717, 0.632864, 0.389739, 0.261895,
0.705474, 0.428446, 0.232894, 0.307485, 0.302750, 0.674029, 0.889548,
0.024203, 0.899017, 0.486783, 0.894972, 0.135508, 0.126685, 0.544459,
0.439571, 0.441465, 0.981052, 0.402445, 0.383666, 0.478168, 0.966476,
0.227272, 0.414722, 0.477134, 0.102537, 0.708277, 0.454688, 0.925254,
0.341142, 0.844427, 0.187149, 0.046615, 0.272873, 0.420043, 0.354100,
0.575623, 0.094072, 0.243648, 0.599826, 0.993089, 0.730431, 0.494798,
0.128598, 0.857116, 0.039258, 0.568169, 0.298580, 0.020310, 0.970614,
0.682247, 0.498478, 0.937089, 0.909519, 0.913199, 0.414224, 0.012056,
0.621477, 0.868912, 0.937310, 0.962618, 0.713339, 0.124459, 0.009234,
0.986212, 0.544503, 0.363334, 0.561835, 0.638575, 0.606982, 0.161661,
0.631664, 0.337413, 0.656459, 0.760261, 0.194528, 0.695717, 0.328430,
0.493109, 0.716027, 0.299044, 0.175356, 0.214505, 0.236133, 0.084874,
0.127705, 0.650357, 0.096931, 0.749181, 0.519269, 0.034241, 0.711800,
0.232607, 0.158700, 0.721034, 0.218819, 0.703203, 0.084367, 0.780655,
0.341777, 0.691349, 0.942316, 0.973441, 0.028762, 0.598775, 0.733702,
0.223290, 0.294492, 0.062133, 0.716399, 0.010520, 0.361177, 0.891754,
0.225025, 0.597310, 0.976629, 0.352730, 0.247667, 0.073559, 0.101911,
0.766936, 0.107800, 0.813711, 0.999543, 0.266500, 0.534744, 0.218363,
0.969703, 0.619112, 0.999017, 0.311480, 0.310461, 0.941333, 0.284921,
0.339222, 0.540109, 0.018624, 0.562513, 0.834601, 0.080756, 0.278911,
0.845121, 0.441933, 0.170666, 0.070146, 0.039243, 0.147295, 0.422875,
0.286910, 0.220854, 0.524786, 0.053846, 0.328654, 0.338497, 0.053389,
0.595155, 0.873241, 0.271752, 0.564858, 0.492352, 0.270769, 0.876338,
0.802813, 0.212102, 0.161259, 0.142036, 0.752211, 0.179882, 0.704548,
0.586812, 0.260639, 0.983460, 0.431933, 0.702572, 0.154125, 0.502078,
0.741815, 0.301420, 0.924953, 0.028725, 0.522274, 0.449739, 0.082571,
0.850929, 0.788236, 0.135960, 0.446083, 0.661477, 0.407712, 0.010941,
0.153829, 0.678481, 0.887279, 0.956642, 0.890583, 0.048538, 0.098678,
0.642794, 0.228420, 0.803226, 0.229606, 0.489059, 0.786685, 0.661539,
0.191631, 0.940811, 0.163617, 0.933446, 0.242231, 0.088571, 0.962171,
0.764505, 0.538310, 0.044742, 0.615433, 0.326546, 0.180702, 0.061517,
0.988022, 0.588413, 0.072458, 0.141851, 0.266894, 0.959737, 0.098494,
0.157478, 0.008274, 0.197171, 0.800272, 0.236694, 0.000397, 0.029879,
0.725753, 0.787083, 0.691418, 0.917384, 0.727894, 0.855035, 0.850830,
0.970124, 0.943606, 0.813001, 0.734629, 0.481916, 0.857742, 0.350063,
0.808462, 0.038444, 0.411580, 0.796484, 0.626857, 0.484037, 0.938336,
0.893751, 0.443774, 0.036829, 0.051229, 0.452048, 0.234000, 0.851501,
0.688742, 0.234398, 0.881380, 0.414496, 0.021480, 0.572798, 0.331880,
0.749374, 0.427833, 0.182710, 0.719498, 0.371438, 0.995710, 0.454128,
0.853354, 0.853452, 0.804191, 0.661816, 0.891896, 0.215770, 0.458300,
0.518753, 0.699808, 0.396635, 0.412505, 0.143582, 0.433465, 0.463734,
0.595630, 0.667465, 0.315235, 0.284372, 0.901863, 0.196615, 0.698868,
0.923343, 0.769413, 0.030748, 0.672717, 0.197246, 0.213457, 0.392216,
0.568684, 0.209168, 0.846343, 0.422038, 0.062620, 0.650534, 0.083854,
0.954516, 0.866304, 0.542154, 0.473269, 0.566112, 0.938789, 0.885774,
0.709694, 0.372254, 0.349508, 0.305323, 0.039719, 0.664743, 0.589695,
0.941582, 0.861358, 0.288563, 0.864925, 0.630771, 0.319311, 0.537642,
0.828017, 0.532768, 0.929857, 0.396701, 0.741936, 0.776201, 0.818739,
0.804556, 0.426735, 0.902593, 0.759072, 0.293039, 0.444747, 0.232341,
0.859151, 0.383536, 0.118115, 0.568845, 0.755790, 0.467623, 0.874168,
0.795509, 0.132366, 0.463863, 0.737091, 0.993724, 0.752426, 0.602015,
0.624496, 0.071737, 0.139657, 0.452512, 0.604505, 0.069515, 0.849213,
0.346441, 0.845716, 0.667952, 0.150997, 0.272451, 0.570546, 0.910069,
0.565490, 0.015293, 0.142410, 0.424641, 0.398829, 0.260526, 0.993486,
0.154620, 0.728149, 0.867654, 0.950129, 0.860515, 0.331517, 0.687219,
0.854239, 0.083943, 0.289235, 0.478735, 0.155680, 0.428892, 0.931247,
0.760185, 0.498407, 0.780461, 0.106625, 0.344122, 0.448413, 0.257622,
0.616573, 0.018959, 0.167690, 0.182063, 0.034252, 0.310101, 0.606704,
0.433081, 0.570626, 0.600190, 0.587700, 0.298775, 0.467844, 0.537829,
0.159290, 0.799362, 0.225049, 0.013529, 0.883305, 0.514283, 0.492263,
0.038985, 0.943175, 0.423511, 0.799169, 0.441582, 0.203971, 0.905794,
0.785704, 0.652384, 0.163416, 0.402276, 0.671343, 0.331106, 0.584339,
0.705594, 0.641207, 0.191043, 0.138675, 0.211833, 0.791233, 0.726376,
0.510608, 0.259077, 0.264205, 0.669897, 0.058439, 0.489253, 0.683426,
0.941744, 0.003537, 0.175689, 0.980728, 0.946712, 0.599200, 0.779898,
0.388294, 0.803171, 0.685692, 0.173997, 0.455555, 0.849108, 0.576274,
0.126898, 0.180215, 0.160613, 0.832492, 0.821422, 0.351656, 0.971168,
0.033255, 0.142889, 0.697543, 0.543863, 0.401966, 0.961748, 0.213760,
0.460405, 0.451002, 0.897186, 0.402148, 0.454538, 0.072875, 0.382877,
0.401250, 0.672075, 0.162774, 0.789544, 0.475246, 0.848467, 0.963541,
0.930801, 0.697575, 0.539815, 0.057699, 0.877790, 0.700428, 0.890192,
0.699212, 0.052083, 0.861359, 0.732467, 0.194972, 0.558902, 0.276329,
0.596938, 0.520651, 0.490089, 0.057343, 0.971652, 0.387275, 0.459491,
0.426190, 0.460150, 0.842368, 0.827441, 0.132226, 0.005142, 0.616984,
0.607472, 0.853609, 0.580525, 0.538273, 0.551184, 0.120340, 0.595973,
0.428973, 0.820768, 0.486165, 0.128185, 0.872851, 0.347524, 0.860652,
0.067823, 0.906426, 0.136981, 0.664761, 0.427077, 0.627070, 0.722104,
0.398729, 0.014346, 0.181595, 0.824919, 0.474496, 0.023963, 0.652360,
0.606722, 0.029105, 0.269344, 0.214194, 0.882713, 0.849869, 0.752467,
0.433897, 0.970210, 0.348440, 0.862870, 0.790977, 0.834605, 0.991055,
0.663829, 0.182128, 0.851707, 0.731652, 0.088555, 0.988688, 0.396413,
0.515631, 0.615758, 0.118517, 0.914360, 0.630104, 0.300112, 0.739279,
0.104600, 0.324075, 0.391639, 0.711322, 0.353179, 0.660983, 0.925516,
0.235892, 0.510853, 0.677983, 0.669789, 0.481062, 0.026423, 0.532659,
0.272040, 0.861027, 0.523715, 0.935868, 0.043156, 0.375422, 0.667520,
0.131710, 0.364110, 0.063933, 0.647341, 0.979868, 0.182451, 0.561701,
0.609972, 0.482563, 0.300981, 0.714572, 0.806637, 0.692620, 0.425894,
0.159817, 0.353603, 0.351410, 0.395709, 0.864456, 0.029393, 0.065498,
0.345518, 0.055815, 0.598158, 0.617558, 0.916843, 0.121872, 0.553426,
0.959998, 0.497294, 0.220946, 0.091708, 0.861404, 0.284879, 0.739050,
0.841273, 0.467330, 0.300751, 0.451245, 0.949893, 0.601732, 0.165818,
0.756530, 0.294352, 0.591712, 0.916347, 0.647955, 0.943122, 0.312056,
0.512410, 0.972514, 0.377554, 0.857928, 0.028330, 0.975712, 0.475486,
0.945172, 0.097584, 0.028912, 0.905171, 0.594879, 0.249858, 0.996879,
0.456283, 0.534737, 0.735928, 0.297556, 0.002067, 0.036680, 0.748801,
0.951960, 0.638411, 0.914619, 0.708490, 0.932763, 0.506331, 0.624837,
0.580718, 0.449453, 0.936893, 0.093128, 0.421967, 0.314447, 0.951056,
0.450297, 0.290159, 0.426542, 0.395469, 0.387744, 0.455454, 0.300640,
0.982623, 0.705311, 0.297519, 0.438906, 0.240048, 0.033447, 0.736462,
0.242115, 0.070127, 0.485263, 0.194075, 0.708538, 0.399881, 0.902565,
0.641301, 0.906212, 0.527402, 0.222019, 0.355665, 0.464296, 0.315147,
0.777632, 0.778743, 0.266203, 0.227929, 0.068902, 0.692745, 0.623398,
0.456646, 0.148199, 0.924038, 0.439269, 0.853510, 0.221557, 0.878175,
0.093558, 0.255004, 0.614636, 0.335674, 0.325131, 0.099899, 0.529749,
0.033669, 0.499780, 0.432314, 0.674970, 0.405993, 0.959717, 0.896989,
0.761657, 0.424012, 0.212136, 0.539289, 0.202755, 0.478340, 0.767218,
0.271658, 0.171085, 0.390616, 0.728304, 0.319284, 0.314654, 0.167573,
0.172795, 0.536211, 0.045748, 0.266353, 0.791214, 0.660384, 0.602027,
0.116345, 0.760283, 0.131775, 0.150014, 0.260064, 0.564089, 0.824984,
0.666056, 0.523806, 0.721974, 0.427713, 0.947818, 0.934110, 0.967003,
0.150573, 0.412450, 0.734220, 0.422231, 0.583535, 0.124836, 0.150535,
0.902819, 0.439490, 0.318108, 0.075614, 0.975701, 0.363855, 0.341967,
0.766915, 0.024239, 0.943993, 0.883260, 0.784523, 0.075769, 0.033274,
0.044586, 0.639858, 0.858259, 0.710642, 0.163664, 0.580232, 0.138356,
0.111482, 0.514342, 0.105358, 0.262055, 0.926792, 0.839579, 0.684286,
0.510327, 0.964415, 0.834821, 0.413146, 0.403905, 0.152928, 0.488760,
0.379606, 0.516784, 0.830726, 0.146521, 0.541023, 0.774720, 0.029781,
0.325546, 0.850488, 0.063056, 0.370132, 0.490346, 0.921314, 0.080774,
0.654010, 0.501547, 0.219130, 0.765492, 0.015889, 0.324488, 0.027547,
0.942681, 0.164067, 0.711834, 0.453007, 0.128481, 0.546654, 0.866153,
0.532386, 0.699583, 0.354913, 0.911992, 0.216367, 0.185640, 0.058513,
0.757390, 0.960359, 0.088294, 0.082935, 0.810847, 0.151350, 0.453067,
0.301194, 0.072664, 0.533841, 0.955204, 0.574211, 0.752971, 0.720696,
0.590099, 0.077459, 0.748244, 0.532780, 0.241525, 0.460077, 0.985787,
0.370007, 0.006731, 0.851940, 0.902393, 0.706314, 0.206853, 0.814386,
0.922681, 0.392493, 0.872898, 0.680071, 0.352852, 0.961193, 0.763006,
0.163700, 0.112542, 0.216073, 0.464893, 0.185206, 0.749915, 0.420097,
0.759417, 0.502886, 0.140793, 0.349516, 0.580345, 0.889037, 0.882296,
0.821870, 0.349114, 0.868083, 0.191877, 0.355845, 0.720023, 0.094270,
0.062160, 0.926876, 0.908656, 0.984840, 0.319369, 0.781554, 0.664911,
0.672221, 0.742747, 0.427917, 0.835921, 0.855289, 0.643991, 0.300814,
0.040495, 0.393905, 0.720911, 0.799912, 0.896791, 0.861705, 0.149428,
0.477136, 0.750741, 0.031724, 0.299006, 0.099855, 0.899807, 0.490882,
0.455700, 0.619830, 0.585153, 0.517860, 0.546706, 0.493809, 0.502700,
0.866075, 0.275363, 0.167612, 0.538297, 0.018110, 0.595529, 0.374218,
0.873399, 0.239520, 0.675032, 0.913894, 0.633425, 0.395943, 0.713806,
0.530216, 0.257648, 0.863234, 0.007352, 0.008389, 0.894958, 0.306358,
0.108245, 0.794765, 0.797240, 0.563945, 0.414594, 0.382393, 0.081805,
0.961301, 0.876201, 0.584505, 0.827376, 0.151564, 0.752117, 0.365673,
0.169674, 0.347646, 0.739890, 0.043073, 0.587166, 0.414922, 0.956967,
0.220591, 0.810866, 0.670773, 0.750808, 0.068514, 0.534007, 0.758159,
0.076903, 0.428965, 0.064517, 0.185148, 0.223730, 0.861757, 0.749093,
0.638325, 0.244150, 0.830898, 0.599625, 0.120351, 0.415403, 0.427001,
0.271915, 0.167520, 0.792674, 0.441589, 0.515167, 0.532564, 0.484662,
0.102332, 0.947487, 0.441628, 0.322924, 0.758353, 0.112401, 0.073731,
0.826866, 0.646408, 0.831891, 0.903770, 0.075373, 0.896408, 0.088918,
0.299104, 0.758165, 0.838011, 0.937428, 0.002315, 0.668909, 0.537053,
0.122666, 0.084312, 0.964054, 0.394581, 0.251833, 0.756728, 0.836170,
0.766999, 0.289292, 0.320831, 0.869332, 0.236779, 0.762460, 0.192256,
0.995132, 0.874861, 0.265987, 0.821998, 0.521269, 0.097878, 0.725768,
0.596642, 0.994285, 0.814686, 0.895746, 0.752450, 0.652697, 0.833174,
0.754765, 0.321606, 0.370227, 0.877430, 0.405918, 0.334281, 0.272011,
0.657751, 0.091009, 0.108181, 0.424750, 0.380302, 0.429013, 0.294082,
0.617081, 0.191472, 0.486338, 0.612212, 0.066333, 0.752325, 0.434210,
0.587601, 0.850202, 0.159978, 0.184244, 0.844487, 0.974664, 0.079989,
0.596938, 0.627361, 0.913163, 0.351702, 0.948966, 0.283390, 0.229133,
0.354884, 0.617671, 0.501144, 0.012635, 0.708680, 0.609325, 0.437385,
0.088982, 0.038337, 0.731468, 0.706062, 0.229810, 0.217805, 0.318274,
0.296142, 0.970130, 0.752485, 0.883744, 0.820332, 0.912463, 0.067987,
0.664820, 0.887127, 0.147976, 0.261757, 0.514487, 0.061139, 0.613459,
0.463453, 0.344529, 0.842592, 0.818338, 0.962200, 0.343736, 0.830973,
0.670880, 0.953061, 0.268358, 0.759862, 0.991398, 0.999826, 0.465925,
0.221208, 0.217631, 0.784199, 0.517350, 0.187761, 0.536684, 0.401094,
0.008093, 0.449146, 0.469081, 0.672913, 0.336273, 0.617057, 0.934670,
0.850760, 0.678196, 0.548130, 0.314213, 0.022726, 0.390722, 0.132551,
0.984926, 0.734457, 0.963524, 0.655806, 0.687518, 0.231882, 0.415668,
0.678917, 0.231707, 0.881593, 0.900125, 0.449338, 0.665792, 0.417475,
0.637100, 0.202476, 0.818568, 0.645193, 0.651622, 0.287649, 0.318106,
0.987895, 0.904706, 0.252776, 0.838655, 0.582902, 0.800905, 0.152868,
0.605628, 0.191627, 0.285419, 0.590554, 0.926084, 0.248943, 0.246360,
0.613603, 0.480824, 0.662028, 0.292519, 0.712532, 0.543621, 0.192644,
0.161870, 0.209414, 0.610118, 0.798970, 0.411889, 0.428686, 0.444163,
0.063512, 0.716335, 0.762269, 0.051407, 0.621041, 0.015045, 0.890061,
0.203944, 0.815950, 0.042930, 0.809571, 0.007577, 0.328349, 0.400125,
0.933661, 0.577292, 0.646485, 0.547264, 0.058116, 0.308513, 0.839783,
0.770648, 0.852134, 0.032427, 0.932518, 0.061548, 0.642545, 0.731488,
0.473437, 0.071232, 0.175651, 0.536949, 0.787567, 0.937920, 0.588355,
0.408608, 0.952965, 0.478417, 0.612552, 0.768915, 0.521346, 0.422123,
0.776492, 0.849695, 0.822248, 0.710154, 0.426987, 0.468732, 0.257418,
0.485103, 0.777245, 0.097201, 0.255751, 0.629379, 0.129628, 0.188270,
0.690927, 0.772173, 0.919758, 0.164364, 0.843404, 0.095410, 0.701313,
0.630971, 0.033330, 0.289668, 0.039579, 0.986295, 0.768084, 0.652131,
0.755210, 0.289431, 0.074254, 0.531702, 0.139126, 0.896502, 0.241856,
0.566113, 0.365234, 0.499273, 0.051216, 0.142480, 0.596474, 0.306967,
0.771859, 0.726102, 0.495237, 0.462786, 0.498274, 0.414995, 0.627150,
0.341679, 0.510404, 0.328463, 0.972650, 0.543734, 0.618131, 0.012229,
0.530029, 0.386215, 0.664360, 0.285238, 0.675645, 0.738614, 0.816940,
0.814771, 0.635116, 0.058796, 0.380884, 0.000351, 0.558069, 0.432100,
0.142830, 0.154543, 0.739067, 0.914690, 0.880644, 0.234303, 0.377476,
0.378919, 0.649298, 0.004626, 0.720598, 0.159702, 0.333089, 0.693247,
0.703436, 0.951220, 0.705477, 0.233464, 0.337435, 0.369837, 0.518703,
0.013080, 0.108452, 0.335643, 0.827851, 0.743568, 0.394438, 0.208735,
0.743919, 0.952507, 0.640835, 0.886749, 0.107050, 0.379901, 0.801439,
0.987694, 0.614205, 0.178915, 0.366613, 0.263502, 0.183541, 0.087211,
0.423204, 0.516630, 0.780458, 0.126640, 0.467849, 0.485935, 0.360105,
0.805284, 0.855772, 0.878807, 0.818364, 0.964224, 0.214450, 0.646215,
0.707791, 0.608888, 0.854950, 0.451710, 0.561395, 0.495785, 0.338459,
0.668445, 0.875686, 0.139898, 0.656139, 0.489891, 0.318813, 0.022753,
0.753393, 0.502353, 0.109963, 0.176598, 0.018983, 0.890421, 0.303238,
0.486832, 0.376356, 0.663342, 0.292116, 0.232128, 0.542150, 0.110480,
0.196352, 0.756599, 0.756695, 0.904143, 0.365488, 0.611645, 0.355854,
0.926883, 0.107430, 0.694313, 0.595328, 0.983117, 0.834211, 0.251467,
0.473008, 0.153024, 0.274220, 0.226401, 0.655377, 0.384183, 0.402999,
0.674360, 0.274605, 0.706237, 0.161192, 0.650961, 0.369579, 0.453308,
0.883089, 0.911729, 0.563788, 0.079441, 0.668328, 0.320483, 0.983585,
0.033816, 0.932129, 0.339438, 0.960698, 0.039559, 0.033751, 0.556026,
0.022676, 0.867962, 0.807494, 0.495684, 0.020986, 0.081713, 0.722085,
0.676363, 0.465896, 0.125084, 0.350723, 0.740501, 0.831320, 0.511915,
0.391462, 0.200899, 0.965224, 0.274551, 0.112628, 0.529012, 0.353993,
0.780956, 0.849495, 0.337577, 0.814772, 0.781624, 0.677016, 0.775470,
0.821183, 0.710767, 0.331496, 0.843859, 0.578729, 0.138990, 0.339543,
0.599715, 0.220703, 0.061628, 0.276079, 0.686600, 0.186712, 0.626802,
0.427101, 0.018032, 0.138717, 0.818563, 0.218931, 0.103940, 0.093114,
0.331559, 0.632952, 0.447107, 0.112515, 0.482448, 0.784684, 0.927287,
0.264072, 0.461700, 0.702757, 0.085255, 0.172467, 0.034253, 0.929114,
0.751196, 0.173243, 0.268657, 0.350912, 0.393946, 0.330285, 0.626990,
0.080546, 0.516996, 0.253792, 0.507647, 0.535028, 0.392508, 0.326210,
0.753959, 0.496449, 0.419324, 0.085519, 0.129401, 0.866431, 0.198034,
0.611848, 0.651115, 0.125320, 0.875920, 0.112814, 0.828077, 0.961175,
0.285281, 0.862330, 0.890289, 0.036478, 0.035573, 0.158945, 0.387389,
0.429519, 0.489230, 0.014379, 0.510065, 0.006226, 0.268171, 0.017712,
0.541254, 0.660680, 0.343922, 0.295214, 0.157128, 0.763246, 0.380732,
0.286529, 0.629677, 0.578766, 0.898378, 0.280791, 0.704086, 0.774298,
0.393606, 0.532164, 0.735473, 0.678887, 0.394494, 0.625761, 0.715365,
0.430067, 0.784707, 0.102754, 0.859586, 0.273937, 0.117133, 0.369652,
0.280163, 0.385305, 0.387364, 0.821417, 0.045984, 0.731286, 0.116631,
0.203113, 0.494532, 0.497363, 0.489642, 0.124209, 0.076129, 0.388020,
0.405000, 0.780216, 0.162318, 0.798606, 0.312379, 0.897791, 0.477493,
0.706873, 0.523552, 0.192858, 0.136940, 0.308259, 0.295612, 0.996526,
0.582195, 0.412745, 0.366178, 0.862358, 0.798050, 0.753542, 0.683776,
0.844034, 0.484828, 0.800406, 0.047146, 0.979361, 0.297770, 0.536789,
0.103570, 0.373899, 0.924808, 0.508570, 0.154114, 0.087126, 0.307176,
0.466493, 0.984917, 0.784670, 0.173366, 0.508469, 0.977528, 0.310306,
0.816728, 0.273139, 0.306832, 0.398923, 0.685884, 0.673010, 0.261281,
0.483934, 0.426552, 0.945057, 0.327968, 0.911380, 0.745463, 0.375114,
0.890740, 0.043233, 0.911902, 0.994310, 0.417132, 0.836711, 0.502880,
0.571246, 0.923837, 0.810057, 0.037739, 0.908754, 0.594726, 0.211106,
0.417223, 0.572254, 0.521412, 0.233951, 0.845393, 0.828244, 0.632874,
0.531277, 0.501254, 0.894155, 0.015211, 0.927805, 0.839212, 0.343179,
0.839185, 0.584676, 0.718293, 0.729925, 0.627909, 0.630195, 0.724235,
0.045041, 0.466906, 0.227116, 0.616287, 0.390743, 0.037172, 0.654026,
0.299498, 0.631898, 0.865132, 0.716721, 0.204152, 0.386543, 0.950672,
0.049545, 0.214787, 0.583546, 0.580822, 0.716041, 0.477701, 0.596034,
0.643846, 0.316914, 0.939212, 0.483031, 0.901590, 0.657505, 0.212956,
0.529499, 0.287700, 0.937191, 0.574539, 0.754606, 0.164307, 0.190826,
0.145349, 0.201479, 0.844852, 0.444847, 0.833377, 0.709983, 0.161568,
0.037529, 0.096526, 0.112240, 0.087075, 0.311314, 0.695785, 0.667897,
0.027354, 0.173487, 0.263931, 0.671200, 0.490400, 0.203143, 0.154230,
0.391990, 0.860648, 0.367186, 0.921488, 0.148347, 0.304377, 0.496028,
0.902953, 0.468684, 0.686853, 0.048303, 0.670163, 0.531705, 0.493150,
0.503540, 0.241688, 0.654718, 0.541069, 0.338214, 0.766957, 0.628144,
0.649528, 0.462743, 0.296041, 0.676882, 0.636229, 0.559972, 0.348082,
0.126630, 0.763114, 0.502312, 0.518620, 0.623762, 0.869499, 0.440108,
0.772109, 0.173876, 0.936136, 0.675063, 0.642560, 0.622989, 0.723365,
0.312722, 0.154694, 0.216515, 0.816262, 0.396382, 0.871233, 0.357332,
0.734596, 0.638190, 0.985476, 0.384124, 0.100933, 0.281517, 0.061006,
0.737162, 0.841489, 0.409088, 0.863792, 0.604603, 0.911401, 0.382412,
0.228365, 0.780899, 0.822520, 0.000474, 0.954775, 0.758655, 0.675537,
0.597335, 0.381645, 0.398902, 0.910057, 0.536338, 0.615417, 0.726320,
0.932720, 0.486650, 0.083651, 0.667316, 0.124839, 0.069127, 0.051441,
0.225772, 0.350644, 0.112447, 0.962934, 0.192133, 0.521535, 0.826726,
0.796736, 0.432936, 0.209137, 0.025101, 0.213835, 0.031657, 0.025575,
0.168610, 0.790313, 0.701112, 0.765945, 0.171957, 0.100014, 0.676002,
0.708296, 0.715431, 0.402322, 0.641016, 0.202080, 0.485973, 0.308332,
0.326920, 0.555101, 0.359773, 0.552692, 0.905745, 0.472220, 0.515626,
0.097878, 0.993755, 0.342351, 0.894614, 0.426691, 0.551489, 0.919714,
0.640526, 0.583146, 0.945289, 0.809136, 0.373458, 0.646401, 0.575081,
0.545416, 0.746415, 0.251083, 0.253711, 0.461845, 0.653405, 0.894727,
0.663926, 0.139379, 0.203059, 0.990845, 0.694479, 0.562832, 0.543537,
0.600224, 0.035051, 0.059162, 0.698102, 0.028806, 0.401514, 0.592716,
0.455497, 0.953003, 0.512430, 0.096022, 0.536149, 0.457719, 0.905158,
0.909607, 0.104120, 0.480239, 0.455023, 0.850534, 0.731323, 0.708734,
0.312380, 0.384728, 0.603461, 0.976305, 0.524107, 0.806520, 0.967151,
0.218586, 0.369351, 0.510688, 0.818811, 0.404402, 0.569850, 0.516913,
0.433208, 0.971364, 0.109629, 0.888705, 0.924367, 0.622059, 0.984727,
0.460515, 0.079778, 0.889886, 0.370123, 0.183898, 0.370125, 0.825145,
0.034432, 0.101448, 0.533879, 0.346812, 0.486176, 0.137340, 0.323118,
0.010283, 0.943859, 0.290268, 0.228869, 0.313210, 0.800956, 0.047679,
0.717613, 0.370806, 0.564592, 0.150821, 0.342170, 0.674221, 0.039526,
0.266537, 0.296280, 0.024253, 0.727052, 0.376058, 0.914139, 0.097175,
0.559956, 0.284264, 0.922320, 0.594388, 0.385711, 0.456199, 0.941200,
0.871887, 0.593539, 0.264318, 0.882170, 0.537398, 0.554586, 0.111038,
0.850608, 0.355542, 0.158718, 0.568221, 0.726348, 0.723310, 0.719042,
0.068518, 0.397531, 0.758568, 0.335054, 0.693811, 0.782821, 0.062107,
0.069868, 0.696959, 0.159281, 0.629824, 0.981223, 0.081601, 0.224212,
0.366934, 0.537800, 0.165412, 0.238822, 0.131339, 0.429729, 0.120991,
0.668737, 0.984315, 0.232030, 0.519345, 0.339857, 0.390747, 0.087565,
0.066204, 0.114057, 0.806607, 0.134722, 0.511588, 0.565175, 0.469777,
0.205399, 0.347995, 0.531883, 0.275268, 0.044955, 0.691165, 0.905091,
0.026178, 0.772766, 0.129303, 0.393112, 0.310566, 0.294715, 0.631933,
0.441905, 0.724444, 0.752925, 0.110641, 0.708759, 0.984954, 0.629986,
0.048616, 0.375702, 0.717551, 0.114820, 0.489759, 0.524158, 0.249542,
0.001348, 0.089333, 0.719319, 0.206747, 0.437328, 0.251202, 0.482014,
0.482282, 0.942367, 0.387106, 0.508460, 0.715133, 0.516409, 0.901572,
0.025699, 0.811124, 0.533505, 0.467604, 0.535568, 0.286430, 0.578245,
0.244327, 0.271384, 0.208231, 0.292943, 0.647086, 0.925782, 0.407763,
0.136845, 0.449941, 0.657305, 0.138193, 0.539273, 0.376625, 0.344940,
0.976601, 0.627827, 0.826954, 0.458884, 0.570194, 0.214059, 0.967344,
0.285327, 0.730468, 0.868916, 0.311026, 0.541592, 0.402421, 0.778630,
0.077160, 0.688851, 0.356875, 0.321487, 0.960236, 0.565106, 0.614429,
0.607322, 0.490889, 0.022192, 0.744167, 0.940829, 0.679498, 0.882360,
0.480103, 0.056123, 0.227300, 0.456704, 0.683950, 0.054254, 0.915587,
0.254144, 0.268313, 0.882931, 0.539471, 0.998782, 0.751847, 0.850497,
0.540374, 0.154268, 0.629126, 0.617534, 0.843119, 0.986001, 0.939020,
0.803355, 0.551107, 0.553450, 0.410677, 0.041996, 0.575642, 0.154845,
0.982825, 0.255140, 0.037205, 0.462928, 0.311263, 0.264505, 0.919631,
0.995212, 0.318759, 0.835219, 0.249356, 0.587072, 0.718150, 0.788827,
0.585853, 0.469996, 0.639323, 0.126227, 0.624264, 0.268449, 0.743761,
0.467384, 0.254451, 0.682781, 0.270739, 0.805558, 0.236231, 0.681416,
0.847554, 0.811873, 0.836260, 0.830379, 0.067013, 0.873465, 0.293307,
0.378276, 0.137970, 0.212939, 0.373489, 0.456729, 0.048158, 0.622845,
0.043801, 0.766307, 0.411671, 0.629654, 0.236304, 0.050995, 0.755881,
0.860568, 0.319444, 0.499642, 0.327952, 0.573895, 0.182423, 0.598690,
0.379453, 0.418653, 0.280106, 0.227007, 0.230526, 0.116366, 0.057386,
0.297540, 0.989831, 0.350694, 0.675816, 0.127801, 0.563633, 0.049304,
0.584530, 0.611790, 0.672149, 0.628331, 0.378097, 0.083820, 0.257985,
0.614401, 0.134815, 0.013866, 0.474969, 0.454259, 0.513507, 0.802921,
0.028154, 0.695930, 0.401611, 0.407607, 0.114583, 0.681717, 0.634614,
0.345109, 0.798083, 0.692000, 0.642649, 0.787915, 0.042694, 0.318465,
0.915716, 0.606327, 0.367769, 0.500246, 0.218117, 0.039918, 0.128577,
0.596214, 0.123738, 0.386561, 0.210616, 0.258553, 0.400427, 0.685585,
0.712813, 0.913934, 0.488506, 0.740967, 0.609864, 0.890117, 0.148574,
0.724447, 0.571834, 0.783188, 0.069556, 0.369918, 0.475188, 0.712205,
0.157832, 0.517882, 0.030670, 0.073549, 0.124209, 0.398439, 0.573795,
0.342326, 0.438356, 0.702371, 0.938540, 0.562095, 0.088933, 0.149156,
0.820648, 0.489360, 0.834741, 0.533461, 0.403294, 0.323247, 0.274427,
0.013158, 0.213364, 0.423001, 0.737604, 0.785198, 0.206189, 0.807160,
0.155116, 0.681377, 0.519365, 0.312949, 0.199259, 0.550035, 0.386497,
0.323467, 0.948473, 0.960292, 0.665793, 0.386830, 0.662663, 0.604333,
0.948924, 0.751596,
};

static int randpt;

extern void init_rand( void );
extern int get_rand( int ll, int ul );

void init_rand( void )
{
   randpt = 1;
}

int get_rand( int ll, int ul )
{
   double r = rnd[randpt++];
   int    val;

   if (randpt >= MAXRND)
      err_internal( __FUNCTION__,
		    "Ran out of random numbers (only %d available)\n",
		    MAXRND );

   val = floor( ll + r * (ul - ll) );
   if (val > ul)
      err_internal( __FUNCTION__, "%d > %d\n", val, ul );
   if (val < ll)
      err_internal( __FUNCTION__, "%d < %d\n", val, ll );
   return val;
}
