/*
 * Copyright (c) 2008-2009 Internet Initiative Japan Inc. All rights reserved.
 *
 * The terms and conditions of the accompanying program
 * shall be provided separately by Internet Initiative Japan Inc.
 * Any use, reproduction or distribution of the program are permitted
 * provided that you agree to be bound to such terms and conditions.
 *
 * $Id: dkimpubkey.h 653 2009-02-28 20:35:27Z takahiko $
 */

#ifndef __DKIM_PUBKEY_H__
#define __DKIM_PUBKEY_H__

#include <stdbool.h>
#include <openssl/evp.h>

#include "dnsresolv.h"
#include "dkim.h"
#include "dkimpolicy.h"
#include "dkimtvobj.h"
#include "dkimsignature.h"

typedef struct DkimPubkey DkimPubkey;

extern DkimPubkey *DkimPubkey_build(const DkimPolicy *policy, const char *keyval,
                                    const char *domain, dkim_stat_t *dstat);
extern void DkimPubkey_free(DkimPubkey *self);
extern DkimPubkey *DkimPubkey_retrieve(const DkimPolicy *policy, const DkimSignature *signature,
                                       DnsResolver *resolver, dkim_stat_t *dstat);
extern EVP_PKEY *DkimPubkey_getPublicKey(const DkimPubkey *self);
extern bool DkimPubkey_isTesing(const DkimPubkey *self);
extern bool DkimPubkey_isSubdomainProhibited(const DkimPubkey *self);
extern bool DkimPubkey_isEMailServiceUsable(const DkimPubkey *self);
extern dkim_pubkeyalg_t DkimPubkey_getPubKeyAlg(const DkimPubkey *self);
extern const char *DkimPubkey_getGranularity(const DkimPubkey *self);

#endif /* __DKIM_PUBKEY_H__ */
