/*
 * Copyright (c) 2008-2009 Internet Initiative Japan Inc. All rights reserved.
 *
 * The terms and conditions of the accompanying program
 * shall be provided separately by Internet Initiative Japan Inc.
 * Any use, reproduction or distribution of the program are permitted
 * provided that you agree to be bound to such terms and conditions.
 *
 * $Id: dkimsignature.h 760 2009-03-22 07:02:14Z takahiko $
 */

#ifndef __DKIM_SIGNATURE_H__
#define __DKIM_SIGNATURE_H__

#include "strarray.h"
#include "xbuffer.h"
#include "intarray.h"
#include "dkim.h"
#include "dkimenum.h"
#include "inetmailbox.h"
#include "dkimtvobj.h"

typedef struct DkimSignature DkimSignature;

extern DkimSignature *DkimSignature_new(const DkimPolicy *policy);
extern dkim_stat_t DkimSignature_isExpired(const DkimSignature *self);
extern DkimSignature *DkimSignature_build(const DkimPolicy *policy, const char *headerf,
                                          const char *headerv, dkim_stat_t *dstat);
extern void DkimSignature_free(DkimSignature *self);
extern dkim_stat_t DkimSignature_buildRawHeader(DkimSignature *self,
                                                bool digestmode,
                                                const char **rawheaderf, const char **rawheaderv);
extern dkim_stat_t DkimSignature_addSelectHeaderName(DkimSignature *self, const char *headerf);
extern bool DkimSignature_isHeaderSigned(const DkimSignature *self, const char *headerf);
extern const char *DkimSignature_getSigningDomain(const DkimSignature *self);
extern dkim_stat_t DkimSignature_setSigningDomain(DkimSignature *self, const char *domain);
extern const char *DkimSignature_getSelector(const DkimSignature *self);
extern dkim_stat_t DkimSignature_setSelector(DkimSignature *self, const char *selector);
extern dkim_digestalg_t DkimSignature_getDigestAlg(const DkimSignature *self);
extern void DkimSignature_setDigestAlg(DkimSignature *self, dkim_digestalg_t digestalg);
extern dkim_pubkeyalg_t DkimSignature_getPubKeyAlg(const DkimSignature *self);
extern void DkimSignature_setPubKeyAlg(DkimSignature *self, dkim_pubkeyalg_t pubkeyalg);
extern long long DkimSignature_getGeneratedTime(const DkimSignature *self);
extern void DkimSignature_setGeneratedTime(DkimSignature *self, long long genaratetime);
extern long long DkimSignature_getSignatureTTL(const DkimSignature *self);
extern long long DkimSignature_setSignatureTTL(DkimSignature *self, long long valid_period);
extern const XBuffer *DkimSignature_getHeaderHash(const DkimSignature *self);
extern dkim_stat_t DkimSignature_setHeaderHash(DkimSignature *self,
                                               unsigned char *hashbuf, unsigned int hashlen);
extern const XBuffer *DkimSignature_getBodyHash(const DkimSignature *self);
extern dkim_stat_t DkimSignature_setBodyHash(DkimSignature *self,
                                             unsigned char *hashbuf, unsigned int hashlen);
extern const StrArray *DkimSignature_getSelectHeader(const DkimSignature *self);
extern dkim_canonalg_t DkimSignature_getHeaderCanonAlg(const DkimSignature *self);
extern void DkimSignature_setHeaderCanonAlg(DkimSignature *self, dkim_canonalg_t headercanon);
extern dkim_canonalg_t DkimSignature_getBodyCanonAlg(const DkimSignature *self);
extern void DkimSignature_setBodyCanonAlg(DkimSignature *self, dkim_canonalg_t bodycanon);
extern long long DkimSignature_getBodyLengthLimit(const DkimSignature *self);
extern void DkimSignature_setBodyLengthLimit(DkimSignature *self, long long body_length_limit);
extern const char *DkimSignature_getRawHeaderName(const DkimSignature *self);
extern const char *DkimSignature_getRawHeaderValue(const DkimSignature *self);
extern void DkimSignature_getReferenceToBodyHashOfRawHeaderValue(const DkimSignature *self,
                                                                 const char **head,
                                                                 const char **tail);
extern const InetMailbox *DkimSignature_getIdentity(const DkimSignature *self);
extern dkim_stat_t DkimSignature_setIdentity(DkimSignature *self, const InetMailbox *mailbox);
extern const IntArray *DkimSignature_getKeyRetrMethod(const DkimSignature *self);

#endif /* __DKIM_SIGNATURE_H__ */
