/*
 * Copyright (c) 2008-2009 Internet Initiative Japan Inc. All rights reserved.
 *
 * The terms and conditions of the accompanying program
 * shall be provided separately by Internet Initiative Japan Inc.
 * Any use, reproduction or distribution of the program are permitted
 * provided that you agree to be bound to such terms and conditions.
 *
 * $Id: dkimtvobj.h 653 2009-02-28 20:35:27Z takahiko $
 */

#ifndef __DKIM_TVOBJ_H__
#define __DKIM_TVOBJ_H__

#include <stdlib.h>
#include <stdbool.h>
#include "dkim.h"
#include "dkimpolicy.h"

typedef struct DkimTvobj DkimTvobj;

typedef struct DkimTagParseContext {
    int tagno;                  // 何番目の tag-value pair か (0-oriented), デフォルト値の場合は -1
    const char *taghead;        // タグ名の先頭へのポインタ
    const char *tagtail;        // タグ名の末尾へのポインタ
    const char *valuehead;      // 値の先頭へのポインタ
    const char *valuetail;      // 値の末尾へのポインタ
} DkimTagParseContext;

typedef const struct DkimTvobjFieldMap {
    const char *tagname;
    dkim_stat_t (*ptagparser) (DkimTvobj *self, const DkimTagParseContext *context,
                               const char **nextp);
    bool required;
    const char *default_value;
    size_t offset_to_parsed_flag;
} DkimTvobjFieldMap;

#define DkimTvobj_MEMBER        \
    DkimTvobjFieldMap *ftbl;    \
    const DkimPolicy *policy

struct DkimTvobj {
    DkimTvobj_MEMBER;
};

extern dkim_stat_t DkimTvobj_build(DkimTvobj *self, const char *record_head,
                                   const char *record_tail, bool wsp_restriction);

#endif /* __DKIM_TVOBJ_H__ */
