#!/bin/bash

### variables
# --------------------------------

# this directory
TLSRCDIR=/opt/home-supp/tl10

# temporaly working directory
TMPDIR=/tmp
#TMPDIR=/var/tmp

# the place of installed TeX Live
TLINSTDIR=/opt/texlive/2010
#TLINSTDIR=/mnt/cd0a

# install directory
PREFIX=/opt/texlive/p2010

# toolkit for [p]xdvi
TL_CONF_XDVI_TOOLKIT=--with-xdvi-x-toolkit=motif
#TL_CONF_XDVI_TOOLKIT=--with-xdvi-x-toolkit=xaw

TL_MAKE_FLAGS=-j3

TL_CONFIGURE_ARGS=
# ``minimal''?
TL_CONFIGURE_ARGS="--disable-all-pkgs --enable-web2c \
                   --disable-luatex --disable-xetex --disable-pdftex \
                   --enable-web-progs --enable-dvipdfmx \
                   --enable-makejvf --enable-pxdvik \
                   --enable-tetex --enable-texlive "

FTVER=2.4.2

# for Ubuntu?
# CONFIG_SHELL=$BASH

### do not edit
# --------------------------------
unset TEXINPUTS
unset PTEX_KANJI_ENC
SRCDIR=$TMPDIR/texlive-20100720-source
ARCH=`ls $SRCDIR/inst/bin/ 2> /dev/null`
PTEX_IN_FILTER=no
TEXMF=$SRCDIR/inst/texmf
XMAP=$TEXMF/fonts/map/dvipdfmx
export TEXMFMAIN=$TEXMF
export ORIGPATH=$PATH
export PATH=$SRCDIR/inst/bin/$ARCH:$PATH
export TL_CONF_XDVI_TOOLKIT TL_CONFIGURE_ARGS TL_MAKE_FLAGS

sedwrite(){
  echo -e "\e[0;33m[rewriting]\e[0m  `basename $1` by \"$2\""
  if [ ! -f "$1" ]; then 
    echo -e "'$1' does not exist"; exit 1
  fi
  perl -pi -e  "$2" "$1" || exit 1
}


zpatch() {
    echo -e "\e[0;33m[patching]\e[0m   `basename $2`"
    if [ ! -f "$2" ]; then 
      echo -e "\e[0;31m`basename %2` does not exist.\e[0m"
      exit 1
    fi
    $PATCH -p$1 -s < $2
    if [ $? -ne 0 ]; then
      if [ "x$PMODE" = "x" ]; then
        echo -e "  \e[0;31mError(s) have occured.\e[0m"
        exit 1
      else 
        echo -e "  \e[0;33mDon't worry about these errors.\e[0m"
      fi
      PMODE=
    fi
}

# simplified tarx()
tarz() {
    echo -e "\e[0;33m[extracting]\e[0m `basename $1`"
    if test ! -f "$1"; then echo "'$1' doesn't exist"; exit 1; fi
    case "$1" in
        *.zip)  unzip -qo "$1" || exit 1;;
        *.xz)   xz    -cd  "$1" | (umask 0; tar xf -) || exit 1;;
        *.gz)   gzip  -cd  "$1" | (umask 0; tar xf -) || exit 1;;
        *.bz2)  bzip2 -cd  "$1" | (umask 0; tar xf -) || exit 1;;
        *.tar)  cat        "$1" | (umask 0; tar xf -) || exit 1;;
    esac
}

while getopts eupr OPT
do
  case $OPT in
    "e" ) FLG_EP="TRUE" ;;
    "u" ) FLG_UP="TRUE" ;;
    "p" ) FLG_PP="TRUE" ;;
    "r" ) FLG_RP="TRUE" ;;
      * ) echo "Usage: $0 [-p] [-e] [-u] [-r]" 1>&2
	  echo "-p: apply patch for pTeX (ptex-base.ch.0711.diff etc.)" 1>&2
	  echo "-e: apply patch for e-pTeX" 1>&2
#	  echo "-u: apply patch for upTeX" 1>&2
	  echo "-r: parallelize reautoconf" 1>&2
          exit 1 ;;
  esac
done

MAKE=make
PATCH=patch
gmake   --version > /dev/null 2>&1 && MAKE=gmake
gpatch  --version > /dev/null 2>&1 && PATCH=gpatch
