#!/bin/bash
# modified from 7font-search.sh in ptexlive-20100322

. ./common.sh $*

TRUETYPE=$TEXMF/fonts/truetype
OPENTYPE=$TEXMF/fonts/opentype
CMAP=$TEXMF/fonts/cmap

# -----------------------------------
### symlink 

# usage: lns dist-link src-dir1 src-dir2 ...
lns() {
    LINK=notyet
    DIST="$1"
    shift
    #echo "DIST=$DIST"
    if [ -h "$DIST" ]; then return; fi
    while test -n "$1" -a $LINK = "notyet"; do
	#echo "  $1"
	if test -f "$1" -o -d "$1"; then
	    echo -e "\e[0;33m[linking ]\e[0m   $1"
	    echo -e "             to \$TEXMF/fonts/`basename $DIST`"
	    ln -sf "$1" "$DIST"
	    if [ $? -eq 0 ]; then
		echo -e "\e[u\e[60C\e[0;32mOK\e[0m"
	    else
		echo -e "\e[u\e[60C\e[0;31mNG\e[0m"
	    fi
            LINK=already
	fi
	shift
    done
}

mksymlink(){
    mkdir -p $1 &>/dev/null
    while read line; do
	case $line in \#*) continue;; esac # skip comment
	eval lns $1/$line
    done
}

echo; echo -e "\e[1;36mSearching fonts...\e[0m"

mksymlink $CMAP <<EOF
### link name [space] directory or file to be searched
Acrobat4    /usr{,/local,/sfw}{,/lib}/Acrobat4/Resource/CMap
Acrobat5    /usr{,/local,/sfw}{,/lib}/Acrobat5/Resource/Font
Acrobat7    {/opt,/usr{,/local,/sfw}{,/lib}}{,/Adobe}/{Acrobat,Reader}7{,.0}/Resource/CMap
Acrobat8    {/opt,/usr{,/local,/sfw}{,/lib}}{,/Adobe}/{Acrobat,Reader}8{,.0}/Resource/CMap
Acrobat9    {/opt,/usr{,/local,/sfw}{,/lib}}{,/Adobe}/{Acrobat,Reader}9{,.0}/Resource/CMap
ghostscript /usr{,/local,/sfw}/{share,lib}/ghostscript{,/*}/Resource/CMap
openwinja   /usr/openwin/lib/locale/ja/X11/Resource/CMap
openwinko   /usr/openwin/lib/locale/ko/X11/Resource/CMap
openwinzh   /usr/openwin/lib/locale/zh/X11/Resource/CMap
openwintw   /usr/openwin/lib/locale/zh_TW.BIG5/X11/Resource/CMap
EOF

mksymlink $TRUETYPE <<EOF
### link name [space] directory or file to be searched
x11       /usr{,/local,/X11R6,/pkg}/lib/X11/fonts/truetype
X11       /usr{,/local,/X11R6,/pkg}/lib/X11/fonts/TrueType
X11TTF    /usr{,/local,/X11R6,/pkg}/lib/X11/fonts/TTF
truetype  /usr{,/local}/share/fonts/truetype
TrueType  /usr{,/local}/share/fonts/TrueType
TTF	  /usr{,/local}/share/fonts/TTF
ja        /usr{,/local}/share/fonts/ja/TrueType
japanese  /usr{,/local}/share/fonts/japanese/TrueType
default   /usr{,/local}/share/fonts/default/TTF
openwin   /usr/openwin/lib/locale/ja/X11/fonts/TT
QtPalmtop	/opt/QtPalmtop/lib/X11/fonts/TrueType
f8sazanami-min	/usr/share/fonts/sazanami-fonts-mincho
f8sazanami-goth	/usr/share/fonts/sazanami-fonts-gothic
f11sazanami	/usr/share/fonts/sazanami
vine5ipa	/usr/share/fonts/TrueType-ipafont
vine5vlgoth	/usr/share/fonts/TrueType-vlgothic
test /opt/fonts
EOF

mksymlink $OPENTYPE <<EOF
### link name [space] directory or file to be searched
QtPalmtop /opt/QtPalmtop/lib/X11/fonts/opentype
# for test (contains white space)
hoge "/tmp/hoge hoge"
EOF

if test -d /System/Library/Fonts; then # for Mac OS X
LC_ALL=ja_JP.UTF-8
cat <<EOF | /usr/bin/iconv -f UTF-8 -t UTF-8-MAC | mksymlink $OPENTYPE
HiraMinPro-W3.otf   {,/System}"/Library/Fonts/ҥ饮ī Pro W3.otf"
HiraMinPro-W6.otf   {,/System}"/Library/Fonts/ҥ饮ī Pro W6.otf"
HiraKakuPro-W3.otf  {,/System}"/Library/Fonts/ҥ饮γѥ Pro W3.otf"
HiraKakuPro-W6.otf  {,/System}"/Library/Fonts/ҥ饮γѥ Pro W6.otf"
HiraKakuStd-W8.otf  {,/System}"/Library/Fonts/ҥ饮γѥ Std W8.otf"
HiraMaruPro-W4.otf  {,/System}"/Library/Fonts/ҥ饮δݥ Pro W4.otf"
HiraMinProN-W3.otf  {,/System}"/Library/Fonts/ҥ饮ī ProN W3.otf"
HiraMinProN-W6.otf  {,/System}"/Library/Fonts/ҥ饮ī ProN W6.otf"
HiraKakuProN-W3.otf {,/System}"/Library/Fonts/ҥ饮γѥ ProN W3.otf"
HiraKakuProN-W6.otf {,/System}"/Library/Fonts/ҥ饮γѥ ProN W6.otf"
HiraKakuStdN-W8.otf {,/System}"/Library/Fonts/ҥ饮γѥ StdN W8.otf"
HiraMaruProN-W4.otf {,/System}"/Library/Fonts/ҥ饮δݥ ProN W4.otf"
EOF
fi

if test -d /cygdrive; then # for Cygwin
mksymlink $CMAP <<EOF
Acrobat5 "`cygpath --mixed "$PROGRAMFILES"`/Adobe/Acrobat 5.0/Resource/Cmap"
Acrobat6 "`cygpath --mixed "$PROGRAMFILES"`/Adobe/Acrobat 6.0/Resource/CMap"
Acrobat7 "`cygpath --mixed "$PROGRAMFILES"`/Adobe/Acrobat 7.0/Resource/CMap"
Acrobat8 "`cygpath --mixed "$PROGRAMFILES"`/Adobe/Acrobat 8.0/Resource/CMap"
Acrobat9 "`cygpath --mixed "$PROGRAMFILES"`/Adobe/Acrobat 9.0/Resource/CMap"
EOF
mksymlink $TRUETYPE <<EOF
windows  "`cygpath --mixed -W`/Fonts"
EOF
fi

(IFS=";"; NUM=1; for f in $EXTRA_CMAP; do
    echo "extra$NUM $f"
    NUM=`expr $NUM + 1`
done) | mksymlink $CMAP

(IFS=";"; NUM=1; for f in $EXTRA_TRUETYPE; do
    echo "extra$NUM $f"
    NUM=`expr $NUM + 1`
done) | mksymlink $TRUETYPE

(IFS=";"; NUM=1; for f in $EXTRA_OPENTYPE; do
    echo "extra$NUM $f"
    NUM=`expr $NUM + 1`
done) | mksymlink $OPENTYPE

