#/bin/bash

. ./common.sh

# pTeX outputs direction of boxes.
#P_SED1=''
#P_SED2=''
P_SED1='s/, yoko direction//;s/yoko direction, //'
P_SED2='s/yoko(math) direction, //'

qtrip() {
echo -e "\e[1;31mQTRIP 1st run for ${P}ptex, $S, $T\e[0m"
${P}ptex $S -kanji=euc -ini qtrip
mv qtrip.log qtrip-${P}${T}1.log
echo -e "\e[1;31mQTRIP 2nd run for ${P}ptex, $S, $T\e[0m"
${P}ptex $S -kanji=euc -fmt=qtrip qtrip 
mv qtrip.log qtrip-${P}${T}2.log
}

trip() {
cd triptrap
echo -e "\e[1;31mTRIP 1st run for ${P}tex, $S, $T\e[0m"
${P}tex $S -ini < trip1.in &>/dev/null
sed "$P_SED1" trip.log > trip-${T}1.log
echo -e "\e[1;31mTRIP 2nd run for ${P}tex, $S, $T\e[0m"
${P}tex $S < trip2.in &>/dev/null
sed "$P_SED1;$P_SED2" trip.log > trip-${T}2.log
cd ..
}

etrip() {
echo -n
P=${P} S=${S} T=${T} trip
cd triptrap
echo -e "\e[1;31mTRIP 1st run for ${P}tex, $S, $T (extended mode)\e[0m"
${P}tex $S -ini <../etrip/etrip1.in &>/dev/null
sed "$P_SED1" trip.log > tripe-${T}1.log
echo -e "\e[1;31mTRIP 2nd run for ${P}tex, $S, $T (extended mode)\e[0m"
${P}tex $S < ../etrip/trip2.in &>/dev/null
sed "$P_SED1;$P_SED2" trip.log > tripe-${T}2.log
cd ..
cd etrip
echo -e "\e[1;31me-TRIP 1st run for ${P}tex, $S, $T\e[0m"
${P}tex $S -ini <etrip2.in &>/dev/null
sed "$P_SED1" etrip.log > etrip-${T}1.log
echo -e "\e[1;31me-TRIP 2nd run for ${P}tex, $S, $T\e[0m"
${P}tex $S < etrip3.in &>/dev/null
sed "$P_SED1;$P_SED2" etrip.log > etrip-${T}2.log
cd ..
}

cd $SRCDIR/Work

#PATH=$ORIGPATH

#unset TEXMF 
#unset TEXMFMAIN
#PATH=/opt/ptetex3/bin:$ORIGPATH

cp -r ../texk/web2c/triptrap .
(cd triptrap;  pltotf trip )
cp -r ../texk/web2c/etexdir/etrip .
(cd etrip;  pltotf etrip )
P=   S=                    T=   trip   # tex
P=e  S=                    T=e  etrip  # etex
P=p  S=                    T=p  trip   # ptex
P=ep S=                    T=ep etrip  # eptex
P=up S=-kanji-internal=euc T=uc trip   # uptex
P=up S=                    T=up trip   # uptex
P=eup S=                    T=eup etrip   # euptex
P=eup S=-kanji-internal=euc T=euc etrip   # euptex

rm -rf ptex-qtrip
tar zxf $TLSRCDIR/ptex-qtrip-??????.tar.gz
cd ptex-qtrip
P=  S=                    T=  qtrip
P=e S=                    T=  qtrip
P=e S=-etex               T=x qtrip # extended mode
P=u S=                    T=  qtrip
P=u S=-kanji-internal=euc T=c qtrip
P=eu S=                    T=  qtrip
P=eu S=-kanji-internal=euc T=c qtrip # kanji-internal=euc
P=eu S=-etex               T=x qtrip
