/* ofono-persona-store.c generated by valac 0.24.0.16-c045, the Vala compiler
 * generated from ofono-persona-store.vala, do not modify */

/*
 * Copyright (C) 2012 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *          Jeremy Whiting <jeremy.whiting@collabora.co.uk>
 *
 * Based on kf-persona-store.vala by:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <folks-internal.h>


#define FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE (folks_backends_ofono_persona_store_get_type ())
#define FOLKS_BACKENDS_OFONO_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStore))
#define FOLKS_BACKENDS_OFONO_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStoreClass))
#define FOLKS_BACKENDS_OFONO_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_OFONO_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_OFONO_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStoreClass))

typedef struct _FolksBackendsOfonoPersonaStore FolksBackendsOfonoPersonaStore;
typedef struct _FolksBackendsOfonoPersonaStoreClass FolksBackendsOfonoPersonaStoreClass;
typedef struct _FolksBackendsOfonoPersonaStorePrivate FolksBackendsOfonoPersonaStorePrivate;

#define FOLKS_BACKENDS_OFONO_TYPE_PERSONA (folks_backends_ofono_persona_get_type ())
#define FOLKS_BACKENDS_OFONO_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_OFONO_TYPE_PERSONA, FolksBackendsOfonoPersona))
#define FOLKS_BACKENDS_OFONO_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_OFONO_TYPE_PERSONA, FolksBackendsOfonoPersonaClass))
#define FOLKS_BACKENDS_OFONO_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_OFONO_TYPE_PERSONA))
#define FOLKS_BACKENDS_OFONO_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_OFONO_TYPE_PERSONA))
#define FOLKS_BACKENDS_OFONO_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_OFONO_TYPE_PERSONA, FolksBackendsOfonoPersonaClass))

typedef struct _FolksBackendsOfonoPersona FolksBackendsOfonoPersona;
typedef struct _FolksBackendsOfonoPersonaClass FolksBackendsOfonoPersonaClass;

#define ORG_OFONO_TYPE_PHONEBOOK (org_ofono_phonebook_get_type ())
#define ORG_OFONO_PHONEBOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORG_OFONO_TYPE_PHONEBOOK, orgofonoPhonebook))
#define ORG_OFONO_IS_PHONEBOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORG_OFONO_TYPE_PHONEBOOK))
#define ORG_OFONO_PHONEBOOK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ORG_OFONO_TYPE_PHONEBOOK, orgofonoPhonebookIface))

typedef struct _orgofonoPhonebook orgofonoPhonebook;
typedef struct _orgofonoPhonebookIface orgofonoPhonebookIface;

#define ORG_OFONO_TYPE_PHONEBOOK_PROXY (org_ofono_phonebook_proxy_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define ORG_OFONO_TYPE_SIM_MANAGER (org_ofono_sim_manager_get_type ())
#define ORG_OFONO_SIM_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORG_OFONO_TYPE_SIM_MANAGER, orgofonoSimManager))
#define ORG_OFONO_IS_SIM_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORG_OFONO_TYPE_SIM_MANAGER))
#define ORG_OFONO_SIM_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ORG_OFONO_TYPE_SIM_MANAGER, orgofonoSimManagerIface))

typedef struct _orgofonoSimManager orgofonoSimManager;
typedef struct _orgofonoSimManagerIface orgofonoSimManagerIface;

#define ORG_OFONO_TYPE_SIM_MANAGER_PROXY (org_ofono_sim_manager_proxy_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FolksBackendsOfonoPersonaStorePrepareData FolksBackendsOfonoPersonaStorePrepareData;
typedef struct _FolksBackendsOfonoPersonaStoreRemovePersonaData FolksBackendsOfonoPersonaStoreRemovePersonaData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _FolksBackendsOfonoPersonaStoreAddPersonaFromDetailsData FolksBackendsOfonoPersonaStoreAddPersonaFromDetailsData;

struct _FolksBackendsOfonoPersonaStore {
	FolksPersonaStore parent_instance;
	FolksBackendsOfonoPersonaStorePrivate * priv;
};

struct _FolksBackendsOfonoPersonaStoreClass {
	FolksPersonaStoreClass parent_class;
};

struct _orgofonoPhonebookIface {
	GTypeInterface parent_iface;
	gchar* (*Import) (orgofonoPhonebook* self, GError** error);
};

struct _FolksBackendsOfonoPersonaStorePrivate {
	GeeHashMap* _personas;
	GeeMap* _personas_ro;
	gboolean _is_prepared;
	gboolean _prepare_pending;
	gboolean _is_quiescent;
	char* _path;
	orgofonoPhonebook* _ofono_phonebook;
};

struct _orgofonoSimManagerIface {
	GTypeInterface parent_iface;
	GHashTable* (*GetProperties) (orgofonoSimManager* self, GError** error);
};

struct _FolksBackendsOfonoPersonaStorePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsOfonoPersonaStore* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	orgofonoPhonebook* _tmp5_;
	const char* _tmp6_;
	orgofonoPhonebook* _tmp7_;
	orgofonoPhonebook* _tmp8_;
	orgofonoSimManager* sim_manager;
	const char* _tmp9_;
	orgofonoSimManager* _tmp10_;
	orgofonoSimManager* _tmp11_;
	gchar* all_vcards;
	orgofonoPhonebook* _tmp12_;
	gchar* _tmp13_;
	gchar** vcards;
	const gchar* _tmp14_;
	gint _tmp15_;
	gchar** _tmp16_;
	gint vcards_length1;
	gint _vcards_size_;
	GeeHashSet* added_personas;
	GeeHashSet* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar** vcard_collection;
	gint vcard_collection_length1;
	gint _vcard_collection_size_;
	gint vcard_it;
	gchar* _tmp19_;
	gchar* vcard;
	FolksBackendsOfonoPersona* persona;
	const gchar* _tmp20_;
	FolksBackendsOfonoPersona* _tmp21_;
	GeeHashMap* _tmp22_;
	FolksBackendsOfonoPersona* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	FolksBackendsOfonoPersona* _tmp26_;
	GeeHashSet* _tmp27_;
	FolksBackendsOfonoPersona* _tmp28_;
	GeeHashMap* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	GeeHashSet* _tmp32_;
	GError* e;
	GError* _tmp33_;
	const gchar* _tmp34_;
	GError* _vala1_e;
	GError* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	GError * _inner_error_;
};

struct _FolksBackendsOfonoPersonaStoreRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsOfonoPersonaStore* self;
	FolksPersona* persona;
	GError* _tmp0_;
	GError * _inner_error_;
};

struct _FolksBackendsOfonoPersonaStoreAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsOfonoPersonaStore* self;
	GHashTable* details;
	FolksPersona* result;
	GError* _tmp0_;
	GError * _inner_error_;
};


static gpointer folks_backends_ofono_persona_store_parent_class = NULL;
static gchar** folks_backends_ofono_persona_store__always_writeable_properties;
static gint folks_backends_ofono_persona_store__always_writeable_properties_length1;
static gchar** folks_backends_ofono_persona_store__always_writeable_properties = NULL;
static gint folks_backends_ofono_persona_store__always_writeable_properties_length1 = 0;
static gint _folks_backends_ofono_persona_store__always_writeable_properties_size_ = 0;

GType folks_backends_ofono_persona_store_get_type (void) G_GNUC_CONST;
GType folks_backends_ofono_persona_get_type (void) G_GNUC_CONST;
GType org_ofono_phonebook_proxy_get_type (void) G_GNUC_CONST;
guint org_ofono_phonebook_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType org_ofono_phonebook_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_OFONO_PERSONA_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStorePrivate))
enum  {
	FOLKS_BACKENDS_OFONO_PERSONA_STORE_DUMMY_PROPERTY,
	FOLKS_BACKENDS_OFONO_PERSONA_STORE_TYPE_ID,
	FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_ADD_PERSONAS,
	FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_ALIAS_PERSONAS,
	FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_GROUP_PERSONAS,
	FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_REMOVE_PERSONAS,
	FOLKS_BACKENDS_OFONO_PERSONA_STORE_IS_PREPARED,
	FOLKS_BACKENDS_OFONO_PERSONA_STORE_IS_QUIESCENT,
	FOLKS_BACKENDS_OFONO_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES,
	FOLKS_BACKENDS_OFONO_PERSONA_STORE_PERSONAS
};
FolksBackendsOfonoPersonaStore* folks_backends_ofono_persona_store_new (const char* path, const gchar* alias);
FolksBackendsOfonoPersonaStore* folks_backends_ofono_persona_store_construct (GType object_type, const char* path, const gchar* alias);
static void _folks_backends_ofono_persona_store_property_changed (FolksBackendsOfonoPersonaStore* self, const gchar* property, GVariant* value);
static void _folks_backends_ofono_persona_store_remove_self (FolksBackendsOfonoPersonaStore* self);
static gchar** _folks_backends_ofono_persona_store_split_all_vcards (FolksBackendsOfonoPersonaStore* self, const gchar* all_vcards, int* result_length1);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void folks_backends_ofono_persona_store_real_prepare_data_free (gpointer _data);
static void folks_backends_ofono_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_ofono_persona_store_real_prepare_co (FolksBackendsOfonoPersonaStorePrepareData* _data_);
static void folks_backends_ofono_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType org_ofono_sim_manager_proxy_get_type (void) G_GNUC_CONST;
guint org_ofono_sim_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType org_ofono_sim_manager_get_type (void) G_GNUC_CONST;
static void __folks_backends_ofono_persona_store_property_changed_org_ofono_sim_manager_property_changed (orgofonoSimManager* _sender, const gchar* property, GVariant* value, gpointer self);
gchar* org_ofono_phonebook_Import (orgofonoPhonebook* self, GError** error);
FolksBackendsOfonoPersona* folks_backends_ofono_persona_new (const gchar* vcard, FolksPersonaStore* store);
FolksBackendsOfonoPersona* folks_backends_ofono_persona_construct (GType object_type, const gchar* vcard, FolksPersonaStore* store);
static void folks_backends_ofono_persona_store_real_remove_persona_data_free (gpointer _data);
static void folks_backends_ofono_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_ofono_persona_store_real_remove_persona_co (FolksBackendsOfonoPersonaStoreRemovePersonaData* _data_);
static void folks_backends_ofono_persona_store_real_add_persona_from_details_data_free (gpointer _data);
static void folks_backends_ofono_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_ofono_persona_store_real_add_persona_from_details_co (FolksBackendsOfonoPersonaStoreAddPersonaFromDetailsData* _data_);
static void folks_backends_ofono_persona_store_finalize (GObject* obj);
static void _vala_folks_backends_ofono_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
   * Create a new PersonaStore.
   *
   * Create a new persona store to expose the {@link Persona}s provided by the
   * modem with the given address.
   *
   * @param path the D-Bus object path of this modem
   * @param alias the name this modem should display to users
   *
   * @since 0.9.0
   */
FolksBackendsOfonoPersonaStore* folks_backends_ofono_persona_store_construct (GType object_type, const char* path, const gchar* alias) {
	FolksBackendsOfonoPersonaStore * self = NULL;
	const char* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	GeeMap* _tmp4_ = NULL;
	GeeMap* _tmp5_ = NULL;
	const char* _tmp6_ = NULL;
	char* _tmp7_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (alias != NULL, NULL);
	_tmp0_ = path;
	_tmp1_ = alias;
	self = (FolksBackendsOfonoPersonaStore*) g_object_new (object_type, "id", _tmp0_, "display-name", _tmp1_, NULL);
	folks_persona_store_set_trust_level ((FolksPersonaStore*) self, FOLKS_PERSONA_STORE_TRUST_FULL);
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_BACKENDS_OFONO_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_personas);
	self->priv->_personas = _tmp2_;
	_tmp3_ = self->priv->_personas;
	_tmp4_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (self->priv->_personas_ro);
	self->priv->_personas_ro = _tmp5_;
	_tmp6_ = path;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (self->priv->_path);
	self->priv->_path = _tmp7_;
	return self;
}


FolksBackendsOfonoPersonaStore* folks_backends_ofono_persona_store_new (const char* path, const gchar* alias) {
	return folks_backends_ofono_persona_store_construct (FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, path, alias);
}


static void _folks_backends_ofono_persona_store_property_changed (FolksBackendsOfonoPersonaStore* self, const gchar* property, GVariant* value) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (property != NULL);
	g_return_if_fail (value != NULL);
	_tmp1_ = property;
	if (g_strcmp0 (_tmp1_, "Present") == 0) {
		GVariant* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = value;
		_tmp3_ = g_variant_get_boolean (_tmp2_);
		_tmp0_ = _tmp3_ == FALSE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_folks_backends_ofono_persona_store_remove_self (self);
	}
}


static void _folks_backends_ofono_persona_store_remove_self (FolksBackendsOfonoPersonaStore* self) {
	GeeHashSet* removed_personas = NULL;
	GeeHashSet* _tmp0_ = NULL;
	GeeMapIterator* iter = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeMapIterator* _tmp2_ = NULL;
	GeeHashSet* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_set_new (FOLKS_BACKENDS_OFONO_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	removed_personas = _tmp0_;
	_tmp1_ = self->priv->_personas;
	_tmp2_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp1_);
	iter = _tmp2_;
	while (TRUE) {
		GeeMapIterator* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		GeeHashSet* _tmp5_ = NULL;
		GeeMapIterator* _tmp6_ = NULL;
		gpointer _tmp7_ = NULL;
		FolksBackendsOfonoPersona* _tmp8_ = NULL;
		_tmp3_ = iter;
		_tmp4_ = gee_map_iterator_next (_tmp3_);
		if (!(_tmp4_ == TRUE)) {
			break;
		}
		_tmp5_ = removed_personas;
		_tmp6_ = iter;
		_tmp7_ = gee_map_iterator_get_value (_tmp6_);
		_tmp8_ = (FolksBackendsOfonoPersona*) _tmp7_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp8_);
		_g_object_unref0 (_tmp8_);
	}
	_tmp9_ = removed_personas;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, NULL, (GeeSet*) _tmp9_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	g_signal_emit_by_name ((FolksPersonaStore*) self, "removed");
	_g_object_unref0 (iter);
	_g_object_unref0 (removed_personas);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** _folks_backends_ofono_persona_store_split_all_vcards (FolksBackendsOfonoPersonaStore* self, const gchar* all_vcards, int* result_length1) {
	gchar** result = NULL;
	gchar** lines = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint lines_length1 = 0;
	gint _lines_size_ = 0;
	gchar** vcards = NULL;
	gchar** _tmp3_ = NULL;
	gint vcards_length1 = 0;
	gint _vcards_size_ = 0;
	gchar* vcard = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar** _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (all_vcards != NULL, NULL);
	_tmp0_ = all_vcards;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "\n", 0);
	lines = _tmp2_;
	lines_length1 = _vala_array_length (_tmp1_);
	_lines_size_ = lines_length1;
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	vcards = _tmp3_;
	vcards_length1 = 0;
	_vcards_size_ = vcards_length1;
	_tmp4_ = g_strdup ("");
	vcard = _tmp4_;
	_tmp5_ = lines;
	_tmp5__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp5_;
		line_collection_length1 = _tmp5__length1;
		for (line_it = 0; line_it < _tmp5__length1; line_it = line_it + 1) {
			gchar* _tmp6_ = NULL;
			gchar* line = NULL;
			_tmp6_ = g_strdup (line_collection[line_it]);
			line = _tmp6_;
			{
				gboolean _tmp7_ = FALSE;
				const gchar* _tmp8_ = NULL;
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gboolean _tmp20_ = FALSE;
				_tmp8_ = vcard;
				if (g_strcmp0 (_tmp8_, "") == 0) {
					const gchar* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					_tmp9_ = line;
					_tmp10_ = string_strip (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp7_ = g_strcmp0 (_tmp11_, "") == 0;
					_g_free0 (_tmp11_);
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_g_free0 (line);
					continue;
				}
				_tmp12_ = vcard;
				_tmp13_ = line;
				_tmp14_ = g_strconcat (_tmp12_, _tmp13_, NULL);
				_g_free0 (vcard);
				vcard = _tmp14_;
				_tmp15_ = vcard;
				_tmp16_ = g_strconcat (_tmp15_, "\n", NULL);
				_g_free0 (vcard);
				vcard = _tmp16_;
				_tmp17_ = line;
				_tmp18_ = string_strip (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_strcmp0 (_tmp19_, "END:VCARD") == 0;
				_g_free0 (_tmp19_);
				if (_tmp20_) {
					gchar** _tmp21_ = NULL;
					gint _tmp21__length1 = 0;
					const gchar* _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
					_tmp21_ = vcards;
					_tmp21__length1 = vcards_length1;
					_tmp22_ = vcard;
					_tmp23_ = g_strdup (_tmp22_);
					_vala_array_add2 (&vcards, &vcards_length1, &_vcards_size_, _tmp23_);
					_tmp24_ = g_strdup ("");
					_g_free0 (vcard);
					vcard = _tmp24_;
				}
				_g_free0 (line);
			}
		}
	}
	_tmp25_ = vcards;
	_tmp25__length1 = vcards_length1;
	if (result_length1) {
		*result_length1 = _tmp25__length1;
	}
	result = _tmp25_;
	_g_free0 (vcard);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void folks_backends_ofono_persona_store_real_prepare_data_free (gpointer _data) {
	FolksBackendsOfonoPersonaStorePrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsOfonoPersonaStorePrepareData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_backends_ofono_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsOfonoPersonaStore * self;
	FolksBackendsOfonoPersonaStorePrepareData* _data_;
	FolksBackendsOfonoPersonaStore* _tmp0_ = NULL;
	self = (FolksBackendsOfonoPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsOfonoPersonaStorePrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_ofono_persona_store_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_ofono_persona_store_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_ofono_persona_store_real_prepare_co (_data_);
}


static void folks_backends_ofono_persona_store_real_prepare_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsOfonoPersonaStorePrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static void folks_backends_ofono_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsOfonoPersonaStorePrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backends_ofono_persona_store_real_prepare_co (_data_);
}


static void __folks_backends_ofono_persona_store_property_changed_org_ofono_sim_manager_property_changed (orgofonoSimManager* _sender, const gchar* property, GVariant* value, gpointer self) {
	_folks_backends_ofono_persona_store_property_changed ((FolksBackendsOfonoPersonaStore*) self, property, value);
}


static gboolean folks_backends_ofono_persona_store_real_prepare_co (FolksBackendsOfonoPersonaStorePrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	folks_internal_profiling_start ("preparing Ofono.PersonaStore (ID: %s)", _data_->_tmp1_, NULL);
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = _data_->self->priv->_is_prepared;
	if (_data_->_tmp3_) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp4_ = FALSE;
		_data_->_tmp4_ = _data_->self->priv->_prepare_pending;
		_data_->_tmp2_ = _data_->_tmp4_;
	}
	if (_data_->_tmp2_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->self->priv->_path;
		_data_->_state_ = 1;
		g_async_initable_new_async (ORG_OFONO_TYPE_PHONEBOOK_PROXY, 0, NULL, folks_backends_ofono_persona_store_prepare_ready, _data_, "g-flags", 0, "g-name", "org.ofono", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", (const gchar*) _data_->_tmp6_, "g-interface-name", "org.ofono.Phonebook", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp5_ = (orgofonoPhonebook*) _data_->_tmp7_;
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_DBUS_ERROR) {
				goto __catch3_g_dbus_error;
			}
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch3_g_io_error;
			}
			{
				_data_->self->priv->_is_prepared = TRUE;
				g_object_notify ((GObject*) _data_->self, "is-prepared");
				_data_->self->priv->_is_quiescent = TRUE;
				g_object_notify ((GObject*) _data_->self, "is-quiescent");
				_data_->self->priv->_prepare_pending = FALSE;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->_tmp5_;
		_data_->_tmp5_ = NULL;
		_g_object_unref0 (_data_->self->priv->_ofono_phonebook);
		_data_->self->priv->_ofono_phonebook = _data_->_tmp8_;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->self->priv->_path;
		_data_->_state_ = 2;
		g_async_initable_new_async (ORG_OFONO_TYPE_SIM_MANAGER_PROXY, 0, NULL, folks_backends_ofono_persona_store_prepare_ready, _data_, "g-flags", 0, "g-name", "org.ofono", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", (const gchar*) _data_->_tmp9_, "g-interface-name", "org.ofono.SimManager", NULL);
		return FALSE;
		_state_2:
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->sim_manager = (orgofonoSimManager*) _data_->_tmp10_;
		if (_data_->_inner_error_ != NULL) {
			_g_object_unref0 (_data_->_tmp5_);
			if (_data_->_inner_error_->domain == G_DBUS_ERROR) {
				goto __catch3_g_dbus_error;
			}
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch3_g_io_error;
			}
			_g_object_unref0 (_data_->_tmp5_);
			{
				_data_->self->priv->_is_prepared = TRUE;
				g_object_notify ((GObject*) _data_->self, "is-prepared");
				_data_->self->priv->_is_quiescent = TRUE;
				g_object_notify ((GObject*) _data_->self, "is-quiescent");
				_data_->self->priv->_prepare_pending = FALSE;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->sim_manager;
		g_signal_connect_object (_data_->_tmp11_, "property-changed", (GCallback) __folks_backends_ofono_persona_store_property_changed_org_ofono_sim_manager_property_changed, _data_->self, 0);
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->self->priv->_ofono_phonebook;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = org_ofono_phonebook_Import (_data_->_tmp12_, &_data_->_inner_error_);
		_data_->all_vcards = _data_->_tmp13_;
		if (_data_->_inner_error_ != NULL) {
			_g_object_unref0 (_data_->sim_manager);
			_g_object_unref0 (_data_->_tmp5_);
			if (_data_->_inner_error_->domain == G_DBUS_ERROR) {
				goto __catch3_g_dbus_error;
			}
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch3_g_io_error;
			}
			_g_object_unref0 (_data_->sim_manager);
			_g_object_unref0 (_data_->_tmp5_);
			{
				_data_->self->priv->_is_prepared = TRUE;
				g_object_notify ((GObject*) _data_->self, "is-prepared");
				_data_->self->priv->_is_quiescent = TRUE;
				g_object_notify ((GObject*) _data_->self, "is-quiescent");
				_data_->self->priv->_prepare_pending = FALSE;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->all_vcards;
		_data_->_tmp15_ = 0;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _folks_backends_ofono_persona_store_split_all_vcards (_data_->self, _data_->_tmp14_, &_data_->_tmp15_);
		_data_->vcards_length1 = 0;
		_data_->_vcards_size_ = 0;
		_data_->vcards = _data_->_tmp16_;
		_data_->vcards_length1 = _data_->_tmp15_;
		_data_->_vcards_size_ = _data_->vcards_length1;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = gee_hash_set_new (FOLKS_BACKENDS_OFONO_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		_data_->added_personas = _data_->_tmp17_;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18__length1 = 0;
		_data_->_tmp18_ = _data_->vcards;
		_data_->_tmp18__length1 = _data_->vcards_length1;
		{
			_data_->vcard_collection_length1 = 0;
			_data_->_vcard_collection_size_ = 0;
			_data_->vcard_collection = _data_->_tmp18_;
			_data_->vcard_collection_length1 = _data_->_tmp18__length1;
			for (_data_->vcard_it = 0; _data_->vcard_it < _data_->_tmp18__length1; _data_->vcard_it = _data_->vcard_it + 1) {
				_data_->_tmp19_ = NULL;
				_data_->_tmp19_ = g_strdup (_data_->vcard_collection[_data_->vcard_it]);
				_data_->vcard = _data_->_tmp19_;
				{
					_data_->_tmp20_ = NULL;
					_data_->_tmp20_ = _data_->vcard;
					_data_->_tmp21_ = NULL;
					_data_->_tmp21_ = folks_backends_ofono_persona_new (_data_->_tmp20_, (FolksPersonaStore*) _data_->self);
					_data_->persona = _data_->_tmp21_;
					_data_->_tmp22_ = NULL;
					_data_->_tmp22_ = _data_->self->priv->_personas;
					_data_->_tmp23_ = NULL;
					_data_->_tmp23_ = _data_->persona;
					_data_->_tmp24_ = NULL;
					_data_->_tmp24_ = folks_persona_get_iid ((FolksPersona*) _data_->_tmp23_);
					_data_->_tmp25_ = NULL;
					_data_->_tmp25_ = _data_->_tmp24_;
					_data_->_tmp26_ = NULL;
					_data_->_tmp26_ = _data_->persona;
					gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp22_, _data_->_tmp25_, _data_->_tmp26_);
					_data_->_tmp27_ = NULL;
					_data_->_tmp27_ = _data_->added_personas;
					_data_->_tmp28_ = NULL;
					_data_->_tmp28_ = _data_->persona;
					gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp27_, _data_->_tmp28_);
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->vcard);
				}
			}
		}
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = _data_->self->priv->_personas;
		_data_->_tmp30_ = 0;
		_data_->_tmp30_ = gee_abstract_map_get_size ((GeeMap*) _data_->_tmp29_);
		_data_->_tmp31_ = 0;
		_data_->_tmp31_ = _data_->_tmp30_;
		if (_data_->_tmp31_ > 0) {
			_data_->_tmp32_ = NULL;
			_data_->_tmp32_ = _data_->added_personas;
			_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) _data_->self, (GeeSet*) _data_->_tmp32_, NULL, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		}
		_g_object_unref0 (_data_->added_personas);
		_data_->vcards = (_vala_array_free (_data_->vcards, _data_->vcards_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->all_vcards);
		_g_object_unref0 (_data_->sim_manager);
		_g_object_unref0 (_data_->_tmp5_);
	}
	goto __finally3;
	__catch3_g_dbus_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = _data_->e;
		_data_->_tmp34_ = NULL;
		_data_->_tmp34_ = _data_->_tmp33_->message;
		g_warning ("ofono-persona-store.vala:235: DBus Error has occurred when fetching of" \
"ono phonebook, %s", _data_->_tmp34_);
		_folks_backends_ofono_persona_store_remove_self (_data_->self);
		_g_error_free0 (_data_->e);
	}
	goto __finally3;
	__catch3_g_io_error:
	{
		_data_->_vala1_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp35_ = NULL;
		_data_->_tmp35_ = _data_->_vala1_e;
		_data_->_tmp36_ = NULL;
		_data_->_tmp36_ = _data_->_tmp35_->message;
		g_warning ("ofono-persona-store.vala:240: IO Error has occurred when fetching ofon" \
"o phonebook, %s", _data_->_tmp36_);
		_folks_backends_ofono_persona_store_remove_self (_data_->self);
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally3:
	{
		_data_->self->priv->_is_prepared = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		_data_->self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-quiescent");
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (_data_->_inner_error_ != NULL) {
		if ((_data_->_inner_error_->domain == G_IO_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp38_ = NULL;
	_data_->_tmp38_ = _data_->_tmp37_;
	folks_internal_profiling_end ("preparing Ofono.PersonaStore (ID: %s)", _data_->_tmp38_, NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_backends_ofono_persona_store_real_remove_persona_data_free (gpointer _data) {
	FolksBackendsOfonoPersonaStoreRemovePersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsOfonoPersonaStoreRemovePersonaData, _data_);
}


static void folks_backends_ofono_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsOfonoPersonaStore * self;
	FolksBackendsOfonoPersonaStoreRemovePersonaData* _data_;
	FolksBackendsOfonoPersonaStore* _tmp0_ = NULL;
	FolksPersona* _tmp1_ = NULL;
	FolksPersona* _tmp2_ = NULL;
	self = (FolksBackendsOfonoPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsOfonoPersonaStoreRemovePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_ofono_persona_store_real_remove_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_ofono_persona_store_real_remove_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->persona);
	_data_->persona = _tmp2_;
	folks_backends_ofono_persona_store_real_remove_persona_co (_data_);
}


static void folks_backends_ofono_persona_store_real_remove_persona_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsOfonoPersonaStoreRemovePersonaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Remove a {@link Persona} from the PersonaStore.
   *
   * See {@link Folks.PersonaStore.remove_persona}.
   *
   * @throws Folks.PersonaStoreError.READ_ONLY every time since the
   * Ofono backend is read-only.
   *
   * @param persona the {@link Persona} to remove.
   *
   * @since 0.9.0
   */
static gboolean folks_backends_ofono_persona_store_real_remove_persona_co (FolksBackendsOfonoPersonaStoreRemovePersonaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_READ_ONLY, "Personas cannot be removed from this store.");
	_data_->_inner_error_ = _data_->_tmp0_;
	if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_backends_ofono_persona_store_real_add_persona_from_details_data_free (gpointer _data) {
	FolksBackendsOfonoPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _data;
	_g_hash_table_unref0 (_data_->details);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsOfonoPersonaStoreAddPersonaFromDetailsData, _data_);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void folks_backends_ofono_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsOfonoPersonaStore * self;
	FolksBackendsOfonoPersonaStoreAddPersonaFromDetailsData* _data_;
	FolksBackendsOfonoPersonaStore* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	self = (FolksBackendsOfonoPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsOfonoPersonaStoreAddPersonaFromDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_ofono_persona_store_real_add_persona_from_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_ofono_persona_store_real_add_persona_from_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = details;
	_tmp2_ = _g_hash_table_ref0 (_tmp1_);
	_g_hash_table_unref0 (_data_->details);
	_data_->details = _tmp2_;
	folks_backends_ofono_persona_store_real_add_persona_from_details_co (_data_);
}


static FolksPersona* folks_backends_ofono_persona_store_real_add_persona_from_details_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	FolksBackendsOfonoPersonaStoreAddPersonaFromDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Add a new {@link Persona} to the PersonaStore.
   *
   * See {@link Folks.PersonaStore.add_persona_from_details}.
   *
   * @throws Folks.PersonaStoreError.READ_ONLY every time since the
   * Ofono backend is read-only.
   *
   * @param details the details of the {@link Persona} to add.
   *
   * @since 0.9.0
   */
static gboolean folks_backends_ofono_persona_store_real_add_persona_from_details_co (FolksBackendsOfonoPersonaStoreAddPersonaFromDetailsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_READ_ONLY, "Personas cannot be added to this store.");
	_data_->_inner_error_ = _data_->_tmp0_;
	if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static const gchar* folks_backends_ofono_persona_store_real_get_type_id (FolksPersonaStore* base) {
	const gchar* result;
	FolksBackendsOfonoPersonaStore* self;
	self = (FolksBackendsOfonoPersonaStore*) base;
	result = BACKEND_NAME;
	return result;
}


static FolksMaybeBool folks_backends_ofono_persona_store_real_get_can_add_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	FolksBackendsOfonoPersonaStore* self;
	self = (FolksBackendsOfonoPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static FolksMaybeBool folks_backends_ofono_persona_store_real_get_can_alias_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	FolksBackendsOfonoPersonaStore* self;
	self = (FolksBackendsOfonoPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static FolksMaybeBool folks_backends_ofono_persona_store_real_get_can_group_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	FolksBackendsOfonoPersonaStore* self;
	self = (FolksBackendsOfonoPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static FolksMaybeBool folks_backends_ofono_persona_store_real_get_can_remove_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	FolksBackendsOfonoPersonaStore* self;
	self = (FolksBackendsOfonoPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static gboolean folks_backends_ofono_persona_store_real_get_is_prepared (FolksPersonaStore* base) {
	gboolean result;
	FolksBackendsOfonoPersonaStore* self;
	gboolean _tmp0_ = FALSE;
	self = (FolksBackendsOfonoPersonaStore*) base;
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


static gboolean folks_backends_ofono_persona_store_real_get_is_quiescent (FolksPersonaStore* base) {
	gboolean result;
	FolksBackendsOfonoPersonaStore* self;
	gboolean _tmp0_ = FALSE;
	self = (FolksBackendsOfonoPersonaStore*) base;
	_tmp0_ = self->priv->_is_quiescent;
	result = _tmp0_;
	return result;
}


static gchar** folks_backends_ofono_persona_store_real_get_always_writeable_properties (FolksPersonaStore* base, int* result_length1) {
	gchar** result;
	FolksBackendsOfonoPersonaStore* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (FolksBackendsOfonoPersonaStore*) base;
	_tmp0_ = folks_backends_ofono_persona_store__always_writeable_properties;
	_tmp0__length1 = folks_backends_ofono_persona_store__always_writeable_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static GeeMap* folks_backends_ofono_persona_store_real_get_personas (FolksPersonaStore* base) {
	GeeMap* result;
	FolksBackendsOfonoPersonaStore* self;
	GeeMap* _tmp0_ = NULL;
	self = (FolksBackendsOfonoPersonaStore*) base;
	_tmp0_ = self->priv->_personas_ro;
	result = _tmp0_;
	return result;
}


static void folks_backends_ofono_persona_store_class_init (FolksBackendsOfonoPersonaStoreClass * klass) {
	gchar** _tmp0_ = NULL;
	folks_backends_ofono_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsOfonoPersonaStorePrivate));
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare = folks_backends_ofono_persona_store_real_prepare;
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare_finish = folks_backends_ofono_persona_store_real_prepare_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona = folks_backends_ofono_persona_store_real_remove_persona;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona_finish = folks_backends_ofono_persona_store_real_remove_persona_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details = folks_backends_ofono_persona_store_real_add_persona_from_details;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details_finish = folks_backends_ofono_persona_store_real_add_persona_from_details_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_type_id = folks_backends_ofono_persona_store_real_get_type_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_add_personas = folks_backends_ofono_persona_store_real_get_can_add_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_alias_personas = folks_backends_ofono_persona_store_real_get_can_alias_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_group_personas = folks_backends_ofono_persona_store_real_get_can_group_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_remove_personas = folks_backends_ofono_persona_store_real_get_can_remove_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_prepared = folks_backends_ofono_persona_store_real_get_is_prepared;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_quiescent = folks_backends_ofono_persona_store_real_get_is_quiescent;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_always_writeable_properties = folks_backends_ofono_persona_store_real_get_always_writeable_properties;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_personas = folks_backends_ofono_persona_store_real_get_personas;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_ofono_persona_store_get_property;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_ofono_persona_store_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_STORE_TYPE_ID, g_param_spec_string ("type-id", "type-id", "type-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_ADD_PERSONAS, g_param_spec_enum ("can-add-personas", "can-add-personas", "can-add-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_ALIAS_PERSONAS, g_param_spec_enum ("can-alias-personas", "can-alias-personas", "can-alias-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_GROUP_PERSONAS, g_param_spec_enum ("can-group-personas", "can-group-personas", "can-group-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_REMOVE_PERSONAS, g_param_spec_enum ("can-remove-personas", "can-remove-personas", "can-remove-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_STORE_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_STORE_IS_QUIESCENT, g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES, g_param_spec_boxed ("always-writeable-properties", "always-writeable-properties", "always-writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_STORE_PERSONAS, g_param_spec_object ("personas", "personas", "personas", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	folks_backends_ofono_persona_store__always_writeable_properties = _tmp0_;
	folks_backends_ofono_persona_store__always_writeable_properties_length1 = 0;
}


static void folks_backends_ofono_persona_store_instance_init (FolksBackendsOfonoPersonaStore * self) {
	self->priv = FOLKS_BACKENDS_OFONO_PERSONA_STORE_GET_PRIVATE (self);
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_is_quiescent = FALSE;
	self->priv->_path = NULL;
	self->priv->_ofono_phonebook = NULL;
}


static void folks_backends_ofono_persona_store_finalize (GObject* obj) {
	FolksBackendsOfonoPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStore);
	_g_object_unref0 (self->priv->_personas);
	_g_object_unref0 (self->priv->_personas_ro);
	_g_free0 (self->priv->_path);
	_g_object_unref0 (self->priv->_ofono_phonebook);
	G_OBJECT_CLASS (folks_backends_ofono_persona_store_parent_class)->finalize (obj);
}


/**
 * A persona store which is associated with a single Ofono device. It will 
 * create a {@link Persona} for each contact on the SIM card phonebook.
 *
 * @since 0.9.0
 */
GType folks_backends_ofono_persona_store_get_type (void) {
	static volatile gsize folks_backends_ofono_persona_store_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_ofono_persona_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsOfonoPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_ofono_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsOfonoPersonaStore), 0, (GInstanceInitFunc) folks_backends_ofono_persona_store_instance_init, NULL };
		GType folks_backends_ofono_persona_store_type_id;
		folks_backends_ofono_persona_store_type_id = g_type_register_static (FOLKS_TYPE_PERSONA_STORE, "FolksBackendsOfonoPersonaStore", &g_define_type_info, 0);
		g_once_init_leave (&folks_backends_ofono_persona_store_type_id__volatile, folks_backends_ofono_persona_store_type_id);
	}
	return folks_backends_ofono_persona_store_type_id__volatile;
}


static void _vala_folks_backends_ofono_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsOfonoPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStore);
	switch (property_id) {
		case FOLKS_BACKENDS_OFONO_PERSONA_STORE_TYPE_ID:
		g_value_set_string (value, folks_persona_store_get_type_id ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_ADD_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_add_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_ALIAS_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_alias_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_GROUP_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_group_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_REMOVE_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_STORE_IS_PREPARED:
		g_value_set_boolean (value, folks_persona_store_get_is_prepared ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_STORE_IS_QUIESCENT:
		g_value_set_boolean (value, folks_persona_store_get_is_quiescent ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_store_get_always_writeable_properties ((FolksPersonaStore*) self, &length));
		}
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_STORE_PERSONAS:
		g_value_set_object (value, folks_persona_store_get_personas ((FolksPersonaStore*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



