/* Test for labels and VM declarations: bug 12913.
   goto statements must not jump into the scope of VM declarations.

   This tests all combinations of label and goto locations in a given
   function.

   c99-vla-jump-1.c tests with just that label and goto, VLAs.
   c99-vla-jump-2.c tests with many other labels and gotos, VLAs.
   c99-vla-jump-3.c tests with just that label and goto, VM.
   c99-vla-jump-4.c tests with many other labels and gotos, VM.
   c99-vla-jump-5.c tests with switch statements.  */

/* Origin: Joseph Myers <joseph@codesourcery.com> */
/* { dg-do compile } */
/* { dg-options "-std=iso9899:1999 -pedantic-errors" } */

void fa0 (int n) {  goto a; a:{ int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa1 (int n) {  goto a; { int b[n]; a:{ int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "21:jump into scope of identifier with variably modified type" } */
void fa2 (int n) {  goto a; { int b[n]; { int c[n]; a:0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "21:jump into scope of identifier with variably modified type" } */
void fa3 (int n) {  goto a; { int b[n]; { int c[n]; 0;} a:{ int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "21:jump into scope of identifier with variably modified type" } */
void fa4 (int n) {  goto a; { int b[n]; { int c[n]; 0;} { int d[n]; a:0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "21:jump into scope of identifier with variably modified type" } */
void fa5 (int n) {  goto a; { int b[n]; { int c[n]; 0;} { int d[n]; 0;} a:; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "21:jump into scope of identifier with variably modified type" } */
void fa6 (int n) {  goto a; { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; a:0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa7 (int n) {  goto a; { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; a:{ int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa8 (int n) {  goto a; { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; a:{ int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa9 (int n) {  goto a; { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; a:0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa10 (int n) {  goto a; { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; a:{ int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa11 (int n) {  goto a; { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; a:0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa12 (int n) {  goto a; { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; a:; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa13 (int n) {  goto a; { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; a:0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa14 (int n) {  goto a; { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; a:; int j[n]; 0; }
void fa15 (int n) {  goto a; { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; a:0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa16 (int n) { a: goto a; { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa17 (int n) { a:{ int b[n];  goto a; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa18 (int n) { { int b[n];  goto a; a:{ int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa19 (int n) { { int b[n];  goto a; { int c[n]; a:0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa20 (int n) { { int b[n];  goto a; { int c[n]; 0;} a:{ int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa21 (int n) { { int b[n];  goto a; { int c[n]; 0;} { int d[n]; a:0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa22 (int n) { { int b[n];  goto a; { int c[n]; 0;} { int d[n]; 0;} a:; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa23 (int n) { { int b[n];  goto a; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; a:0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa24 (int n) { { int b[n];  goto a; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; a:{ int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa25 (int n) { { int b[n];  goto a; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; a:{ int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa26 (int n) { { int b[n];  goto a; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; a:0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa27 (int n) { { int b[n];  goto a; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; a:{ int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa28 (int n) { { int b[n];  goto a; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; a:0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa29 (int n) { { int b[n];  goto a; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; a:; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa30 (int n) { { int b[n];  goto a; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; a:0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa31 (int n) { { int b[n];  goto a; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; a:; int j[n]; 0; }
void fa32 (int n) { { int b[n];  goto a; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; a:0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa33 (int n) { { int b[n]; a: goto a; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa34 (int n) { a:{ int b[n]; { int c[n];  goto a; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa35 (int n) { { int b[n]; a:{ int c[n];  goto a; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa36 (int n) { { int b[n]; { int c[n];  goto a; a:0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa37 (int n) { { int b[n]; { int c[n];  goto a; 0;} a:{ int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa38 (int n) { { int b[n]; { int c[n];  goto a; 0;} { int d[n]; a:0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa39 (int n) { { int b[n]; { int c[n];  goto a; 0;} { int d[n]; 0;} a:; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa40 (int n) { { int b[n]; { int c[n];  goto a; 0;} { int d[n]; 0;} ; int e[n]; a:0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa41 (int n) { { int b[n]; { int c[n];  goto a; 0;} { int d[n]; 0;} ; int e[n]; 0;}; a:{ int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa42 (int n) { { int b[n]; { int c[n];  goto a; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; a:{ int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa43 (int n) { { int b[n]; { int c[n];  goto a; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; a:0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa44 (int n) { { int b[n]; { int c[n];  goto a; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; a:{ int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa45 (int n) { { int b[n]; { int c[n];  goto a; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; a:0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa46 (int n) { { int b[n]; { int c[n];  goto a; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; a:; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa47 (int n) { { int b[n]; { int c[n];  goto a; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; a:0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa48 (int n) { { int b[n]; { int c[n];  goto a; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; a:; int j[n]; 0; }
void fa49 (int n) { { int b[n]; { int c[n];  goto a; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; a:0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa50 (int n) { { int b[n]; { int c[n]; a: goto a; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa51 (int n) { a:{ int b[n]; { int c[n]; 0;}  goto a; { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa52 (int n) { { int b[n]; a:{ int c[n]; 0;}  goto a; { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa53 (int n) { { int b[n]; { int c[n]; a:0;}  goto a; { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa54 (int n) { { int b[n]; { int c[n]; 0;}  goto a; a:{ int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa55 (int n) { { int b[n]; { int c[n]; 0;}  goto a; { int d[n]; a:0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa56 (int n) { { int b[n]; { int c[n]; 0;}  goto a; { int d[n]; 0;} a:; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa57 (int n) { { int b[n]; { int c[n]; 0;}  goto a; { int d[n]; 0;} ; int e[n]; a:0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa58 (int n) { { int b[n]; { int c[n]; 0;}  goto a; { int d[n]; 0;} ; int e[n]; 0;}; a:{ int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa59 (int n) { { int b[n]; { int c[n]; 0;}  goto a; { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; a:{ int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa60 (int n) { { int b[n]; { int c[n]; 0;}  goto a; { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; a:0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa61 (int n) { { int b[n]; { int c[n]; 0;}  goto a; { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; a:{ int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa62 (int n) { { int b[n]; { int c[n]; 0;}  goto a; { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; a:0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa63 (int n) { { int b[n]; { int c[n]; 0;}  goto a; { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; a:; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa64 (int n) { { int b[n]; { int c[n]; 0;}  goto a; { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; a:0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa65 (int n) { { int b[n]; { int c[n]; 0;}  goto a; { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; a:; int j[n]; 0; }
void fa66 (int n) { { int b[n]; { int c[n]; 0;}  goto a; { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; a:0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa67 (int n) { { int b[n]; { int c[n]; 0;} a: goto a; { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa68 (int n) { a:{ int b[n]; { int c[n]; 0;} { int d[n];  goto a; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa69 (int n) { { int b[n]; a:{ int c[n]; 0;} { int d[n];  goto a; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa70 (int n) { { int b[n]; { int c[n]; a:0;} { int d[n];  goto a; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa71 (int n) { { int b[n]; { int c[n]; 0;} a:{ int d[n];  goto a; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa72 (int n) { { int b[n]; { int c[n]; 0;} { int d[n];  goto a; a:0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa73 (int n) { { int b[n]; { int c[n]; 0;} { int d[n];  goto a; 0;} a:; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa74 (int n) { { int b[n]; { int c[n]; 0;} { int d[n];  goto a; 0;} ; int e[n]; a:0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa75 (int n) { { int b[n]; { int c[n]; 0;} { int d[n];  goto a; 0;} ; int e[n]; 0;}; a:{ int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa76 (int n) { { int b[n]; { int c[n]; 0;} { int d[n];  goto a; 0;} ; int e[n]; 0;}; { int f[n]; a:{ int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa77 (int n) { { int b[n]; { int c[n]; 0;} { int d[n];  goto a; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; a:0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa78 (int n) { { int b[n]; { int c[n]; 0;} { int d[n];  goto a; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; a:{ int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa79 (int n) { { int b[n]; { int c[n]; 0;} { int d[n];  goto a; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; a:0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa80 (int n) { { int b[n]; { int c[n]; 0;} { int d[n];  goto a; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; a:; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa81 (int n) { { int b[n]; { int c[n]; 0;} { int d[n];  goto a; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; a:0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa82 (int n) { { int b[n]; { int c[n]; 0;} { int d[n];  goto a; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; a:; int j[n]; 0; }
void fa83 (int n) { { int b[n]; { int c[n]; 0;} { int d[n];  goto a; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; a:0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa84 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; a: goto a; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa85 (int n) { a:{ int b[n]; { int c[n]; 0;} { int d[n]; 0;}  goto a; ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa86 (int n) { { int b[n]; a:{ int c[n]; 0;} { int d[n]; 0;}  goto a; ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa87 (int n) { { int b[n]; { int c[n]; a:0;} { int d[n]; 0;}  goto a; ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa88 (int n) { { int b[n]; { int c[n]; 0;} a:{ int d[n]; 0;}  goto a; ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa89 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; a:0;}  goto a; ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa90 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;}  goto a; a:; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa91 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;}  goto a; ; int e[n]; a:0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa92 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;}  goto a; ; int e[n]; 0;}; a:{ int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa93 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;}  goto a; ; int e[n]; 0;}; { int f[n]; a:{ int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa94 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;}  goto a; ; int e[n]; 0;}; { int f[n]; { int g[n]; a:0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa95 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;}  goto a; ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; a:{ int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa96 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;}  goto a; ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; a:0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa97 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;}  goto a; ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; a:; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa98 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;}  goto a; ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; a:0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa99 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;}  goto a; ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; a:; int j[n]; 0; }
void fa100 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;}  goto a; ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; a:0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa101 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} a: goto a; ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa102 (int n) { a:{ int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n];  goto a; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa103 (int n) { { int b[n]; a:{ int c[n]; 0;} { int d[n]; 0;} ; int e[n];  goto a; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa104 (int n) { { int b[n]; { int c[n]; a:0;} { int d[n]; 0;} ; int e[n];  goto a; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa105 (int n) { { int b[n]; { int c[n]; 0;} a:{ int d[n]; 0;} ; int e[n];  goto a; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa106 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; a:0;} ; int e[n];  goto a; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa107 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} a:; int e[n];  goto a; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa108 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n];  goto a; a:0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa109 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n];  goto a; 0;}; a:{ int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa110 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n];  goto a; 0;}; { int f[n]; a:{ int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa111 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n];  goto a; 0;}; { int f[n]; { int g[n]; a:0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa112 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n];  goto a; 0;}; { int f[n]; { int g[n]; 0;}; a:{ int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa113 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n];  goto a; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; a:0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa114 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n];  goto a; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; a:; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa115 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n];  goto a; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; a:0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa116 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n];  goto a; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; a:; int j[n]; 0; }
void fa117 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n];  goto a; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; a:0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa118 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; a: goto a; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa119 (int n) { a:{ int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;};  goto a; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa120 (int n) { { int b[n]; a:{ int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;};  goto a; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa121 (int n) { { int b[n]; { int c[n]; a:0;} { int d[n]; 0;} ; int e[n]; 0;};  goto a; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa122 (int n) { { int b[n]; { int c[n]; 0;} a:{ int d[n]; 0;} ; int e[n]; 0;};  goto a; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa123 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; a:0;} ; int e[n]; 0;};  goto a; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa124 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} a:; int e[n]; 0;};  goto a; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa125 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; a:0;};  goto a; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa126 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;};  goto a; a:{ int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa127 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;};  goto a; { int f[n]; a:{ int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa128 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;};  goto a; { int f[n]; { int g[n]; a:0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa129 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;};  goto a; { int f[n]; { int g[n]; 0;}; a:{ int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa130 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;};  goto a; { int f[n]; { int g[n]; 0;}; { int h[n]; a:0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa131 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;};  goto a; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; a:; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa132 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;};  goto a; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; a:0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa133 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;};  goto a; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; a:; int j[n]; 0; }
void fa134 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;};  goto a; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; a:0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa135 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; a: goto a; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa136 (int n) { a:{ int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n];  goto a; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa137 (int n) { { int b[n]; a:{ int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n];  goto a; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa138 (int n) { { int b[n]; { int c[n]; a:0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n];  goto a; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa139 (int n) { { int b[n]; { int c[n]; 0;} a:{ int d[n]; 0;} ; int e[n]; 0;}; { int f[n];  goto a; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa140 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; a:0;} ; int e[n]; 0;}; { int f[n];  goto a; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa141 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} a:; int e[n]; 0;}; { int f[n];  goto a; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa142 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; a:0;}; { int f[n];  goto a; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa143 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; a:{ int f[n];  goto a; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa144 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n];  goto a; a:{ int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa145 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n];  goto a; { int g[n]; a:0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa146 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n];  goto a; { int g[n]; 0;}; a:{ int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa147 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n];  goto a; { int g[n]; 0;}; { int h[n]; a:0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa148 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n];  goto a; { int g[n]; 0;}; { int h[n]; 0;}; a:; int i[n]; 0;}; ; int j[n]; 0; }
void fa149 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n];  goto a; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; a:0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa150 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n];  goto a; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; a:; int j[n]; 0; }
void fa151 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n];  goto a; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; a:0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa152 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; a: goto a; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa153 (int n) { a:{ int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n];  goto a; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa154 (int n) { { int b[n]; a:{ int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n];  goto a; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa155 (int n) { { int b[n]; { int c[n]; a:0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n];  goto a; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa156 (int n) { { int b[n]; { int c[n]; 0;} a:{ int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n];  goto a; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa157 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; a:0;} ; int e[n]; 0;}; { int f[n]; { int g[n];  goto a; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa158 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} a:; int e[n]; 0;}; { int f[n]; { int g[n];  goto a; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa159 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; a:0;}; { int f[n]; { int g[n];  goto a; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa160 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; a:{ int f[n]; { int g[n];  goto a; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa161 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; a:{ int g[n];  goto a; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa162 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n];  goto a; a:0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa163 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n];  goto a; 0;}; a:{ int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa164 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n];  goto a; 0;}; { int h[n]; a:0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa165 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n];  goto a; 0;}; { int h[n]; 0;}; a:; int i[n]; 0;}; ; int j[n]; 0; }
void fa166 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n];  goto a; 0;}; { int h[n]; 0;}; ; int i[n]; a:0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa167 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n];  goto a; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; a:; int j[n]; 0; }
void fa168 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n];  goto a; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; a:0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa169 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; a: goto a; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa170 (int n) { a:{ int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;};  goto a; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa171 (int n) { { int b[n]; a:{ int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;};  goto a; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa172 (int n) { { int b[n]; { int c[n]; a:0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;};  goto a; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa173 (int n) { { int b[n]; { int c[n]; 0;} a:{ int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;};  goto a; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa174 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; a:0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;};  goto a; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa175 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} a:; int e[n]; 0;}; { int f[n]; { int g[n]; 0;};  goto a; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa176 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; a:0;}; { int f[n]; { int g[n]; 0;};  goto a; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa177 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; a:{ int f[n]; { int g[n]; 0;};  goto a; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa178 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; a:{ int g[n]; 0;};  goto a; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa179 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; a:0;};  goto a; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa180 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;};  goto a; a:{ int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa181 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;};  goto a; { int h[n]; a:0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa182 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;};  goto a; { int h[n]; 0;}; a:; int i[n]; 0;}; ; int j[n]; 0; }
void fa183 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;};  goto a; { int h[n]; 0;}; ; int i[n]; a:0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa184 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;};  goto a; { int h[n]; 0;}; ; int i[n]; 0;}; a:; int j[n]; 0; }
void fa185 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;};  goto a; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; a:0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa186 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; a: goto a; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa187 (int n) { a:{ int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n];  goto a; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa188 (int n) { { int b[n]; a:{ int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n];  goto a; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa189 (int n) { { int b[n]; { int c[n]; a:0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n];  goto a; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa190 (int n) { { int b[n]; { int c[n]; 0;} a:{ int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n];  goto a; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa191 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; a:0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n];  goto a; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa192 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} a:; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n];  goto a; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa193 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; a:0;}; { int f[n]; { int g[n]; 0;}; { int h[n];  goto a; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa194 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; a:{ int f[n]; { int g[n]; 0;}; { int h[n];  goto a; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa195 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; a:{ int g[n]; 0;}; { int h[n];  goto a; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa196 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; a:0;}; { int h[n];  goto a; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa197 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; a:{ int h[n];  goto a; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa198 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n];  goto a; a:0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa199 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n];  goto a; 0;}; a:; int i[n]; 0;}; ; int j[n]; 0; }
void fa200 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n];  goto a; 0;}; ; int i[n]; a:0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa201 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n];  goto a; 0;}; ; int i[n]; 0;}; a:; int j[n]; 0; }
void fa202 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n];  goto a; 0;}; ; int i[n]; 0;}; ; int j[n]; a:0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa203 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; a: goto a; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa204 (int n) { a:{ int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;};  goto a; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa205 (int n) { { int b[n]; a:{ int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;};  goto a; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa206 (int n) { { int b[n]; { int c[n]; a:0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;};  goto a; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa207 (int n) { { int b[n]; { int c[n]; 0;} a:{ int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;};  goto a; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa208 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; a:0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;};  goto a; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa209 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} a:; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;};  goto a; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa210 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; a:0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;};  goto a; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa211 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; a:{ int f[n]; { int g[n]; 0;}; { int h[n]; 0;};  goto a; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa212 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; a:{ int g[n]; 0;}; { int h[n]; 0;};  goto a; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa213 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; a:0;}; { int h[n]; 0;};  goto a; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa214 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; a:{ int h[n]; 0;};  goto a; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa215 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; a:0;};  goto a; ; int i[n]; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa216 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;};  goto a; a:; int i[n]; 0;}; ; int j[n]; 0; }
void fa217 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;};  goto a; ; int i[n]; a:0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa218 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;};  goto a; ; int i[n]; 0;}; a:; int j[n]; 0; }
void fa219 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;};  goto a; ; int i[n]; 0;}; ; int j[n]; a:0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa220 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; a: goto a; ; int i[n]; 0;}; ; int j[n]; 0; }
void fa221 (int n) { a:{ int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n];  goto a; 0;}; ; int j[n]; 0; }
void fa222 (int n) { { int b[n]; a:{ int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n];  goto a; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa223 (int n) { { int b[n]; { int c[n]; a:0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n];  goto a; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa224 (int n) { { int b[n]; { int c[n]; 0;} a:{ int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n];  goto a; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa225 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; a:0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n];  goto a; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa226 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} a:; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n];  goto a; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa227 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; a:0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n];  goto a; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa228 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; a:{ int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n];  goto a; 0;}; ; int j[n]; 0; }
void fa229 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; a:{ int g[n]; 0;}; { int h[n]; 0;}; ; int i[n];  goto a; 0;}; ; int j[n]; 0; }
void fa230 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; a:0;}; { int h[n]; 0;}; ; int i[n];  goto a; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa231 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; a:{ int h[n]; 0;}; ; int i[n];  goto a; 0;}; ; int j[n]; 0; }
void fa232 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; a:0;}; ; int i[n];  goto a; 0;}; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa233 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; a:; int i[n];  goto a; 0;}; ; int j[n]; 0; }
void fa234 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n];  goto a; a:0;}; ; int j[n]; 0; }
void fa235 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n];  goto a; 0;}; a:; int j[n]; 0; }
void fa236 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n];  goto a; 0;}; ; int j[n]; a:0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa237 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; a: goto a; 0;}; ; int j[n]; 0; }
void fa238 (int n) { a:{ int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;};  goto a; ; int j[n]; 0; }
void fa239 (int n) { { int b[n]; a:{ int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;};  goto a; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa240 (int n) { { int b[n]; { int c[n]; a:0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;};  goto a; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa241 (int n) { { int b[n]; { int c[n]; 0;} a:{ int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;};  goto a; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa242 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; a:0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;};  goto a; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa243 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} a:; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;};  goto a; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa244 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; a:0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;};  goto a; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa245 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; a:{ int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;};  goto a; ; int j[n]; 0; }
void fa246 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; a:{ int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;};  goto a; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa247 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; a:0;}; { int h[n]; 0;}; ; int i[n]; 0;};  goto a; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa248 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; a:{ int h[n]; 0;}; ; int i[n]; 0;};  goto a; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa249 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; a:0;}; ; int i[n]; 0;};  goto a; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa250 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; a:; int i[n]; 0;};  goto a; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa251 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; a:0;};  goto a; ; int j[n]; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa252 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;};  goto a; a:; int j[n]; 0; }
void fa253 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;};  goto a; ; int j[n]; a:0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa254 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; a: goto a; ; int j[n]; 0; }
void fa255 (int n) { a:{ int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n];  goto a; 0; }
void fa256 (int n) { { int b[n]; a:{ int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n];  goto a; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa257 (int n) { { int b[n]; { int c[n]; a:0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n];  goto a; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa258 (int n) { { int b[n]; { int c[n]; 0;} a:{ int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n];  goto a; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa259 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; a:0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n];  goto a; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa260 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} a:; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n];  goto a; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa261 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; a:0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n];  goto a; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa262 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; a:{ int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n];  goto a; 0; }
void fa263 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; a:{ int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n];  goto a; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa264 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; a:0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n];  goto a; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa265 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; a:{ int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n];  goto a; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa266 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; a:0;}; ; int i[n]; 0;}; ; int j[n];  goto a; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa267 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; a:; int i[n]; 0;}; ; int j[n];  goto a; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa268 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; a:0;}; ; int j[n];  goto a; 0; } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa269 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; a:; int j[n];  goto a; 0; }
void fa270 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n];  goto a; a:0; }
void fa271 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; a: goto a; 0; }
void fa272 (int n) { a:{ int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; goto a;  }
void fa273 (int n) { { int b[n]; a:{ int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; goto a;  } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa274 (int n) { { int b[n]; { int c[n]; a:0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; goto a;  } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa275 (int n) { { int b[n]; { int c[n]; 0;} a:{ int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; goto a;  } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa276 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; a:0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; goto a;  } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa277 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} a:; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; goto a;  } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa278 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; a:0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; goto a;  } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa279 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; a:{ int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; goto a;  }
void fa280 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; a:{ int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; goto a;  } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa281 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; a:0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; goto a;  } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa282 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; a:{ int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0; goto a;  } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa283 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; a:0;}; ; int i[n]; 0;}; ; int j[n]; 0; goto a;  } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa284 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; a:; int i[n]; 0;}; ; int j[n]; 0; goto a;  } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa285 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; a:0;}; ; int j[n]; 0; goto a;  } /* { dg-error "jump into scope of identifier with variably modified type" } */
void fa286 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; a:; int j[n]; 0; goto a;  }
void fa287 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; a:0; goto a;  }
void fa288 (int n) { { int b[n]; { int c[n]; 0;} { int d[n]; 0;} ; int e[n]; 0;}; { int f[n]; { int g[n]; 0;}; { int h[n]; 0;}; ; int i[n]; 0;}; ; int j[n]; 0;a: goto a;  }

/* Match extra informative notes.  */
/* { dg-message "note: label '\[^\n'\]*' defined here" "note: defined" { target *-*-* } 0 } */
/* { dg-message "note: '\[^\n'\]*' declared here" "note: declared" { target *-*-* } 0 } */
