/* contacts-app.c generated by valac 0.26.0.27-f1f8, the Vala compiler
 * generated from contacts-app.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks.h>
#include <glib/gi18n-lib.h>
#include <folks/folks-eds.h>
#include <contacts-esd-setup.h>
#include <libedataserver/libedataserver.h>
#include <config.h>
#include <gdk/gdk.h>
#include <libgd/gd.h>
#include <pango/pango.h>
#include <gee.h>


#define CONTACTS_TYPE_APP (contacts_app_get_type ())
#define CONTACTS_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_APP, ContactsApp))
#define CONTACTS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_APP, ContactsAppClass))
#define CONTACTS_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_APP))
#define CONTACTS_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_APP))
#define CONTACTS_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_APP, ContactsAppClass))

typedef struct _ContactsApp ContactsApp;
typedef struct _ContactsAppClass ContactsAppClass;
typedef struct _ContactsAppPrivate ContactsAppPrivate;

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;

#define CONTACTS_TYPE_WINDOW (contacts_window_get_type ())
#define CONTACTS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_WINDOW, ContactsWindow))
#define CONTACTS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_WINDOW, ContactsWindowClass))
#define CONTACTS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_WINDOW))
#define CONTACTS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_WINDOW))
#define CONTACTS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_WINDOW, ContactsWindowClass))

typedef struct _ContactsWindow ContactsWindow;
typedef struct _ContactsWindowClass ContactsWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _ContactsContactPrivate ContactsContactPrivate;
typedef struct _Block2Data Block2Data;
typedef struct _ContactsAppShowIndividualData ContactsAppShowIndividualData;

#define CONTACTS_TYPE_ACCOUNTS_LIST (contacts_accounts_list_get_type ())
#define CONTACTS_ACCOUNTS_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_ACCOUNTS_LIST, ContactsAccountsList))
#define CONTACTS_ACCOUNTS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_ACCOUNTS_LIST, ContactsAccountsListClass))
#define CONTACTS_IS_ACCOUNTS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_ACCOUNTS_LIST))
#define CONTACTS_IS_ACCOUNTS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_ACCOUNTS_LIST))
#define CONTACTS_ACCOUNTS_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_ACCOUNTS_LIST, ContactsAccountsListClass))

typedef struct _ContactsAccountsList ContactsAccountsList;
typedef struct _ContactsAccountsListClass ContactsAccountsListClass;
typedef struct _Block3Data Block3Data;
typedef struct _ContactsAccountsListPrivate ContactsAccountsListPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _ContactsAppShowByEmailData ContactsAppShowByEmailData;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _ContactsApp {
	GtkApplication parent_instance;
	ContactsAppPrivate * priv;
	GSettings* settings;
	ContactsStore* contacts_store;
	ContactsWindow* window;
};

struct _ContactsAppClass {
	GtkApplicationClass parent_class;
};

struct _ContactsAppPrivate {
	gboolean is_prepare_scheluded;
	gboolean is_quiescent_scheduled;
};

struct _Block1Data {
	int _ref_count_;
	ContactsApp* self;
	gchar* id;
	gpointer _async_data_;
};

typedef gboolean (*ContactsStoreContactMatcher) (ContactsContact* c, void* user_data);
struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	gboolean is_main;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	FolksIndividual* individual;
	FolksPersona* fake_persona;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	GtkMessageDialog* dialog;
};

struct _ContactsAppShowIndividualData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ContactsApp* self;
	gchar* id;
	Block1Data* _data1_;
	const gchar* _tmp0_;
	ContactsContact* contact;
	ContactsStore* _tmp1_;
	ContactsContact* _tmp2_;
	ContactsContact* _tmp3_;
	ContactsContact* _tmp4_;
	Block2Data* _data2_;
	ContactsApp* _tmp5_;
	ContactsWindow* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GtkMessageDialog* _tmp9_;
	GtkMessageDialog* _tmp10_;
	const gchar* _tmp11_;
	GtkMessageDialog* _tmp12_;
	GtkMessageDialog* _tmp13_;
};

struct _Block3Data {
	int _ref_count_;
	ContactsApp* self;
	GtkDialog* dialog;
	GtkWidget* ok_button;
	ContactsAccountsList* acc;
	gulong active_button_once;
	gulong stores_changed_id;
};

struct _ContactsAccountsList {
	GtkGrid parent_instance;
	ContactsAccountsListPrivate * priv;
	FolksPersonaStore* selected_store;
};

struct _ContactsAccountsListClass {
	GtkGridClass parent_class;
};

struct _Block4Data {
	int _ref_count_;
	ContactsApp* self;
	gchar* email_address;
	gpointer _async_data_;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	GtkMessageDialog* dialog;
};

struct _ContactsAppShowByEmailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ContactsApp* self;
	gchar* email_address;
	Block4Data* _data4_;
	const gchar* _tmp0_;
	ContactsContact* contact;
	ContactsStore* _tmp1_;
	ContactsContact* _tmp2_;
	ContactsContact* _tmp3_;
	ContactsContact* _tmp4_;
	Block5Data* _data5_;
	ContactsApp* _tmp5_;
	ContactsWindow* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GtkMessageDialog* _tmp9_;
	GtkMessageDialog* _tmp10_;
	const gchar* _tmp11_;
	GtkMessageDialog* _tmp12_;
	GtkMessageDialog* _tmp13_;
};

struct _Block6Data {
	int _ref_count_;
	ContactsApp* self;
	gchar* query;
};

struct _Block7Data {
	int _ref_count_;
	ContactsApp* self;
	gulong id;
	guint id2;
};

struct _Block8Data {
	int _ref_count_;
	ContactsApp* self;
	gulong id;
	guint id2;
};


static gpointer contacts_app_parent_class = NULL;
extern ContactsApp* contacts_app_app;
ContactsApp* contacts_app_app = NULL;
static gchar* contacts_app_individual_id;
static gchar* contacts_app_individual_id = NULL;
static gchar* contacts_app_email_address;
static gchar* contacts_app_email_address = NULL;
static gchar* contacts_app_search_terms;
static gchar* contacts_app_search_terms = NULL;

GType contacts_app_get_type (void) G_GNUC_CONST;
GType contacts_store_get_type (void) G_GNUC_CONST;
GType contacts_window_get_type (void) G_GNUC_CONST;
#define CONTACTS_APP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_APP, ContactsAppPrivate))
enum  {
	CONTACTS_APP_DUMMY_PROPERTY
};
GType contacts_contact_get_type (void) G_GNUC_CONST;
void contacts_app_show_contact (ContactsApp* self, ContactsContact* contact);
void contacts_window_set_shown_contact (ContactsWindow* self, ContactsContact* c);
static void contacts_app_show_individual_data_free (gpointer _data);
void contacts_app_show_individual (ContactsApp* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void contacts_app_show_individual_finish (ContactsApp* self, GAsyncResult* _res_);
static gboolean contacts_app_show_individual_co (ContactsAppShowIndividualData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void contacts_store_find_contact (ContactsStore* self, ContactsStoreContactMatcher matcher, void* matcher_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
ContactsContact* contacts_store_find_contact_finish (ContactsStore* self, GAsyncResult* _res_);
static gboolean __lambda109_ (Block1Data* _data1_, ContactsContact* c);
static gboolean ___lambda109__contacts_store_contact_matcher (ContactsContact* c, gpointer self);
static void contacts_app_show_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda110_ (Block2Data* _data2_, gint id);
static void ____lambda110__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void contacts_app_change_address_book (ContactsApp* self);
GType contacts_accounts_list_get_type (void) G_GNUC_CONST;
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
ContactsAccountsList* contacts_accounts_list_new (void);
ContactsAccountsList* contacts_accounts_list_construct (GType object_type);
void contacts_accounts_list_update_contents (ContactsAccountsList* self, gboolean select_active);
static void __lambda111_ (Block3Data* _data3_);
static void ___lambda111__contacts_accounts_list_account_selected (ContactsAccountsList* _sender, gpointer self);
static void __lambda112_ (Block3Data* _data3_);
static void ___lambda112__contacts_store_eds_persona_store_changed (ContactsStore* _sender, gpointer self);
static void __lambda113_ (Block3Data* _data3_, gint response);
void contacts_store_refresh (ContactsStore* self);
static void ___lambda113__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void contacts_app_show_help (ContactsApp* self);
void contacts_app_show_about (ContactsApp* self);
static void contacts_app_show_by_email_data_free (gpointer _data);
void contacts_app_show_by_email (ContactsApp* self, const gchar* email_address, GAsyncReadyCallback _callback_, gpointer _user_data_);
void contacts_app_show_by_email_finish (ContactsApp* self, GAsyncResult* _res_);
static gboolean contacts_app_show_by_email_co (ContactsAppShowByEmailData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean __lambda114_ (Block4Data* _data4_, ContactsContact* c);
gboolean contacts_contact_has_email (ContactsContact* self, const gchar* email_address);
static gboolean ___lambda114__contacts_store_contact_matcher (ContactsContact* c, gpointer self);
static void contacts_app_show_by_email_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ___lambda115_ (Block5Data* _data5_, gint id);
static void ____lambda115__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void contacts_app_show_search (ContactsApp* self, const gchar* query);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
gboolean contacts_store_get_is_quiescent (ContactsStore* self);
void contacts_window_show_search (ContactsWindow* self, const gchar* query);
static void ___lambda116_ (Block6Data* _data6_);
static void ____lambda116__contacts_store_quiescent (ContactsStore* _sender, gpointer self);
static void contacts_app_create_app_menu (ContactsApp* self);
static void __lambda117_ (ContactsApp* self);
static void ___lambda117__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void __lambda118_ (ContactsApp* self);
static void ___lambda118__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void __lambda119_ (ContactsApp* self);
static void ___lambda119__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void __lambda120_ (ContactsApp* self);
static void ___lambda120__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void __lambda121_ (ContactsApp* self);
void contacts_app_new_contact (ContactsApp* self);
static void ___lambda121__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
GtkBuilder* contacts_load_ui (const gchar* ui);
static void contacts_app_create_window (ContactsApp* self);
ContactsWindow* contacts_window_new (GtkApplication* app, ContactsStore* contacts_store);
ContactsWindow* contacts_window_construct (GType object_type, GtkApplication* app, ContactsStore* contacts_store);
static void contacts_app_schedule_window_creation (ContactsApp* self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda122_ (Block7Data* _data7_);
static void contacts_app_schedule_window_finish_ui (ContactsApp* self);
static void ___lambda122__contacts_store_prepared (ContactsStore* _sender, gpointer self);
static gboolean __lambda125_ (Block7Data* _data7_);
static gboolean ___lambda125__gsource_func (gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda123_ (Block8Data* _data8_);
void contacts_window_set_list_pane (ContactsWindow* self);
static void ___lambda123__contacts_store_quiescent (ContactsStore* _sender, gpointer self);
static gboolean __lambda124_ (Block8Data* _data8_);
static gboolean ___lambda124__gsource_func (gpointer self);
static void contacts_app_real_startup (GApplication* base);
ContactsStore* contacts_store_new (void);
ContactsStore* contacts_store_construct (GType object_type);
GtkCssProvider* contacts_load_css (const gchar* css);
static void contacts_app_real_activate (GApplication* base);
gboolean contacts_store_get_is_prepared (ContactsStore* self);
void contacts_app_show_message (ContactsApp* self, const gchar* message);
void contacts_window_add_notification (ContactsWindow* self, GtkWidget* notification);
void contacts_window_new_contact (ContactsWindow* self);
static gint contacts_app_real_command_line (GApplication* base, GApplicationCommandLine* command_line);
FolksPersonaStore** contacts_app_get_eds_address_books (int* result_length1);
FolksBackendStore* contacts_store_get_backend_store (ContactsStore* self);
static void _vala_array_add1 (FolksPersonaStore*** array, int* length, int* size, FolksPersonaStore* value);
ContactsApp* contacts_app_new (void);
ContactsApp* contacts_app_construct (GType object_type);
static void contacts_app_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry CONTACTS_APP_options[4] = {{"individual", 'i', 0, G_OPTION_ARG_STRING, &contacts_app_individual_id, "Show contact with this individual id", NULL}, {"email", 'e', 0, G_OPTION_ARG_STRING, &contacts_app_email_address, "Show contact with this email address", NULL}, {"search", 's', 0, G_OPTION_ARG_STRING, &contacts_app_search_terms, NULL, NULL}, {NULL}};

void contacts_app_show_contact (ContactsApp* self, ContactsContact* contact) {
	ContactsWindow* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->window;
	_tmp1_ = contact;
	contacts_window_set_shown_contact (_tmp0_, _tmp1_);
}


static void contacts_app_show_individual_data_free (gpointer _data) {
	ContactsAppShowIndividualData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsAppShowIndividualData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void contacts_app_show_individual (ContactsApp* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsAppShowIndividualData* _data_;
	ContactsApp* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_data_ = g_slice_new0 (ContactsAppShowIndividualData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, contacts_app_show_individual);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, contacts_app_show_individual_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->id);
	_data_->id = _tmp2_;
	contacts_app_show_individual_co (_data_);
}


void contacts_app_show_individual_finish (ContactsApp* self, GAsyncResult* _res_) {
	ContactsAppShowIndividualData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ContactsApp* self;
		self = _data1_->self;
		_g_free0 (_data1_->id);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean __lambda109_ (Block1Data* _data1_, ContactsContact* c) {
	ContactsApp* self;
	gboolean result = FALSE;
	ContactsContact* _tmp0_ = NULL;
	FolksIndividual* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	self = _data1_->self;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = c;
	_tmp1_ = _tmp0_->individual;
	_tmp2_ = folks_individual_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _data1_->id;
	result = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	return result;
}


static gboolean ___lambda109__contacts_store_contact_matcher (ContactsContact* c, gpointer self) {
	gboolean result;
	result = __lambda109_ (self, c);
	return result;
}


static void contacts_app_show_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ContactsAppShowIndividualData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_app_show_individual_co (_data_);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ContactsApp* self;
		self = _data2_->_data1_->self;
		_g_object_unref0 (_data2_->dialog);
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}


static void ___lambda110_ (Block2Data* _data2_, gint id) {
	Block1Data* _data1_;
	ContactsApp* self;
	GtkMessageDialog* _tmp0_ = NULL;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	_tmp0_ = _data2_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void ____lambda110__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	___lambda110_ (self, response_id);
}


static gboolean contacts_app_show_individual_co (ContactsAppShowIndividualData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->id;
	_g_free0 (_data_->_data1_->id);
	_data_->_data1_->id = _data_->_tmp0_;
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->contacts_store;
	_data_->_state_ = 1;
	contacts_store_find_contact (_data_->_tmp1_, ___lambda109__contacts_store_contact_matcher, _data_->_data1_, contacts_app_show_individual_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = contacts_store_find_contact_finish (_data_->_tmp1_, _data_->_res_);
	_data_->contact = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->contact;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->contact;
		contacts_app_show_contact (_data_->self, _data_->_tmp4_);
	} else {
		_data_->_data2_ = g_slice_new0 (Block2Data);
		_data_->_data2_->_ref_count_ = 1;
		_data_->_data2_->_data1_ = block1_data_ref (_data_->_data1_);
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = contacts_app_app;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_tmp5_->window;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _ ("No contact with id %s found");
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->_data1_->id;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data_->_tmp6_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _data_->_tmp7_, _data_->_tmp8_);
		g_object_ref_sink (_data_->_tmp9_);
		_data_->_data2_->dialog = _data_->_tmp9_;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->_data2_->dialog;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _ ("Contact not found");
		gtk_window_set_title ((GtkWindow*) _data_->_tmp10_, _data_->_tmp11_);
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->_data2_->dialog;
		gtk_widget_show ((GtkWidget*) _data_->_tmp12_);
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->_data2_->dialog;
		g_signal_connect_data ((GtkDialog*) _data_->_tmp13_, "response", (GCallback) ____lambda110__gtk_dialog_response, block2_data_ref (_data_->_data2_), (GClosureNotify) block2_data_unref, 0);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
	}
	_g_object_unref0 (_data_->contact);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		ContactsApp* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->acc);
		_g_object_unref0 (_data3_->ok_button);
		_g_object_unref0 (_data3_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void __lambda111_ (Block3Data* _data3_) {
	ContactsApp* self;
	gulong _tmp0_ = 0UL;
	self = _data3_->self;
	gtk_widget_set_sensitive (_data3_->ok_button, TRUE);
	_tmp0_ = _data3_->active_button_once;
	g_signal_handler_disconnect ((GObject*) _data3_->acc, _tmp0_);
}


static void ___lambda111__contacts_accounts_list_account_selected (ContactsAccountsList* _sender, gpointer self) {
	__lambda111_ (self);
}


static void __lambda112_ (Block3Data* _data3_) {
	ContactsApp* self;
	self = _data3_->self;
	contacts_accounts_list_update_contents (_data3_->acc, TRUE);
}


static void ___lambda112__contacts_store_eds_persona_store_changed (ContactsStore* _sender, gpointer self) {
	__lambda112_ (self);
}


static void __lambda113_ (Block3Data* _data3_, gint response) {
	ContactsApp* self;
	gint _tmp0_ = 0;
	ContactsStore* _tmp16_ = NULL;
	self = _data3_->self;
	_tmp0_ = response;
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
		EdsfPersonaStore* e_store = NULL;
		FolksPersonaStore* _tmp1_ = NULL;
		EdsfPersonaStore* _tmp2_ = NULL;
		EdsfPersonaStore* _tmp3_ = NULL;
		_tmp1_ = _data3_->acc->selected_store;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, EDSF_TYPE_PERSONA_STORE) ? ((EdsfPersonaStore*) _tmp1_) : NULL);
		e_store = _tmp2_;
		_tmp3_ = e_store;
		if (_tmp3_ != NULL) {
			ESourceRegistry* _tmp4_ = NULL;
			EdsfPersonaStore* _tmp5_ = NULL;
			ESource* _tmp6_ = NULL;
			ESource* _tmp7_ = NULL;
			GSettings* settings = NULL;
			GSettings* _tmp8_ = NULL;
			GSettings* _tmp9_ = NULL;
			EdsfPersonaStore* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			ContactsStore* _tmp15_ = NULL;
			_tmp4_ = eds_source_registry;
			_tmp5_ = e_store;
			_tmp6_ = edsf_persona_store_get_source (_tmp5_);
			_tmp7_ = _tmp6_;
			e_source_registry_set_default_address_book (_tmp4_, _tmp7_);
			_tmp8_ = g_settings_new ("org.freedesktop.folks");
			settings = _tmp8_;
			_tmp9_ = settings;
			_tmp10_ = e_store;
			_tmp11_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strdup_printf ("eds:%s", _tmp12_);
			_tmp14_ = _tmp13_;
			g_settings_set_string (_tmp9_, "primary-store", _tmp14_);
			_g_free0 (_tmp14_);
			_tmp15_ = self->contacts_store;
			contacts_store_refresh (_tmp15_);
			_g_object_unref0 (settings);
		}
		_g_object_unref0 (e_store);
	}
	_tmp16_ = self->contacts_store;
	g_signal_handler_disconnect ((GObject*) _tmp16_, _data3_->stores_changed_id);
	gtk_widget_destroy ((GtkWidget*) _data3_->dialog);
}


static void ___lambda113__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda113_ (self, response_id);
}


void contacts_app_change_address_book (ContactsApp* self) {
	Block3Data* _data3_;
	const gchar* _tmp0_ = NULL;
	ContactsWindow* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkDialog* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkWidget* _tmp6_ = NULL;
	GtkStyleContext* _tmp7_ = NULL;
	GtkLabel* explanation_label = NULL;
	const gchar* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	GtkBox* _tmp10_ = NULL;
	GtkBox* _tmp11_ = NULL;
	ContactsAccountsList* _tmp12_ = NULL;
	gulong _tmp13_ = 0UL;
	ContactsStore* _tmp14_ = NULL;
	gulong _tmp15_ = 0UL;
	GtkBox* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = _ ("Change Address Book");
	_tmp1_ = self->window;
	_tmp2_ = _ ("Change");
	_tmp3_ = _ ("Cancel");
	_tmp4_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, (GtkWindow*) G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CONTACTS_TYPE_WINDOW, ContactsWindow), (GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT) | GTK_DIALOG_USE_HEADER_BAR, _tmp2_, GTK_RESPONSE_OK, _tmp3_, GTK_RESPONSE_CANCEL, NULL, NULL);
	g_object_ref_sink (_tmp4_);
	_data3_->dialog = _tmp4_;
	_tmp5_ = gtk_dialog_get_widget_for_response (_data3_->dialog, (gint) GTK_RESPONSE_OK);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_data3_->ok_button = _tmp6_;
	gtk_widget_set_sensitive (_data3_->ok_button, FALSE);
	_tmp7_ = gtk_widget_get_style_context (_data3_->ok_button);
	gtk_style_context_add_class (_tmp7_, "suggested-action");
	gtk_window_set_resizable ((GtkWindow*) _data3_->dialog, FALSE);
	gtk_container_set_border_width ((GtkContainer*) _data3_->dialog, (guint) 12);
	_tmp8_ = _ ("New contacts will be added to the selected address book.\n" \
"You are able to view and edit contacts from other address books.");
	_tmp9_ = (GtkLabel*) gtk_label_new (_tmp8_);
	g_object_ref_sink (_tmp9_);
	explanation_label = _tmp9_;
	_tmp10_ = (GtkBox*) gtk_dialog_get_content_area (_data3_->dialog);
	gtk_container_add ((GtkContainer*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, gtk_box_get_type ()) ? ((GtkBox*) _tmp10_) : NULL), (GtkWidget*) explanation_label);
	_tmp11_ = (GtkBox*) gtk_dialog_get_content_area (_data3_->dialog);
	gtk_box_set_spacing (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, gtk_box_get_type ()) ? ((GtkBox*) _tmp11_) : NULL, 12);
	_tmp12_ = contacts_accounts_list_new ();
	g_object_ref_sink (_tmp12_);
	_data3_->acc = _tmp12_;
	contacts_accounts_list_update_contents (_data3_->acc, TRUE);
	_data3_->active_button_once = (gulong) 0;
	_tmp13_ = g_signal_connect_data (_data3_->acc, "account-selected", (GCallback) ___lambda111__contacts_accounts_list_account_selected, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_data3_->active_button_once = _tmp13_;
	_tmp14_ = self->contacts_store;
	_tmp15_ = g_signal_connect_data (_tmp14_, "eds-persona-store-changed", (GCallback) ___lambda112__contacts_store_eds_persona_store_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_data3_->stores_changed_id = _tmp15_;
	_tmp16_ = (GtkBox*) gtk_dialog_get_content_area (_data3_->dialog);
	gtk_container_add ((GtkContainer*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, gtk_box_get_type ()) ? ((GtkBox*) _tmp16_) : NULL), (GtkWidget*) _data3_->acc);
	gtk_widget_show_all ((GtkWidget*) _data3_->dialog);
	g_signal_connect_data (_data3_->dialog, "response", (GCallback) ___lambda113__gtk_dialog_response, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_g_object_unref0 (explanation_label);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


void contacts_app_show_help (ContactsApp* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		ContactsWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->window;
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-help/contacts", _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e1 = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e1;
		_tmp4_ = _tmp3_->message;
		g_warning ("contacts-app.vala:113: Error showing help: %s", _tmp4_);
		_g_error_free0 (e1);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void contacts_app_show_about (ContactsApp* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** artists = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint artists_length1 = 0;
	gint _artists_size_ = 0;
	ContactsWindow* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Alexander Larsson <alexl@redhat.com>");
	_tmp1_ = g_strdup ("Erick Pérez Castellanos <erick.red@gmail.com>");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	authors = _tmp2_;
	authors_length1 = 2;
	_authors_size_ = authors_length1;
	_tmp3_ = g_strdup ("Allan Day <allanpday@gmail.com>");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	artists = _tmp4_;
	artists_length1 = 1;
	_artists_size_ = artists_length1;
	_tmp5_ = self->window;
	_tmp6_ = _ ("translator-credits");
	_tmp7_ = _ ("GNOME Contacts");
	_tmp8_ = _ ("About GNOME Contacts");
	_tmp9_ = _ ("Contact Management Application");
	gtk_show_about_dialog ((GtkWindow*) _tmp5_, "artists", artists, "authors", authors, "translator-credits", _tmp6_, "program-name", _tmp7_, "title", _tmp8_, "comments", _tmp9_, "copyright", "Copyright 2011 Red Hat, Inc.\nCopyright 2014 The Contacts Developers", "license-type", GTK_LICENSE_GPL_2_0, "logo-icon-name", "x-office-address-book", "version", PACKAGE_VERSION, "website", "https://wiki.gnome.org/Apps/Contacts", "wrap-license", TRUE, NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static void contacts_app_show_by_email_data_free (gpointer _data) {
	ContactsAppShowByEmailData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsAppShowByEmailData, _data_);
}


void contacts_app_show_by_email (ContactsApp* self, const gchar* email_address, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsAppShowByEmailData* _data_;
	ContactsApp* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_data_ = g_slice_new0 (ContactsAppShowByEmailData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, contacts_app_show_by_email);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, contacts_app_show_by_email_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = email_address;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->email_address);
	_data_->email_address = _tmp2_;
	contacts_app_show_by_email_co (_data_);
}


void contacts_app_show_by_email_finish (ContactsApp* self, GAsyncResult* _res_) {
	ContactsAppShowByEmailData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		ContactsApp* self;
		self = _data4_->self;
		_g_free0 (_data4_->email_address);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static gboolean __lambda114_ (Block4Data* _data4_, ContactsContact* c) {
	ContactsApp* self;
	gboolean result = FALSE;
	ContactsContact* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	self = _data4_->self;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = c;
	_tmp1_ = _data4_->email_address;
	_tmp2_ = contacts_contact_has_email (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static gboolean ___lambda114__contacts_store_contact_matcher (ContactsContact* c, gpointer self) {
	gboolean result;
	result = __lambda114_ (self, c);
	return result;
}


static void contacts_app_show_by_email_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ContactsAppShowByEmailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_app_show_by_email_co (_data_);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		ContactsApp* self;
		self = _data5_->_data4_->self;
		_g_object_unref0 (_data5_->dialog);
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}


static void ___lambda115_ (Block5Data* _data5_, gint id) {
	Block4Data* _data4_;
	ContactsApp* self;
	GtkMessageDialog* _tmp0_ = NULL;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	_tmp0_ = _data5_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void ____lambda115__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	___lambda115_ (self, response_id);
}


static gboolean contacts_app_show_by_email_co (ContactsAppShowByEmailData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data4_ = g_slice_new0 (Block4Data);
	_data_->_data4_->_ref_count_ = 1;
	_data_->_data4_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->email_address;
	_g_free0 (_data_->_data4_->email_address);
	_data_->_data4_->email_address = _data_->_tmp0_;
	_data_->_data4_->_async_data_ = _data_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->contacts_store;
	_data_->_state_ = 1;
	contacts_store_find_contact (_data_->_tmp1_, ___lambda114__contacts_store_contact_matcher, _data_->_data4_, contacts_app_show_by_email_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = contacts_store_find_contact_finish (_data_->_tmp1_, _data_->_res_);
	_data_->contact = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->contact;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->contact;
		contacts_app_show_contact (_data_->self, _data_->_tmp4_);
	} else {
		_data_->_data5_ = g_slice_new0 (Block5Data);
		_data_->_data5_->_ref_count_ = 1;
		_data_->_data5_->_data4_ = block4_data_ref (_data_->_data4_);
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = contacts_app_app;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_tmp5_->window;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _ ("No contact with email address %s found");
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->_data4_->email_address;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data_->_tmp6_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _data_->_tmp7_, _data_->_tmp8_);
		g_object_ref_sink (_data_->_tmp9_);
		_data_->_data5_->dialog = _data_->_tmp9_;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->_data5_->dialog;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _ ("Contact not found");
		gtk_window_set_title ((GtkWindow*) _data_->_tmp10_, _data_->_tmp11_);
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->_data5_->dialog;
		gtk_widget_show ((GtkWidget*) _data_->_tmp12_);
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->_data5_->dialog;
		g_signal_connect_data ((GtkDialog*) _data_->_tmp13_, "response", (GCallback) ____lambda115__gtk_dialog_response, block5_data_ref (_data_->_data5_), (GClosureNotify) block5_data_unref, 0);
		block5_data_unref (_data_->_data5_);
		_data_->_data5_ = NULL;
	}
	_g_object_unref0 (_data_->contact);
	block4_data_unref (_data_->_data4_);
	_data_->_data4_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		ContactsApp* self;
		self = _data6_->self;
		_g_free0 (_data6_->query);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}


static void ___lambda116_ (Block6Data* _data6_) {
	ContactsApp* self;
	ContactsWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	self = _data6_->self;
	_tmp0_ = self->window;
	_tmp1_ = _data6_->query;
	contacts_window_show_search (_tmp0_, _tmp1_);
}


static void ____lambda116__contacts_store_quiescent (ContactsStore* _sender, gpointer self) {
	___lambda116_ (self);
}


void contacts_app_show_search (ContactsApp* self, const gchar* query) {
	Block6Data* _data6_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	ContactsStore* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = query;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data6_->query);
	_data6_->query = _tmp1_;
	_tmp2_ = self->contacts_store;
	_tmp3_ = contacts_store_get_is_quiescent (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		ContactsWindow* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp5_ = self->window;
		_tmp6_ = _data6_->query;
		contacts_window_show_search (_tmp5_, _tmp6_);
	} else {
		ContactsStore* _tmp7_ = NULL;
		_tmp7_ = self->contacts_store;
		g_signal_connect_data (_tmp7_, "quiescent", (GCallback) ____lambda116__contacts_store_quiescent, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, G_CONNECT_AFTER);
	}
	block6_data_unref (_data6_);
	_data6_ = NULL;
}


static void __lambda117_ (ContactsApp* self) {
	g_application_quit ((GApplication*) self);
}


static void ___lambda117__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	__lambda117_ ((ContactsApp*) self);
}


static void __lambda118_ (ContactsApp* self) {
	contacts_app_show_help (self);
}


static void ___lambda118__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	__lambda118_ ((ContactsApp*) self);
}


static void __lambda119_ (ContactsApp* self) {
	contacts_app_show_about (self);
}


static void ___lambda119__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	__lambda119_ ((ContactsApp*) self);
}


static void __lambda120_ (ContactsApp* self) {
	contacts_app_change_address_book (self);
}


static void ___lambda120__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	__lambda120_ ((ContactsApp*) self);
}


static void __lambda121_ (ContactsApp* self) {
	contacts_app_new_contact (self);
}


static void ___lambda121__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	__lambda121_ ((ContactsApp*) self);
}


static void contacts_app_create_app_menu (ContactsApp* self) {
	GSimpleAction* action = NULL;
	GSimpleAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GSimpleAction* _tmp4_ = NULL;
	GSimpleAction* _tmp5_ = NULL;
	GSimpleAction* _tmp6_ = NULL;
	GSimpleAction* _tmp7_ = NULL;
	GSimpleAction* _tmp8_ = NULL;
	GSimpleAction* _tmp9_ = NULL;
	GSimpleAction* _tmp10_ = NULL;
	GSimpleAction* _tmp11_ = NULL;
	GSimpleAction* _tmp12_ = NULL;
	GSimpleAction* _tmp13_ = NULL;
	GSimpleAction* _tmp14_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp15_ = NULL;
	GObject* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_simple_action_new ("quit", NULL);
	action = _tmp0_;
	_tmp1_ = action;
	g_signal_connect_object (_tmp1_, "activate", (GCallback) ___lambda117__g_simple_action_activate, self, 0);
	_tmp2_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp2_);
	_tmp3_ = g_simple_action_new ("help", NULL);
	_g_object_unref0 (action);
	action = _tmp3_;
	_tmp4_ = action;
	g_signal_connect_object (_tmp4_, "activate", (GCallback) ___lambda118__g_simple_action_activate, self, 0);
	_tmp5_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp5_);
	gtk_application_add_accelerator ((GtkApplication*) self, "F1", "app.help", NULL);
	_tmp6_ = g_simple_action_new ("about", NULL);
	_g_object_unref0 (action);
	action = _tmp6_;
	_tmp7_ = action;
	g_signal_connect_object (_tmp7_, "activate", (GCallback) ___lambda119__g_simple_action_activate, self, 0);
	_tmp8_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp8_);
	_tmp9_ = g_simple_action_new ("change_book", NULL);
	_g_object_unref0 (action);
	action = _tmp9_;
	_tmp10_ = action;
	g_signal_connect_object (_tmp10_, "activate", (GCallback) ___lambda120__g_simple_action_activate, self, 0);
	_tmp11_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp11_);
	_tmp12_ = g_simple_action_new ("new_contact", NULL);
	_g_object_unref0 (action);
	action = _tmp12_;
	_tmp13_ = action;
	g_signal_connect_object (_tmp13_, "activate", (GCallback) ___lambda121__g_simple_action_activate, self, 0);
	_tmp14_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp14_);
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>n", "app.new_contact", NULL);
	_tmp15_ = contacts_load_ui ("app-menu.ui");
	builder = _tmp15_;
	_tmp16_ = gtk_builder_get_object (builder, "app-menu");
	gtk_application_set_app_menu ((GtkApplication*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, g_menu_model_get_type (), GMenuModel));
	_g_object_unref0 (builder);
	_g_object_unref0 (action);
}


static void contacts_app_create_window (ContactsApp* self) {
	ContactsStore* _tmp0_ = NULL;
	ContactsWindow* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->contacts_store;
	_tmp1_ = contacts_window_new ((GtkApplication*) self, _tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->window);
	self->window = _tmp1_;
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		ContactsApp* self;
		self = _data7_->self;
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}


static void __lambda122_ (Block7Data* _data7_) {
	ContactsApp* self;
	ContactsStore* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	guint _tmp2_ = 0U;
	ContactsWindow* _tmp3_ = NULL;
	self = _data7_->self;
	_tmp0_ = self->contacts_store;
	_tmp1_ = _data7_->id;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _tmp1_);
	_tmp2_ = _data7_->id2;
	g_source_remove (_tmp2_);
	contacts_app_create_app_menu (self);
	contacts_app_create_window (self);
	_tmp3_ = self->window;
	gtk_widget_show ((GtkWidget*) _tmp3_);
	contacts_app_schedule_window_finish_ui (self);
	g_application_release ((GApplication*) self);
}


static void ___lambda122__contacts_store_prepared (ContactsStore* _sender, gpointer self) {
	__lambda122_ (self);
}


static gboolean __lambda125_ (Block7Data* _data7_) {
	ContactsApp* self;
	gboolean result = FALSE;
	ContactsStore* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	ContactsWindow* _tmp2_ = NULL;
	self = _data7_->self;
	_tmp0_ = self->contacts_store;
	_tmp1_ = _data7_->id;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _tmp1_);
	contacts_app_create_app_menu (self);
	contacts_app_create_window (self);
	_tmp2_ = self->window;
	gtk_widget_show ((GtkWidget*) _tmp2_);
	contacts_app_schedule_window_finish_ui (self);
	g_application_release ((GApplication*) self);
	result = FALSE;
	return result;
}


static gboolean ___lambda125__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda125_ (self);
	return result;
}


static void contacts_app_schedule_window_creation (ContactsApp* self) {
	Block7Data* _data7_;
	ContactsStore* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	guint _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	g_application_hold ((GApplication*) self);
	_data7_->id = (gulong) 0;
	_data7_->id2 = (guint) 0;
	_tmp0_ = self->contacts_store;
	_tmp1_ = g_signal_connect_data (_tmp0_, "prepared", (GCallback) ___lambda122__contacts_store_prepared, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_data7_->id = _tmp1_;
	_tmp2_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda125__gsource_func, block7_data_ref (_data7_), block7_data_unref);
	_data7_->id2 = _tmp2_;
	self->priv->is_prepare_scheluded = TRUE;
	block7_data_unref (_data7_);
	_data7_ = NULL;
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		ContactsApp* self;
		self = _data8_->self;
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}


static void __lambda123_ (Block8Data* _data8_) {
	ContactsApp* self;
	guint _tmp0_ = 0U;
	ContactsStore* _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
	ContactsWindow* _tmp3_ = NULL;
	self = _data8_->self;
	_tmp0_ = _data8_->id2;
	g_source_remove (_tmp0_);
	_tmp1_ = self->contacts_store;
	_tmp2_ = _data8_->id;
	g_signal_handler_disconnect ((GObject*) _tmp1_, _tmp2_);
	g_debug ("contacts-app.vala:241: callign set_list_pane from quiescent.connect");
	_tmp3_ = self->window;
	contacts_window_set_list_pane (_tmp3_);
}


static void ___lambda123__contacts_store_quiescent (ContactsStore* _sender, gpointer self) {
	__lambda123_ (self);
}


static gboolean __lambda124_ (Block8Data* _data8_) {
	ContactsApp* self;
	gboolean result = FALSE;
	ContactsStore* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	ContactsWindow* _tmp2_ = NULL;
	self = _data8_->self;
	_tmp0_ = self->contacts_store;
	_tmp1_ = _data8_->id;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _tmp1_);
	g_debug ("contacts-app.vala:248: callign set_list_pane from 500.timeout");
	_tmp2_ = self->window;
	contacts_window_set_list_pane (_tmp2_);
	result = FALSE;
	return result;
}


static gboolean ___lambda124__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda124_ (self);
	return result;
}


static void contacts_app_schedule_window_finish_ui (ContactsApp* self) {
	Block8Data* _data8_;
	ContactsStore* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	guint _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_data8_->id = (gulong) 0;
	_data8_->id2 = (guint) 0;
	_tmp0_ = self->contacts_store;
	_tmp1_ = g_signal_connect_data (_tmp0_, "quiescent", (GCallback) ___lambda123__contacts_store_quiescent, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	_data8_->id = _tmp1_;
	_tmp2_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda124__gsource_func, block8_data_ref (_data8_), block8_data_unref);
	_data8_->id2 = _tmp2_;
	self->priv->is_quiescent_scheduled = TRUE;
	block8_data_unref (_data8_);
	_data8_ = NULL;
}


static void contacts_app_real_startup (GApplication* base) {
	ContactsApp * self;
	ContactsStore* _tmp0_ = NULL;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp1_ = NULL;
	GdkScreen* _tmp2_ = NULL;
	self = (ContactsApp*) base;
	contacts_ensure_eds_accounts ();
	_tmp0_ = contacts_store_new ();
	_g_object_unref0 (self->contacts_store);
	self->contacts_store = _tmp0_;
	G_APPLICATION_CLASS (contacts_app_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp1_ = contacts_load_css ("style.css");
	css_provider = _tmp1_;
	_tmp2_ = gdk_screen_get_default ();
	gtk_style_context_add_provider_for_screen (_tmp2_, (GtkStyleProvider*) css_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (css_provider);
}


static void contacts_app_real_activate (GApplication* base) {
	ContactsApp * self;
	ContactsWindow* _tmp0_ = NULL;
	ContactsStore* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	ContactsWindow* _tmp11_ = NULL;
	self = (ContactsApp*) base;
	_tmp0_ = self->window;
	if (_tmp0_ == NULL) {
		ContactsStore* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		ContactsWindow* _tmp5_ = NULL;
		_tmp1_ = self->contacts_store;
		_tmp2_ = contacts_store_get_is_prepared (_tmp1_);
		_tmp3_ = _tmp2_;
		if (!_tmp3_) {
			gboolean _tmp4_ = FALSE;
			_tmp4_ = self->priv->is_prepare_scheluded;
			if (!_tmp4_) {
				contacts_app_schedule_window_creation (self);
				return;
			}
		}
		contacts_app_create_app_menu (self);
		contacts_app_create_window (self);
		_tmp5_ = self->window;
		gtk_widget_show ((GtkWidget*) _tmp5_);
	}
	_tmp6_ = self->contacts_store;
	_tmp7_ = contacts_store_get_is_quiescent (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		ContactsWindow* _tmp9_ = NULL;
		g_debug ("contacts-app.vala:284: callign set_list_pane cause store is already qu" \
"iescent");
		_tmp9_ = self->window;
		contacts_window_set_list_pane (_tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		_tmp10_ = self->priv->is_quiescent_scheduled;
		if (!_tmp10_) {
			contacts_app_schedule_window_finish_ui (self);
		}
	}
	_tmp11_ = self->window;
	if (_tmp11_ != NULL) {
		ContactsWindow* _tmp12_ = NULL;
		_tmp12_ = self->window;
		gtk_window_present ((GtkWindow*) _tmp12_);
	}
}


void contacts_app_show_message (ContactsApp* self, const gchar* message) {
	GdNotification* notification = NULL;
	GdNotification* _tmp0_ = NULL;
	GtkGrid* g = NULL;
	GtkGrid* _tmp1_ = NULL;
	GtkLabel* l = NULL;
	const gchar* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	ContactsWindow* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = (GdNotification*) gd_notification_new ();
	g_object_ref_sink (_tmp0_);
	notification = _tmp0_;
	g_object_set (notification, "timeout", 5, NULL);
	_tmp1_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp1_);
	g = _tmp1_;
	gtk_grid_set_column_spacing (g, (guint) 8);
	_tmp2_ = message;
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	l = _tmp3_;
	gtk_label_set_line_wrap (l, TRUE);
	gtk_label_set_line_wrap_mode (l, PANGO_WRAP_WORD_CHAR);
	gtk_container_add ((GtkContainer*) notification, (GtkWidget*) l);
	gtk_widget_show_all ((GtkWidget*) notification);
	_tmp4_ = self->window;
	contacts_window_add_notification (_tmp4_, (GtkWidget*) notification);
	_g_object_unref0 (l);
	_g_object_unref0 (g);
	_g_object_unref0 (notification);
}


void contacts_app_new_contact (ContactsApp* self) {
	ContactsWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->window;
	contacts_window_new_contact (_tmp0_);
}


static gint contacts_app_real_command_line (GApplication* base, GApplicationCommandLine* command_line) {
	ContactsApp * self;
	gint result = 0;
	gchar** args = NULL;
	GApplicationCommandLine* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	gchar** _args = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _args_length1 = 0;
	gint __args_size_ = 0;
	GOptionContext* context = NULL;
	GOptionContext* _tmp4_ = NULL;
	GOptionContext* _tmp5_ = NULL;
	GOptionContext* _tmp6_ = NULL;
	GOptionContext* _tmp7_ = NULL;
	GOptionGroup* _tmp8_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp18_ = NULL;
	GError * _inner_error_ = NULL;
	self = (ContactsApp*) base;
	g_return_val_if_fail (command_line != NULL, 0);
	_tmp0_ = command_line;
	_tmp2_ = g_application_command_line_get_arguments (_tmp0_, &_tmp1_);
	args = _tmp2_;
	args_length1 = _tmp1_;
	_args_size_ = args_length1;
	_tmp3_ = args;
	_tmp3__length1 = args_length1;
	_args = _tmp3_;
	_args_length1 = _tmp3__length1;
	__args_size_ = _args_length1;
	_tmp4_ = g_option_context_new ("— contact management");
	context = _tmp4_;
	_tmp5_ = context;
	g_option_context_add_main_entries (_tmp5_, CONTACTS_APP_options, GETTEXT_PACKAGE);
	_tmp6_ = context;
	g_option_context_set_translation_domain (_tmp6_, GETTEXT_PACKAGE);
	_tmp7_ = context;
	_tmp8_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp7_, _tmp8_);
	_g_free0 (contacts_app_individual_id);
	contacts_app_individual_id = NULL;
	_g_free0 (contacts_app_email_address);
	contacts_app_email_address = NULL;
	_g_free0 (contacts_app_search_terms);
	contacts_app_search_terms = NULL;
	{
		GOptionContext* _tmp9_ = NULL;
		_tmp9_ = context;
		g_option_context_parse (_tmp9_, &_args_length1, &_args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_printerr ("Unable to parse: %s\n", _tmp11_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (context);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	g_application_activate ((GApplication*) self);
	_tmp12_ = contacts_app_individual_id;
	if (_tmp12_ != NULL) {
		ContactsApp* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		_tmp13_ = contacts_app_app;
		_tmp14_ = contacts_app_individual_id;
		contacts_app_show_individual (_tmp13_, _tmp14_, NULL, NULL);
	}
	_tmp15_ = contacts_app_email_address;
	if (_tmp15_ != NULL) {
		ContactsApp* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_tmp16_ = contacts_app_app;
		_tmp17_ = contacts_app_email_address;
		contacts_app_show_by_email (_tmp16_, _tmp17_, NULL, NULL);
	}
	_tmp18_ = contacts_app_search_terms;
	if (_tmp18_ != NULL) {
		ContactsApp* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		_tmp19_ = contacts_app_app;
		_tmp20_ = contacts_app_search_terms;
		contacts_app_show_search (_tmp19_, _tmp20_);
	}
	result = 0;
	_g_option_context_free0 (context);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void _vala_array_add1 (FolksPersonaStore*** array, int* length, int* size, FolksPersonaStore* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FolksPersonaStore*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


FolksPersonaStore** contacts_app_get_eds_address_books (int* result_length1) {
	FolksPersonaStore** result = NULL;
	FolksPersonaStore** stores = NULL;
	FolksPersonaStore** _tmp0_ = NULL;
	gint stores_length1 = 0;
	gint _stores_size_ = 0;
	FolksPersonaStore** _tmp34_ = NULL;
	gint _tmp34__length1 = 0;
	_tmp0_ = g_new0 (FolksPersonaStore*, 0 + 1);
	stores = _tmp0_;
	stores_length1 = 0;
	_stores_size_ = stores_length1;
	{
		GeeIterator* _backend_it = NULL;
		ContactsApp* _tmp1_ = NULL;
		ContactsStore* _tmp2_ = NULL;
		FolksBackendStore* _tmp3_ = NULL;
		FolksBackendStore* _tmp4_ = NULL;
		GeeMap* _tmp5_ = NULL;
		GeeMap* _tmp6_ = NULL;
		GeeCollection* _tmp7_ = NULL;
		GeeCollection* _tmp8_ = NULL;
		GeeCollection* _tmp9_ = NULL;
		GeeIterator* _tmp10_ = NULL;
		GeeIterator* _tmp11_ = NULL;
		_tmp1_ = contacts_app_app;
		_tmp2_ = _tmp1_->contacts_store;
		_tmp3_ = contacts_store_get_backend_store (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = folks_backend_store_get_enabled_backends (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_map_get_values (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_backend_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			FolksBackend* backend = NULL;
			GeeIterator* _tmp14_ = NULL;
			gpointer _tmp15_ = NULL;
			_tmp12_ = _backend_it;
			_tmp13_ = gee_iterator_next (_tmp12_);
			if (!_tmp13_) {
				break;
			}
			_tmp14_ = _backend_it;
			_tmp15_ = gee_iterator_get (_tmp14_);
			backend = (FolksBackend*) _tmp15_;
			{
				GeeIterator* _persona_store_it = NULL;
				FolksBackend* _tmp16_ = NULL;
				GeeMap* _tmp17_ = NULL;
				GeeMap* _tmp18_ = NULL;
				GeeCollection* _tmp19_ = NULL;
				GeeCollection* _tmp20_ = NULL;
				GeeCollection* _tmp21_ = NULL;
				GeeIterator* _tmp22_ = NULL;
				GeeIterator* _tmp23_ = NULL;
				_tmp16_ = backend;
				_tmp17_ = folks_backend_get_persona_stores (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = gee_map_get_values (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = _tmp20_;
				_tmp22_ = gee_iterable_iterator ((GeeIterable*) _tmp21_);
				_tmp23_ = _tmp22_;
				_g_object_unref0 (_tmp21_);
				_persona_store_it = _tmp23_;
				while (TRUE) {
					GeeIterator* _tmp24_ = NULL;
					gboolean _tmp25_ = FALSE;
					FolksPersonaStore* persona_store = NULL;
					GeeIterator* _tmp26_ = NULL;
					gpointer _tmp27_ = NULL;
					FolksPersonaStore* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
					_tmp24_ = _persona_store_it;
					_tmp25_ = gee_iterator_next (_tmp24_);
					if (!_tmp25_) {
						break;
					}
					_tmp26_ = _persona_store_it;
					_tmp27_ = gee_iterator_get (_tmp26_);
					persona_store = (FolksPersonaStore*) _tmp27_;
					_tmp28_ = persona_store;
					_tmp29_ = folks_persona_store_get_type_id (_tmp28_);
					_tmp30_ = _tmp29_;
					if (g_strcmp0 (_tmp30_, "eds") == 0) {
						FolksPersonaStore** _tmp31_ = NULL;
						gint _tmp31__length1 = 0;
						FolksPersonaStore* _tmp32_ = NULL;
						FolksPersonaStore* _tmp33_ = NULL;
						_tmp31_ = stores;
						_tmp31__length1 = stores_length1;
						_tmp32_ = persona_store;
						_tmp33_ = _g_object_ref0 (_tmp32_);
						_vala_array_add1 (&stores, &stores_length1, &_stores_size_, _tmp33_);
					}
					_g_object_unref0 (persona_store);
				}
				_g_object_unref0 (_persona_store_it);
			}
			_g_object_unref0 (backend);
		}
		_g_object_unref0 (_backend_it);
	}
	_tmp34_ = stores;
	_tmp34__length1 = stores_length1;
	if (result_length1) {
		*result_length1 = _tmp34__length1;
	}
	result = _tmp34_;
	return result;
}


ContactsApp* contacts_app_construct (GType object_type) {
	ContactsApp * self = NULL;
	ContactsApp* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	self = (ContactsApp*) g_object_new (object_type, "application-id", "org.gnome.Contacts", "flags", G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (contacts_app_app);
	contacts_app_app = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.Contacts");
	_g_object_unref0 (self->settings);
	self->settings = _tmp1_;
	return self;
}


ContactsApp* contacts_app_new (void) {
	return contacts_app_construct (CONTACTS_TYPE_APP);
}


static void contacts_app_class_init (ContactsAppClass * klass) {
	contacts_app_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsAppPrivate));
	((GApplicationClass *) klass)->startup = contacts_app_real_startup;
	((GApplicationClass *) klass)->activate = contacts_app_real_activate;
	((GApplicationClass *) klass)->command_line = contacts_app_real_command_line;
	G_OBJECT_CLASS (klass)->finalize = contacts_app_finalize;
}


static void contacts_app_instance_init (ContactsApp * self) {
	self->priv = CONTACTS_APP_GET_PRIVATE (self);
	self->priv->is_prepare_scheluded = FALSE;
	self->priv->is_quiescent_scheduled = FALSE;
}


static void contacts_app_finalize (GObject* obj) {
	ContactsApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_APP, ContactsApp);
	_g_object_unref0 (self->settings);
	_g_object_unref0 (self->contacts_store);
	_g_object_unref0 (self->window);
	G_OBJECT_CLASS (contacts_app_parent_class)->finalize (obj);
}


GType contacts_app_get_type (void) {
	static volatile gsize contacts_app_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_app_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsApp), 0, (GInstanceInitFunc) contacts_app_instance_init, NULL };
		GType contacts_app_type_id;
		contacts_app_type_id = g_type_register_static (gtk_application_get_type (), "ContactsApp", &g_define_type_info, 0);
		g_once_init_leave (&contacts_app_type_id__volatile, contacts_app_type_id);
	}
	return contacts_app_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



