/* Settings.c generated by valac 0.25.1, the Vala compiler
 * generated from Settings.vala, do not modify */

/*
 * Copyright (C) 2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>


#define DVB_TYPE_SETTINGS (dvb_settings_get_type ())
#define DVB_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SETTINGS, DVBSettings))
#define DVB_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SETTINGS, DVBSettingsClass))
#define DVB_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SETTINGS))
#define DVB_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SETTINGS))
#define DVB_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SETTINGS, DVBSettingsClass))

typedef struct _DVBSettings DVBSettings;
typedef struct _DVBSettingsClass DVBSettingsClass;
typedef struct _DVBSettingsPrivate DVBSettingsPrivate;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _DVBSettings {
	GObject parent_instance;
	DVBSettingsPrivate * priv;
};

struct _DVBSettingsClass {
	GObjectClass parent_class;
};

struct _DVBSettingsPrivate {
	GKeyFile* keyfile;
};


static gpointer dvb_settings_parent_class = NULL;
static DVBLoggingLogger* dvb_settings_log;
static DVBLoggingLogger* dvb_settings_log = NULL;

GType dvb_settings_get_type (void) G_GNUC_CONST;
#define DVB_SETTINGS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SETTINGS, DVBSettingsPrivate))
enum  {
	DVB_SETTINGS_DUMMY_PROPERTY
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
#define DVB_SETTINGS_TIMERS_SECTION "timers"
#define DVB_SETTINGS_MARGIN_START "margin_start"
#define DVB_SETTINGS_MARGIN_END "margin_end"
#define DVB_SETTINGS_EPG_SECTION "epg"
#define DVB_SETTINGS_SCAN_INTERVAL "scan_interval"
#define DVB_SETTINGS_STREAMING_SECTION "streaming"
#define DVB_SETTINGS_INTERFACE "interface"
#define DVB_SETTINGS_DEFAULT_MARGIN_START 5
#define DVB_SETTINGS_DEFAULT_MARGIN_END 5
#define DVB_SETTINGS_DEFAULT_SCAN_INTERVAL 30
#define DVB_SETTINGS_DEFAULT_INTERFACE "lo"
#define DVB_SETTINGS_DEFAULT_SETTINGS "[timers]\n" \
"        margin_start=5\n" \
"        margin_end=5\n" \
"        [epg]\n" \
"        scan_interval=30\n" \
"        [streaming]\n" \
"        interface=lo"
gint dvb_settings_get_epg_scan_interval (DVBSettings* self);
gint dvb_settings_get_integer (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error);
void dvb_logging_logger_warning (DVBLoggingLogger* self, const gchar* format, ...);
gint dvb_settings_get_timers_margin_start (DVBSettings* self);
gint dvb_settings_get_timers_margin_end (DVBSettings* self);
gchar* dvb_settings_get_streaming_interface (DVBSettings* self);
gchar* dvb_settings_get_string (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error);
GFile* dvb_settings_get_settings_file (DVBSettings* self);
gboolean dvb_settings_load (DVBSettings* self);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
gboolean dvb_settings_save (DVBSettings* self);
gboolean dvb_settings_get_boolean (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error);
gdouble dvb_settings_get_double (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error);
gchar** dvb_settings_get_string_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error);
gboolean* dvb_settings_get_boolean_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error);
gint* dvb_settings_get_integer_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error);
gdouble* dvb_settings_get_double_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error);
void dvb_settings_set_string (DVBSettings* self, const gchar* group_name, const gchar* key, const gchar* val, GError** error);
void dvb_settings_set_boolean (DVBSettings* self, const gchar* group_name, const gchar* key, gboolean val, GError** error);
void dvb_settings_set_double (DVBSettings* self, const gchar* group_name, const gchar* key, gdouble val, GError** error);
void dvb_settings_set_integer (DVBSettings* self, const gchar* group_name, const gchar* key, gint val, GError** error);
void dvb_settings_set_string_list (DVBSettings* self, const gchar* group_name, const gchar* key, gchar** val, int val_length1, GError** error);
void dvb_settings_set_boolean_list (DVBSettings* self, const gchar* group_name, const gchar* key, gboolean* val, int val_length1, GError** error);
void dvb_settings_set_double_list (DVBSettings* self, const gchar* group_name, const gchar* key, gdouble* val, int val_length1, GError** error);
void dvb_settings_set_integer_list (DVBSettings* self, const gchar* group_name, const gchar* key, gint* val, int val_length1, GError** error);
DVBSettings* dvb_settings_new (void);
DVBSettings* dvb_settings_construct (GType object_type);
static GObject * dvb_settings_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_settings_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


gint dvb_settings_get_epg_scan_interval (DVBSettings* self) {
	gint result = 0;
	gint val = 0;
	gint _tmp5_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		_tmp1_ = dvb_settings_get_integer (self, DVB_SETTINGS_EPG_SECTION, DVB_SETTINGS_SCAN_INTERVAL, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch187_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		val = _tmp0_;
	}
	goto __finally187;
	__catch187_g_key_file_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = dvb_settings_log;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		dvb_logging_logger_warning (_tmp2_, "Settings.vala:64: %s", _tmp4_);
		val = DVB_SETTINGS_DEFAULT_SCAN_INTERVAL;
		_g_error_free0 (e);
	}
	__finally187:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp5_ = val;
	result = _tmp5_ * 60;
	return result;
}


gint dvb_settings_get_timers_margin_start (DVBSettings* self) {
	gint result = 0;
	gint start_margin = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		_tmp1_ = dvb_settings_get_integer (self, DVB_SETTINGS_TIMERS_SECTION, DVB_SETTINGS_MARGIN_START, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch188_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		start_margin = _tmp0_;
	}
	goto __finally188;
	__catch188_g_key_file_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = dvb_settings_log;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		dvb_logging_logger_warning (_tmp2_, "Settings.vala:75: %s", _tmp4_);
		start_margin = DVB_SETTINGS_DEFAULT_MARGIN_START;
		_g_error_free0 (e);
	}
	__finally188:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = start_margin;
	return result;
}


gint dvb_settings_get_timers_margin_end (DVBSettings* self) {
	gint result = 0;
	gint end_margin = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		_tmp1_ = dvb_settings_get_integer (self, DVB_SETTINGS_TIMERS_SECTION, DVB_SETTINGS_MARGIN_END, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch189_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		end_margin = _tmp0_;
	}
	goto __finally189;
	__catch189_g_key_file_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = dvb_settings_log;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		dvb_logging_logger_warning (_tmp2_, "Settings.vala:86: %s", _tmp4_);
		end_margin = DVB_SETTINGS_DEFAULT_MARGIN_END;
		_g_error_free0 (e);
	}
	__finally189:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = end_margin;
	return result;
}


gchar* dvb_settings_get_streaming_interface (DVBSettings* self) {
	gchar* result = NULL;
	gchar* val = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		_tmp1_ = dvb_settings_get_string (self, DVB_SETTINGS_STREAMING_SECTION, DVB_SETTINGS_INTERFACE, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch190_g_key_file_error;
			}
			_g_free0 (val);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (val);
		val = _tmp2_;
		_g_free0 (_tmp0_);
	}
	goto __finally190;
	__catch190_g_key_file_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = dvb_settings_log;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		dvb_logging_logger_warning (_tmp3_, "Settings.vala:97: %s", _tmp5_);
		_tmp6_ = g_strdup (DVB_SETTINGS_DEFAULT_INTERFACE);
		_g_free0 (val);
		val = _tmp6_;
		_g_error_free0 (e);
	}
	__finally190:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (val);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = val;
	return result;
}


GFile* dvb_settings_get_settings_file (DVBSettings* self) {
	GFile* result = NULL;
	GFile* config_dir = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* our_config = NULL;
	GFile* _tmp2_ = NULL;
	GFile* settings_file = NULL;
	GFile* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	config_dir = _tmp1_;
	_tmp2_ = g_file_get_child (config_dir, "gnome-dvb-daemon");
	our_config = _tmp2_;
	_tmp3_ = g_file_get_child (our_config, "settings.ini");
	settings_file = _tmp3_;
	result = settings_file;
	_g_object_unref0 (our_config);
	_g_object_unref0 (config_dir);
	return result;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


gboolean dvb_settings_load (DVBSettings* self) {
	gboolean result = FALSE;
	GFile* settings_file = NULL;
	GFile* _tmp0_ = NULL;
	gboolean success = FALSE;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp26_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = dvb_settings_get_settings_file (self);
	settings_file = _tmp0_;
	success = TRUE;
	_tmp1_ = settings_file;
	_tmp2_ = g_file_query_exists (_tmp1_, NULL);
	if (!_tmp2_) {
		GFileOutputStream* stream = NULL;
		stream = NULL;
		{
			GFileOutputStream* _tmp3_ = NULL;
			GFile* _tmp4_ = NULL;
			GFileOutputStream* _tmp5_ = NULL;
			GFileOutputStream* _tmp6_ = NULL;
			_tmp4_ = settings_file;
			_tmp5_ = g_file_create (_tmp4_, 0, NULL, &_inner_error_);
			_tmp3_ = _tmp5_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch191_g_error;
			}
			_tmp6_ = _tmp3_;
			_tmp3_ = NULL;
			_g_object_unref0 (stream);
			stream = _tmp6_;
			_g_object_unref0 (_tmp3_);
		}
		goto __finally191;
		__catch191_g_error:
		{
			GError* e = NULL;
			DVBLoggingLogger* _tmp7_ = NULL;
			GFile* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			GError* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp7_ = dvb_settings_log;
			_tmp8_ = settings_file;
			_tmp9_ = g_file_get_path (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			dvb_logging_logger_error (_tmp7_, "Settings.vala:120: Could not create file %s: %s", _tmp10_, _tmp12_);
			_g_free0 (_tmp10_);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (stream);
			_g_object_unref0 (settings_file);
			return result;
		}
		__finally191:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (stream);
			_g_object_unref0 (settings_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		{
			GFileOutputStream* _tmp13_ = NULL;
			guint8* _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			guint8* _tmp15_ = NULL;
			gint _tmp15__length1 = 0;
			_tmp13_ = stream;
			_tmp14_ = string_get_data (DVB_SETTINGS_DEFAULT_SETTINGS, &_tmp14__length1);
			_tmp15_ = _tmp14_;
			_tmp15__length1 = _tmp14__length1;
			g_output_stream_write ((GOutputStream*) _tmp13_, _tmp15_, (gsize) _tmp15__length1, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch192_g_error;
			}
		}
		goto __finally192;
		__catch192_g_error:
		{
			GError* e = NULL;
			DVBLoggingLogger* _tmp16_ = NULL;
			GFile* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			GError* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp16_ = dvb_settings_log;
			_tmp17_ = settings_file;
			_tmp18_ = g_file_get_path (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = e;
			_tmp21_ = _tmp20_->message;
			dvb_logging_logger_error (_tmp16_, "Settings.vala:128: Could not write to file %s: %s", _tmp19_, _tmp21_);
			_g_free0 (_tmp19_);
			success = FALSE;
			_g_error_free0 (e);
		}
		__finally192:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (stream);
			_g_object_unref0 (settings_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		{
			GFileOutputStream* _tmp22_ = NULL;
			_tmp22_ = stream;
			g_output_stream_close ((GOutputStream*) _tmp22_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch193_g_error;
			}
		}
		goto __finally193;
		__catch193_g_error:
		{
			GError* e = NULL;
			DVBLoggingLogger* _tmp23_ = NULL;
			GError* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp23_ = dvb_settings_log;
			_tmp24_ = e;
			_tmp25_ = _tmp24_->message;
			dvb_logging_logger_error (_tmp23_, "Settings.vala:136: %s", _tmp25_);
			success = FALSE;
			_g_error_free0 (e);
		}
		__finally193:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (stream);
			_g_object_unref0 (settings_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (stream);
	}
	_tmp26_ = success;
	if (_tmp26_) {
		{
			GKeyFile* _tmp27_ = NULL;
			GFile* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			_tmp27_ = self->priv->keyfile;
			_tmp28_ = settings_file;
			_tmp29_ = g_file_get_path (_tmp28_);
			_tmp30_ = _tmp29_;
			g_key_file_load_from_file (_tmp27_, _tmp30_, 0, &_inner_error_);
			_g_free0 (_tmp30_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_KEY_FILE_ERROR) {
					goto __catch194_g_key_file_error;
				}
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch194_g_file_error;
				}
				_g_object_unref0 (settings_file);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		goto __finally194;
		__catch194_g_key_file_error:
		{
			GError* e = NULL;
			DVBLoggingLogger* _tmp31_ = NULL;
			GError* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp31_ = dvb_settings_log;
			_tmp32_ = e;
			_tmp33_ = _tmp32_->message;
			dvb_logging_logger_error (_tmp31_, "Settings.vala:145: Could not load settings: %s", _tmp33_);
			success = FALSE;
			_g_error_free0 (e);
		}
		goto __finally194;
		__catch194_g_file_error:
		{
			GError* e = NULL;
			DVBLoggingLogger* _tmp34_ = NULL;
			GError* _tmp35_ = NULL;
			const gchar* _tmp36_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp34_ = dvb_settings_log;
			_tmp35_ = e;
			_tmp36_ = _tmp35_->message;
			dvb_logging_logger_error (_tmp34_, "Settings.vala:148: Could not load settings: %s", _tmp36_);
			success = FALSE;
			_g_error_free0 (e);
		}
		__finally194:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (settings_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = success;
	_g_object_unref0 (settings_file);
	return result;
}


gboolean dvb_settings_save (DVBSettings* self) {
	gboolean result = FALSE;
	GFile* settings_file = NULL;
	GFile* _tmp0_ = NULL;
	GFileOutputStream* stream = NULL;
	gchar* data = NULL;
	gsize data_len = 0UL;
	GKeyFile* _tmp11_ = NULL;
	gsize _tmp12_ = 0UL;
	gchar* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = dvb_settings_get_settings_file (self);
	settings_file = _tmp0_;
	stream = NULL;
	{
		GFileOutputStream* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		GFileOutputStream* _tmp3_ = NULL;
		GFileOutputStream* _tmp4_ = NULL;
		_tmp2_ = settings_file;
		_tmp3_ = g_file_replace (_tmp2_, NULL, TRUE, 0, NULL, &_inner_error_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch195_g_error;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (stream);
		stream = _tmp4_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally195;
	__catch195_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = dvb_settings_log;
		_tmp6_ = settings_file;
		_tmp7_ = g_file_get_path (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		dvb_logging_logger_error (_tmp5_, "Settings.vala:163: Could not replace file %s: %s", _tmp8_, _tmp10_);
		_g_free0 (_tmp8_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (stream);
		_g_object_unref0 (settings_file);
		return result;
	}
	__finally195:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (stream);
		_g_object_unref0 (settings_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	data = NULL;
	_tmp11_ = self->priv->keyfile;
	_tmp13_ = g_key_file_to_data (_tmp11_, &_tmp12_, NULL);
	data_len = _tmp12_;
	_g_free0 (data);
	data = _tmp13_;
	{
		GFileOutputStream* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		guint8* _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		guint8* _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		_tmp14_ = stream;
		_tmp15_ = data;
		_tmp16_ = string_get_data (_tmp15_, &_tmp16__length1);
		_tmp17_ = _tmp16_;
		_tmp17__length1 = _tmp16__length1;
		g_output_stream_write_all ((GOutputStream*) _tmp14_, _tmp17_, (gsize) _tmp17__length1, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch196_g_error;
		}
	}
	goto __finally196;
	__catch196_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp18_ = NULL;
		GFile* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		GError* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = dvb_settings_log;
		_tmp19_ = settings_file;
		_tmp20_ = g_file_get_path (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		dvb_logging_logger_error (_tmp18_, "Settings.vala:175: Could not write to file %s: %s", _tmp21_, _tmp23_);
		_g_free0 (_tmp21_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (data);
		_g_object_unref0 (stream);
		_g_object_unref0 (settings_file);
		return result;
	}
	__finally196:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (data);
		_g_object_unref0 (stream);
		_g_object_unref0 (settings_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	{
		GFileOutputStream* _tmp24_ = NULL;
		_tmp24_ = stream;
		g_output_stream_close ((GOutputStream*) _tmp24_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch197_g_error;
		}
	}
	goto __finally197;
	__catch197_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp25_ = NULL;
		GError* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = dvb_settings_log;
		_tmp26_ = e;
		_tmp27_ = _tmp26_->message;
		dvb_logging_logger_error (_tmp25_, "Settings.vala:184: %s", _tmp27_);
		_g_error_free0 (e);
	}
	__finally197:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (data);
		_g_object_unref0 (stream);
		_g_object_unref0 (settings_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	_g_free0 (data);
	_g_object_unref0 (stream);
	_g_object_unref0 (settings_file);
	return result;
}


gchar* dvb_settings_get_string (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	GKeyFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp1_ = self->priv->keyfile;
	_tmp2_ = group_name;
	_tmp3_ = key;
	_tmp4_ = g_key_file_get_string (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_g_free0 (_tmp0_);
	return result;
}


gboolean dvb_settings_get_boolean (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GKeyFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group_name != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp1_ = self->priv->keyfile;
	_tmp2_ = group_name;
	_tmp3_ = key;
	_tmp4_ = g_key_file_get_boolean (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp0_;
	return result;
}


gint dvb_settings_get_integer (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error) {
	gint result = 0;
	gint _tmp0_ = 0;
	GKeyFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (group_name != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_tmp1_ = self->priv->keyfile;
	_tmp2_ = group_name;
	_tmp3_ = key;
	_tmp4_ = g_key_file_get_integer (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp0_;
	return result;
}


gdouble dvb_settings_get_double (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
	GKeyFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gdouble _tmp4_ = 0.0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (group_name != NULL, 0.0);
	g_return_val_if_fail (key != NULL, 0.0);
	_tmp1_ = self->priv->keyfile;
	_tmp2_ = group_name;
	_tmp3_ = key;
	_tmp4_ = g_key_file_get_double (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0.0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0.0;
		}
	}
	result = _tmp0_;
	return result;
}


gchar** dvb_settings_get_string_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	GKeyFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gsize _tmp4_;
	gchar** _tmp5_ = NULL;
	gint _tmp0__length1 = 0;
	gint __tmp0__size_ = 0;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp1_ = self->priv->keyfile;
	_tmp2_ = group_name;
	_tmp3_ = key;
	_tmp5_ = g_key_file_get_string_list (_tmp1_, _tmp2_, _tmp3_, &_tmp4_, &_inner_error_);
	_tmp0_ = _tmp5_;
	_tmp0__length1 = _tmp4_;
	__tmp0__size_ = _tmp0__length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = _tmp0_;
	_tmp6__length1 = _tmp0__length1;
	_tmp0_ = NULL;
	_tmp0__length1 = 0;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
	return result;
}


gboolean* dvb_settings_get_boolean_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error) {
	gboolean* result = NULL;
	gboolean* _tmp0_ = NULL;
	GKeyFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gsize _tmp4_;
	gboolean* _tmp5_ = NULL;
	gint _tmp0__length1 = 0;
	gint __tmp0__size_ = 0;
	gboolean* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gboolean* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp1_ = self->priv->keyfile;
	_tmp2_ = group_name;
	_tmp3_ = key;
	_tmp5_ = g_key_file_get_boolean_list (_tmp1_, _tmp2_, _tmp3_, &_tmp4_, &_inner_error_);
	_tmp0_ = _tmp5_;
	_tmp0__length1 = _tmp4_;
	__tmp0__size_ = _tmp0__length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = _tmp0_;
	_tmp6__length1 = _tmp0__length1;
	_tmp0_ = NULL;
	_tmp0__length1 = 0;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	_tmp0_ = (g_free (_tmp0_), NULL);
	return result;
}


gint* dvb_settings_get_integer_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error) {
	gint* result = NULL;
	gint* _tmp0_ = NULL;
	GKeyFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gsize _tmp4_;
	gint* _tmp5_ = NULL;
	gint _tmp0__length1 = 0;
	gint __tmp0__size_ = 0;
	gint* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp1_ = self->priv->keyfile;
	_tmp2_ = group_name;
	_tmp3_ = key;
	_tmp5_ = g_key_file_get_integer_list (_tmp1_, _tmp2_, _tmp3_, &_tmp4_, &_inner_error_);
	_tmp0_ = _tmp5_;
	_tmp0__length1 = _tmp4_;
	__tmp0__size_ = _tmp0__length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = _tmp0_;
	_tmp6__length1 = _tmp0__length1;
	_tmp0_ = NULL;
	_tmp0__length1 = 0;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	_tmp0_ = (g_free (_tmp0_), NULL);
	return result;
}


gdouble* dvb_settings_get_double_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error) {
	gdouble* result = NULL;
	gdouble* _tmp0_ = NULL;
	GKeyFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gsize _tmp4_;
	gdouble* _tmp5_ = NULL;
	gint _tmp0__length1 = 0;
	gint __tmp0__size_ = 0;
	gdouble* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gdouble* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp1_ = self->priv->keyfile;
	_tmp2_ = group_name;
	_tmp3_ = key;
	_tmp5_ = g_key_file_get_double_list (_tmp1_, _tmp2_, _tmp3_, &_tmp4_, &_inner_error_);
	_tmp0_ = _tmp5_;
	_tmp0__length1 = _tmp4_;
	__tmp0__size_ = _tmp0__length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = _tmp0_;
	_tmp6__length1 = _tmp0__length1;
	_tmp0_ = NULL;
	_tmp0__length1 = 0;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	_tmp0_ = (g_free (_tmp0_), NULL);
	return result;
}


void dvb_settings_set_string (DVBSettings* self, const gchar* group_name, const gchar* key, const gchar* val, GError** error) {
	GKeyFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp3_ = val;
	g_key_file_set_string (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
}


void dvb_settings_set_boolean (DVBSettings* self, const gchar* group_name, const gchar* key, gboolean val, GError** error) {
	GKeyFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp3_ = val;
	g_key_file_set_boolean (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
}


void dvb_settings_set_double (DVBSettings* self, const gchar* group_name, const gchar* key, gdouble val, GError** error) {
	GKeyFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp3_ = val;
	g_key_file_set_double (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
}


void dvb_settings_set_integer (DVBSettings* self, const gchar* group_name, const gchar* key, gint val, GError** error) {
	GKeyFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp3_ = val;
	g_key_file_set_integer (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
}


void dvb_settings_set_string_list (DVBSettings* self, const gchar* group_name, const gchar* key, gchar** val, int val_length1, GError** error) {
	GKeyFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp3_ = val;
	_tmp3__length1 = val_length1;
	g_key_file_set_string_list (_tmp0_, _tmp1_, _tmp2_, (const gchar* const*) _tmp3_, _tmp3__length1);
}


void dvb_settings_set_boolean_list (DVBSettings* self, const gchar* group_name, const gchar* key, gboolean* val, int val_length1, GError** error) {
	GKeyFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp3_ = val;
	_tmp3__length1 = val_length1;
	g_key_file_set_boolean_list (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp3__length1);
}


void dvb_settings_set_double_list (DVBSettings* self, const gchar* group_name, const gchar* key, gdouble* val, int val_length1, GError** error) {
	GKeyFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gdouble* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp3_ = val;
	_tmp3__length1 = val_length1;
	g_key_file_set_double_list (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp3__length1);
}


void dvb_settings_set_integer_list (DVBSettings* self, const gchar* group_name, const gchar* key, gint* val, int val_length1, GError** error) {
	GKeyFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp3_ = val;
	_tmp3__length1 = val_length1;
	g_key_file_set_integer_list (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp3__length1);
}


DVBSettings* dvb_settings_construct (GType object_type) {
	DVBSettings * self = NULL;
	self = (DVBSettings*) g_object_new (object_type, NULL);
	return self;
}


DVBSettings* dvb_settings_new (void) {
	return dvb_settings_construct (DVB_TYPE_SETTINGS);
}


static GObject * dvb_settings_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBSettings * self;
	GKeyFile* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (dvb_settings_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_SETTINGS, DVBSettings);
	_tmp0_ = g_key_file_new ();
	_g_key_file_unref0 (self->priv->keyfile);
	self->priv->keyfile = _tmp0_;
	return obj;
}


static void dvb_settings_class_init (DVBSettingsClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBSettingsPrivate));
	G_OBJECT_CLASS (klass)->constructor = dvb_settings_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_settings_finalize;
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_settings_log = _tmp1_;
}


static void dvb_settings_instance_init (DVBSettings * self) {
	self->priv = DVB_SETTINGS_GET_PRIVATE (self);
}


static void dvb_settings_finalize (GObject* obj) {
	DVBSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_SETTINGS, DVBSettings);
	_g_key_file_unref0 (self->priv->keyfile);
	G_OBJECT_CLASS (dvb_settings_parent_class)->finalize (obj);
}


GType dvb_settings_get_type (void) {
	static volatile gsize dvb_settings_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_settings_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBSettings), 0, (GInstanceInitFunc) dvb_settings_instance_init, NULL };
		GType dvb_settings_type_id;
		dvb_settings_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBSettings", &g_define_type_info, 0);
		g_once_init_leave (&dvb_settings_type_id__volatile, dvb_settings_type_id);
	}
	return dvb_settings_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



