/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define GNOME_SCAN_TYPE_OPTION_MANAGER (gnome_scan_option_manager_get_type ())
#define GNOME_SCAN_OPTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_MANAGER, GnomeScanOptionManager))
#define GNOME_SCAN_OPTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_MANAGER, GnomeScanOptionManagerClass))
#define GNOME_SCAN_IS_OPTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_MANAGER))
#define GNOME_SCAN_IS_OPTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_MANAGER))
#define GNOME_SCAN_OPTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_MANAGER, GnomeScanOptionManagerClass))

typedef struct _GnomeScanOptionManager GnomeScanOptionManager;
typedef struct _GnomeScanOptionManagerClass GnomeScanOptionManagerClass;
typedef struct _GnomeScanOptionManagerPrivate GnomeScanOptionManagerPrivate;

#define GNOME_SCAN_TYPE_OPTION (gnome_scan_option_get_type ())
#define GNOME_SCAN_OPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOption))
#define GNOME_SCAN_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))
#define GNOME_SCAN_IS_OPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_IS_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_OPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))

typedef struct _GnomeScanOption GnomeScanOption;
typedef struct _GnomeScanOptionClass GnomeScanOptionClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _GnomeScanOptionManager {
	GObject parent_instance;
	GnomeScanOptionManagerPrivate * priv;
};

struct _GnomeScanOptionManagerClass {
	GObjectClass parent_class;
};

struct _GnomeScanOptionManagerPrivate {
	GHashTable* rules_by_name;
	GHashTable* rules_by_type;
	GHashTable* options;
};


extern GnomeScanOptionManager* gnome_scan_option_manager;
GnomeScanOptionManager* gnome_scan_option_manager = NULL;
static gpointer gnome_scan_option_manager_parent_class = NULL;

GType gnome_scan_option_manager_get_type (void);
GType gnome_scan_option_get_type (void);
#define GNOME_SCAN_OPTION_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION_MANAGER, GnomeScanOptionManagerPrivate))
enum  {
	GNOME_SCAN_OPTION_MANAGER_DUMMY_PROPERTY
};
const char* gnome_scan_option_get_name (GnomeScanOption* self);
void gnome_scan_option_manager_register_option (GnomeScanOptionManager* self, GnomeScanOption* option);
void gnome_scan_option_manager_register_rule_by_name (GnomeScanOptionManager* self, const char* option_name, GType handler_type);
void gnome_scan_option_manager_register_rule_by_type (GnomeScanOptionManager* self, GType option_type, GType handler_type);
GType gnome_scan_option_manager_get_widget_type_for (GnomeScanOptionManager* self, GnomeScanOption* option);
GnomeScanOptionManager* gnome_scan_option_manager_new (void);
GnomeScanOptionManager* gnome_scan_option_manager_construct (GType object_type);
static GObject * gnome_scan_option_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gnome_scan_option_manager_finalize (GObject* obj);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void gnome_scan_option_manager_register_option (GnomeScanOptionManager* self, GnomeScanOption* option) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	g_hash_table_insert (self->priv->options, gnome_scan_option_get_name (option), _g_object_ref0 (option));
}


void gnome_scan_option_manager_register_rule_by_name (GnomeScanOptionManager* self, const char* option_name, GType handler_type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (option_name != NULL);
	g_hash_table_insert (self->priv->rules_by_name, option_name, GINT_TO_POINTER (handler_type));
}


void gnome_scan_option_manager_register_rule_by_type (GnomeScanOptionManager* self, GType option_type, GType handler_type) {
	g_return_if_fail (self != NULL);
	g_hash_table_insert (self->priv->rules_by_type, GINT_TO_POINTER (option_type), GINT_TO_POINTER (handler_type));
}


GType gnome_scan_option_manager_get_widget_type_for (GnomeScanOptionManager* self, GnomeScanOption* option) {
	GType result;
	GType wtype;
	g_return_val_if_fail (self != NULL, 0UL);
	g_return_val_if_fail (option != NULL, 0UL);
	wtype = 0UL;
	wtype = GPOINTER_TO_INT (g_hash_table_lookup (self->priv->rules_by_name, gnome_scan_option_get_name (option)));
	if (wtype != G_TYPE_INVALID) {
		result = wtype;
		return result;
	}
	wtype = GPOINTER_TO_INT (g_hash_table_lookup (self->priv->rules_by_type, GINT_TO_POINTER (G_TYPE_FROM_INSTANCE ((GObject*) option))));
	if (wtype != G_TYPE_INVALID) {
		result = wtype;
		return result;
	}
	result = G_TYPE_INVALID;
	return result;
}


GnomeScanOptionManager* gnome_scan_option_manager_construct (GType object_type) {
	GnomeScanOptionManager * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GnomeScanOptionManager* gnome_scan_option_manager_new (void) {
	return gnome_scan_option_manager_construct (GNOME_SCAN_TYPE_OPTION_MANAGER);
}


static GObject * gnome_scan_option_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanOptionManagerClass * klass;
	GObjectClass * parent_class;
	GnomeScanOptionManager * self;
	klass = GNOME_SCAN_OPTION_MANAGER_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_OPTION_MANAGER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_OPTION_MANAGER (obj);
	{
		GHashTable* _tmp0_;
		GHashTable* _tmp1_;
		GHashTable* _tmp2_;
		self->priv->rules_by_name = (_tmp0_ = g_hash_table_new (g_str_hash, g_str_equal), _g_hash_table_unref0 (self->priv->rules_by_name), _tmp0_);
		self->priv->rules_by_type = (_tmp1_ = g_hash_table_new (g_direct_hash, g_direct_equal), _g_hash_table_unref0 (self->priv->rules_by_type), _tmp1_);
		self->priv->options = (_tmp2_ = g_hash_table_new (g_str_hash, g_str_equal), _g_hash_table_unref0 (self->priv->options), _tmp2_);
	}
	return obj;
}


static void gnome_scan_option_manager_class_init (GnomeScanOptionManagerClass * klass) {
	gnome_scan_option_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionManagerPrivate));
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_option_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_manager_finalize;
}


static void gnome_scan_option_manager_instance_init (GnomeScanOptionManager * self) {
	self->priv = GNOME_SCAN_OPTION_MANAGER_GET_PRIVATE (self);
}


static void gnome_scan_option_manager_finalize (GObject* obj) {
	GnomeScanOptionManager * self;
	self = GNOME_SCAN_OPTION_MANAGER (obj);
	_g_hash_table_unref0 (self->priv->rules_by_name);
	_g_hash_table_unref0 (self->priv->rules_by_type);
	_g_hash_table_unref0 (self->priv->options);
	G_OBJECT_CLASS (gnome_scan_option_manager_parent_class)->finalize (obj);
}


GType gnome_scan_option_manager_get_type (void) {
	static GType gnome_scan_option_manager_type_id = 0;
	if (gnome_scan_option_manager_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionManager), 0, (GInstanceInitFunc) gnome_scan_option_manager_instance_init, NULL };
		gnome_scan_option_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GnomeScanOptionManager", &g_define_type_info, 0);
	}
	return gnome_scan_option_manager_type_id;
}




