#! /usr/bin/ruby -Ke

#==============================================================================#
# $Id: pie4.rb,v 1.3 2004/01/23 00:38:36 yuya Exp $
#==============================================================================#

require 'grb/chart/pie/facade'

#==============================================================================#

data = [
  {:name => 'Field 1', :value => 9, :color => GRb::Color.red(224)    },
  {:name => 'Field 2', :value => 8, :color => GRb::Color.green(224)  },
  {:name => 'Field 3', :value => 6, :color => GRb::Color.blue(224)   },
  {:name => 'Field 4', :value => 5, :color => GRb::Color.yellow(224) },
  {:name => 'Field 5', :value => 3, :color => GRb::Color.skyblue(224)},
  {:name => 'Field 6', :value => 2, :color => GRb::Color.purple(224) },
]

#==============================================================================#

facade = GRb::Chart::PieChartFacade.create(400, 300)
facade.title.text             = 'Pie Chart Sample 4'   # ȥ ʸ
facade.title.position         = :middle_left           # ȥ 
facade.title.font.vertical    = true                   # ȥ ե ľ
facade.frame.fill.visible     = true                   # ط طʿ ɽ
facade.frame.fill.color       = GRb::Color.gray(224)   # ط طʿ 
facade.frame.shadow.visible   = true                   # ط  ɽ
facade.frame.shadow.color     = GRb::Color.gray(192)   # ط  
facade.frame.shadow.offset_x  = -3                     # ط  եå
facade.frame.shadow.offset_y  = 3                      # ط  եå
facade.legend.vertical        = false                  #  ʿ
facade.legend.position        = :bottom_left           #  
facade.legend.font.name       = GRb::Chart::Font::Tiny #  ե ̾
facade.legend.fill.visible    = true                   #  طʿ ɽ
facade.legend.fill.color      = GRb::Color.gray(192)   #  طʿ 
facade.legend.shadow.visible  = true                   #   ɽ
facade.legend.shadow.color    = GRb::Color.gray(128)   #   
facade.legend.shadow.offset_x = -3                     #   եå
facade.legend.shadow.offset_y = 3                      #   եå
facade.chart.fill.visible     = true                   # 㡼 طʿ ɽ
facade.chart.fill.color       = GRb::Color.gray(192)   # 㡼 طʿ 
facade.chart.border.visible   = true                   # 㡼  ɽ
facade.chart.shadow.visible   = true                   # 㡼  ɽ
facade.chart.shadow.color     = GRb::Color.gray(128)   # 㡼  
facade.chart.shadow.offset_x  = -3                     # 㡼  եå
facade.chart.shadow.offset_y  = 3                      # 㡼  եå
facade.data                   = data
facade.write_png_file('pie4.png')

#==============================================================================#
#==============================================================================#
