
#==============================================================================#
# $Id: split.rb,v 1.2 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/decorator/split.rb,v $
#==============================================================================#

require 'grb/chart/base/decorator/base'

#==============================================================================#

module GRb

  module Chart

    class VerticalSplitDecoratorBase < DecoratorBase

      def initialize(upper, lower)
        @upper = upper
        @lower = lower
      end

      def draw(image, box)
        if @upper || @lower
          height = self.calculate_height
          @upper.draw(image, self.calculate_upper(box, height))
          @lower.draw(image, self.calculate_lower(box, height))
        end
      end

    end # VerticalSplitDecoratorBase

    class VerticalSplitUpperDecorator < VerticalSplitDecoratorBase

      def calculate_height
        return @upper.dy
      end

      def calculate_upper(box, height)
        upper_box = GRb::Chart::Box.new
        upper_box.x  = box.x
        upper_box.y  = box.y
        upper_box.dx = box.dx
        upper_box.dy = height
        return upper_box
      end

      def calculate_lower(box, height)
        lower_box = GRb::Chart::Box.new
        lower_box.x  = box.x
        lower_box.y  = box.y + height
        lower_box.dx = box.dx
        lower_box.dy = box.dy - height
        return lower_box
      end

    end # VerticalSplitUpperDecorator

    class VerticalSplitLowerDecorator < VerticalSplitDecoratorBase

      def calculate_height
        return @lower.dy
      end

      def calculate_upper(box, height)
        upper_box = GRb::Chart::Box.new
        upper_box.x  = box.x
        upper_box.y  = box.y
        upper_box.dx = box.dx
        upper_box.dy = box.dy - height
        return upper_box
      end

      def calculate_lower(box, height)
        lower_box = GRb::Chart::Box.new
        lower_box.x  = box.x
        lower_box.y  = box.y2 - height + 1
        lower_box.dx = box.dx
        lower_box.dy = height
        return lower_box
      end

    end # VerticalSplitLowerDecorator

    class HorizontalSplitDecoratorBase < DecoratorBase

      def initialize(left, right)
        @left  = left
        @right = right
      end

      def draw(image, box)
        if @left || @right
          width = self.calculate_width
          @left.draw(image, self.calculate_left(box, width))
          @right.draw(image, self.calculate_right(box, width))
        end
      end

    end # HorizontalSplitDecoratorBase

    class HorizontalSplitLeftDecorator < HorizontalSplitDecoratorBase

      def calculate_width
        return @left.dx
      end

      def calculate_left(box, width)
        left_box = GRb::Chart::Box.new
        left_box.x  = box.x
        left_box.y  = box.y
        left_box.dx = width
        left_box.dy = box.dy
        return left_box
      end

      def calculate_right(box, width)
        right_box = GRb::Chart::Box.new
        right_box.x  = box.x + width
        right_box.y  = box.y
        right_box.dx = box.dx - width
        right_box.dy = box.dy
        return right_box
      end

    end # HorizontalSplitLeftDecorator

    class HorizontalSplitRightDecorator < HorizontalSplitDecoratorBase

      def calculate_width
        return @right.dx
      end

      def calculate_left(box, width)
        left_box = GRb::Chart::Box.new
        left_box.x  = box.x
        left_box.y  = box.y
        left_box.dx = box.dx - width
        left_box.dy = box.dy
        return left_box
      end

      def calculate_right(box, width)
        right_box = GRb::Chart::Box.new
        right_box.x  = box.x2 - width + 1
        right_box.y  = box.y
        right_box.dx = width
        right_box.dy = box.dy
        return right_box
      end

    end # HorizontalSplitRightDecorator

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
