
#==============================================================================#
# $Id: scale_grid.rb,v 1.2 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/xy_base/decorator/scale_grid.rb,v $
#==============================================================================#

require 'grb/chart/base/decorator/no_child_base'

#==============================================================================#

module GRb

  module Chart

    class ScaleGridDecorator < NoChildDecoratorBase

      def initialize
        @scale = nil
        @color = nil
      end

      attr_accessor :scale, :color

      def draw(image, box)
        interval = @scale.interval
        raito    = @scale.raito(box.dy - 1)
        origin   = @scale.delta + @scale.minimum

        if @scale.maximum > 0
          base   = [@scale.minimum, 0].max
          delta  = @scale.maximum - base
          number = (delta.to_f / interval.to_f).floor + 1
          number.times { |i|
            y = box.y + (origin - base - interval * i) * raito
            image.line(box.x, y, box.x2, y, @color)
          }
        end

        if @scale.minimum < 0
          base   = [@scale.maximum, 0].min
          delta  = (@scale.minimum - base).abs
          number = (delta.to_f / interval.to_f).floor + 1
          number.times { |i|
            y = box.y + (origin - base + interval * i) * raito
            image.line(box.x, y, box.x2, y, @color)
          }
        end
      end

    end # ScaleGridDecorator

  end # Chart

end # GRb

#==============================================================================#

if $0 == __FILE__
  require 'grb/image'
  require 'grb/chart/scale'

  GRb::Image.create_and_write_png_file(200, 200, false, __FILE__.sub(/\.rb/, '.png')) { |image|
    GRb::Chart::Decorator::ScaleGrid.new.instance_eval {
      self.scale = GRb::Chart::Scale.new(100, -20, 10)
      self.color = GRb::Color.red(128)
      self.draw(image, GRb::Chart::Box.new(10, 10, 180, 180))
    }
  }
end

#==============================================================================#
#==============================================================================#
