
#==============================================================================#
# $Id: fill.rb,v 1.2 2004/01/16 14:37:33 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/fill.rb,v $
#==============================================================================#

module GRb

  class Fill

    def initialize(color = nil, opacity = nil)
      @color   = color   || nil
      @opacity = opacity || 100
    end

    attr_accessor :color, :opacity

    def self.new_from(style)
      case style
      when Fill     then return style
      when Color    then return self.new(style)
      when Hash     then return self.new_from_hash(style)
      when NilClass then return self.new
      else raise(TypeError, "GRb::Fill/GRb::Color/Hash required")
      end
    end

    def self.new_from_hash(hash)
      fill = self.new
      fill.color   = hash[:color]   || nil
      fill.opacity = hash[:opacity] || 100

      return fill
    end

    def draw?
      return false if @color.nil?
      return false if @opacity <= 0
      return true
    end

    def set(image)
      return @color.set(image)
    end

  end # Fill

end # GRb

#==============================================================================#
#==============================================================================#
