/* 
 * cache.c: Cache mechanisms mainly for POP3 commands.
 *
 * Created: R.J.V. Bertin, Josh Myer and David Smith 2002/3.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */


#include "hotwayd.h"
#include <sys/time.h>

cmdtable *prev_command;

void register_command( cmdtable *command, char *response, int argc, char *arg1, char *arg2 )
{
	int i;

	if( prev_command && prev_command->argc > 0 ){
		for( i = 0; i < prev_command->argc; i++ )
			free( prev_command->argv[i] );
		prev_command->argc= 0;
		free(prev_command->response);
	}

	if( response && command ){
		struct timeval tv;
		struct timezone tz;

		command->response= strdup(response);

		/* why not time() here? we only need a relative
		 * timestamp -jbm */

		gettimeofday( &tv, &tz );
		command->timestamp= tv.tv_sec;
		if( argc > 0 ){
			char *a;
			command->argc= MIN( argc, MAXARGC );
			for( i = 0; i < command->argc; i++ ){
				switch( i ){
				case 0:
					a= arg1;
					break;
				case 1:
					a= arg2;
					break;
				default:
					a= NULL;
					break;
				}
				command->argv[i]= (a) ? strdup(a) : NULL;
			}
		}
		prev_command= command;
#ifdef DEBUG
		fprintf( stderr, "Command \"%s\" registered in cache with timestamp %ld and %d arg(s)\n",
			 prev_command->name, prev_command->timestamp, prev_command->argc 
			);
#endif
	}
	else{
		prev_command= NULL;		
	}
}

cmdtable *cached_command( cmdtable *command, int argc, char **argv )
{ 
	struct timeval tv;
	struct timezone tz;

	gettimeofday( &tv, &tz );
	argc= MIN( argc-1, MAXARGC );
	if( prev_command && command->handler== prev_command->handler && 
		argc== prev_command->argc && tv.tv_sec- prev_command->timestamp<= 30
	){
		if( argc ){
		  int i;
		  for( i= 0; i< argc; i++ ){
		    /* If no previous argument was found, or it is different than the current at the matching
		       \ position, we exit with a failure status. The current command must be looked up at
		       \ offset 1 (argv[0] is the POP command name).
		    */
		    if( !prev_command->argv[i] || strcmp( argv[i+1], prev_command->argv[i]) ){
		      return NULL;
		    }
		  }
		}
		return prev_command;
	}
	else{
		return(0);
	}
}

