/* service.c generated by valac 0.14.0, the Vala compiler
 * generated from service.vala, do not modify */

/*
 * Copyright (C) 2011  Daiki Ueno
 * Copyright (C) 2011  Red Hat, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <ibus/ibuspanelextensions.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


#define IBUS_CHARMAP_TYPE_SERVICE (ibus_charmap_service_get_type ())
#define IBUS_CHARMAP_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_CHARMAP_TYPE_SERVICE, IBusCharmapService))
#define IBUS_CHARMAP_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_CHARMAP_TYPE_SERVICE, IBusCharmapServiceClass))
#define IBUS_CHARMAP_IS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_CHARMAP_TYPE_SERVICE))
#define IBUS_CHARMAP_IS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_CHARMAP_TYPE_SERVICE))
#define IBUS_CHARMAP_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_CHARMAP_TYPE_SERVICE, IBusCharmapServiceClass))

typedef struct _IBusCharmapService IBusCharmapService;
typedef struct _IBusCharmapServiceClass IBusCharmapServiceClass;
typedef struct _IBusCharmapServicePrivate IBusCharmapServicePrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _IBusCharmapService {
	GObject parent_instance;
	IBusCharmapServicePrivate * priv;
};

struct _IBusCharmapServiceClass {
	GObjectClass parent_class;
	void (*show) (IBusCharmapService* self);
	void (*hide) (IBusCharmapService* self);
	void (*set_cursor_location) (IBusCharmapService* self, gint x, gint y, gint w, gint h);
	void (*move_cursor) (IBusCharmapService* self, IBusMovementStep step, gint count);
	void (*select_character) (IBusCharmapService* self, gunichar uc);
	void (*activate_selected) (IBusCharmapService* self);
	void (*popup_chapters) (IBusCharmapService* self);
	void (*start_search) (IBusCharmapService* self, const gchar* name, guint max_matches);
	void (*cancel_search) (IBusCharmapService* self);
};

struct _IBusCharmapServicePrivate {
	gboolean _visible;
};


static gpointer ibus_charmap_service_parent_class = NULL;

GType ibus_charmap_service_get_type (void) G_GNUC_CONST;
guint ibus_charmap_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
#define IBUS_CHARMAP_SERVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), IBUS_CHARMAP_TYPE_SERVICE, IBusCharmapServicePrivate))
enum  {
	IBUS_CHARMAP_SERVICE_DUMMY_PROPERTY,
	IBUS_CHARMAP_SERVICE_VISIBLE
};
void ibus_charmap_service_show (IBusCharmapService* self);
static void ibus_charmap_service_real_show (IBusCharmapService* self);
void ibus_charmap_service_hide (IBusCharmapService* self);
static void ibus_charmap_service_real_hide (IBusCharmapService* self);
void ibus_charmap_service_set_cursor_location (IBusCharmapService* self, gint x, gint y, gint w, gint h);
static void ibus_charmap_service_real_set_cursor_location (IBusCharmapService* self, gint x, gint y, gint w, gint h);
void ibus_charmap_service_move_cursor (IBusCharmapService* self, IBusMovementStep step, gint count);
static void ibus_charmap_service_real_move_cursor (IBusCharmapService* self, IBusMovementStep step, gint count);
void ibus_charmap_service_select_character (IBusCharmapService* self, gunichar uc);
static void ibus_charmap_service_real_select_character (IBusCharmapService* self, gunichar uc);
void ibus_charmap_service_activate_selected (IBusCharmapService* self);
static void ibus_charmap_service_real_activate_selected (IBusCharmapService* self);
void ibus_charmap_service_popup_chapters (IBusCharmapService* self);
static void ibus_charmap_service_real_popup_chapters (IBusCharmapService* self);
void ibus_charmap_service_start_search (IBusCharmapService* self, const gchar* name, guint max_matches);
static void ibus_charmap_service_real_start_search (IBusCharmapService* self, const gchar* name, guint max_matches);
void ibus_charmap_service_cancel_search (IBusCharmapService* self);
static void ibus_charmap_service_real_cancel_search (IBusCharmapService* self);
void ibus_charmap_service_register_charmap (IBusCharmapService* self, GDBusConnection* conn);
static void __lambda1_ (IBusCharmapService* self);
static void ___lambda1__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void __lambda2_ (IBusCharmapService* self);
static void ___lambda2__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self);
IBusCharmapService* ibus_charmap_service_construct (GType object_type);
gboolean ibus_charmap_service_get_visible (IBusCharmapService* self);
void ibus_charmap_service_set_visible (IBusCharmapService* self, gboolean value);
static void ibus_charmap_service_finalize (GObject* obj);
static void _vala_ibus_charmap_service_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_ibus_charmap_service_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _dbus_ibus_charmap_service_show (IBusCharmapService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_ibus_charmap_service_hide (IBusCharmapService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_ibus_charmap_service_set_cursor_location (IBusCharmapService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_ibus_charmap_service_move_cursor (IBusCharmapService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_ibus_charmap_service_select_character (IBusCharmapService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_ibus_charmap_service_activate_selected (IBusCharmapService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_ibus_charmap_service_popup_chapters (IBusCharmapService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_ibus_charmap_service_start_search (IBusCharmapService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_ibus_charmap_service_cancel_search (IBusCharmapService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void ibus_charmap_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* ibus_charmap_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_ibus_charmap_service_get_visible (IBusCharmapService* self);
static gboolean ibus_charmap_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_ibus_charmap_service_set_visible (IBusCharmapService* self, GVariant* _value);
static void _dbus_ibus_charmap_service_character_activated (GObject* _sender, gunichar uc, gpointer* _data);
static void _ibus_charmap_service_unregister_object (gpointer user_data);

static const GDBusArgInfo * const _ibus_charmap_service_dbus_arg_info_show_in[] = {NULL};
static const GDBusArgInfo * const _ibus_charmap_service_dbus_arg_info_show_out[] = {NULL};
static const GDBusMethodInfo _ibus_charmap_service_dbus_method_info_show = {-1, "Show", (GDBusArgInfo **) (&_ibus_charmap_service_dbus_arg_info_show_in), (GDBusArgInfo **) (&_ibus_charmap_service_dbus_arg_info_show_out)};
static const GDBusArgInfo * const _ibus_charmap_service_dbus_arg_info_hide_in[] = {NULL};
static const GDBusArgInfo * const _ibus_charmap_service_dbus_arg_info_hide_out[] = {NULL};
static const GDBusMethodInfo _ibus_charmap_service_dbus_method_info_hide = {-1, "Hide", (GDBusArgInfo **) (&_ibus_charmap_service_dbus_arg_info_hide_in), (GDBusArgInfo **) (&_ibus_charmap_service_dbus_arg_info_hide_out)};
static const GDBusArgInfo _ibus_charmap_service_dbus_arg_info_set_cursor_location_x = {-1, "x", "i"};
static const GDBusArgInfo _ibus_charmap_service_dbus_arg_info_set_cursor_location_y = {-1, "y", "i"};
static const GDBusArgInfo _ibus_charmap_service_dbus_arg_info_set_cursor_location_w = {-1, "w", "i"};
static const GDBusArgInfo _ibus_charmap_service_dbus_arg_info_set_cursor_location_h = {-1, "h", "i"};
static const GDBusArgInfo * const _ibus_charmap_service_dbus_arg_info_set_cursor_location_in[] = {&_ibus_charmap_service_dbus_arg_info_set_cursor_location_x, &_ibus_charmap_service_dbus_arg_info_set_cursor_location_y, &_ibus_charmap_service_dbus_arg_info_set_cursor_location_w, &_ibus_charmap_service_dbus_arg_info_set_cursor_location_h, NULL};
static const GDBusArgInfo * const _ibus_charmap_service_dbus_arg_info_set_cursor_location_out[] = {NULL};
static const GDBusMethodInfo _ibus_charmap_service_dbus_method_info_set_cursor_location = {-1, "SetCursorLocation", (GDBusArgInfo **) (&_ibus_charmap_service_dbus_arg_info_set_cursor_location_in), (GDBusArgInfo **) (&_ibus_charmap_service_dbus_arg_info_set_cursor_location_out)};
static const GDBusArgInfo _ibus_charmap_service_dbus_arg_info_move_cursor_step = {-1, "step", "i"};
static const GDBusArgInfo _ibus_charmap_service_dbus_arg_info_move_cursor_count = {-1, "count", "i"};
static const GDBusArgInfo * const _ibus_charmap_service_dbus_arg_info_move_cursor_in[] = {&_ibus_charmap_service_dbus_arg_info_move_cursor_step, &_ibus_charmap_service_dbus_arg_info_move_cursor_count, NULL};
static const GDBusArgInfo * const _ibus_charmap_service_dbus_arg_info_move_cursor_out[] = {NULL};
static const GDBusMethodInfo _ibus_charmap_service_dbus_method_info_move_cursor = {-1, "MoveCursor", (GDBusArgInfo **) (&_ibus_charmap_service_dbus_arg_info_move_cursor_in), (GDBusArgInfo **) (&_ibus_charmap_service_dbus_arg_info_move_cursor_out)};
static const GDBusArgInfo _ibus_charmap_service_dbus_arg_info_select_character_uc = {-1, "uc", "u"};
static const GDBusArgInfo * const _ibus_charmap_service_dbus_arg_info_select_character_in[] = {&_ibus_charmap_service_dbus_arg_info_select_character_uc, NULL};
static const GDBusArgInfo * const _ibus_charmap_service_dbus_arg_info_select_character_out[] = {NULL};
static const GDBusMethodInfo _ibus_charmap_service_dbus_method_info_select_character = {-1, "SelectCharacter", (GDBusArgInfo **) (&_ibus_charmap_service_dbus_arg_info_select_character_in), (GDBusArgInfo **) (&_ibus_charmap_service_dbus_arg_info_select_character_out)};
static const GDBusArgInfo * const _ibus_charmap_service_dbus_arg_info_activate_selected_in[] = {NULL};
static const GDBusArgInfo * const _ibus_charmap_service_dbus_arg_info_activate_selected_out[] = {NULL};
static const GDBusMethodInfo _ibus_charmap_service_dbus_method_info_activate_selected = {-1, "ActivateSelected", (GDBusArgInfo **) (&_ibus_charmap_service_dbus_arg_info_activate_selected_in), (GDBusArgInfo **) (&_ibus_charmap_service_dbus_arg_info_activate_selected_out)};
static const GDBusArgInfo * const _ibus_charmap_service_dbus_arg_info_popup_chapters_in[] = {NULL};
static const GDBusArgInfo * const _ibus_charmap_service_dbus_arg_info_popup_chapters_out[] = {NULL};
static const GDBusMethodInfo _ibus_charmap_service_dbus_method_info_popup_chapters = {-1, "PopupChapters", (GDBusArgInfo **) (&_ibus_charmap_service_dbus_arg_info_popup_chapters_in), (GDBusArgInfo **) (&_ibus_charmap_service_dbus_arg_info_popup_chapters_out)};
static const GDBusArgInfo _ibus_charmap_service_dbus_arg_info_start_search_name = {-1, "name", "s"};
static const GDBusArgInfo _ibus_charmap_service_dbus_arg_info_start_search_max_matches = {-1, "max_matches", "u"};
static const GDBusArgInfo * const _ibus_charmap_service_dbus_arg_info_start_search_in[] = {&_ibus_charmap_service_dbus_arg_info_start_search_name, &_ibus_charmap_service_dbus_arg_info_start_search_max_matches, NULL};
static const GDBusArgInfo * const _ibus_charmap_service_dbus_arg_info_start_search_out[] = {NULL};
static const GDBusMethodInfo _ibus_charmap_service_dbus_method_info_start_search = {-1, "StartSearch", (GDBusArgInfo **) (&_ibus_charmap_service_dbus_arg_info_start_search_in), (GDBusArgInfo **) (&_ibus_charmap_service_dbus_arg_info_start_search_out)};
static const GDBusArgInfo * const _ibus_charmap_service_dbus_arg_info_cancel_search_in[] = {NULL};
static const GDBusArgInfo * const _ibus_charmap_service_dbus_arg_info_cancel_search_out[] = {NULL};
static const GDBusMethodInfo _ibus_charmap_service_dbus_method_info_cancel_search = {-1, "CancelSearch", (GDBusArgInfo **) (&_ibus_charmap_service_dbus_arg_info_cancel_search_in), (GDBusArgInfo **) (&_ibus_charmap_service_dbus_arg_info_cancel_search_out)};
static const GDBusMethodInfo * const _ibus_charmap_service_dbus_method_info[] = {&_ibus_charmap_service_dbus_method_info_show, &_ibus_charmap_service_dbus_method_info_hide, &_ibus_charmap_service_dbus_method_info_set_cursor_location, &_ibus_charmap_service_dbus_method_info_move_cursor, &_ibus_charmap_service_dbus_method_info_select_character, &_ibus_charmap_service_dbus_method_info_activate_selected, &_ibus_charmap_service_dbus_method_info_popup_chapters, &_ibus_charmap_service_dbus_method_info_start_search, &_ibus_charmap_service_dbus_method_info_cancel_search, NULL};
static const GDBusArgInfo _ibus_charmap_service_dbus_arg_info_character_activated_uc = {-1, "uc", "u"};
static const GDBusArgInfo * const _ibus_charmap_service_dbus_arg_info_character_activated[] = {&_ibus_charmap_service_dbus_arg_info_character_activated_uc, NULL};
static const GDBusSignalInfo _ibus_charmap_service_dbus_signal_info_character_activated = {-1, "CharacterActivated", (GDBusArgInfo **) (&_ibus_charmap_service_dbus_arg_info_character_activated)};
static const GDBusSignalInfo * const _ibus_charmap_service_dbus_signal_info[] = {&_ibus_charmap_service_dbus_signal_info_character_activated, NULL};
static const GDBusPropertyInfo _ibus_charmap_service_dbus_property_info_visible = {-1, "Visible", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo * const _ibus_charmap_service_dbus_property_info[] = {&_ibus_charmap_service_dbus_property_info_visible, NULL};
static const GDBusInterfaceInfo _ibus_charmap_service_dbus_interface_info = {-1, "org.freedesktop.IBus.Charmap", (GDBusMethodInfo **) (&_ibus_charmap_service_dbus_method_info), (GDBusSignalInfo **) (&_ibus_charmap_service_dbus_signal_info), (GDBusPropertyInfo **) (&_ibus_charmap_service_dbus_property_info)};
static const GDBusInterfaceVTable _ibus_charmap_service_dbus_interface_vtable = {ibus_charmap_service_dbus_interface_method_call, ibus_charmap_service_dbus_interface_get_property, ibus_charmap_service_dbus_interface_set_property};

static void ibus_charmap_service_real_show (IBusCharmapService* self) {
	g_critical ("Type `%s' does not implement abstract method `ibus_charmap_service_show'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void ibus_charmap_service_show (IBusCharmapService* self) {
	g_return_if_fail (self != NULL);
	IBUS_CHARMAP_SERVICE_GET_CLASS (self)->show (self);
}


static void ibus_charmap_service_real_hide (IBusCharmapService* self) {
	g_critical ("Type `%s' does not implement abstract method `ibus_charmap_service_hide'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void ibus_charmap_service_hide (IBusCharmapService* self) {
	g_return_if_fail (self != NULL);
	IBUS_CHARMAP_SERVICE_GET_CLASS (self)->hide (self);
}


static void ibus_charmap_service_real_set_cursor_location (IBusCharmapService* self, gint x, gint y, gint w, gint h) {
	g_critical ("Type `%s' does not implement abstract method `ibus_charmap_service_set_cursor_location'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void ibus_charmap_service_set_cursor_location (IBusCharmapService* self, gint x, gint y, gint w, gint h) {
	g_return_if_fail (self != NULL);
	IBUS_CHARMAP_SERVICE_GET_CLASS (self)->set_cursor_location (self, x, y, w, h);
}


static void ibus_charmap_service_real_move_cursor (IBusCharmapService* self, IBusMovementStep step, gint count) {
	g_critical ("Type `%s' does not implement abstract method `ibus_charmap_service_move_cursor'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void ibus_charmap_service_move_cursor (IBusCharmapService* self, IBusMovementStep step, gint count) {
	g_return_if_fail (self != NULL);
	IBUS_CHARMAP_SERVICE_GET_CLASS (self)->move_cursor (self, step, count);
}


static void ibus_charmap_service_real_select_character (IBusCharmapService* self, gunichar uc) {
	g_critical ("Type `%s' does not implement abstract method `ibus_charmap_service_select_character'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void ibus_charmap_service_select_character (IBusCharmapService* self, gunichar uc) {
	g_return_if_fail (self != NULL);
	IBUS_CHARMAP_SERVICE_GET_CLASS (self)->select_character (self, uc);
}


static void ibus_charmap_service_real_activate_selected (IBusCharmapService* self) {
	g_critical ("Type `%s' does not implement abstract method `ibus_charmap_service_activate_selected'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void ibus_charmap_service_activate_selected (IBusCharmapService* self) {
	g_return_if_fail (self != NULL);
	IBUS_CHARMAP_SERVICE_GET_CLASS (self)->activate_selected (self);
}


static void ibus_charmap_service_real_popup_chapters (IBusCharmapService* self) {
	g_critical ("Type `%s' does not implement abstract method `ibus_charmap_service_popup_chapters'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void ibus_charmap_service_popup_chapters (IBusCharmapService* self) {
	g_return_if_fail (self != NULL);
	IBUS_CHARMAP_SERVICE_GET_CLASS (self)->popup_chapters (self);
}


static void ibus_charmap_service_real_start_search (IBusCharmapService* self, const gchar* name, guint max_matches) {
	g_critical ("Type `%s' does not implement abstract method `ibus_charmap_service_start_search'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void ibus_charmap_service_start_search (IBusCharmapService* self, const gchar* name, guint max_matches) {
	g_return_if_fail (self != NULL);
	IBUS_CHARMAP_SERVICE_GET_CLASS (self)->start_search (self, name, max_matches);
}


static void ibus_charmap_service_real_cancel_search (IBusCharmapService* self) {
	g_critical ("Type `%s' does not implement abstract method `ibus_charmap_service_cancel_search'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void ibus_charmap_service_cancel_search (IBusCharmapService* self) {
	g_return_if_fail (self != NULL);
	IBUS_CHARMAP_SERVICE_GET_CLASS (self)->cancel_search (self);
}


static void __lambda1_ (IBusCharmapService* self) {
}


static void ___lambda1__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	__lambda1_ (self);
}


static void __lambda2_ (IBusCharmapService* self) {
	FILE* _tmp0_;
	_tmp0_ = stderr;
	fprintf (_tmp0_, "Could not aquire name\n");
}


static void ___lambda2__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	__lambda2_ (self);
}


void ibus_charmap_service_register_charmap (IBusCharmapService* self, GDBusConnection* conn) {
	GDBusConnection* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		GDBusConnection* _tmp0_;
		_tmp0_ = conn;
		ibus_charmap_service_register_object (self, _tmp0_, "/org/freedesktop/IBus/Charmap", &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch1_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally1;
	__catch1_g_io_error:
	{
		GError* e = NULL;
		FILE* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = stderr;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		fprintf (_tmp1_, "Could not register service: %s\n", _tmp3_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = conn;
	g_bus_own_name_on_connection_with_closures (_tmp4_, "org.freedesktop.IBus.Charmap", G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((___lambda1__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda1__gbus_name_acquired_callback, g_object_ref (self), g_object_unref)), (GClosure*) ((___lambda2__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda2__gbus_name_lost_callback, g_object_ref (self), g_object_unref)));
}


IBusCharmapService* ibus_charmap_service_construct (GType object_type) {
	IBusCharmapService * self = NULL;
	self = (IBusCharmapService*) g_object_new (object_type, NULL);
	return self;
}


gboolean ibus_charmap_service_get_visible (IBusCharmapService* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_visible;
	result = _tmp0_;
	return result;
}


void ibus_charmap_service_set_visible (IBusCharmapService* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_visible = _tmp0_;
	g_object_notify ((GObject *) self, "visible");
}


static void ibus_charmap_service_class_init (IBusCharmapServiceClass * klass) {
	ibus_charmap_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IBusCharmapServicePrivate));
	IBUS_CHARMAP_SERVICE_CLASS (klass)->show = ibus_charmap_service_real_show;
	IBUS_CHARMAP_SERVICE_CLASS (klass)->hide = ibus_charmap_service_real_hide;
	IBUS_CHARMAP_SERVICE_CLASS (klass)->set_cursor_location = ibus_charmap_service_real_set_cursor_location;
	IBUS_CHARMAP_SERVICE_CLASS (klass)->move_cursor = ibus_charmap_service_real_move_cursor;
	IBUS_CHARMAP_SERVICE_CLASS (klass)->select_character = ibus_charmap_service_real_select_character;
	IBUS_CHARMAP_SERVICE_CLASS (klass)->activate_selected = ibus_charmap_service_real_activate_selected;
	IBUS_CHARMAP_SERVICE_CLASS (klass)->popup_chapters = ibus_charmap_service_real_popup_chapters;
	IBUS_CHARMAP_SERVICE_CLASS (klass)->start_search = ibus_charmap_service_real_start_search;
	IBUS_CHARMAP_SERVICE_CLASS (klass)->cancel_search = ibus_charmap_service_real_cancel_search;
	G_OBJECT_CLASS (klass)->get_property = _vala_ibus_charmap_service_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_ibus_charmap_service_set_property;
	G_OBJECT_CLASS (klass)->finalize = ibus_charmap_service_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), IBUS_CHARMAP_SERVICE_VISIBLE, g_param_spec_boolean ("visible", "visible", "visible", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("character_activated", IBUS_CHARMAP_TYPE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
}


static void ibus_charmap_service_instance_init (IBusCharmapService * self) {
	self->priv = IBUS_CHARMAP_SERVICE_GET_PRIVATE (self);
}


static void ibus_charmap_service_finalize (GObject* obj) {
	IBusCharmapService * self;
	self = IBUS_CHARMAP_SERVICE (obj);
	G_OBJECT_CLASS (ibus_charmap_service_parent_class)->finalize (obj);
}


GType ibus_charmap_service_get_type (void) {
	static volatile gsize ibus_charmap_service_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_charmap_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IBusCharmapServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ibus_charmap_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IBusCharmapService), 0, (GInstanceInitFunc) ibus_charmap_service_instance_init, NULL };
		GType ibus_charmap_service_type_id;
		ibus_charmap_service_type_id = g_type_register_static (G_TYPE_OBJECT, "IBusCharmapService", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_set_qdata (ibus_charmap_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) ibus_charmap_service_register_object);
		g_once_init_leave (&ibus_charmap_service_type_id__volatile, ibus_charmap_service_type_id);
	}
	return ibus_charmap_service_type_id__volatile;
}


static void _vala_ibus_charmap_service_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	IBusCharmapService * self;
	self = IBUS_CHARMAP_SERVICE (object);
	switch (property_id) {
		case IBUS_CHARMAP_SERVICE_VISIBLE:
		g_value_set_boolean (value, ibus_charmap_service_get_visible (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_ibus_charmap_service_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	IBusCharmapService * self;
	self = IBUS_CHARMAP_SERVICE (object);
	switch (property_id) {
		case IBUS_CHARMAP_SERVICE_VISIBLE:
		ibus_charmap_service_set_visible (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _dbus_ibus_charmap_service_show (IBusCharmapService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	ibus_charmap_service_show (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_ibus_charmap_service_hide (IBusCharmapService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	ibus_charmap_service_hide (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_ibus_charmap_service_set_cursor_location (IBusCharmapService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint x = 0;
	GVariant* _tmp0_;
	gint y = 0;
	GVariant* _tmp1_;
	gint w = 0;
	GVariant* _tmp2_;
	gint h = 0;
	GVariant* _tmp3_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	x = g_variant_get_int32 (_tmp0_);
	g_variant_unref (_tmp0_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	y = g_variant_get_int32 (_tmp1_);
	g_variant_unref (_tmp1_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	w = g_variant_get_int32 (_tmp2_);
	g_variant_unref (_tmp2_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	h = g_variant_get_int32 (_tmp3_);
	g_variant_unref (_tmp3_);
	ibus_charmap_service_set_cursor_location (self, x, y, w, h);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_ibus_charmap_service_move_cursor (IBusCharmapService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	IBusMovementStep step = 0;
	GVariant* _tmp4_;
	gint count = 0;
	GVariant* _tmp5_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	step = g_variant_get_int32 (_tmp4_);
	g_variant_unref (_tmp4_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	count = g_variant_get_int32 (_tmp5_);
	g_variant_unref (_tmp5_);
	ibus_charmap_service_move_cursor (self, step, count);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_ibus_charmap_service_select_character (IBusCharmapService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gunichar uc = 0U;
	GVariant* _tmp6_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	uc = g_variant_get_uint32 (_tmp6_);
	g_variant_unref (_tmp6_);
	ibus_charmap_service_select_character (self, uc);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_ibus_charmap_service_activate_selected (IBusCharmapService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	ibus_charmap_service_activate_selected (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_ibus_charmap_service_popup_chapters (IBusCharmapService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	ibus_charmap_service_popup_chapters (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_ibus_charmap_service_start_search (IBusCharmapService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp7_;
	guint max_matches = 0U;
	GVariant* _tmp8_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp7_, NULL);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	max_matches = g_variant_get_uint32 (_tmp8_);
	g_variant_unref (_tmp8_);
	ibus_charmap_service_start_search (self, name, max_matches);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (name);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_ibus_charmap_service_cancel_search (IBusCharmapService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	ibus_charmap_service_cancel_search (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void ibus_charmap_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Show") == 0) {
		_dbus_ibus_charmap_service_show (object, parameters, invocation);
	} else if (strcmp (method_name, "Hide") == 0) {
		_dbus_ibus_charmap_service_hide (object, parameters, invocation);
	} else if (strcmp (method_name, "SetCursorLocation") == 0) {
		_dbus_ibus_charmap_service_set_cursor_location (object, parameters, invocation);
	} else if (strcmp (method_name, "MoveCursor") == 0) {
		_dbus_ibus_charmap_service_move_cursor (object, parameters, invocation);
	} else if (strcmp (method_name, "SelectCharacter") == 0) {
		_dbus_ibus_charmap_service_select_character (object, parameters, invocation);
	} else if (strcmp (method_name, "ActivateSelected") == 0) {
		_dbus_ibus_charmap_service_activate_selected (object, parameters, invocation);
	} else if (strcmp (method_name, "PopupChapters") == 0) {
		_dbus_ibus_charmap_service_popup_chapters (object, parameters, invocation);
	} else if (strcmp (method_name, "StartSearch") == 0) {
		_dbus_ibus_charmap_service_start_search (object, parameters, invocation);
	} else if (strcmp (method_name, "CancelSearch") == 0) {
		_dbus_ibus_charmap_service_cancel_search (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* _dbus_ibus_charmap_service_get_visible (IBusCharmapService* self) {
	gboolean result;
	GVariant* _reply;
	result = ibus_charmap_service_get_visible (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* ibus_charmap_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Visible") == 0) {
		return _dbus_ibus_charmap_service_get_visible (object);
	}
	return NULL;
}


static void _dbus_ibus_charmap_service_set_visible (IBusCharmapService* self, GVariant* _value) {
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	ibus_charmap_service_set_visible (self, value);
}


static gboolean ibus_charmap_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Visible") == 0) {
		_dbus_ibus_charmap_service_set_visible (object, value);
		return TRUE;
	}
	return FALSE;
}


static void _dbus_ibus_charmap_service_character_activated (GObject* _sender, gunichar uc, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (uc));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.IBus.Charmap", "CharacterActivated", _arguments, NULL);
}


guint ibus_charmap_service_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_ibus_charmap_service_dbus_interface_info), &_ibus_charmap_service_dbus_interface_vtable, data, _ibus_charmap_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "character-activated", (GCallback) _dbus_ibus_charmap_service_character_activated, data);
	return result;
}


static void _ibus_charmap_service_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_ibus_charmap_service_character_activated, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}



