/* setup.c generated by valac 0.14.0, the Vala compiler
 * generated from setup.vala, do not modify */

/* 
 * Copyright (C) 2011-2012 Daiki Ueno <ueno@unixuser.org>
 * Copyright (C) 2011-2012 Red Hat, Inc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libutil.h>
#include <config.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <libskk/libskk.h>
#include <gee.h>
#include <ibus.h>
#include <glib/gi18n-lib.h>


#define TYPE_SETUP (setup_get_type ())
#define SETUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETUP, Setup))
#define SETUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETUP, SetupClass))
#define IS_SETUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETUP))
#define IS_SETUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETUP))
#define SETUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETUP, SetupClass))

typedef struct _Setup Setup;
typedef struct _SetupClass SetupClass;
typedef struct _SetupPrivate SetupPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SETUP_TYPE_TYPECELL_RENDERER (setup_typecell_renderer_get_type ())
#define SETUP_TYPECELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SETUP_TYPE_TYPECELL_RENDERER, SetupTypeCellRenderer))
#define SETUP_TYPECELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SETUP_TYPE_TYPECELL_RENDERER, SetupTypeCellRendererClass))
#define SETUP_IS_TYPECELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SETUP_TYPE_TYPECELL_RENDERER))
#define SETUP_IS_TYPECELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SETUP_TYPE_TYPECELL_RENDERER))
#define SETUP_TYPECELL_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SETUP_TYPE_TYPECELL_RENDERER, SetupTypeCellRendererClass))

typedef struct _SetupTypeCellRenderer SetupTypeCellRenderer;
typedef struct _SetupTypeCellRendererClass SetupTypeCellRendererClass;

#define SETUP_TYPE_DESC_CELL_RENDERER (setup_desc_cell_renderer_get_type ())
#define SETUP_DESC_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SETUP_TYPE_DESC_CELL_RENDERER, SetupDescCellRenderer))
#define SETUP_DESC_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SETUP_TYPE_DESC_CELL_RENDERER, SetupDescCellRendererClass))
#define SETUP_IS_DESC_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SETUP_TYPE_DESC_CELL_RENDERER))
#define SETUP_IS_DESC_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SETUP_TYPE_DESC_CELL_RENDERER))
#define SETUP_DESC_CELL_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SETUP_TYPE_DESC_CELL_RENDERER, SetupDescCellRendererClass))

typedef struct _SetupDescCellRenderer SetupDescCellRenderer;
typedef struct _SetupDescCellRendererClass SetupDescCellRendererClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))
typedef struct _SetupTypeCellRendererPrivate SetupTypeCellRendererPrivate;
typedef struct _SetupDescCellRendererPrivate SetupDescCellRendererPrivate;

struct _Setup {
	GObject parent_instance;
	SetupPrivate * priv;
};

struct _SetupClass {
	GObjectClass parent_class;
};

struct _SetupPrivate {
	GtkDialog* dialog;
	GtkTreeView* dictionaries_treeview;
	GtkEntry* auto_start_henkan_keywords_entry;
	GtkComboBox* period_style_combobox;
	GtkSpinButton* page_size_spinbutton;
	GtkSpinButton* pagination_start_spinbutton;
	GtkCheckButton* show_annotation_checkbutton;
	GtkComboBox* initial_input_mode_combobox;
	GtkCheckButton* egg_like_newline_checkbutton;
	GtkComboBox* typing_rule_combobox;
	GtkDialog* dict_dialog;
	GtkComboBoxText* dict_type_comboboxtext;
	GtkHBox* dict_data_hbox;
	GtkWidget* dict_data_widget;
	GtkFileChooserButton* dict_filechooserbutton;
	GtkEntry* dict_entry;
	GtkSpinButton* dict_spinbutton;
	Preferences* preferences;
};

struct _Block1Data {
	int _ref_count_;
	Setup * self;
	GtkButton* remove_dict_button;
	GtkButton* up_dict_button;
	GtkButton* down_dict_button;
	GtkTreeSelection* selection;
};

struct _SetupTypeCellRenderer {
	GtkCellRendererText parent_instance;
	SetupTypeCellRendererPrivate * priv;
};

struct _SetupTypeCellRendererClass {
	GtkCellRendererTextClass parent_class;
};

struct _SetupTypeCellRendererPrivate {
	PList* _plist;
};

struct _SetupDescCellRenderer {
	GtkCellRendererText parent_instance;
	SetupDescCellRendererPrivate * priv;
};

struct _SetupDescCellRendererClass {
	GtkCellRendererTextClass parent_class;
};

struct _SetupDescCellRendererPrivate {
	PList* _plist;
};


static gpointer setup_parent_class = NULL;
static gpointer setup_typecell_renderer_parent_class = NULL;
static gpointer setup_desc_cell_renderer_parent_class = NULL;

GType setup_get_type (void) G_GNUC_CONST;
#define SETUP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SETUP, SetupPrivate))
enum  {
	SETUP_DUMMY_PROPERTY
};
Setup* setup_new (Preferences* preferences);
Setup* setup_construct (GType object_type, Preferences* preferences);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static SetupTypeCellRenderer* setup_typecell_renderer_new (void);
static SetupTypeCellRenderer* setup_typecell_renderer_construct (GType object_type);
static GType setup_typecell_renderer_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SetupDescCellRenderer* setup_desc_cell_renderer_new (void);
static SetupDescCellRenderer* setup_desc_cell_renderer_construct (GType object_type);
static GType setup_desc_cell_renderer_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void setup_load (Setup* self);
static void setup_add_dict (Setup* self);
static void _setup_add_dict_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void setup_remove_dict (Setup* self);
static void _setup_remove_dict_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void setup_up_dict (Setup* self);
static void _setup_up_dict_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void setup_down_dict (Setup* self);
static void _setup_down_dict_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda0_ (Block1Data* _data1_);
static void ___lambda0__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void __lambda1_ (Setup* self);
static void ___lambda1__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _vala_SkkRuleMetadata_array_free (SkkRuleMetadata* array, gint array_length);
static void setup_populate_dictionaries_treeview (Setup* self);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
static void setup_load_combobox (Setup* self, const gchar* name, GtkComboBox* combo, gint column);
static void setup_save_dictionaries (Setup* self, const gchar* name);
static GVariant* _variant_new1 (gchar** value, gint value_length1);
static void setup_save_combobox (Setup* self, const gchar* name, GtkComboBox* combo, gint column);
static GVariant* _variant_new2 (gint value);
static void setup_save (Setup* self);
static GVariant* _variant_new3 (gchar** value, gint value_length1);
static GVariant* _variant_new4 (gboolean value);
static GVariant* _variant_new5 (gint value);
static GVariant* _variant_new6 (gint value);
static GVariant* _variant_new7 (gboolean value);
static GVariant* _variant_new8 (const gchar* value);
void setup_run (Setup* self);
gint setup_main (gchar** args, int args_length1);
#define SETUP_TYPECELL_RENDERER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SETUP_TYPE_TYPECELL_RENDERER, SetupTypeCellRendererPrivate))
enum  {
	SETUP_TYPECELL_RENDERER_DUMMY_PROPERTY,
	SETUP_TYPECELL_RENDERER_PLIST
};
static PList* setup_typecell_renderer_get_plist (SetupTypeCellRenderer* self);
static void setup_typecell_renderer_set_plist (SetupTypeCellRenderer* self, PList* value);
static void setup_typecell_renderer_finalize (GObject* obj);
static void _vala_setup_typecell_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_setup_typecell_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define SETUP_DESC_CELL_RENDERER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SETUP_TYPE_DESC_CELL_RENDERER, SetupDescCellRendererPrivate))
enum  {
	SETUP_DESC_CELL_RENDERER_DUMMY_PROPERTY,
	SETUP_DESC_CELL_RENDERER_PLIST
};
static PList* setup_desc_cell_renderer_get_plist (SetupDescCellRenderer* self);
static void setup_desc_cell_renderer_set_plist (SetupDescCellRenderer* self, PList* value);
static void setup_desc_cell_renderer_finalize (GObject* obj);
static void _vala_setup_desc_cell_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_setup_desc_cell_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void setup_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->selection);
		_g_object_unref0 (_data1_->down_dict_button);
		_g_object_unref0 (_data1_->up_dict_button);
		_g_object_unref0 (_data1_->remove_dict_button);
		g_slice_free (Block1Data, _data1_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _setup_add_dict_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	setup_add_dict (self);
}


static void _setup_remove_dict_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	setup_remove_dict (self);
}


static void _setup_up_dict_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	setup_up_dict (self);
}


static void _setup_down_dict_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	setup_down_dict (self);
}


static void __lambda0_ (Block1Data* _data1_) {
	Setup * self;
	gint _tmp0_ = 0;
	gint count;
	gint _tmp1_;
	self = _data1_->self;
	_tmp0_ = gtk_tree_selection_count_selected_rows (_data1_->selection);
	count = _tmp0_;
	_tmp1_ = count;
	if (_tmp1_ > 0) {
		GtkButton* _tmp2_;
		GtkButton* _tmp3_;
		GtkButton* _tmp4_;
		_tmp2_ = _data1_->remove_dict_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, TRUE);
		_tmp3_ = _data1_->up_dict_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, TRUE);
		_tmp4_ = _data1_->down_dict_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, TRUE);
	} else {
		gint _tmp5_;
		_tmp5_ = count;
		if (_tmp5_ == 0) {
			GtkButton* _tmp6_;
			GtkButton* _tmp7_;
			GtkButton* _tmp8_;
			_tmp6_ = _data1_->remove_dict_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, FALSE);
			_tmp7_ = _data1_->up_dict_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, FALSE);
			_tmp8_ = _data1_->down_dict_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, FALSE);
		}
	}
}


static void ___lambda0__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda0_ (self);
}


static void __lambda1_ (Setup* self) {
	GtkComboBoxText* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* text;
	GtkWidget* _tmp3_;
	const gchar* _tmp6_;
	GtkHBox* _tmp34_;
	GtkWidget* _tmp35_;
	GtkHBox* _tmp36_;
	GtkHBox* _tmp37_;
	_tmp0_ = self->priv->dict_type_comboboxtext;
	_tmp1_ = gtk_combo_box_text_get_active_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	text = _tmp2_;
	_tmp3_ = self->priv->dict_data_widget;
	if (_tmp3_ != NULL) {
		GtkHBox* _tmp4_;
		GtkWidget* _tmp5_;
		_tmp4_ = self->priv->dict_data_hbox;
		_tmp5_ = self->priv->dict_data_widget;
		gtk_container_remove ((GtkContainer*) _tmp4_, _tmp5_);
	}
	_tmp6_ = text;
	if (g_strcmp0 (_tmp6_, "System") == 0) {
		GtkFileChooserButton* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		GtkFileChooserButton* _tmp10_;
		GtkWidget* _tmp11_;
		_tmp7_ = self->priv->dict_filechooserbutton;
		_tmp8_ = g_build_filename (DATADIR, "skk", NULL);
		_tmp9_ = _tmp8_;
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp7_, _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = self->priv->dict_filechooserbutton;
		_tmp11_ = _g_object_ref0 ((GtkWidget*) _tmp10_);
		_g_object_unref0 (self->priv->dict_data_widget);
		self->priv->dict_data_widget = _tmp11_;
	} else {
		const gchar* _tmp12_;
		_tmp12_ = text;
		if (g_strcmp0 (_tmp12_, "User") == 0) {
			GtkFileChooserButton* _tmp13_;
			const gchar* _tmp14_ = NULL;
			GtkFileChooserButton* _tmp15_;
			GtkWidget* _tmp16_;
			_tmp13_ = self->priv->dict_filechooserbutton;
			_tmp14_ = g_get_home_dir ();
			gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp13_, _tmp14_);
			_tmp15_ = self->priv->dict_filechooserbutton;
			_tmp16_ = _g_object_ref0 ((GtkWidget*) _tmp15_);
			_g_object_unref0 (self->priv->dict_data_widget);
			self->priv->dict_data_widget = _tmp16_;
		} else {
			const gchar* _tmp17_;
			_tmp17_ = text;
			if (g_strcmp0 (_tmp17_, "SKK Server") == 0) {
				GtkHBox* _tmp18_;
				GtkHBox* _tmp19_;
				GtkHBox* hbox;
				GtkHBox* _tmp20_;
				GtkLabel* _tmp21_;
				GtkLabel* _tmp22_;
				GtkHBox* _tmp23_;
				GtkEntry* _tmp24_;
				GtkEntry* _tmp25_;
				GtkHBox* _tmp26_;
				GtkLabel* _tmp27_;
				GtkLabel* _tmp28_;
				GtkHBox* _tmp29_;
				GtkSpinButton* _tmp30_;
				GtkSpinButton* _tmp31_;
				GtkHBox* _tmp32_;
				GtkWidget* _tmp33_;
				_tmp18_ = (GtkHBox*) gtk_hbox_new (FALSE, 2);
				_tmp19_ = g_object_ref_sink (_tmp18_);
				hbox = _tmp19_;
				_tmp20_ = hbox;
				_tmp21_ = (GtkLabel*) gtk_label_new ("Host:");
				_tmp22_ = g_object_ref_sink (_tmp21_);
				gtk_box_pack_start ((GtkBox*) _tmp20_, (GtkWidget*) _tmp22_, FALSE, FALSE, (guint) 0);
				_g_object_unref0 (_tmp22_);
				_tmp23_ = hbox;
				_tmp24_ = self->priv->dict_entry;
				gtk_box_pack_start ((GtkBox*) _tmp23_, (GtkWidget*) _tmp24_, FALSE, FALSE, (guint) 0);
				_tmp25_ = self->priv->dict_entry;
				gtk_entry_set_text (_tmp25_, "localhost");
				_tmp26_ = hbox;
				_tmp27_ = (GtkLabel*) gtk_label_new ("Port:");
				_tmp28_ = g_object_ref_sink (_tmp27_);
				gtk_box_pack_start ((GtkBox*) _tmp26_, (GtkWidget*) _tmp28_, FALSE, FALSE, (guint) 0);
				_g_object_unref0 (_tmp28_);
				_tmp29_ = hbox;
				_tmp30_ = self->priv->dict_spinbutton;
				gtk_box_pack_start ((GtkBox*) _tmp29_, (GtkWidget*) _tmp30_, FALSE, FALSE, (guint) 0);
				_tmp31_ = self->priv->dict_spinbutton;
				gtk_spin_button_set_value (_tmp31_, (gdouble) 1178);
				_tmp32_ = hbox;
				_tmp33_ = _g_object_ref0 ((GtkWidget*) _tmp32_);
				_g_object_unref0 (self->priv->dict_data_widget);
				self->priv->dict_data_widget = _tmp33_;
				_g_object_unref0 (hbox);
			} else {
				g_assert_not_reached ();
			}
		}
	}
	_tmp34_ = self->priv->dict_data_hbox;
	_tmp35_ = self->priv->dict_data_widget;
	gtk_container_add ((GtkContainer*) _tmp34_, _tmp35_);
	_tmp36_ = self->priv->dict_data_hbox;
	gtk_widget_show_all ((GtkWidget*) _tmp36_);
	_tmp37_ = self->priv->dict_data_hbox;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp37_, TRUE);
	_g_free0 (text);
}


static void ___lambda1__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	__lambda1_ (self);
}


static void _vala_SkkRuleMetadata_array_free (SkkRuleMetadata* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			skk_rule_metadata_destroy (&array[i]);
		}
	}
	g_free (array);
}


Setup* setup_construct (GType object_type, Preferences* preferences) {
	Setup * self = NULL;
	Block1Data* _data1_;
	Preferences* _tmp0_;
	Preferences* _tmp1_;
	GtkBuilder* _tmp2_;
	GtkBuilder* builder;
	gchar* _tmp3_ = NULL;
	gchar* ui_filename;
	GObject* object = NULL;
	GObject* _tmp5_ = NULL;
	GObject* _tmp6_;
	GObject* _tmp7_;
	GObject* _tmp8_;
	GtkDialog* _tmp9_;
	GObject* _tmp10_ = NULL;
	GObject* _tmp11_;
	GObject* _tmp12_;
	GObject* _tmp13_;
	GtkTreeView* _tmp14_;
	GObject* _tmp15_ = NULL;
	GObject* _tmp16_;
	GObject* _tmp17_;
	GObject* _tmp18_;
	GtkEntry* _tmp19_;
	GObject* _tmp20_ = NULL;
	GObject* _tmp21_;
	GObject* _tmp22_;
	GObject* _tmp23_;
	GtkCheckButton* _tmp24_;
	GObject* _tmp25_ = NULL;
	GObject* _tmp26_;
	GObject* _tmp27_;
	GObject* _tmp28_;
	GtkComboBox* _tmp29_;
	GObject* _tmp30_ = NULL;
	GObject* _tmp31_;
	GObject* _tmp32_;
	GObject* _tmp33_;
	GtkSpinButton* _tmp34_;
	GObject* _tmp35_ = NULL;
	GObject* _tmp36_;
	GObject* _tmp37_;
	GObject* _tmp38_;
	GtkSpinButton* _tmp39_;
	GObject* _tmp40_ = NULL;
	GObject* _tmp41_;
	GObject* _tmp42_;
	GObject* _tmp43_;
	GtkCheckButton* _tmp44_;
	GObject* _tmp45_ = NULL;
	GObject* _tmp46_;
	GObject* _tmp47_;
	GObject* _tmp48_;
	GtkComboBox* _tmp49_;
	GObject* _tmp50_ = NULL;
	GObject* _tmp51_;
	GObject* _tmp52_;
	GObject* _tmp53_;
	GtkCheckButton* _tmp54_;
	GObject* _tmp55_ = NULL;
	GObject* _tmp56_;
	GObject* _tmp57_;
	GObject* _tmp58_;
	GtkComboBox* _tmp59_;
	GObject* _tmp60_ = NULL;
	GObject* _tmp61_;
	GObject* _tmp62_;
	GObject* _tmp63_;
	GtkButton* _tmp64_;
	GtkButton* add_dict_button;
	GObject* _tmp65_ = NULL;
	GObject* _tmp66_;
	GObject* _tmp67_;
	GObject* _tmp68_;
	GtkButton* _tmp69_;
	GObject* _tmp70_ = NULL;
	GObject* _tmp71_;
	GObject* _tmp72_;
	GObject* _tmp73_;
	GtkButton* _tmp74_;
	GObject* _tmp75_ = NULL;
	GObject* _tmp76_;
	GObject* _tmp77_;
	GObject* _tmp78_;
	GtkButton* _tmp79_;
	GObject* _tmp80_ = NULL;
	GObject* _tmp81_;
	GObject* _tmp82_;
	GObject* _tmp83_;
	GtkDialog* _tmp84_;
	GObject* _tmp85_ = NULL;
	GObject* _tmp86_;
	GObject* _tmp87_;
	GObject* _tmp88_;
	GtkComboBoxText* _tmp89_;
	GObject* _tmp90_ = NULL;
	GObject* _tmp91_;
	GObject* _tmp92_;
	GObject* _tmp93_;
	GtkHBox* _tmp94_;
	GtkFileChooserButton* _tmp95_;
	GtkFileChooserButton* _tmp96_;
	GtkEntry* _tmp97_;
	GtkEntry* _tmp98_;
	GtkSpinButton* _tmp99_;
	GtkSpinButton* _tmp100_;
	GtkListStore* model = NULL;
	GtkCellRenderer* renderer = NULL;
	GtkTreeViewColumn* column = NULL;
	GtkListStore* _tmp101_;
	GtkTreeView* _tmp102_;
	GtkListStore* _tmp103_;
	SetupTypeCellRenderer* _tmp104_;
	GtkCellRenderer* _tmp105_;
	GtkCellRenderer* _tmp106_;
	GtkTreeViewColumn* _tmp107_;
	GtkTreeViewColumn* _tmp108_;
	GtkTreeView* _tmp109_;
	GtkTreeViewColumn* _tmp110_;
	SetupDescCellRenderer* _tmp111_;
	GtkCellRenderer* _tmp112_;
	GtkCellRenderer* _tmp113_;
	GtkTreeViewColumn* _tmp114_;
	GtkTreeViewColumn* _tmp115_;
	GtkTreeView* _tmp116_;
	GtkTreeViewColumn* _tmp117_;
	GtkCellRendererText* _tmp118_;
	GtkCellRenderer* _tmp119_;
	GtkComboBox* _tmp120_;
	GtkCellRenderer* _tmp121_;
	GtkComboBox* _tmp122_;
	GtkCellRenderer* _tmp123_;
	GtkCellRendererText* _tmp124_;
	GtkCellRenderer* _tmp125_;
	GtkComboBox* _tmp126_;
	GtkCellRenderer* _tmp127_;
	GtkComboBox* _tmp128_;
	GtkCellRenderer* _tmp129_;
	GtkListStore* _tmp130_;
	GtkListStore* _tmp131_;
	GtkComboBox* _tmp132_;
	GtkListStore* _tmp133_;
	gint _tmp134_ = 0;
	SkkRuleMetadata* _tmp135_ = NULL;
	SkkRuleMetadata* rules;
	gint rules_length1;
	gint _rules_size_;
	SkkRuleMetadata* _tmp136_;
	gint _tmp136__length1;
	GtkCellRendererText* _tmp148_;
	GtkCellRenderer* _tmp149_;
	GtkComboBox* _tmp150_;
	GtkCellRenderer* _tmp151_;
	GtkComboBox* _tmp152_;
	GtkCellRenderer* _tmp153_;
	GtkButton* _tmp154_;
	GtkButton* _tmp155_;
	GtkButton* _tmp156_;
	GtkButton* _tmp157_;
	GtkTreeView* _tmp158_;
	GtkTreeSelection* _tmp159_ = NULL;
	GtkTreeSelection* _tmp160_;
	GtkComboBoxText* _tmp161_;
	GtkComboBoxText* _tmp162_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (preferences != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	self = (Setup*) g_object_new (object_type, NULL);
	_data1_->self = g_object_ref (self);
	_tmp0_ = preferences;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->preferences);
	self->priv->preferences = _tmp1_;
	_tmp2_ = gtk_builder_new ();
	builder = _tmp2_;
	gtk_builder_set_translation_domain (builder, "ibus-skk");
	_tmp3_ = g_build_filename (SETUPDIR, "ibus-skk-preferences.ui", NULL);
	ui_filename = _tmp3_;
	{
		gtk_builder_add_from_file (builder, ui_filename, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e->message;
		g_error ("setup.vala:56: can't load %s: %s", ui_filename, _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_free0 (ui_filename);
		_g_object_unref0 (builder);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp5_ = gtk_builder_get_object (builder, "dialog");
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (object);
	object = _tmp6_;
	_tmp7_ = object;
	g_assert (_tmp7_ != NULL);
	_tmp8_ = object;
	_tmp9_ = _g_object_ref0 (GTK_DIALOG (_tmp8_));
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp9_;
	_tmp10_ = gtk_builder_get_object (builder, "dictionaries_treeview");
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (object);
	object = _tmp11_;
	_tmp12_ = object;
	g_assert (_tmp12_ != NULL);
	_tmp13_ = object;
	_tmp14_ = _g_object_ref0 (GTK_TREE_VIEW (_tmp13_));
	_g_object_unref0 (self->priv->dictionaries_treeview);
	self->priv->dictionaries_treeview = _tmp14_;
	_tmp15_ = gtk_builder_get_object (builder, "auto_start_henkan_keywords_entry");
	_tmp16_ = _g_object_ref0 (_tmp15_);
	_g_object_unref0 (object);
	object = _tmp16_;
	_tmp17_ = object;
	g_assert (_tmp17_ != NULL);
	_tmp18_ = object;
	_tmp19_ = _g_object_ref0 (GTK_ENTRY (_tmp18_));
	_g_object_unref0 (self->priv->auto_start_henkan_keywords_entry);
	self->priv->auto_start_henkan_keywords_entry = _tmp19_;
	_tmp20_ = gtk_builder_get_object (builder, "egg_like_newline_checkbutton");
	_tmp21_ = _g_object_ref0 (_tmp20_);
	_g_object_unref0 (object);
	object = _tmp21_;
	_tmp22_ = object;
	g_assert (_tmp22_ != NULL);
	_tmp23_ = object;
	_tmp24_ = _g_object_ref0 (GTK_CHECK_BUTTON (_tmp23_));
	_g_object_unref0 (self->priv->egg_like_newline_checkbutton);
	self->priv->egg_like_newline_checkbutton = _tmp24_;
	_tmp25_ = gtk_builder_get_object (builder, "period_style_combobox");
	_tmp26_ = _g_object_ref0 (_tmp25_);
	_g_object_unref0 (object);
	object = _tmp26_;
	_tmp27_ = object;
	g_assert (_tmp27_ != NULL);
	_tmp28_ = object;
	_tmp29_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp28_));
	_g_object_unref0 (self->priv->period_style_combobox);
	self->priv->period_style_combobox = _tmp29_;
	_tmp30_ = gtk_builder_get_object (builder, "page_size_spinbutton");
	_tmp31_ = _g_object_ref0 (_tmp30_);
	_g_object_unref0 (object);
	object = _tmp31_;
	_tmp32_ = object;
	g_assert (_tmp32_ != NULL);
	_tmp33_ = object;
	_tmp34_ = _g_object_ref0 (GTK_SPIN_BUTTON (_tmp33_));
	_g_object_unref0 (self->priv->page_size_spinbutton);
	self->priv->page_size_spinbutton = _tmp34_;
	_tmp35_ = gtk_builder_get_object (builder, "pagination_start_spinbutton");
	_tmp36_ = _g_object_ref0 (_tmp35_);
	_g_object_unref0 (object);
	object = _tmp36_;
	_tmp37_ = object;
	g_assert (_tmp37_ != NULL);
	_tmp38_ = object;
	_tmp39_ = _g_object_ref0 (GTK_SPIN_BUTTON (_tmp38_));
	_g_object_unref0 (self->priv->pagination_start_spinbutton);
	self->priv->pagination_start_spinbutton = _tmp39_;
	_tmp40_ = gtk_builder_get_object (builder, "show_annotation_checkbutton");
	_tmp41_ = _g_object_ref0 (_tmp40_);
	_g_object_unref0 (object);
	object = _tmp41_;
	_tmp42_ = object;
	g_assert (_tmp42_ != NULL);
	_tmp43_ = object;
	_tmp44_ = _g_object_ref0 (GTK_CHECK_BUTTON (_tmp43_));
	_g_object_unref0 (self->priv->show_annotation_checkbutton);
	self->priv->show_annotation_checkbutton = _tmp44_;
	_tmp45_ = gtk_builder_get_object (builder, "initial_input_mode_combobox");
	_tmp46_ = _g_object_ref0 (_tmp45_);
	_g_object_unref0 (object);
	object = _tmp46_;
	_tmp47_ = object;
	g_assert (_tmp47_ != NULL);
	_tmp48_ = object;
	_tmp49_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp48_));
	_g_object_unref0 (self->priv->initial_input_mode_combobox);
	self->priv->initial_input_mode_combobox = _tmp49_;
	_tmp50_ = gtk_builder_get_object (builder, "egg_like_newline_checkbutton");
	_tmp51_ = _g_object_ref0 (_tmp50_);
	_g_object_unref0 (object);
	object = _tmp51_;
	_tmp52_ = object;
	g_assert (_tmp52_ != NULL);
	_tmp53_ = object;
	_tmp54_ = _g_object_ref0 (GTK_CHECK_BUTTON (_tmp53_));
	_g_object_unref0 (self->priv->egg_like_newline_checkbutton);
	self->priv->egg_like_newline_checkbutton = _tmp54_;
	_tmp55_ = gtk_builder_get_object (builder, "typing_rule_combobox");
	_tmp56_ = _g_object_ref0 (_tmp55_);
	_g_object_unref0 (object);
	object = _tmp56_;
	_tmp57_ = object;
	g_assert (_tmp57_ != NULL);
	_tmp58_ = object;
	_tmp59_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp58_));
	_g_object_unref0 (self->priv->typing_rule_combobox);
	self->priv->typing_rule_combobox = _tmp59_;
	_tmp60_ = gtk_builder_get_object (builder, "add_dict_button");
	_tmp61_ = _g_object_ref0 (_tmp60_);
	_g_object_unref0 (object);
	object = _tmp61_;
	_tmp62_ = object;
	g_assert (_tmp62_ != NULL);
	_tmp63_ = object;
	_tmp64_ = _g_object_ref0 (GTK_BUTTON (_tmp63_));
	add_dict_button = _tmp64_;
	_tmp65_ = gtk_builder_get_object (builder, "remove_dict_button");
	_tmp66_ = _g_object_ref0 (_tmp65_);
	_g_object_unref0 (object);
	object = _tmp66_;
	_tmp67_ = object;
	g_assert (_tmp67_ != NULL);
	_tmp68_ = object;
	_tmp69_ = _g_object_ref0 (GTK_BUTTON (_tmp68_));
	_data1_->remove_dict_button = _tmp69_;
	_tmp70_ = gtk_builder_get_object (builder, "up_dict_button");
	_tmp71_ = _g_object_ref0 (_tmp70_);
	_g_object_unref0 (object);
	object = _tmp71_;
	_tmp72_ = object;
	g_assert (_tmp72_ != NULL);
	_tmp73_ = object;
	_tmp74_ = _g_object_ref0 (GTK_BUTTON (_tmp73_));
	_data1_->up_dict_button = _tmp74_;
	_tmp75_ = gtk_builder_get_object (builder, "down_dict_button");
	_tmp76_ = _g_object_ref0 (_tmp75_);
	_g_object_unref0 (object);
	object = _tmp76_;
	_tmp77_ = object;
	g_assert (_tmp77_ != NULL);
	_tmp78_ = object;
	_tmp79_ = _g_object_ref0 (GTK_BUTTON (_tmp78_));
	_data1_->down_dict_button = _tmp79_;
	_tmp80_ = gtk_builder_get_object (builder, "dict_dialog");
	_tmp81_ = _g_object_ref0 (_tmp80_);
	_g_object_unref0 (object);
	object = _tmp81_;
	_tmp82_ = object;
	g_assert (_tmp82_ != NULL);
	_tmp83_ = object;
	_tmp84_ = _g_object_ref0 (GTK_DIALOG (_tmp83_));
	_g_object_unref0 (self->priv->dict_dialog);
	self->priv->dict_dialog = _tmp84_;
	_tmp85_ = gtk_builder_get_object (builder, "dict_type_comboboxtext");
	_tmp86_ = _g_object_ref0 (_tmp85_);
	_g_object_unref0 (object);
	object = _tmp86_;
	_tmp87_ = object;
	g_assert (_tmp87_ != NULL);
	_tmp88_ = object;
	_tmp89_ = _g_object_ref0 (GTK_COMBO_BOX_TEXT (_tmp88_));
	_g_object_unref0 (self->priv->dict_type_comboboxtext);
	self->priv->dict_type_comboboxtext = _tmp89_;
	_tmp90_ = gtk_builder_get_object (builder, "dict_data_hbox");
	_tmp91_ = _g_object_ref0 (_tmp90_);
	_g_object_unref0 (object);
	object = _tmp91_;
	_tmp92_ = object;
	g_assert (_tmp92_ != NULL);
	_tmp93_ = object;
	_tmp94_ = _g_object_ref0 (GTK_HBOX (_tmp93_));
	_g_object_unref0 (self->priv->dict_data_hbox);
	self->priv->dict_data_hbox = _tmp94_;
	_tmp95_ = (GtkFileChooserButton*) gtk_file_chooser_button_new ("dictionary file", GTK_FILE_CHOOSER_ACTION_OPEN);
	_tmp96_ = g_object_ref_sink (_tmp95_);
	_g_object_unref0 (self->priv->dict_filechooserbutton);
	self->priv->dict_filechooserbutton = _tmp96_;
	_tmp97_ = (GtkEntry*) gtk_entry_new ();
	_tmp98_ = g_object_ref_sink (_tmp97_);
	_g_object_unref0 (self->priv->dict_entry);
	self->priv->dict_entry = _tmp98_;
	_tmp99_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 0, (gdouble) 65535, (gdouble) 1);
	_tmp100_ = g_object_ref_sink (_tmp99_);
	_g_object_unref0 (self->priv->dict_spinbutton);
	self->priv->dict_spinbutton = _tmp100_;
	_tmp101_ = gtk_list_store_new (1, TYPE_PLIST);
	_g_object_unref0 (model);
	model = _tmp101_;
	_tmp102_ = self->priv->dictionaries_treeview;
	_tmp103_ = model;
	gtk_tree_view_set_model (_tmp102_, (GtkTreeModel*) _tmp103_);
	_tmp104_ = setup_typecell_renderer_new ();
	_tmp105_ = (GtkCellRenderer*) g_object_ref_sink (_tmp104_);
	_g_object_unref0 (renderer);
	renderer = _tmp105_;
	_tmp106_ = renderer;
	_tmp107_ = gtk_tree_view_column_new_with_attributes ("type", _tmp106_, "plist", 0, NULL);
	_tmp108_ = g_object_ref_sink (_tmp107_);
	_g_object_unref0 (column);
	column = _tmp108_;
	_tmp109_ = self->priv->dictionaries_treeview;
	_tmp110_ = column;
	gtk_tree_view_append_column (_tmp109_, _tmp110_);
	_tmp111_ = setup_desc_cell_renderer_new ();
	_tmp112_ = (GtkCellRenderer*) g_object_ref_sink (_tmp111_);
	_g_object_unref0 (renderer);
	renderer = _tmp112_;
	_tmp113_ = renderer;
	_tmp114_ = gtk_tree_view_column_new_with_attributes ("desc", _tmp113_, "plist", 0, NULL);
	_tmp115_ = g_object_ref_sink (_tmp114_);
	_g_object_unref0 (column);
	column = _tmp115_;
	_tmp116_ = self->priv->dictionaries_treeview;
	_tmp117_ = column;
	gtk_tree_view_append_column (_tmp116_, _tmp117_);
	_tmp118_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp119_ = (GtkCellRenderer*) g_object_ref_sink (_tmp118_);
	_g_object_unref0 (renderer);
	renderer = _tmp119_;
	_tmp120_ = self->priv->period_style_combobox;
	_tmp121_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp120_, _tmp121_, FALSE);
	_tmp122_ = self->priv->period_style_combobox;
	_tmp123_ = renderer;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp122_, _tmp123_, "text", 0, NULL);
	_tmp124_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp125_ = (GtkCellRenderer*) g_object_ref_sink (_tmp124_);
	_g_object_unref0 (renderer);
	renderer = _tmp125_;
	_tmp126_ = self->priv->initial_input_mode_combobox;
	_tmp127_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp126_, _tmp127_, FALSE);
	_tmp128_ = self->priv->initial_input_mode_combobox;
	_tmp129_ = renderer;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp128_, _tmp129_, "text", 0, NULL);
	_tmp130_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
	_g_object_unref0 (model);
	model = _tmp130_;
	_tmp131_ = model;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp131_, 1, GTK_SORT_ASCENDING);
	_tmp132_ = self->priv->typing_rule_combobox;
	_tmp133_ = model;
	gtk_combo_box_set_model (_tmp132_, (GtkTreeModel*) _tmp133_);
	_tmp135_ = skk_rule_list (&_tmp134_);
	rules = _tmp135_;
	rules_length1 = _tmp134_;
	_rules_size_ = rules_length1;
	_tmp136_ = rules;
	_tmp136__length1 = rules_length1;
	{
		SkkRuleMetadata* rule_collection = NULL;
		gint rule_collection_length1 = 0;
		gint _rule_collection_size_ = 0;
		gint rule_it = 0;
		rule_collection = _tmp136_;
		rule_collection_length1 = _tmp136__length1;
		for (rule_it = 0; rule_it < _tmp136__length1; rule_it = rule_it + 1) {
			SkkRuleMetadata _tmp137_ = {0};
			SkkRuleMetadata rule = {0};
			skk_rule_metadata_copy (&rule_collection[rule_it], &_tmp137_);
			rule = _tmp137_;
			{
				GtkTreeIter iter = {0};
				GtkListStore* _tmp138_;
				GtkTreeIter _tmp139_ = {0};
				GtkListStore* _tmp140_;
				GtkTreeIter _tmp141_;
				SkkRuleMetadata _tmp142_;
				const gchar* _tmp143_;
				GtkListStore* _tmp144_;
				GtkTreeIter _tmp145_;
				SkkRuleMetadata _tmp146_;
				const gchar* _tmp147_;
				_tmp138_ = model;
				gtk_list_store_append (_tmp138_, &_tmp139_);
				iter = _tmp139_;
				_tmp140_ = model;
				_tmp141_ = iter;
				_tmp142_ = rule;
				_tmp143_ = _tmp142_.name;
				gtk_list_store_set (_tmp140_, &_tmp141_, 0, _tmp143_, -1);
				_tmp144_ = model;
				_tmp145_ = iter;
				_tmp146_ = rule;
				_tmp147_ = _tmp146_.label;
				gtk_list_store_set (_tmp144_, &_tmp145_, 1, _tmp147_, -1);
				skk_rule_metadata_destroy (&rule);
			}
		}
	}
	_tmp148_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp149_ = (GtkCellRenderer*) g_object_ref_sink (_tmp148_);
	_g_object_unref0 (renderer);
	renderer = _tmp149_;
	_tmp150_ = self->priv->typing_rule_combobox;
	_tmp151_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp150_, _tmp151_, FALSE);
	_tmp152_ = self->priv->typing_rule_combobox;
	_tmp153_ = renderer;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp152_, _tmp153_, "text", 1, NULL);
	setup_load (self);
	_tmp154_ = add_dict_button;
	g_signal_connect_object (_tmp154_, "clicked", (GCallback) _setup_add_dict_gtk_button_clicked, self, 0);
	_tmp155_ = _data1_->remove_dict_button;
	g_signal_connect_object (_tmp155_, "clicked", (GCallback) _setup_remove_dict_gtk_button_clicked, self, 0);
	_tmp156_ = _data1_->up_dict_button;
	g_signal_connect_object (_tmp156_, "clicked", (GCallback) _setup_up_dict_gtk_button_clicked, self, 0);
	_tmp157_ = _data1_->down_dict_button;
	g_signal_connect_object (_tmp157_, "clicked", (GCallback) _setup_down_dict_gtk_button_clicked, self, 0);
	_tmp158_ = self->priv->dictionaries_treeview;
	_tmp159_ = gtk_tree_view_get_selection (_tmp158_);
	_tmp160_ = _g_object_ref0 (_tmp159_);
	_data1_->selection = _tmp160_;
	g_signal_connect_data (_data1_->selection, "changed", (GCallback) ___lambda0__gtk_tree_selection_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp161_ = self->priv->dict_type_comboboxtext;
	g_signal_connect_object ((GtkComboBox*) _tmp161_, "changed", (GCallback) ___lambda1__gtk_combo_box_changed, self, 0);
	_tmp162_ = self->priv->dict_type_comboboxtext;
	gtk_combo_box_set_active ((GtkComboBox*) _tmp162_, 0);
	rules = (_vala_SkkRuleMetadata_array_free (rules, rules_length1), NULL);
	_g_object_unref0 (column);
	_g_object_unref0 (renderer);
	_g_object_unref0 (model);
	_g_object_unref0 (add_dict_button);
	_g_object_unref0 (object);
	_g_free0 (ui_filename);
	_g_object_unref0 (builder);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return self;
}


Setup* setup_new (Preferences* preferences) {
	return setup_construct (TYPE_SETUP, preferences);
}


static void setup_populate_dictionaries_treeview (Setup* self) {
	Preferences* _tmp0_;
	GVariant* _tmp1_ = NULL;
	GVariant* variant;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	size_t _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar** strv;
	gint strv_length1;
	gint _strv_size_;
	GtkTreeView* _tmp6_;
	GtkTreeModel* _tmp7_ = NULL;
	GtkListStore* _tmp8_;
	GtkListStore* model;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences;
	_tmp1_ = preferences_get (_tmp0_, "dictionaries");
	variant = _tmp1_;
	_tmp2_ = variant;
	g_assert (_tmp2_ != NULL);
	_tmp3_ = variant;
	_tmp5_ = g_variant_dup_strv (_tmp3_, &_tmp4_);
	strv = _tmp5_;
	strv_length1 = _tmp4_;
	_strv_size_ = strv_length1;
	_tmp6_ = self->priv->dictionaries_treeview;
	_tmp7_ = gtk_tree_view_get_model (_tmp6_);
	_tmp8_ = _g_object_ref0 (GTK_LIST_STORE (_tmp7_));
	model = _tmp8_;
	_tmp9_ = strv;
	_tmp9__length1 = strv_length1;
	{
		gchar** str_collection = NULL;
		gint str_collection_length1 = 0;
		gint _str_collection_size_ = 0;
		gint str_it = 0;
		str_collection = _tmp9_;
		str_collection_length1 = _tmp9__length1;
		for (str_it = 0; str_it < _tmp9__length1; str_it = str_it + 1) {
			gchar* _tmp10_;
			gchar* str = NULL;
			_tmp10_ = g_strdup (str_collection[str_it]);
			str = _tmp10_;
			{
				PList* plist = NULL;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp17_;
				GtkTreeIter _tmp18_ = {0};
				GtkListStore* _tmp19_;
				GtkTreeIter _tmp20_;
				PList* _tmp21_;
				{
					const gchar* _tmp11_;
					PList* _tmp12_;
					PList* _tmp13_;
					_tmp11_ = str;
					_tmp12_ = plist_new (_tmp11_, &_inner_error_);
					_tmp13_ = _tmp12_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == PLIST_PARSE_ERROR) {
							goto __catch1_plist_parse_error;
						}
						_g_object_unref0 (plist);
						_g_free0 (str);
						_g_object_unref0 (model);
						strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
						_g_variant_unref0 (variant);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (plist);
					plist = _tmp13_;
				}
				goto __finally1;
				__catch1_plist_parse_error:
				{
					GError* e = NULL;
					const gchar* _tmp14_;
					GError* _tmp15_;
					const gchar* _tmp16_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp14_ = str;
					_tmp15_ = e;
					_tmp16_ = _tmp15_->message;
					g_warning ("setup.vala:243: can't parse plist %s: %s", _tmp14_, _tmp16_);
					_g_error_free0 (e);
					_g_object_unref0 (plist);
					_g_free0 (str);
					continue;
				}
				__finally1:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (plist);
					_g_free0 (str);
					_g_object_unref0 (model);
					strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
					_g_variant_unref0 (variant);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp17_ = model;
				gtk_list_store_append (_tmp17_, &_tmp18_);
				iter = _tmp18_;
				_tmp19_ = model;
				_tmp20_ = iter;
				_tmp21_ = plist;
				gtk_list_store_set (_tmp19_, &_tmp20_, 0, _tmp21_, -1);
				_g_object_unref0 (plist);
				_g_free0 (str);
			}
		}
	}
	_g_object_unref0 (model);
	strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
	_g_variant_unref0 (variant);
}


static void setup_add_dict (Setup* self) {
	GtkDialog* _tmp0_;
	gint _tmp1_ = 0;
	GtkDialog* _tmp80_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dict_dialog;
	_tmp1_ = gtk_dialog_run (_tmp0_);
	if (_tmp1_ == ((gint) GTK_RESPONSE_OK)) {
		PList* plist;
		GtkComboBoxText* _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* text;
		const gchar* _tmp5_;
		PList* _tmp52_;
		plist = NULL;
		_tmp2_ = self->priv->dict_type_comboboxtext;
		_tmp3_ = gtk_combo_box_text_get_active_text (_tmp2_);
		_tmp4_ = g_strdup (_tmp3_);
		text = _tmp4_;
		_tmp5_ = text;
		if (g_strcmp0 (_tmp5_, "System") == 0) {
			GtkFileChooserButton* _tmp6_;
			gchar* _tmp7_ = NULL;
			gchar* file;
			const gchar* _tmp8_;
			_tmp6_ = self->priv->dict_filechooserbutton;
			_tmp7_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp6_);
			file = _tmp7_;
			_tmp8_ = file;
			if (_tmp8_ != NULL) {
				{
					const gchar* _tmp9_;
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_;
					PList* _tmp14_;
					PList* _tmp15_;
					PList* _tmp16_;
					_tmp9_ = file;
					_tmp10_ = plist_escape (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_strdup_printf ("type=file,file=%s,mode=readonly", _tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = plist_new (_tmp13_, &_inner_error_);
					_tmp15_ = _tmp14_;
					_g_free0 (_tmp13_);
					_g_free0 (_tmp11_);
					_tmp16_ = _tmp15_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == PLIST_PARSE_ERROR) {
							goto __catch2_plist_parse_error;
						}
						_g_free0 (file);
						_g_free0 (text);
						_g_object_unref0 (plist);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (plist);
					plist = _tmp16_;
				}
				goto __finally2;
				__catch2_plist_parse_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					g_assert_not_reached ();
					_g_error_free0 (e);
				}
				__finally2:
				if (_inner_error_ != NULL) {
					_g_free0 (file);
					_g_free0 (text);
					_g_object_unref0 (plist);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_g_free0 (file);
		} else {
			const gchar* _tmp17_;
			_tmp17_ = text;
			if (g_strcmp0 (_tmp17_, "User") == 0) {
				GtkFileChooserButton* _tmp18_;
				gchar* _tmp19_ = NULL;
				gchar* file;
				const gchar* _tmp20_;
				_tmp18_ = self->priv->dict_filechooserbutton;
				_tmp19_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp18_);
				file = _tmp19_;
				_tmp20_ = file;
				if (_tmp20_ != NULL) {
					{
						const gchar* _tmp21_;
						gchar* _tmp22_ = NULL;
						gchar* _tmp23_;
						gchar* _tmp24_ = NULL;
						gchar* _tmp25_;
						PList* _tmp26_;
						PList* _tmp27_;
						PList* _tmp28_;
						_tmp21_ = file;
						_tmp22_ = plist_escape (_tmp21_);
						_tmp23_ = _tmp22_;
						_tmp24_ = g_strdup_printf ("type=file,file=%s,mode=readwrite", _tmp23_);
						_tmp25_ = _tmp24_;
						_tmp26_ = plist_new (_tmp25_, &_inner_error_);
						_tmp27_ = _tmp26_;
						_g_free0 (_tmp25_);
						_g_free0 (_tmp23_);
						_tmp28_ = _tmp27_;
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == PLIST_PARSE_ERROR) {
								goto __catch3_plist_parse_error;
							}
							_g_free0 (file);
							_g_free0 (text);
							_g_object_unref0 (plist);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_g_object_unref0 (plist);
						plist = _tmp28_;
					}
					goto __finally3;
					__catch3_plist_parse_error:
					{
						GError* e = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						g_assert_not_reached ();
						_g_error_free0 (e);
					}
					__finally3:
					if (_inner_error_ != NULL) {
						_g_free0 (file);
						_g_free0 (text);
						_g_object_unref0 (plist);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_g_free0 (file);
			} else {
				const gchar* _tmp29_;
				_tmp29_ = text;
				if (g_strcmp0 (_tmp29_, "SKK Server") == 0) {
					GtkEntry* _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* host;
					GtkSpinButton* _tmp34_;
					gdouble _tmp35_;
					gdouble _tmp36_;
					guint16 port;
					gboolean _tmp37_ = FALSE;
					const gchar* _tmp38_;
					gint _tmp39_;
					gint _tmp40_;
					gboolean _tmp42_;
					_tmp30_ = self->priv->dict_entry;
					_tmp31_ = gtk_entry_get_text (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = g_strdup (_tmp32_);
					host = _tmp33_;
					_tmp34_ = self->priv->dict_spinbutton;
					_tmp35_ = gtk_spin_button_get_value (_tmp34_);
					_tmp36_ = _tmp35_;
					port = (guint16) _tmp36_;
					_tmp38_ = host;
					_tmp39_ = strlen (_tmp38_);
					_tmp40_ = _tmp39_;
					if (_tmp40_ > 0) {
						guint16 _tmp41_;
						_tmp41_ = port;
						_tmp37_ = ((gint) _tmp41_) > 0;
					} else {
						_tmp37_ = FALSE;
					}
					_tmp42_ = _tmp37_;
					if (_tmp42_) {
						{
							const gchar* _tmp43_;
							gchar* _tmp44_ = NULL;
							gchar* _tmp45_;
							guint16 _tmp46_;
							gchar* _tmp47_ = NULL;
							gchar* _tmp48_;
							PList* _tmp49_;
							PList* _tmp50_;
							PList* _tmp51_;
							_tmp43_ = host;
							_tmp44_ = plist_escape (_tmp43_);
							_tmp45_ = _tmp44_;
							_tmp46_ = port;
							_tmp47_ = g_strdup_printf ("type=server,host=%s,port=%d", _tmp45_, (gint) _tmp46_);
							_tmp48_ = _tmp47_;
							_tmp49_ = plist_new (_tmp48_, &_inner_error_);
							_tmp50_ = _tmp49_;
							_g_free0 (_tmp48_);
							_g_free0 (_tmp45_);
							_tmp51_ = _tmp50_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == PLIST_PARSE_ERROR) {
									goto __catch4_plist_parse_error;
								}
								_g_free0 (host);
								_g_free0 (text);
								_g_object_unref0 (plist);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_g_object_unref0 (plist);
							plist = _tmp51_;
						}
						goto __finally4;
						__catch4_plist_parse_error:
						{
							GError* e = NULL;
							e = _inner_error_;
							_inner_error_ = NULL;
							g_assert_not_reached ();
							_g_error_free0 (e);
						}
						__finally4:
						if (_inner_error_ != NULL) {
							_g_free0 (host);
							_g_free0 (text);
							_g_object_unref0 (plist);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_g_free0 (host);
				} else {
					g_assert_not_reached ();
				}
			}
		}
		_tmp52_ = plist;
		if (_tmp52_ != NULL) {
			GtkTreeView* _tmp53_;
			GtkTreeModel* _tmp54_ = NULL;
			GtkListStore* _tmp55_;
			GtkListStore* model;
			GtkTreeIter iter = {0};
			gboolean found;
			GtkListStore* _tmp56_;
			GtkTreeIter _tmp57_ = {0};
			gboolean _tmp58_ = FALSE;
			gboolean _tmp75_;
			_tmp53_ = self->priv->dictionaries_treeview;
			_tmp54_ = gtk_tree_view_get_model (_tmp53_);
			_tmp55_ = _g_object_ref0 (GTK_LIST_STORE (_tmp54_));
			model = _tmp55_;
			found = FALSE;
			_tmp56_ = model;
			_tmp58_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp56_, &_tmp57_);
			iter = _tmp57_;
			if (_tmp58_) {
				{
					gboolean _tmp59_;
					_tmp59_ = TRUE;
					while (TRUE) {
						gboolean _tmp60_;
						PList* _plist = NULL;
						GtkListStore* _tmp66_;
						GtkTreeIter _tmp67_;
						PList* _tmp68_;
						gchar* _tmp69_ = NULL;
						gchar* _tmp70_;
						PList* _tmp71_;
						gchar* _tmp72_ = NULL;
						gchar* _tmp73_;
						gboolean _tmp74_;
						_tmp60_ = _tmp59_;
						if (!_tmp60_) {
							gboolean _tmp61_ = FALSE;
							gboolean _tmp62_;
							gboolean _tmp65_;
							_tmp62_ = found;
							if (!_tmp62_) {
								GtkListStore* _tmp63_;
								gboolean _tmp64_ = FALSE;
								_tmp63_ = model;
								_tmp64_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp63_, &iter);
								_tmp61_ = _tmp64_;
							} else {
								_tmp61_ = FALSE;
							}
							_tmp65_ = _tmp61_;
							if (!_tmp65_) {
								break;
							}
						}
						_tmp59_ = FALSE;
						_tmp66_ = model;
						_tmp67_ = iter;
						gtk_tree_model_get ((GtkTreeModel*) _tmp66_, &_tmp67_, 0, &_plist, -1, -1);
						_tmp68_ = _plist;
						_tmp69_ = plist_to_string (_tmp68_);
						_tmp70_ = _tmp69_;
						_tmp71_ = plist;
						_tmp72_ = plist_to_string (_tmp71_);
						_tmp73_ = _tmp72_;
						_tmp74_ = g_strcmp0 (_tmp70_, _tmp73_) == 0;
						_g_free0 (_tmp73_);
						_g_free0 (_tmp70_);
						if (_tmp74_) {
							found = TRUE;
						}
						_g_object_unref0 (_plist);
					}
				}
			}
			_tmp75_ = found;
			if (!_tmp75_) {
				GtkListStore* _tmp76_;
				gint _tmp77_;
				PList* _tmp78_;
				GtkTreeIter _tmp79_ = {0};
				_tmp76_ = model;
				_tmp77_ = G_MAXINT;
				_tmp78_ = plist;
				gtk_list_store_insert_with_values (_tmp76_, &_tmp79_, _tmp77_, 0, _tmp78_, -1, -1);
				iter = _tmp79_;
			}
			_g_object_unref0 (model);
		}
		_g_free0 (text);
		_g_object_unref0 (plist);
	}
	_tmp80_ = self->priv->dict_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp80_);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static void setup_remove_dict (Setup* self) {
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* selection;
	GtkTreeModel* model = NULL;
	GtkTreeSelection* _tmp3_;
	GtkTreeModel* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_;
	GList* rows;
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dictionaries_treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp5_ = gtk_tree_selection_get_selected_rows (_tmp3_, &_tmp4_);
	_g_object_unref0 (model);
	_tmp6_ = _g_object_ref0 (_tmp4_);
	model = _tmp6_;
	rows = _tmp5_;
	_tmp7_ = rows;
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp7_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkTreePath* _tmp8_;
			GtkTreePath* row = NULL;
			_tmp8_ = _gtk_tree_path_copy0 ((GtkTreePath*) row_it->data);
			row = _tmp8_;
			{
				GtkTreeIter iter = {0};
				GtkTreeModel* _tmp9_;
				GtkTreePath* _tmp10_;
				GtkTreeIter _tmp11_ = {0};
				gboolean _tmp12_ = FALSE;
				_tmp9_ = model;
				_tmp10_ = row;
				_tmp12_ = gtk_tree_model_get_iter (_tmp9_, &_tmp11_, _tmp10_);
				iter = _tmp11_;
				if (_tmp12_) {
					GtkTreeModel* _tmp13_;
					GtkTreeIter _tmp14_;
					_tmp13_ = model;
					_tmp14_ = iter;
					gtk_list_store_remove (GTK_LIST_STORE (_tmp13_), &_tmp14_);
				}
				_gtk_tree_path_free0 (row);
			}
		}
	}
	__g_list_free__gtk_tree_path_free0_0 (rows);
	_g_object_unref0 (model);
	_g_object_unref0 (selection);
}


static void setup_up_dict (Setup* self) {
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* selection;
	GtkTreeModel* model = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp3_;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	GtkTreeModel* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dictionaries_treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp6_ = gtk_tree_selection_get_selected (_tmp3_, &_tmp4_, &_tmp5_);
	_g_object_unref0 (model);
	_tmp7_ = _g_object_ref0 (_tmp4_);
	model = _tmp7_;
	iter = _tmp5_;
	if (_tmp6_) {
		GtkTreeIter _tmp8_;
		GtkTreeIter prev;
		GtkTreeModel* _tmp9_;
		gboolean _tmp10_ = FALSE;
		_tmp8_ = iter;
		prev = _tmp8_;
		_tmp9_ = model;
		_tmp10_ = gtk_tree_model_iter_previous (_tmp9_, &prev);
		if (_tmp10_) {
			GtkTreeModel* _tmp11_;
			GtkTreeIter _tmp12_;
			GtkTreeIter _tmp13_;
			_tmp11_ = model;
			_tmp12_ = iter;
			_tmp13_ = prev;
			gtk_list_store_swap (GTK_LIST_STORE (_tmp11_), &_tmp12_, &_tmp13_);
		}
	}
	_g_object_unref0 (model);
	_g_object_unref0 (selection);
}


static void setup_down_dict (Setup* self) {
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* selection;
	GtkTreeModel* model = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp3_;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	GtkTreeModel* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dictionaries_treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp6_ = gtk_tree_selection_get_selected (_tmp3_, &_tmp4_, &_tmp5_);
	_g_object_unref0 (model);
	_tmp7_ = _g_object_ref0 (_tmp4_);
	model = _tmp7_;
	iter = _tmp5_;
	if (_tmp6_) {
		GtkTreeIter _tmp8_;
		GtkTreeIter next;
		GtkTreeModel* _tmp9_;
		gboolean _tmp10_ = FALSE;
		_tmp8_ = iter;
		next = _tmp8_;
		_tmp9_ = model;
		_tmp10_ = gtk_tree_model_iter_next (_tmp9_, &next);
		if (_tmp10_) {
			GtkTreeModel* _tmp11_;
			GtkTreeIter _tmp12_;
			GtkTreeIter _tmp13_;
			_tmp11_ = model;
			_tmp12_ = iter;
			_tmp13_ = next;
			gtk_list_store_swap (GTK_LIST_STORE (_tmp11_), &_tmp12_, &_tmp13_);
		}
	}
	_g_object_unref0 (model);
	_g_object_unref0 (selection);
}


static void setup_load_combobox (Setup* self, const gchar* name, GtkComboBox* combo, gint column) {
	Preferences* _tmp0_;
	const gchar* _tmp1_;
	GVariant* _tmp2_ = NULL;
	GVariant* variant;
	GVariant* _tmp3_;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp4_;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_;
	GtkTreeModel* model;
	GtkTreeModel* _tmp7_;
	GtkTreeIter _tmp8_ = {0};
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->preferences;
	_tmp1_ = name;
	_tmp2_ = preferences_get (_tmp0_, _tmp1_);
	variant = _tmp2_;
	_tmp3_ = variant;
	g_assert (_tmp3_ != NULL);
	_tmp4_ = combo;
	_tmp5_ = gtk_combo_box_get_model (_tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	model = _tmp6_;
	_tmp7_ = model;
	_tmp9_ = gtk_tree_model_get_iter_first (_tmp7_, &_tmp8_);
	iter = _tmp8_;
	if (_tmp9_) {
		GVariant* _tmp10_;
		gint32 _tmp11_ = 0;
		gint32 index;
		gint _index = 0;
		_tmp10_ = variant;
		_tmp11_ = g_variant_get_int32 (_tmp10_);
		index = _tmp11_;
		{
			gboolean _tmp12_;
			_tmp12_ = TRUE;
			while (TRUE) {
				gboolean _tmp13_;
				GtkTreeModel* _tmp16_;
				GtkTreeIter _tmp17_;
				gint _tmp18_;
				gint32 _tmp19_;
				gint _tmp20_;
				_tmp13_ = _tmp12_;
				if (!_tmp13_) {
					GtkTreeModel* _tmp14_;
					gboolean _tmp15_ = FALSE;
					_tmp14_ = model;
					_tmp15_ = gtk_tree_model_iter_next (_tmp14_, &iter);
					if (!_tmp15_) {
						break;
					}
				}
				_tmp12_ = FALSE;
				_tmp16_ = model;
				_tmp17_ = iter;
				_tmp18_ = column;
				gtk_tree_model_get (_tmp16_, &_tmp17_, _tmp18_, &_index, -1, -1);
				_tmp19_ = index;
				_tmp20_ = _index;
				if (_tmp19_ == ((gint32) _tmp20_)) {
					GtkComboBox* _tmp21_;
					GtkTreeIter _tmp22_;
					_tmp21_ = combo;
					_tmp22_ = iter;
					gtk_combo_box_set_active_iter (_tmp21_, &_tmp22_);
					break;
				}
			}
		}
	}
	_g_object_unref0 (model);
	_g_variant_unref0 (variant);
}


static void setup_load (Setup* self) {
	GVariant* variant = NULL;
	Preferences* _tmp0_;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_;
	GtkEntry* _tmp3_;
	GVariant* _tmp4_;
	size_t _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	Preferences* _tmp10_;
	GVariant* _tmp11_ = NULL;
	GVariant* _tmp12_;
	GtkCheckButton* _tmp13_;
	GVariant* _tmp14_;
	gboolean _tmp15_ = FALSE;
	Preferences* _tmp16_;
	GVariant* _tmp17_ = NULL;
	GVariant* _tmp18_;
	GtkSpinButton* _tmp19_;
	GtkSpinButton* _tmp20_;
	GtkSpinButton* _tmp21_;
	GVariant* _tmp22_;
	gint32 _tmp23_ = 0;
	Preferences* _tmp24_;
	GVariant* _tmp25_ = NULL;
	GVariant* _tmp26_;
	GtkSpinButton* _tmp27_;
	GtkSpinButton* _tmp28_;
	GtkSpinButton* _tmp29_;
	GVariant* _tmp30_;
	gint32 _tmp31_ = 0;
	Preferences* _tmp32_;
	GVariant* _tmp33_ = NULL;
	GVariant* _tmp34_;
	GtkCheckButton* _tmp35_;
	GVariant* _tmp36_;
	gboolean _tmp37_ = FALSE;
	GtkComboBox* _tmp38_;
	GtkComboBox* _tmp39_;
	Preferences* _tmp40_;
	GVariant* _tmp41_ = NULL;
	GVariant* _tmp42_;
	GtkComboBox* _tmp43_;
	GtkTreeModel* _tmp44_ = NULL;
	GtkListStore* _tmp45_;
	GtkListStore* model;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp46_;
	GtkTreeIter _tmp47_ = {0};
	gboolean _tmp48_ = FALSE;
	g_return_if_fail (self != NULL);
	setup_populate_dictionaries_treeview (self);
	_tmp0_ = self->priv->preferences;
	_tmp1_ = preferences_get (_tmp0_, "auto_start_henkan_keywords");
	_g_variant_unref0 (variant);
	variant = _tmp1_;
	_tmp2_ = variant;
	g_assert (_tmp2_ != NULL);
	_tmp3_ = self->priv->auto_start_henkan_keywords_entry;
	_tmp4_ = variant;
	_tmp6_ = g_variant_dup_strv (_tmp4_, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	_tmp8_ = g_strjoinv ("", _tmp7_);
	_tmp9_ = _tmp8_;
	gtk_entry_set_text (_tmp3_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	_tmp10_ = self->priv->preferences;
	_tmp11_ = preferences_get (_tmp10_, "egg_like_newline");
	_g_variant_unref0 (variant);
	variant = _tmp11_;
	_tmp12_ = variant;
	g_assert (_tmp12_ != NULL);
	_tmp13_ = self->priv->egg_like_newline_checkbutton;
	_tmp14_ = variant;
	_tmp15_ = g_variant_get_boolean (_tmp14_);
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp13_, _tmp15_);
	_tmp16_ = self->priv->preferences;
	_tmp17_ = preferences_get (_tmp16_, "page_size");
	_g_variant_unref0 (variant);
	variant = _tmp17_;
	_tmp18_ = variant;
	g_assert (_tmp18_ != NULL);
	_tmp19_ = self->priv->page_size_spinbutton;
	gtk_spin_button_set_range (_tmp19_, 7.0, 16.0);
	_tmp20_ = self->priv->page_size_spinbutton;
	gtk_spin_button_set_increments (_tmp20_, 1.0, 1.0);
	_tmp21_ = self->priv->page_size_spinbutton;
	_tmp22_ = variant;
	_tmp23_ = g_variant_get_int32 (_tmp22_);
	gtk_spin_button_set_value (_tmp21_, (gdouble) _tmp23_);
	_tmp24_ = self->priv->preferences;
	_tmp25_ = preferences_get (_tmp24_, "pagination_start");
	_g_variant_unref0 (variant);
	variant = _tmp25_;
	_tmp26_ = variant;
	g_assert (_tmp26_ != NULL);
	_tmp27_ = self->priv->pagination_start_spinbutton;
	gtk_spin_button_set_range (_tmp27_, 0.0, 7.0);
	_tmp28_ = self->priv->pagination_start_spinbutton;
	gtk_spin_button_set_increments (_tmp28_, 1.0, 1.0);
	_tmp29_ = self->priv->pagination_start_spinbutton;
	_tmp30_ = variant;
	_tmp31_ = g_variant_get_int32 (_tmp30_);
	gtk_spin_button_set_value (_tmp29_, (gdouble) _tmp31_);
	_tmp32_ = self->priv->preferences;
	_tmp33_ = preferences_get (_tmp32_, "show_annotation");
	_g_variant_unref0 (variant);
	variant = _tmp33_;
	_tmp34_ = variant;
	g_assert (_tmp34_ != NULL);
	_tmp35_ = self->priv->show_annotation_checkbutton;
	_tmp36_ = variant;
	_tmp37_ = g_variant_get_boolean (_tmp36_);
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp35_, _tmp37_);
	_tmp38_ = self->priv->period_style_combobox;
	setup_load_combobox (self, "period_style", _tmp38_, 1);
	_tmp39_ = self->priv->initial_input_mode_combobox;
	setup_load_combobox (self, "initial_input_mode", _tmp39_, 1);
	_tmp40_ = self->priv->preferences;
	_tmp41_ = preferences_get (_tmp40_, "typing_rule");
	_g_variant_unref0 (variant);
	variant = _tmp41_;
	_tmp42_ = variant;
	g_assert (_tmp42_ != NULL);
	_tmp43_ = self->priv->typing_rule_combobox;
	_tmp44_ = gtk_combo_box_get_model (_tmp43_);
	_tmp45_ = _g_object_ref0 (GTK_LIST_STORE (_tmp44_));
	model = _tmp45_;
	_tmp46_ = model;
	_tmp48_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp46_, &_tmp47_);
	iter = _tmp47_;
	if (_tmp48_) {
		GVariant* _tmp49_;
		const gchar* _tmp50_ = NULL;
		gchar* _tmp51_;
		gchar* rule;
		_tmp49_ = variant;
		_tmp50_ = g_variant_get_string (_tmp49_, NULL);
		_tmp51_ = g_strdup (_tmp50_);
		rule = _tmp51_;
		{
			gboolean _tmp52_;
			_tmp52_ = TRUE;
			while (TRUE) {
				gboolean _tmp53_;
				gchar* _rule = NULL;
				GtkListStore* _tmp56_;
				GtkTreeIter _tmp57_;
				const gchar* _tmp58_;
				const gchar* _tmp59_;
				_tmp53_ = _tmp52_;
				if (!_tmp53_) {
					GtkListStore* _tmp54_;
					gboolean _tmp55_ = FALSE;
					_tmp54_ = model;
					_tmp55_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp54_, &iter);
					if (!_tmp55_) {
						break;
					}
				}
				_tmp52_ = FALSE;
				_tmp56_ = model;
				_tmp57_ = iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp56_, &_tmp57_, 0, &_rule, -1, -1);
				_tmp58_ = rule;
				_tmp59_ = _rule;
				if (g_strcmp0 (_tmp58_, _tmp59_) == 0) {
					GtkComboBox* _tmp60_;
					GtkTreeIter _tmp61_;
					_tmp60_ = self->priv->typing_rule_combobox;
					_tmp61_ = iter;
					gtk_combo_box_set_active_iter (_tmp60_, &_tmp61_);
					_g_free0 (_rule);
					break;
				}
				_g_free0 (_rule);
			}
		}
		_g_free0 (rule);
	}
	_g_object_unref0 (model);
	_g_variant_unref0 (variant);
}


static GVariant* _variant_new1 (gchar** value, gint value_length1) {
	gchar** _tmp23_;
	GVariantBuilder _tmp24_;
	int _tmp25_;
	_tmp23_ = value;
	g_variant_builder_init (&_tmp24_, G_VARIANT_TYPE ("as"));
	for (_tmp25_ = 0; _tmp25_ < value_length1; _tmp25_++) {
		g_variant_builder_add_value (&_tmp24_, g_variant_new_string (*_tmp23_));
		_tmp23_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp24_));
}


static void setup_save_dictionaries (Setup* self, const gchar* name) {
	GtkTreeView* _tmp0_;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->dictionaries_treeview;
	_tmp1_ = gtk_tree_view_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp3_ = model;
	_tmp5_ = gtk_tree_model_get_iter_first (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	if (_tmp5_) {
		GeeArrayList* _tmp6_;
		GeeArrayList* dictionaries;
		Preferences* _tmp17_;
		const gchar* _tmp18_;
		GeeArrayList* _tmp19_;
		gint _tmp20_ = 0;
		gpointer* _tmp21_ = NULL;
		gchar** _tmp22_;
		gint _tmp22__length1;
		GVariant* _tmp26_;
		_tmp6_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
		dictionaries = _tmp6_;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				PList* plist = NULL;
				GtkTreeModel* _tmp11_;
				GtkTreeIter _tmp12_;
				GeeArrayList* _tmp13_;
				PList* _tmp14_;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					GtkTreeModel* _tmp9_;
					gboolean _tmp10_ = FALSE;
					_tmp9_ = model;
					_tmp10_ = gtk_tree_model_iter_next (_tmp9_, &iter);
					if (!_tmp10_) {
						break;
					}
				}
				_tmp7_ = FALSE;
				_tmp11_ = model;
				_tmp12_ = iter;
				gtk_tree_model_get (_tmp11_, &_tmp12_, 0, &plist, -1, -1);
				_tmp13_ = dictionaries;
				_tmp14_ = plist;
				_tmp15_ = plist_to_string (_tmp14_);
				_tmp16_ = _tmp15_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp16_);
				_g_free0 (_tmp16_);
				_g_object_unref0 (plist);
			}
		}
		_tmp17_ = self->priv->preferences;
		_tmp18_ = name;
		_tmp19_ = dictionaries;
		_tmp21_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp19_, &_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp22__length1 = _tmp20_;
		_tmp26_ = _variant_new1 (_tmp22_, _tmp20_);
		preferences_set (_tmp17_, _tmp18_, _tmp26_);
		_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (dictionaries);
	}
	_g_object_unref0 (model);
}


static GVariant* _variant_new2 (gint value) {
	return g_variant_ref_sink (g_variant_new_int32 (value));
}


static void setup_save_combobox (Setup* self, const gchar* name, GtkComboBox* combo, gint column) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		gint index = 0;
		GtkComboBox* _tmp3_;
		GtkTreeModel* _tmp4_ = NULL;
		GtkTreeModel* _tmp5_;
		GtkTreeModel* model;
		GtkTreeModel* _tmp6_;
		GtkTreeIter _tmp7_;
		gint _tmp8_;
		Preferences* _tmp9_;
		const gchar* _tmp10_;
		gint _tmp11_;
		GVariant* _tmp12_;
		_tmp3_ = combo;
		_tmp4_ = gtk_combo_box_get_model (_tmp3_);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		model = _tmp5_;
		_tmp6_ = model;
		_tmp7_ = iter;
		_tmp8_ = column;
		gtk_tree_model_get (_tmp6_, &_tmp7_, _tmp8_, &index, -1, -1);
		_tmp9_ = self->priv->preferences;
		_tmp10_ = name;
		_tmp11_ = index;
		_tmp12_ = _variant_new2 (_tmp11_);
		preferences_set (_tmp9_, _tmp10_, _tmp12_);
		_g_object_unref0 (model);
	}
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static GVariant* _variant_new3 (gchar** value, gint value_length1) {
	gchar** _tmp15_;
	GVariantBuilder _tmp16_;
	int _tmp17_;
	_tmp15_ = value;
	g_variant_builder_init (&_tmp16_, G_VARIANT_TYPE ("as"));
	for (_tmp17_ = 0; _tmp17_ < value_length1; _tmp17_++) {
		g_variant_builder_add_value (&_tmp16_, g_variant_new_string (*_tmp15_));
		_tmp15_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp16_));
}


static GVariant* _variant_new4 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static GVariant* _variant_new5 (gint value) {
	return g_variant_ref_sink (g_variant_new_int32 (value));
}


static GVariant* _variant_new6 (gint value) {
	return g_variant_ref_sink (g_variant_new_int32 (value));
}


static GVariant* _variant_new7 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static GVariant* _variant_new8 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static void setup_save (Setup* self) {
	GeeArrayList* _tmp0_;
	GeeArrayList* keywords;
	gint index;
	gunichar uc = 0U;
	Preferences* _tmp10_;
	GeeArrayList* _tmp11_;
	gint _tmp12_ = 0;
	gpointer* _tmp13_ = NULL;
	gchar** _tmp14_;
	gint _tmp14__length1;
	GVariant* _tmp18_;
	Preferences* _tmp19_;
	GtkCheckButton* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	GVariant* _tmp23_;
	Preferences* _tmp24_;
	GtkSpinButton* _tmp25_;
	gdouble _tmp26_;
	gdouble _tmp27_;
	GVariant* _tmp28_;
	Preferences* _tmp29_;
	GtkSpinButton* _tmp30_;
	gdouble _tmp31_;
	gdouble _tmp32_;
	GVariant* _tmp33_;
	Preferences* _tmp34_;
	GtkCheckButton* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	GVariant* _tmp38_;
	GtkComboBox* _tmp39_;
	GtkComboBox* _tmp40_;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp41_;
	GtkTreeIter _tmp42_ = {0};
	gboolean _tmp43_ = FALSE;
	Preferences* _tmp52_;
	g_return_if_fail (self != NULL);
	setup_save_dictionaries (self, "dictionaries");
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	keywords = _tmp0_;
	index = 0;
	while (TRUE) {
		GtkEntry* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gunichar _tmp4_ = 0U;
		gboolean _tmp5_ = FALSE;
		GeeArrayList* _tmp6_;
		gunichar _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp1_ = self->priv->auto_start_henkan_keywords_entry;
		_tmp2_ = gtk_entry_get_text (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp5_ = string_get_next_char (_tmp3_, &index, &_tmp4_);
		uc = _tmp4_;
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = keywords;
		_tmp7_ = uc;
		_tmp8_ = g_unichar_to_string (_tmp7_);
		_tmp9_ = _tmp8_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp9_);
		_g_free0 (_tmp9_);
	}
	_tmp10_ = self->priv->preferences;
	_tmp11_ = keywords;
	_tmp13_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp11_, &_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp14__length1 = _tmp12_;
	_tmp18_ = _variant_new3 (_tmp14_, _tmp12_);
	preferences_set (_tmp10_, "auto_start_henkan_keywords", _tmp18_);
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	_tmp19_ = self->priv->preferences;
	_tmp20_ = self->priv->egg_like_newline_checkbutton;
	_tmp21_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = _variant_new4 (_tmp22_);
	preferences_set (_tmp19_, "egg_like_newline", _tmp23_);
	_tmp24_ = self->priv->preferences;
	_tmp25_ = self->priv->page_size_spinbutton;
	_tmp26_ = gtk_spin_button_get_value (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = _variant_new5 ((gint) _tmp27_);
	preferences_set (_tmp24_, "page_size", _tmp28_);
	_tmp29_ = self->priv->preferences;
	_tmp30_ = self->priv->pagination_start_spinbutton;
	_tmp31_ = gtk_spin_button_get_value (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = _variant_new6 ((gint) _tmp32_);
	preferences_set (_tmp29_, "pagination_start", _tmp33_);
	_tmp34_ = self->priv->preferences;
	_tmp35_ = self->priv->show_annotation_checkbutton;
	_tmp36_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = _variant_new7 (_tmp37_);
	preferences_set (_tmp34_, "show_annotation", _tmp38_);
	_tmp39_ = self->priv->period_style_combobox;
	setup_save_combobox (self, "period_style", _tmp39_, 1);
	_tmp40_ = self->priv->initial_input_mode_combobox;
	setup_save_combobox (self, "initial_input_mode", _tmp40_, 1);
	_tmp41_ = self->priv->typing_rule_combobox;
	_tmp43_ = gtk_combo_box_get_active_iter (_tmp41_, &_tmp42_);
	iter = _tmp42_;
	if (_tmp43_) {
		GtkComboBox* _tmp44_;
		GtkTreeModel* _tmp45_ = NULL;
		GtkListStore* _tmp46_;
		GtkListStore* model;
		gchar* rule = NULL;
		GtkListStore* _tmp47_;
		GtkTreeIter _tmp48_;
		Preferences* _tmp49_;
		const gchar* _tmp50_;
		GVariant* _tmp51_;
		_tmp44_ = self->priv->typing_rule_combobox;
		_tmp45_ = gtk_combo_box_get_model (_tmp44_);
		_tmp46_ = _g_object_ref0 (GTK_LIST_STORE (_tmp45_));
		model = _tmp46_;
		_tmp47_ = model;
		_tmp48_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp47_, &_tmp48_, 0, &rule, -1, -1);
		_tmp49_ = self->priv->preferences;
		_tmp50_ = rule;
		_tmp51_ = _variant_new8 (_tmp50_);
		preferences_set (_tmp49_, "typing_rule", _tmp51_);
		_g_free0 (rule);
		_g_object_unref0 (model);
	}
	_tmp52_ = self->priv->preferences;
	preferences_save (_tmp52_);
	_g_object_unref0 (keywords);
}


void setup_run (Setup* self) {
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dialog;
	gtk_dialog_run (_tmp0_);
	setup_save (self);
}


gint setup_main (gchar** args, int args_length1) {
	gint result = 0;
	IBusBus* _tmp0_;
	IBusBus* _tmp1_;
	IBusBus* bus;
	IBusConfig* _tmp2_ = NULL;
	IBusConfig* _tmp3_;
	IBusConfig* config;
	Preferences* _tmp4_;
	Preferences* _tmp5_;
	Setup* _tmp6_;
	Setup* _tmp7_;
	Setup* setup;
	gtk_init (&args_length1, &args);
	ibus_init ();
	skk_init ();
	_tmp0_ = ibus_bus_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	bus = _tmp1_;
	_tmp2_ = ibus_bus_get_config (bus);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	config = _tmp3_;
	_tmp4_ = preferences_new (config);
	_tmp5_ = _tmp4_;
	_tmp6_ = setup_new (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	setup = _tmp7_;
	setup_run (setup);
	result = 0;
	_g_object_unref0 (setup);
	_g_object_unref0 (config);
	_g_object_unref0 (bus);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return setup_main (argv, argc);
}


static SetupTypeCellRenderer* setup_typecell_renderer_construct (GType object_type) {
	SetupTypeCellRenderer * self = NULL;
	self = (SetupTypeCellRenderer*) g_object_new (object_type, NULL);
	return self;
}


static SetupTypeCellRenderer* setup_typecell_renderer_new (void) {
	return setup_typecell_renderer_construct (SETUP_TYPE_TYPECELL_RENDERER);
}


static PList* setup_typecell_renderer_get_plist (SetupTypeCellRenderer* self) {
	PList* result;
	PList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_plist;
	result = _tmp0_;
	return result;
}


static void setup_typecell_renderer_set_plist (SetupTypeCellRenderer* self, PList* value) {
	PList* _tmp0_;
	PList* _tmp1_;
	PList* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* type;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_plist);
	self->priv->_plist = _tmp1_;
	_tmp2_ = self->priv->_plist;
	_tmp3_ = plist_get (_tmp2_, "type");
	type = _tmp3_;
	_tmp4_ = type;
	if (g_strcmp0 (_tmp4_, "file") == 0) {
		PList* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* mode;
		const gchar* _tmp12_;
		_tmp5_ = self->priv->_plist;
		_tmp6_ = plist_get (_tmp5_, "mode");
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		if (_tmp8_ == NULL) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("readonly");
			_g_free0 (_tmp7_);
			_tmp7_ = _tmp9_;
		}
		_tmp10_ = _tmp7_;
		_tmp11_ = g_strdup (_tmp10_);
		mode = _tmp11_;
		_tmp12_ = mode;
		if (g_strcmp0 (_tmp12_, "readonly") == 0) {
			const gchar* _tmp13_ = NULL;
			_tmp13_ = _ ("system");
			g_object_set ((GtkCellRendererText*) self, "text", _tmp13_, NULL);
		} else {
			const gchar* _tmp14_ = NULL;
			_tmp14_ = _ ("user");
			g_object_set ((GtkCellRendererText*) self, "text", _tmp14_, NULL);
		}
		_g_free0 (mode);
		_g_free0 (_tmp7_);
	} else {
		const gchar* _tmp15_ = NULL;
		_tmp15_ = _ ("server");
		g_object_set ((GtkCellRendererText*) self, "text", _tmp15_, NULL);
	}
	_g_free0 (type);
	g_object_notify ((GObject *) self, "plist");
}


static void setup_typecell_renderer_class_init (SetupTypeCellRendererClass * klass) {
	setup_typecell_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SetupTypeCellRendererPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_setup_typecell_renderer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_setup_typecell_renderer_set_property;
	G_OBJECT_CLASS (klass)->finalize = setup_typecell_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETUP_TYPECELL_RENDERER_PLIST, g_param_spec_object ("plist", "plist", "plist", TYPE_PLIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void setup_typecell_renderer_instance_init (SetupTypeCellRenderer * self) {
	self->priv = SETUP_TYPECELL_RENDERER_GET_PRIVATE (self);
}


static void setup_typecell_renderer_finalize (GObject* obj) {
	SetupTypeCellRenderer * self;
	self = SETUP_TYPECELL_RENDERER (obj);
	_g_object_unref0 (self->priv->_plist);
	G_OBJECT_CLASS (setup_typecell_renderer_parent_class)->finalize (obj);
}


static GType setup_typecell_renderer_get_type (void) {
	static volatile gsize setup_typecell_renderer_type_id__volatile = 0;
	if (g_once_init_enter (&setup_typecell_renderer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SetupTypeCellRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) setup_typecell_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SetupTypeCellRenderer), 0, (GInstanceInitFunc) setup_typecell_renderer_instance_init, NULL };
		GType setup_typecell_renderer_type_id;
		setup_typecell_renderer_type_id = g_type_register_static (GTK_TYPE_CELL_RENDERER_TEXT, "SetupTypeCellRenderer", &g_define_type_info, 0);
		g_once_init_leave (&setup_typecell_renderer_type_id__volatile, setup_typecell_renderer_type_id);
	}
	return setup_typecell_renderer_type_id__volatile;
}


static void _vala_setup_typecell_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SetupTypeCellRenderer * self;
	self = SETUP_TYPECELL_RENDERER (object);
	switch (property_id) {
		case SETUP_TYPECELL_RENDERER_PLIST:
		g_value_set_object (value, setup_typecell_renderer_get_plist (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_setup_typecell_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SetupTypeCellRenderer * self;
	self = SETUP_TYPECELL_RENDERER (object);
	switch (property_id) {
		case SETUP_TYPECELL_RENDERER_PLIST:
		setup_typecell_renderer_set_plist (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static SetupDescCellRenderer* setup_desc_cell_renderer_construct (GType object_type) {
	SetupDescCellRenderer * self = NULL;
	self = (SetupDescCellRenderer*) g_object_new (object_type, NULL);
	return self;
}


static SetupDescCellRenderer* setup_desc_cell_renderer_new (void) {
	return setup_desc_cell_renderer_construct (SETUP_TYPE_DESC_CELL_RENDERER);
}


static PList* setup_desc_cell_renderer_get_plist (SetupDescCellRenderer* self) {
	PList* result;
	PList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_plist;
	result = _tmp0_;
	return result;
}


static void setup_desc_cell_renderer_set_plist (SetupDescCellRenderer* self, PList* value) {
	PList* _tmp0_;
	PList* _tmp1_;
	PList* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* type;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_plist);
	self->priv->_plist = _tmp1_;
	_tmp2_ = self->priv->_plist;
	_tmp3_ = plist_get (_tmp2_, "type");
	type = _tmp3_;
	_tmp4_ = type;
	if (g_strcmp0 (_tmp4_, "file") == 0) {
		PList* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp5_ = self->priv->_plist;
		_tmp6_ = plist_get (_tmp5_, "file");
		_tmp7_ = _tmp6_;
		g_object_set ((GtkCellRendererText*) self, "text", _tmp7_, NULL);
		_g_free0 (_tmp7_);
	} else {
		PList* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* host;
		PList* _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* port;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		_tmp8_ = self->priv->_plist;
		_tmp9_ = plist_get (_tmp8_, "host");
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_;
		if (_tmp11_ == NULL) {
			gchar* _tmp12_;
			_tmp12_ = g_strdup ("localhost");
			_g_free0 (_tmp10_);
			_tmp10_ = _tmp12_;
		}
		_tmp13_ = _tmp10_;
		_tmp14_ = g_strdup (_tmp13_);
		host = _tmp14_;
		_tmp15_ = self->priv->_plist;
		_tmp16_ = plist_get (_tmp15_, "port");
		_tmp17_ = _tmp16_;
		_tmp18_ = _tmp17_;
		if (_tmp18_ == NULL) {
			gchar* _tmp19_;
			_tmp19_ = g_strdup ("1178");
			_g_free0 (_tmp17_);
			_tmp17_ = _tmp19_;
		}
		_tmp20_ = _tmp17_;
		_tmp21_ = g_strdup (_tmp20_);
		port = _tmp21_;
		_tmp22_ = host;
		_tmp23_ = port;
		_tmp24_ = g_strdup_printf ("%s:%s", _tmp22_, _tmp23_);
		_tmp25_ = _tmp24_;
		g_object_set ((GtkCellRendererText*) self, "text", _tmp25_, NULL);
		_g_free0 (_tmp25_);
		_g_free0 (port);
		_g_free0 (_tmp17_);
		_g_free0 (host);
		_g_free0 (_tmp10_);
	}
	_g_free0 (type);
	g_object_notify ((GObject *) self, "plist");
}


static void setup_desc_cell_renderer_class_init (SetupDescCellRendererClass * klass) {
	setup_desc_cell_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SetupDescCellRendererPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_setup_desc_cell_renderer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_setup_desc_cell_renderer_set_property;
	G_OBJECT_CLASS (klass)->finalize = setup_desc_cell_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETUP_DESC_CELL_RENDERER_PLIST, g_param_spec_object ("plist", "plist", "plist", TYPE_PLIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void setup_desc_cell_renderer_instance_init (SetupDescCellRenderer * self) {
	self->priv = SETUP_DESC_CELL_RENDERER_GET_PRIVATE (self);
}


static void setup_desc_cell_renderer_finalize (GObject* obj) {
	SetupDescCellRenderer * self;
	self = SETUP_DESC_CELL_RENDERER (obj);
	_g_object_unref0 (self->priv->_plist);
	G_OBJECT_CLASS (setup_desc_cell_renderer_parent_class)->finalize (obj);
}


static GType setup_desc_cell_renderer_get_type (void) {
	static volatile gsize setup_desc_cell_renderer_type_id__volatile = 0;
	if (g_once_init_enter (&setup_desc_cell_renderer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SetupDescCellRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) setup_desc_cell_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SetupDescCellRenderer), 0, (GInstanceInitFunc) setup_desc_cell_renderer_instance_init, NULL };
		GType setup_desc_cell_renderer_type_id;
		setup_desc_cell_renderer_type_id = g_type_register_static (GTK_TYPE_CELL_RENDERER_TEXT, "SetupDescCellRenderer", &g_define_type_info, 0);
		g_once_init_leave (&setup_desc_cell_renderer_type_id__volatile, setup_desc_cell_renderer_type_id);
	}
	return setup_desc_cell_renderer_type_id__volatile;
}


static void _vala_setup_desc_cell_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SetupDescCellRenderer * self;
	self = SETUP_DESC_CELL_RENDERER (object);
	switch (property_id) {
		case SETUP_DESC_CELL_RENDERER_PLIST:
		g_value_set_object (value, setup_desc_cell_renderer_get_plist (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_setup_desc_cell_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SetupDescCellRenderer * self;
	self = SETUP_DESC_CELL_RENDERER (object);
	switch (property_id) {
		case SETUP_DESC_CELL_RENDERER_PLIST:
		setup_desc_cell_renderer_set_plist (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void setup_class_init (SetupClass * klass) {
	setup_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SetupPrivate));
	G_OBJECT_CLASS (klass)->finalize = setup_finalize;
}


static void setup_instance_init (Setup * self) {
	self->priv = SETUP_GET_PRIVATE (self);
}


static void setup_finalize (GObject* obj) {
	Setup * self;
	self = SETUP (obj);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->dictionaries_treeview);
	_g_object_unref0 (self->priv->auto_start_henkan_keywords_entry);
	_g_object_unref0 (self->priv->period_style_combobox);
	_g_object_unref0 (self->priv->page_size_spinbutton);
	_g_object_unref0 (self->priv->pagination_start_spinbutton);
	_g_object_unref0 (self->priv->show_annotation_checkbutton);
	_g_object_unref0 (self->priv->initial_input_mode_combobox);
	_g_object_unref0 (self->priv->egg_like_newline_checkbutton);
	_g_object_unref0 (self->priv->typing_rule_combobox);
	_g_object_unref0 (self->priv->dict_dialog);
	_g_object_unref0 (self->priv->dict_type_comboboxtext);
	_g_object_unref0 (self->priv->dict_data_hbox);
	_g_object_unref0 (self->priv->dict_data_widget);
	_g_object_unref0 (self->priv->dict_filechooserbutton);
	_g_object_unref0 (self->priv->dict_entry);
	_g_object_unref0 (self->priv->dict_spinbutton);
	_g_object_unref0 (self->priv->preferences);
	G_OBJECT_CLASS (setup_parent_class)->finalize (obj);
}


GType setup_get_type (void) {
	static volatile gsize setup_type_id__volatile = 0;
	if (g_once_init_enter (&setup_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SetupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) setup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Setup), 0, (GInstanceInitFunc) setup_instance_init, NULL };
		GType setup_type_id;
		setup_type_id = g_type_register_static (G_TYPE_OBJECT, "Setup", &g_define_type_info, 0);
		g_once_init_leave (&setup_type_id__volatile, setup_type_id);
	}
	return setup_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



