/* help.c for kan netmaj */
#include "xnet.h"
#include "help_str.h"
#include "strdef.h"

extern int fonth[3], jfonth[2];

int page;

void
draw_help(num)
     int num;
{
    char **text;
    int h, i = 0;

    if (!num) return;

    if ((num > 3) || (num < 1))
      return;

    h = (nmax(fonth[SLFNT], jfonth[SLFNT]))+4;

    switch (num)
      {
	case 1: text = help_rule;
	  break;
	case 2: text = help_yaku;
	  break;
	case 3: text = help_others;
	  break;
      }

    win_cleararea(help_win, 4, 4, win_width(help_win)-8, 
		  win_height(help_win)-8-region_height(help_but));
    while (text[i] != NULL) {
	draw_cotext(help_win, 9, 9+h/2+i*h, cols.mess, SLFNT, text[i]);
	i++;
    }
    page = num;
  
    win_flush();
}


void
open_help()
{
    if (page)
      raise_win(help_win);
    else {
	win_map_normal(help_win);
	draw_help(1);
    }
}

void
map_help()
{
    int w = win_width(help_win), h = win_height(help_win);

    if (!page) return;

    set_reg_position(help_but, w-4-region_width(help_but), 
		     h-4-region_height(help_but));
    win_cleararea(help_win, 0, 0, w, h);
    ThreeDframe2(help_win, 0, 0, w, h, 2);

    draw_button(help_but);

    draw_help(page);
}

void
unmap_help()
{
    set_reg_responsive(help_but, 0);
    win_unmap_normal(help_win);
    page = 0;
}

void
help_call(num, sel)
     int num, sel;
{
    switch (sel+1)
      {
	case 1:
	  draw_help(page-1);
	  break;
	case 2:
	  draw_help(page+1);
	  break;
	case 3:
	  unmap_help();
	  break;
      }
}

void
help_init()
{
    int i, j, k, w, h;
    char **tp, *sp[3];
    char *help_name = "KAN NetMaj Help";

    i = w = 0;
    tp = help_rule;
    while (tp[i] != NULL) {
	k = textwidth(tp[i], SLFNT);
	if (k > w) w = k;
	i++;
    }
    j = 0;
    tp = help_yaku;
    while (tp[j] != NULL) {
	k = textwidth(tp[j], SLFNT);
	if (k > w) w = k;
	j++;
    }
    if (j > i) i = j;
    j = 0;
    tp = help_others;
    while (tp[j] != NULL)  {
	k = textwidth(tp[j], SLFNT);
	if (k > w) w = k;
	j++;
    }
    if (j > i) i = j;

    page = 0;

    help_win = make_window(-1, help_name,
			   ( ExposureMask | ButtonPressMask | ButtonReleaseMask ), 0);
    set_expose_func(help_win, (void *)map_help);

    /* buttons in help */
    for (j = 0; j < 3; j++)
      sp[j] = but6_label[j];
    help_but = make_button(help_win, HORIZ, 3, sp, SLFNT, (void *)help_call);

    w += 8+10;
    h = 8+region_height(help_but)+i*((nmax(fonth[SLFNT], jfonth[SLFNT]))+4)+10; 
    resize_win(help_win, w, h);
}
