// -*- c++ -*-
/***************************************************************************
                           channelscanner.h
                           ----------------
    begin                : Sat Oct 25 2003
    copyright            : (C) 2003 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef CHANNELSCANNER_H
#define CHANNELSCANNER_H

#include <qstring.h>

#include "chwizard.h"

class Kdetv;
class Channel;
class SourceManager;
class ScannerFrequencyFactory;
class ChannelStore;
class ChannelImporter;
class QVVbiPlugin;
class QTimer;
class VbiManager;
class FineTuningDlg;

class ChannelScanner : public ChWizard
{
    Q_OBJECT


public:
    ChannelScanner( Kdetv*, QWidget* parent=0, const char* name=0, bool modal = FALSE, WFlags fl = 0 );
    virtual ~ChannelScanner();


    signals:
    void progress(int);
    void progress(const QString&);


private slots:
    void pageChanged();
    void updatePageSelection();
    void checkSignalStrengthReadback();
    void updateSource();
    void updateEncoding();
    void setChannel();
    void preselectRangeChanged();

    void setNetworkId(const QString& name);

    void checkFrequency();
    void checkName();
    void setFrequency(int);

    void fineTuneOK();
    void fineTuneCancel();

private:
    enum {
        Setup=0, Properties, prepareFreqRange, preparePredefined, Scanning, Finished
    } wizardPages;

    void setupFinishedPage();
    virtual void accept();
    virtual void reject();

    void scan();
    void scanFrequency();
    bool fineTune();
    void stationFound(bool enable);
    void scanningDone(bool success);
    void fineTuningDone();

    ScannerFrequencyFactory* _freqFactory;
    ChannelStore*            _store;

    QString  _name;
    Q_ULLONG _freq;

    QTimer* _nameTimer;
    QTimer* _stationTimer;

    QString _networkName;

    ChannelImporter* _channelImporter;
    Kdetv*           _ktv;
    SourceManager*   _srcm;

    VbiManager* _vbimgr;

    FineTuningDlg* ftd;

    QString _prevDev;
};

#endif // CHANNELSCANNER_H
