// -*- c++ -*-
/***************************************************************************
                           controlwidgetimpl.h
                           -------------------
    begin                : Sun Nov 21 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __CONTROLWIDGETIMPL_H__
#define __CONTROLWIDGETIMPL_H__

#include "controlinterface.h"
#include "controlwidget.h"

class Channel;

class ControlWidgetImpl : public ControlWidget
{
    Q_OBJECT
    
public: 
    ControlWidgetImpl(const Control::ControlList& controls, Channel* channel, const QString& dev,
                      QWidget* parent, const char* name=0, WFlags f=0);
    virtual ~ControlWidgetImpl();

public slots:
    void defaults();
    void apply();
    void cancel();

private:
    const Control::ControlList& _controlList;
    QMap<QString, QVariant> _previousValues;
    Channel* _channel;
    QString _dev;
};

#endif
