/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details. 
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <qapp.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qlineedit.h> 
#include <qtextedit.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qprocess.h>

#include "kfiledialog.h"
#include "klocale.h"

#include "KYumPreferences.h" 
#include "UserEvents.h"
#include "DlgGenerateRSS.h"


DlgGenerateRSS::E_Which DlgGenerateRSS::m_which       = DlgGenerateRSS::c_Recent;
QString                 DlgGenerateRSS::m_strFileName = "/etc/yum-rss.xml";


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/ 

DlgGenerateRSS::DlgGenerateRSS(QWidget * pParent)
  
  : BaseDlgGenerateRSS(pParent, "DlgGenerateRSS"),
    m_bThreadDone(true),
    m_pProcess(0)
    
{
    switch(m_which)
    {
      case c_Updates:
              m_pRadioUpdates->setChecked(true);
              break;

      case c_Recent:
              m_pRadioRecent->setChecked(true);
              break;
    }

    m_pEdFileName->setText(m_strFileName);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/ 

void DlgGenerateRSS::slotSelectFile()
{
    static QString  strDir;
    QString         strFilter("*.xml|XML Files (*.xml)\n*|All Files (*)"),
                    strSelection;

    strSelection = KFileDialog::getSaveFileName(strDir, 
                                                strFilter,
                                                this,
                                                i18n("Choose an RSS filename to write results to"));
    
    if ( !strSelection.isEmpty() )
    {
        m_strFileName = strSelection;
        strDir        = QFileInfo(m_strFileName).filePath();

        m_pEdFileName->setText(m_strFileName);
    }
}


/***************************************************************************/
/**
 *  
 *
 ***************************************************************************/ 

void DlgGenerateRSS::slotProcessStarted()
{
    m_pEdOutput->setColor(KYumPreferences::c_clrInfo);

    QString strMsg;

    strMsg.sprintf(i18n("Process %d has been started.\n"), 
                   m_pProcess->processIdentifier());

    m_pEdOutput->append(strMsg);
}


/***************************************************************************/
/**
 *  
 *
 ***************************************************************************/ 

void DlgGenerateRSS::slotProcessExited()
{
    QString strMsg;

    if ( m_pProcess->normalExit() )
    {
        m_pEdOutput->setColor(KYumPreferences::c_clrInfo);

        strMsg.sprintf(i18n("Process %d exited normally with code %d"),
                       m_pProcess->processIdentifier(),
                       m_pProcess->exitStatus());
    }
    else
    {
        m_pEdOutput->setColor(KYumPreferences::c_clrError);

        strMsg.sprintf(i18n("Process %d exited abnormally with code %d"),
                       m_pProcess->processIdentifier(),
                       m_pProcess->exitStatus());
    }

    m_pEdOutput->append(strMsg);

    if ( m_bExitRequested )
        reject();
}


/***************************************************************************/
/**
 *  
 *
 ***************************************************************************/ 

void DlgGenerateRSS::slotReadyStdout()
{
    m_pEdOutput->setColor(KYumPreferences::c_clrInfo);

#if 1
    m_pEdOutput->append(m_pProcess->readStdout());
#else
    while ( m_pProcess->canReadLineStdout() )
        m_pEdOutput->append(m_pProcess->readLineStdout());
#endif
}


/***************************************************************************/
/**
 *  
 *
 ***************************************************************************/ 

void DlgGenerateRSS::slotReadyStderr()
{
    m_pEdOutput->setColor(KYumPreferences::c_clrError);

#if 1
    m_pEdOutput->append(m_pProcess->readStderr());
#else
    while ( m_pProcess->canReadLineStderr() )
        m_pEdOutput->append(m_pProcess->readLineStderr());
#endif
}


/***************************************************************************/
/**
 *  
 *
 ***************************************************************************/ 

void DlgGenerateRSS::accept()
{
    m_bThreadDone     = false;
    m_bExitRequested  = false;

    m_pButtonOk->setEnabled(false);
    m_pButtonCancel->setText(i18n("&Cancel"));
    m_pEdOutput->setText("");

    m_pProcess = new QProcess(this);

    m_pProcess->addArgument("yum");

    if ( !m_strFileName.isEmpty() )
        m_pProcess->addArgument(QString("--rss-filename=") + m_strFileName);

    m_pProcess->addArgument("generate-rss");

    if ( m_pRadioUpdates->isChecked() )
    {
        m_which = c_Updates;
        m_pProcess->addArgument("updates");
    }
    else if ( m_pRadioRecent->isChecked() )
    {
        m_which = c_Recent;
        m_pProcess->addArgument("recent");
    }


//    connect(m_pProcess, SIGNAL(launchFinished()),  this, SLOT(slotProcessStarted()));
    connect(m_pProcess, SIGNAL(processExited()),   this, SLOT(slotProcessExited()));
    connect(m_pProcess, SIGNAL(readyReadStdout()), this, SLOT(slotReadyStdout()));
    connect(m_pProcess, SIGNAL(readyReadStderr()), this, SLOT(slotReadyStderr()));

    m_pButtonCancel->setText(i18n("&Abort"));
    start();
}


/***************************************************************************/
/**
 *  
 *
 ***************************************************************************/ 

void DlgGenerateRSS::reject()
{
    QMutexLocker locker(&m_mutex);

    m_bExitRequested = true;

    if ( m_bThreadDone )
        BaseDlgGenerateRSS::reject();
}


/***************************************************************************/
/**
 *  
 *
 ***************************************************************************/ 

bool DlgGenerateRSS::event(QEvent * pEvent)
{
    bool bProcessed = false;

    if ( pEvent->type() == QEvent::Type(c_evt_ProcessStarted) )
    {
        QMutexLocker          locker(&m_mutex);
//        ProcessStartedEvent * pEvt = dynamic_cast<ProcessStartedEvent *>(pEvent);

        slotProcessStarted();
    }
    else
        bProcessed = BaseDlgGenerateRSS::event(pEvent);

    return bProcessed;
}


/***************************************************************************/
/**
 *  
 *
 ***************************************************************************/ 

void DlgGenerateRSS::run()
{
    if ( m_pProcess->start() )
    {
        //
        // The signal launchFinished() is not emitted automatically, since we did 
        // not use launch() to start the program. We use a thread-safe way to
        // inform the main thread by putting an event in its queue.
        //
        QApplication::postEvent(this, new ProcessStartedEvent(
                                               m_pProcess->processIdentifier()));

        do
        {
            msleep(500);

            if ( m_bExitRequested )
                m_pProcess->tryTerminate();
        }
        while ( m_pProcess->isRunning() );
    }

    QMutexLocker locker(&m_mutex);

    delete m_pProcess;
    m_pProcess = 0;

    m_bThreadDone = true;
    m_pButtonOk->setEnabled(true);
    m_pButtonCancel->setText(i18n("&Exit"));
}


#include "DlgGenerateRSS.moc"
