/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <qapp.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qtextedit.h>
#include <qcolor.h>

#include <klocale.h>

#include "System.h"
#include "KYumPreferences.h"
#include "UserEvents.h"
#include "DlgImportGPG.h"


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

DlgImportGPG::DlgImportGPG(QWidget * pParent, QString strKey)

  : BaseDlgImportGPG(pParent, "DlgImportGPG"),
    m_bThreadDone(true),
    m_bExitRequested(false),
    m_pProcess(0)

{
    m_pEdKey->setText(m_strKey = strKey);
    slotKeyChanged(m_strKey);

    m_pEdKey->setFocus();

    connect(m_pEdKey, SIGNAL(textChanged(const QString &)),
            this,     SLOT(slotKeyChanged(const QString &)));
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void DlgImportGPG::slotKeyChanged(const QString & strKey)
{
    m_pButtonOk->setEnabled(!strKey.isEmpty());
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void DlgImportGPG::slotProcessStarted()
{
    m_pEdOutput->setColor(KYumPreferences::c_clrInfo);

    QString strMsg;

    strMsg.sprintf(i18n("Process %d has been started.\n"),
                   m_pProcess->processIdentifier());

    m_pEdOutput->append(strMsg);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void DlgImportGPG::slotProcessExited()
{
    QString strMsg;

    if ( m_pProcess->normalExit() )
    {
        m_pEdOutput->setColor(KYumPreferences::c_clrInfo);

        strMsg.sprintf(i18n("Process %d exited normally with code %d"),
                       m_pProcess->processIdentifier(),
                       m_pProcess->exitStatus());
    }
    else
    {
        m_pEdOutput->setColor(KYumPreferences::c_clrError);

        strMsg.sprintf(i18n("Process %d exited abnormally with code %d"),
                       m_pProcess->processIdentifier(),
                       m_pProcess->exitStatus());
    }

    m_pEdOutput->append(strMsg);

    if ( m_bExitRequested )
        reject();
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void DlgImportGPG::slotReadyStdout()
{
    m_pEdOutput->setColor(KYumPreferences::c_clrInfo);

#if 1
    m_pEdOutput->append(m_pProcess->readStdout());
#else
    while ( m_pProcess->canReadLineStdout() )
        m_pEdOutput->append(m_pProcess->readLineStdout());
#endif
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void DlgImportGPG::slotReadyStderr()
{
    m_pEdOutput->setColor(KYumPreferences::c_clrError);

#if 1
    m_pEdOutput->append(m_pProcess->readStderr());
#else
    while ( m_pProcess->canReadLineStderr() )
        m_pEdOutput->append(m_pProcess->readLineStderr());
#endif
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void DlgImportGPG::accept()
{
    m_strKey = m_pEdKey->text();

    m_bThreadDone     = false;
    m_bExitRequested  = false;

    m_pButtonOk->setEnabled(false);
    m_pButtonCancel->setText(i18n("&Cancel"));
    m_pEdOutput->setText("");

    m_pProcess = new QProcess(this);

    m_pProcess->addArgument("rpm");
    m_pProcess->addArgument("--import");
    m_pProcess->addArgument(m_strKey);

//    connect(m_pProcess, SIGNAL(launchFinished()),  this, SLOT(slotProcessStarted()));
    connect(m_pProcess, SIGNAL(processExited()),   this, SLOT(slotProcessExited()));
    connect(m_pProcess, SIGNAL(readyReadStdout()), this, SLOT(slotReadyStdout()));
    connect(m_pProcess, SIGNAL(readyReadStderr()), this, SLOT(slotReadyStderr()));

    start();
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void DlgImportGPG::reject()
{
    QMutexLocker locker(&m_mutex);

    m_bExitRequested = true;

    if ( m_bThreadDone )
        BaseDlgImportGPG::reject();
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

bool DlgImportGPG::event(QEvent * pEvent)
{
    bool bProcessed = false;

    if ( pEvent->type() == QEvent::Type(c_evt_ProcessStarted) )
    {
        QMutexLocker          locker(&m_mutex);
//        ProcessStartedEvent * pEvt = dynamic_cast<ProcessStartedEvent *>(pEvent);

        slotProcessStarted();
    }
    else
        bProcessed = BaseDlgImportGPG::event(pEvent);

    return bProcessed;
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void DlgImportGPG::run()
{
    if ( m_pProcess->start() )
    {
        //
        // The signal launchFinished() is not emitted automatically, since we did
        // not use launch() to start the program. We use a thread-safe way to
        // inform the main thread by putting an event in its queue.
        //
        QApplication::postEvent(this, new ProcessStartedEvent(
                                               m_pProcess->processIdentifier()));

        do
        {
            msleep(500);

            if ( m_bExitRequested )
                m_pProcess->tryTerminate();
        }
        while ( m_pProcess->isRunning() );
    }

    QMutexLocker locker(&m_mutex);

    delete m_pProcess;
    m_pProcess = 0;

    m_bThreadDone = true;
    m_pButtonOk->setEnabled(true);
    m_pButtonCancel->setText(i18n("&Exit"));
}

#include "DlgImportGPG.moc"
