/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <qpushbutton.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qmutex.h>

#include <ktextedit.h>
#include <klocale.h>

#include "Process.h"
#include "KYumPreferences.h"
#include "DlgRemovePkgs.h"


/****************************************************************************/
/*
 *
 *
 ****************************************************************************/

DlgRemovePkgs::DlgRemovePkgs(const QStringList  & pkgList,
                             QWidget            * pParent,
                             const char         * pName)

  : ProcessDlg(pParent, pName)

{
    QWidget     * pMainView   = new QWidget(this);
    QVBoxLayout * pTopLayout  = new QVBoxLayout(this, 5, 5),
                * pMainLayout = new QVBoxLayout(pMainView, 5);

    m_pOutputView = new KTextEdit(pMainView, "m_pOutputView");
    m_pOutputView->setReadOnly(true);

    QString strMsg;

    strMsg.sprintf(i18n("<b><p>You have chosen to erase %d installed package(s)."
                        "The following is a list of installed packages that, "
                        "according to rpm, rely on these packages and will "
                        "therefore be uninstalled, too.</p>"
                        ""
                        "<p>Please confirm that you <i>really</i> want to delete these "
                        "packages.</p></b>"),
                        pkgList.size());

    KTextEdit * pMsgView = new KTextEdit(pMainView, "pMsgView");
    pMsgView->setReadOnly(true);

    pMsgView->setText(strMsg);

    pMainLayout->addWidget(pMsgView);
    pMainLayout->addWidget(m_pOutputView, 1);

    pTopLayout->addWidget(pMainView, 1);

    QWidget     * pButtonPanel  = new QWidget(this);
    QHBoxLayout * pButtonLayout = new QHBoxLayout(pButtonPanel, 6);
    QSpacerItem * pHSpacer      = new QSpacerItem(60,
                                                  60,
                                                  QSizePolicy::Expanding,
                                                  QSizePolicy::Minimum);

    pButtonLayout->addItem(pHSpacer);

    m_pButtonOk = new QPushButton(pButtonPanel, "m_pButtonStart");
    m_pButtonOk->setText(i18n("&Ok"));
    pButtonLayout->addWidget(m_pButtonOk);

    m_pButtonCancel = new QPushButton(pButtonPanel, "m_pButtonCancel");
    m_pButtonCancel->setText(i18n("&Cancel"));
    pButtonLayout->addWidget(m_pButtonCancel);

    pTopLayout->addWidget(pButtonPanel);

    resize(400, 600);

    connect(m_pButtonOk,     SIGNAL(clicked()), this, SLOT(accept()));
    connect(m_pButtonCancel, SIGNAL(clicked()), this, SLOT(reject()));

    QStringList                   args;
    QStringList::const_iterator   it;

    args.push_back("rpm");
    args.push_back("-q");
    args.push_back("--whatrequires");

    for ( it = pkgList.begin(); it != pkgList.end(); it++ )
        args.push_back(*it);

    setArgs(args);
}


/****************************************************************************/
/*
 *
 *
 ****************************************************************************/

DlgRemovePkgs::~DlgRemovePkgs()
{
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void DlgRemovePkgs::slotProcessStarted()
{
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void DlgRemovePkgs::slotProcessExited()
{
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void DlgRemovePkgs::slotReadyStdout()
{
    QMutexLocker  locker(m_pMutex);

    m_pOutputView->setColor(KYumPreferences::c_clrInfo);
    m_pOutputView->append(m_pProcess->readStdout());
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void DlgRemovePkgs::slotReadyStderr()
{
    QMutexLocker  locker(m_pMutex);

    m_pOutputView->setColor(KYumPreferences::c_clrError);
    m_pOutputView->append(m_pProcess->readStderr());
}


#include "DlgRemovePkgs.moc"
