/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef _KYumPreferences_H_
#define _KYumPreferences_H_

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif


#include <qcolor.h>

#include <kdialogbase.h>


class KConfig;

//
//
//
class KYumPreferences
  {
    private:
      enum E_Option
        {
          c_opt_RemoveFromListAfterInstall,
          c_opt_MonitorYumConf,
          c_opt_ConfirmSave,
          c_opt_AssumeYesOnRemove
        };

    private:
      static QString    m_strYumConfPath,
                        m_strLogFile;
      static unsigned   m_optionFlags,
                        m_disabledMsgs;


    public:
      static QColor     c_clrInfo,
                        c_clrError,
                        c_clrPkgInfo,
                        c_clrAddInfo,
                        c_clrDirty;


    private:
      static unsigned   o2f(E_Option option)            { return 0x01U << unsigned(option); }
      static unsigned   defaultOptions();


    public:
      static QString    getYumConfPath()                { return m_strYumConfPath; }
      static void       setYumConfPath(QString strPath) { m_strYumConfPath = strPath; }

      static QString    getLogFile()                    { return m_strLogFile; }
      static void       setLogFile(QString strFile)     { m_strLogFile = strFile; }

      static bool       getRemoveFromListAfterInstall() { return getOption(c_opt_RemoveFromListAfterInstall); }
      static bool       getMonitorYumConf()             { return getOption(c_opt_MonitorYumConf); }
      static bool       getConfirmSave()                { return getOption(c_opt_ConfirmSave); }
      static bool       getAssumeYesOnRemove()          { return getOption(c_opt_AssumeYesOnRemove); }

      static void       setRemoveFromListAfterInstall(bool bSet)
                        {
                            setOption(c_opt_RemoveFromListAfterInstall, bSet);
                        }

      static void       setMonitorYumConf(bool bSet)
                        {
                            setOption(c_opt_MonitorYumConf, bSet);
                        }

      static void       setConfirmSave(bool bSet)
                        {
                            setOption(c_opt_ConfirmSave, bSet);
                        }

      static void       setAssumeYesOnRemove(bool bSet)
                        {
                            setOption(c_opt_AssumeYesOnRemove, bSet);
                        }

      static bool       getOption(E_Option option)      { return !!(m_optionFlags & o2f(option)); }
      static void       setOption(E_Option option, bool bSet);

      static void       writeConfig (KConfig * pConfig);
      static void       readConfig  (KConfig * pConfig);

      static unsigned   isMsgEnabled(int msgNo)
                        {
                            return !(m_disabledMsgs & (0x01 << msgNo));
                        }

      static void       enableMsg(int msgNo, bool bEnable)
                        {
                            if ( bEnable )
                                m_disabledMsgs &= ~o2f(E_Option(msgNo));
                            else
                                m_disabledMsgs |=  o2f(E_Option(msgNo));
                        }
  };


inline void KYumPreferences::setOption(E_Option option, bool bSet)
{
    if ( bSet )
        m_optionFlags |= o2f(option);
    else
        m_optionFlags &= ~o2f(option);
}


inline unsigned KYumPreferences::defaultOptions()
{
    return o2f(c_opt_RemoveFromListAfterInstall) |
           o2f(c_opt_MonitorYumConf) |
           o2f(c_opt_ConfirmSave);
}


class KColorCombo;

//
//
//
class PrefPageAppearance : public QFrame
  {
    Q_OBJECT

    private:
      KColorCombo   * m_pComboClrInfo,
                    * m_pComboClrError,
                    * m_pComboClrAddInfo;


    public:
                      PrefPageAppearance(QWidget * pParent);

      void            apply();
  };


//
//
//
class QCheckBox;

class PrefPageBehavior : public QFrame
  {
    Q_OBJECT

    private:
      QCheckBox     * m_pCheckRemoveAfterInstall,
                    * m_pCheckAssumeYesOnRemove,
                    * m_pCheckMonitorYumConf,
                    * m_pCheckConfirmSave;

    public:
                      PrefPageBehavior(QWidget * pParent);

      void            apply();
  };


//
//
//
//
class KYumPreferencesDlg : public KDialogBase
  {
    Q_OBJECT

    public:
                            KYumPreferencesDlg();
      virtual             ~ KYumPreferencesDlg();

    private:
      PrefPageAppearance  * m_pPageAppearance;
      PrefPageBehavior    * m_pPageBehavior;


    protected slots:
      void                  slotApply ();
      void                  slotOk    ();
  };


#endif
