/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <qregexp.h>

#include "StrTok.h"


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

StrTok::StrTok(QString str)

  : m_str(str),
    m_pos(0)

{
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

bool StrTok::nextToken(const QRegExp & sep, QString & strToken)
{
    bool bSuccess = false;

    if ( !atEnd() )
    {
        int posEnd = m_str.find(sep, m_pos),
            posNext;

        if ( posEnd < 0 )
        {
            posEnd  = (int) m_str.length();
            posNext = posEnd;
        }
        else
            posNext = posEnd + 1;


        strToken = m_str.mid(m_pos, posEnd - m_pos);
        m_pos    = posNext;
        bSuccess = true;
    }

    return bSuccess;
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

bool StrTok::nextToken(const char sep, QString & strToken)
{
    bool bSuccess = false;

    if ( !atEnd() )
    {
        int posEnd = m_str.find(sep, m_pos),
            posNext;

        if ( posEnd < 0 )
        {
            posEnd  = (int) m_str.length();
            posNext = posEnd;
        }
        else
            posNext = posEnd + 1;

        strToken = m_str.mid(m_pos, posEnd - m_pos);
        m_pos    = posNext;
        bSuccess = true;
    }

    return bSuccess;
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void StrTok::skipWhitespace()
{
    while ( !atEnd() )
    {
        QChar ch = m_str[m_pos];

        if ( ch == '\r' )
        {
            m_pos++;

            if ( atEnd() )
                break;

            ch = m_str[m_pos];
        }

        if ( ch != ' ' && ch != '\t' && ch != '\n' )
            break;

        m_pos++;
    }
}
