/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef ThreadDlg_H_Included
#define ThreadDlg_H_Included

#include <qdialog.h>
#include <qthread.h>

class QWaitCondition;

class ThreadDlg : public QDialog, public QThread
  {
    Q_OBJECT

    private:
      bool              m_bExitRequested;
      QWaitCondition  * m_pWaitCond;

    protected:
      bool          mayContinue ();
      virtual void  threadMain  () {}

    public:
                    ThreadDlg   (QWidget * pParent = 0, const char * pName = 0);
      virtual     ~ ThreadDlg   ();

      void          run         ();
      void          abortThread () { m_bExitRequested = true; }

    protected slots:
      virtual void  done        (int result);
  };

#endif
