/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef _KYUM_H_
#define _KYUM_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>

#include "KYumView.h"

class KPrinter;
class KAction;
class KURL;

class Process;

class KYum : public KMainWindow
  {
     Q_OBJECT

    private:
      QString       m_strCurrentProfile;
      KYumView    * m_pView;
      KPrinter    * m_pPrinter;
      KAction     * m_pActionAbort,
                  * m_pActionClean,
                  * m_pActionLocalInstall,
                  * m_pActionLoadProfile,
                  * m_pActionSaveProfile,
                  * m_pActionGenerateRSS;


    private:
      void          setupAccel();
      void          setupActions();


    public:
                    KYum();
      virtual     ~ KYum();

      bool          saveCurrentProfile();

      void          enableAbort(bool bEnable = true);
      void          enableClean(bool bEnable = true);
      void          enableRSS(bool bEnable = true);

    protected:
      /**
      * Overridden virtuals for Qt drag 'n drop (XDND)
      */
      virtual void  dragEnterEvent(QDragEnterEvent *event);
      virtual void  dropEvent(QDropEvent *event);

    protected:
      /**
      * This function is called when it is time for the app to save its
      * properties for session management purposes.
      */
      void      saveProperties(KConfig *);

      /**
      * This function is called when this app is restored.  The KConfig
      * object points to the session management config file that was saved
      * with @ref saveProperties
      */
      void      readProperties(KConfig *);


    private slots:
      void      fileNew();
      void      fileOpen();
      void      fileSave();
      void      fileSaveAs();
      void      filePrint();
      void      fileAddRepository();

      void      optionsPreferences    ();

      void      changeStatusbar       (const QString & text);
      void      changeCaption         (const QString & text);

      void      slotActionStarted     (Process * pProcess);
      void      slotActionTerminated  (Process * pProcess);
      void      slotAbort             ();

      void      slotCleanCache        ();
      void      slotGenerateRSS       ();

      void      slotLocalUpdate       ();
      void      slotLocalInstall      ();

      void      slotLoadProfile       ();
      void      slotSaveProfile       ();
  };

#endif // _KYUM_H_

