/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.apache.poi.hssf.model.Node;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.formula.AbstractFunctionPtg;
import org.apache.poi.hssf.record.formula.AddPtg;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.AttrPtg;
import org.apache.poi.hssf.record.formula.BoolPtg;
import org.apache.poi.hssf.record.formula.ConcatPtg;
import org.apache.poi.hssf.record.formula.DividePtg;
import org.apache.poi.hssf.record.formula.EqualPtg;
import org.apache.poi.hssf.record.formula.FuncVarPtg;
import org.apache.poi.hssf.record.formula.GreaterEqualPtg;
import org.apache.poi.hssf.record.formula.GreaterThanPtg;
import org.apache.poi.hssf.record.formula.IntPtg;
import org.apache.poi.hssf.record.formula.LessEqualPtg;
import org.apache.poi.hssf.record.formula.LessThanPtg;
import org.apache.poi.hssf.record.formula.MissingArgPtg;
import org.apache.poi.hssf.record.formula.MultiplyPtg;
import org.apache.poi.hssf.record.formula.NamePtg;
import org.apache.poi.hssf.record.formula.NotEqualPtg;
import org.apache.poi.hssf.record.formula.NumberPtg;
import org.apache.poi.hssf.record.formula.OperationPtg;
import org.apache.poi.hssf.record.formula.ParenthesisPtg;
import org.apache.poi.hssf.record.formula.PowerPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.record.formula.ReferencePtg;
import org.apache.poi.hssf.record.formula.StringPtg;
import org.apache.poi.hssf.record.formula.SubtractPtg;
import org.apache.poi.hssf.record.formula.UnaryMinusPtg;
import org.apache.poi.hssf.record.formula.UnaryPlusPtg;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FormulaParser {
    public static int FORMULA_TYPE_CELL = 0;
    public static int FORMULA_TYPE_SHARED = 1;
    public static int FORMULA_TYPE_ARRAY = 2;
    public static int FORMULA_TYPE_CONDFOMRAT = 3;
    public static int FORMULA_TYPE_NAMEDRANGE = 4;
    private static char TAB = (char)9;
    private static char CR = (char)10;
    private String formulaString;
    private int pointer;
    private int formulaLength;
    private List tokens;
    private List functionTokens;
    private char look;
    private Workbook book;

    private final void GetChar() {
        if (this.pointer == this.formulaLength) {
            this.look = '\u0000';
            return;
        }
        this.look = this.formulaString.charAt(this.pointer++);
    }

    private final void Error(String s) {
        System.out.println("Error: " + s);
    }

    private final void Abort(String s) {
        this.Error(s);
        throw new RuntimeException("Cannot Parse, sorry : " + s + " @ " + this.pointer + " [Formula String was: '" + this.formulaString + "']");
    }

    private final void Expected(String s) {
        this.Abort(s + " Expected");
    }

    private final boolean IsAlpha(char c) {
        boolean bl = false;
        if (Character.isLetter(c) || c == '$' || c == '_') {
            bl = true;
        }
        return bl;
    }

    private final boolean IsDigit(char c) {
        return Character.isDigit(c);
    }

    private final boolean IsAlNum(char c) {
        boolean bl = false;
        if (this.IsAlpha(c) || this.IsDigit(c)) {
            bl = true;
        }
        return bl;
    }

    private final boolean IsAddop(char c) {
        boolean bl = false;
        if (c == '+' || c == '-') {
            bl = true;
        }
        return bl;
    }

    private final boolean IsWhite(char c) {
        boolean bl = false;
        if (c == ' ' || c == TAB) {
            bl = true;
        }
        return bl;
    }

    private final boolean IsSpecialChar(char c) {
        boolean bl = false;
        if (c == '>' || c == '<' || c == '=' || c == '&' || c == '[' || c == ']') {
            bl = true;
        }
        return bl;
    }

    private final void SkipWhite() {
        while (this.IsWhite(this.look)) {
            this.GetChar();
        }
    }

    private final void Match(char x) {
        if (this.look != x) {
            this.Expected("" + x);
        } else {
            this.GetChar();
            this.SkipWhite();
        }
    }

    /*
     * Unable to fully structure code
     */
    private final String GetName() {
        block4: {
            Token = new StringBuffer();
            if (!this.IsAlpha(this.look) && this.look != '\'') {
                this.Expected("Name");
            }
            if (this.look != '\'') ** GOTO lbl24
            this.Match('\'');
            v0 = false;
            if (this.look == '\'') {
                v0 = true;
            }
            done = v0;
            while (!done) {
                Token.append(Character.toUpperCase(this.look));
                this.GetChar();
                if (this.look != '\'') continue;
                this.Match('\'');
                v1 = false;
                if (this.look == '\'') continue;
                v1 = done = true;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                Token.append(Character.toUpperCase(this.look));
                this.GetChar();
lbl24:
                // 2 sources

                ** while (this.IsAlNum((char)this.look))
            }
        }
        this.SkipWhite();
        return Token.toString();
    }

    private final String GetNameAsIs() {
        StringBuffer Token = new StringBuffer();
        while (this.IsAlNum(this.look) || this.IsWhite(this.look) || this.IsSpecialChar(this.look)) {
            Token = Token.append(this.look);
            this.GetChar();
        }
        return Token.toString();
    }

    private final String GetExponent() {
        StringBuffer retval = new StringBuffer();
        String sign = "";
        this.GetChar();
        if ('-' == this.look) {
            sign = "-";
            this.GetChar();
        }
        while (this.IsDigit(this.look)) {
            retval.append(this.look);
            this.GetChar();
        }
        if (retval.length() > 0) {
            retval.insert(0, sign);
        }
        return retval.toString();
    }

    private final String GetNum() {
        StringBuffer value = new StringBuffer();
        if (!this.IsDigit(this.look)) {
            this.Expected("Integer");
        }
        while (this.IsDigit(this.look)) {
            value.append(this.look);
            this.GetChar();
        }
        this.SkipWhite();
        return value.toString();
    }

    private final void Emit(String s) {
        System.out.print(TAB + s);
    }

    private final void EmitLn(String s) {
        this.Emit(s);
        System.out.println();
    }

    private final void Ident() {
        String name = this.GetName();
        if (this.look == '(') {
            this.function(name);
        } else if (this.look == ':') {
            String first = name;
            this.Match(':');
            String second = this.GetName();
            this.tokens.add(new AreaPtg(first + ':' + second));
        } else if (this.look == '!') {
            this.Match('!');
            String sheetName = name;
            String first = this.GetName();
            short externIdx = this.book.checkExternSheet(this.book.getSheetIndex(sheetName));
            if (this.look == ':') {
                this.Match(':');
                String second = this.GetName();
                if (this.look == '!') {
                    this.Match('!');
                    String third = this.GetName();
                    if (!sheetName.equals(second)) {
                        throw new RuntimeException("Unhandled double sheet reference.");
                    }
                    this.tokens.add(new Area3DPtg(first + ':' + third, externIdx));
                } else {
                    this.tokens.add(new Area3DPtg(first + ':' + second, externIdx));
                }
            } else {
                this.tokens.add(new Ref3DPtg(first, externIdx));
            }
        } else {
            boolean boolLit;
            boolean cellRef = true;
            boolean bl = false;
            if (name.equals("TRUE") || name.equals("FALSE")) {
                bl = true;
            }
            if (boolLit = bl) {
                this.tokens.add(new BoolPtg(name));
            } else if (cellRef) {
                this.tokens.add(new ReferencePtg(name));
            }
        }
    }

    private final void addArgumentPointer() {
        if (this.functionTokens.size() > 0) {
            List arguments = (List)this.functionTokens.get(0);
            arguments.add(this.tokens.get(this.tokens.size() - 1));
        }
    }

    private final void function(String name) {
        this.functionTokens.add(0, new ArrayList(2));
        this.Match('(');
        int numArgs = this.Arguments();
        this.Match(')');
        AbstractFunctionPtg functionPtg = this.getFunction(name, (byte)numArgs);
        this.tokens.add(functionPtg);
        if (functionPtg.getName().equals("externalflag")) {
            this.tokens.add(new NamePtg(name, this.book));
        }
        this.functionTokens.remove(0);
    }

    private final int getPtgSize(int index) {
        int count = 0;
        ListIterator ptgIterator = this.tokens.listIterator(index);
        while (ptgIterator.hasNext()) {
            Ptg ptg = (Ptg)ptgIterator.next();
            count += ptg.getSize();
        }
        return count;
    }

    private final int getPtgSize(int start, int end) {
        int count = 0;
        int index = start;
        ListIterator ptgIterator = this.tokens.listIterator(index);
        while (ptgIterator.hasNext() && index <= end) {
            Ptg ptg = (Ptg)ptgIterator.next();
            count += ptg.getSize();
            ++index;
        }
        return count;
    }

    private final AbstractFunctionPtg getFunction(String name, byte numArgs) {
        FuncVarPtg retval = null;
        if (name.equals("IF")) {
            retval = new FuncVarPtg("specialflag", numArgs);
            List argumentPointers = (List)this.functionTokens.get(0);
            AttrPtg ifPtg = new AttrPtg();
            ifPtg.setData((short)7);
            ifPtg.setOptimizedIf(true);
            if (argumentPointers.size() != 2 && argumentPointers.size() != 3) {
                throw new IllegalArgumentException("[" + argumentPointers.size() + "] Arguments Found - An IF formula requires 2 or 3 arguments. IF(CONDITION, TRUE_VALUE, FALSE_VALUE [OPTIONAL]");
            }
            int ifIndex = this.tokens.indexOf(argumentPointers.get(0)) + 1;
            this.tokens.add(ifIndex, ifPtg);
            int gotoIndex = this.tokens.indexOf(argumentPointers.get(1)) + 1;
            AttrPtg goto1Ptg = new AttrPtg();
            goto1Ptg.setGoto(true);
            this.tokens.add(gotoIndex, goto1Ptg);
            if (numArgs > 2) {
                AttrPtg goto2Ptg = new AttrPtg();
                goto2Ptg.setGoto(true);
                goto2Ptg.setData((short)(((AbstractFunctionPtg)retval).getSize() - 1));
                this.tokens.add(goto2Ptg);
            }
            ifPtg.setData((short)this.getPtgSize(ifIndex + 1, gotoIndex));
            int ptgCount = this.getPtgSize(gotoIndex) - goto1Ptg.getSize() + ((AbstractFunctionPtg)retval).getSize();
            if (ptgCount > Short.MAX_VALUE) {
                throw new RuntimeException("Ptg Size exceeds short when being specified for a goto ptg in an if");
            }
            goto1Ptg.setData((short)(ptgCount - 1));
        } else {
            retval = new FuncVarPtg(name, numArgs);
        }
        return retval;
    }

    private final int Arguments() {
        int numArgs = 0;
        if (this.look != ')') {
            ++numArgs;
            this.Expression();
            this.addArgumentPointer();
        }
        while (this.look == ',' || this.look == ';') {
            if (this.look == ',') {
                this.Match(',');
            } else {
                this.Match(';');
            }
            this.Expression();
            this.addArgumentPointer();
            ++numArgs;
        }
        return numArgs;
    }

    private final void Factor() {
        if (this.look == '-') {
            this.Match('-');
            this.Factor();
            this.tokens.add(new UnaryMinusPtg());
        } else if (this.look == '+') {
            this.Match('+');
            this.Factor();
            this.tokens.add(new UnaryPlusPtg());
        } else if (this.look == '(') {
            this.Match('(');
            this.Expression();
            this.Match(')');
            this.tokens.add(new ParenthesisPtg());
        } else if (this.IsAlpha(this.look) || this.look == '\'') {
            this.Ident();
        } else if (this.look == '\"') {
            this.StringLiteral();
        } else if (this.look == ')' || this.look == ',') {
            this.tokens.add(new MissingArgPtg());
        } else {
            String number = this.GetNum();
            if (this.look == '.') {
                this.Match('.');
                Object decimalPart = null;
                if (this.IsDigit(this.look)) {
                    number = number + '.' + this.GetNum();
                }
                if ('E' == this.look) {
                    String exponent = this.GetExponent();
                    number = number + 'E' + exponent;
                }
                this.tokens.add(new NumberPtg(number));
            } else if ('E' == this.look) {
                String exponent = this.GetExponent();
                number = number + 'E' + exponent;
                this.tokens.add(new NumberPtg(number));
            } else {
                this.tokens.add(this.getNumberPtgFromString(number));
            }
        }
    }

    private final Ptg getNumberPtgFromString(String number) {
        try {
            return new IntPtg(number);
        }
        catch (NumberFormatException e) {
            return new NumberPtg(number);
        }
    }

    private final void StringLiteral() {
        if (this.look != '\"') {
            this.Expected("\"");
        } else {
            this.GetChar();
            StringBuffer Token = new StringBuffer();
            while (true) {
                if (this.look == '\"') {
                    this.GetChar();
                    this.SkipWhite();
                    if (this.look != '\"') break;
                    Token.append("\"");
                    continue;
                }
                if (this.look == '\u0000') break;
                Token.append(this.look);
                this.GetChar();
            }
            this.tokens.add(new StringPtg(Token.toString()));
        }
    }

    private final void Multiply() {
        this.Match('*');
        this.Factor();
        this.tokens.add(new MultiplyPtg());
    }

    private final void Divide() {
        this.Match('/');
        this.Factor();
        this.tokens.add(new DividePtg());
    }

    private final void Term() {
        this.Factor();
        while (this.look == '*' || this.look == '/' || this.look == '^' || this.look == '&') {
            if (this.look == '*') {
                this.Multiply();
                continue;
            }
            if (this.look == '/') {
                this.Divide();
                continue;
            }
            if (this.look == '^') {
                this.Power();
                continue;
            }
            if (this.look != '&') continue;
            this.Concat();
        }
    }

    private final void Add() {
        this.Match('+');
        this.Term();
        this.tokens.add(new AddPtg());
    }

    private final void Concat() {
        this.Match('&');
        this.Term();
        this.tokens.add(new ConcatPtg());
    }

    private final void Equal() {
        this.Match('=');
        this.Expression();
        this.tokens.add(new EqualPtg());
    }

    private final void Subtract() {
        this.Match('-');
        this.Term();
        this.tokens.add(new SubtractPtg());
    }

    private final void Power() {
        this.Match('^');
        this.Term();
        this.tokens.add(new PowerPtg());
    }

    private final void Expression() {
        this.Term();
        while (this.IsAddop(this.look)) {
            if (this.look == '+') {
                this.Add();
                continue;
            }
            if (this.look != '-') continue;
            this.Subtract();
        }
        if (this.look == '=' || this.look == '>' || this.look == '<') {
            if (this.look == '=') {
                this.Equal();
            } else if (this.look == '>') {
                this.GreaterThan();
            } else if (this.look == '<') {
                this.LessThan();
            }
            return;
        }
    }

    private final void GreaterThan() {
        this.Match('>');
        if (this.look == '=') {
            this.GreaterEqual();
        } else {
            this.Expression();
            this.tokens.add(new GreaterThanPtg());
        }
    }

    private final void LessThan() {
        this.Match('<');
        if (this.look == '=') {
            this.LessEqual();
        } else if (this.look == '>') {
            this.NotEqual();
        } else {
            this.Expression();
            this.tokens.add(new LessThanPtg());
        }
    }

    private final void GreaterEqual() {
        this.Match('=');
        this.Expression();
        this.tokens.add(new GreaterEqualPtg());
    }

    private final void LessEqual() {
        this.Match('=');
        this.Expression();
        this.tokens.add(new LessEqualPtg());
    }

    private final void NotEqual() {
        this.Match('>');
        this.Expression();
        this.tokens.add(new NotEqualPtg());
    }

    private final void init() {
        this.GetChar();
        this.SkipWhite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse() {
        List list = this.tokens;
        synchronized (list) {
            this.init();
            this.Expression();
            return;
        }
    }

    public Ptg[] getRPNPtg() {
        return this.getRPNPtg(FORMULA_TYPE_CELL);
    }

    public Ptg[] getRPNPtg(int formulaType) {
        Node node = this.createTree();
        this.setRootLevelRVA(node, formulaType);
        this.setParameterRVA(node, formulaType);
        return this.tokens.toArray(new Ptg[0]);
    }

    private final void setRootLevelRVA(Node n, int formulaType) {
        Ptg p = n.getValue();
        if (formulaType == FORMULA_TYPE_NAMEDRANGE) {
            if (p.getDefaultOperandClass() == 0) {
                this.setClass(n, (byte)0);
            } else {
                this.setClass(n, (byte)64);
            }
        } else {
            this.setClass(n, (byte)32);
        }
    }

    private final void setParameterRVA(Node n, int formulaType) {
        Ptg p = n.getValue();
        int numOperands = n.getNumChildren();
        if (p instanceof AbstractFunctionPtg) {
            int i = 0;
            while (i < numOperands) {
                this.setParameterRVA(n.getChild(i), ((AbstractFunctionPtg)p).getParameterClass(i), formulaType);
                this.setParameterRVA(n.getChild(i), formulaType);
                ++i;
            }
        } else {
            int i = 0;
            while (i < numOperands) {
                this.setParameterRVA(n.getChild(i), formulaType);
                ++i;
            }
        }
    }

    private final void setParameterRVA(Node n, int expectedClass, int formulaType) {
        Ptg p = n.getValue();
        if (expectedClass == 0) {
            if (p.getDefaultOperandClass() == 0) {
                this.setClass(n, (byte)0);
            }
            if (p.getDefaultOperandClass() == 32) {
                if (formulaType == FORMULA_TYPE_CELL || formulaType == FORMULA_TYPE_SHARED) {
                    this.setClass(n, (byte)32);
                } else {
                    this.setClass(n, (byte)64);
                }
            }
            if (p.getDefaultOperandClass() == 64) {
                this.setClass(n, (byte)64);
            }
        } else if (expectedClass == 32) {
            if (formulaType == FORMULA_TYPE_NAMEDRANGE) {
                this.setClass(n, (byte)64);
            } else {
                this.setClass(n, (byte)32);
            }
        } else if (p.getDefaultOperandClass() == 32 && (formulaType == FORMULA_TYPE_CELL || formulaType == FORMULA_TYPE_SHARED)) {
            this.setClass(n, (byte)32);
        } else {
            this.setClass(n, (byte)64);
        }
    }

    private final void setClass(Node n, byte theClass) {
        Ptg p = n.getValue();
        if (p instanceof AbstractFunctionPtg || !(p instanceof OperationPtg)) {
            p.setClass(theClass);
        } else {
            int i = 0;
            while (i < n.getNumChildren()) {
                this.setClass(n.getChild(i), theClass);
                ++i;
            }
        }
    }

    public static String toFormulaString(Workbook book, List lptgs) {
        String retval = null;
        if (lptgs == null || lptgs.size() == 0) {
            return "#NAME";
        }
        Ptg[] ptgs = new Ptg[lptgs.size()];
        ptgs = lptgs.toArray(ptgs);
        retval = FormulaParser.toFormulaString(book, ptgs);
        return retval;
    }

    public static String toFormulaString(Workbook book, Ptg[] ptgs) {
        if (ptgs == null || ptgs.length == 0) {
            return "#NAME";
        }
        Stack<String> stack = new Stack<String>();
        AttrPtg ifptg = null;
        stack.push(ptgs[0].toFormulaString(book));
        int i = 1;
        while (i < ptgs.length) {
            if (!(ptgs[i] instanceof OperationPtg)) {
                stack.push(ptgs[i].toFormulaString(book));
            } else if (ptgs[i] instanceof AttrPtg && ((AttrPtg)ptgs[i]).isOptimizedIf()) {
                ifptg = (AttrPtg)ptgs[i];
            } else {
                AbstractFunctionPtg f;
                String fname;
                OperationPtg o = (OperationPtg)ptgs[i];
                String[] operands = new String[o.getNumberOfOperands()];
                int j = operands.length;
                while (j > 0) {
                    operands[j - 1] = (String)stack.pop();
                    --j;
                }
                stack.push(o.toFormulaString(operands));
                if (o instanceof AbstractFunctionPtg && (fname = (f = (AbstractFunctionPtg)o).getName()) != null) {
                    if (ifptg != null && fname.equals("specialflag")) {
                        stack.push(ifptg.toFormulaString(new String[]{(String)stack.pop()}));
                    } else if (fname.equals("externalflag")) {
                        String top = (String)stack.pop();
                        int paren = top.indexOf(40);
                        int comma = top.indexOf(44);
                        if (comma == -1) {
                            int rparen = top.indexOf(41);
                            stack.push(top.substring(paren + 1, rparen) + "()");
                        } else {
                            stack.push(top.substring(paren + 1, comma) + '(' + top.substring(comma + 1));
                        }
                    }
                }
            }
            ++i;
        }
        return (String)stack.pop();
    }

    private final Node createTree() {
        Stack<Node> stack = new Stack<Node>();
        int numPtgs = this.tokens.size();
        int i = 0;
        while (i < numPtgs) {
            if (this.tokens.get(i) instanceof OperationPtg) {
                OperationPtg o = (OperationPtg)this.tokens.get(i);
                int numOperands = o.getNumberOfOperands();
                Node[] operands = new Node[numOperands];
                int j = 0;
                while (j < numOperands) {
                    operands[numOperands - j - 1] = (Node)stack.pop();
                    ++j;
                }
                Node result = new Node(o);
                result.setChildren(operands);
                stack.push(result);
            } else {
                stack.push(new Node((Ptg)this.tokens.get(i)));
            }
            ++i;
        }
        return (Node)stack.pop();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.tokens.size()) {
            buf.append(((Ptg)this.tokens.get(i)).toFormulaString(this.book));
            buf.append(' ');
            ++i;
        }
        return buf.toString();
    }

    private final /* synthetic */ void this() {
        this.pointer = 0;
        this.tokens = new Stack();
        this.functionTokens = new LinkedList();
    }

    public FormulaParser(String formula, Workbook book) {
        this.this();
        this.formulaString = formula;
        this.pointer = 0;
        this.book = book;
        this.formulaLength = this.formulaString.length();
    }
}

