/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public class GutsRecord
extends Record {
    public static final short sid = 128;
    private short field_1_left_row_gutter;
    private short field_2_top_col_gutter;
    private short field_3_row_level_max;
    private short field_4_col_level_max;

    protected void validateSid(short id) {
        if (id != 128) {
            throw new RecordFormatException("NOT A Guts RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_left_row_gutter = in.readShort();
        this.field_2_top_col_gutter = in.readShort();
        this.field_3_row_level_max = in.readShort();
        this.field_4_col_level_max = in.readShort();
    }

    public void setLeftRowGutter(short gut) {
        this.field_1_left_row_gutter = gut;
    }

    public void setTopColGutter(short gut) {
        this.field_2_top_col_gutter = gut;
    }

    public void setRowLevelMax(short max) {
        this.field_3_row_level_max = max;
    }

    public void setColLevelMax(short max) {
        this.field_4_col_level_max = max;
    }

    public short getLeftRowGutter() {
        return this.field_1_left_row_gutter;
    }

    public short getTopColGutter() {
        return this.field_2_top_col_gutter;
    }

    public short getRowLevelMax() {
        return this.field_3_row_level_max;
    }

    public short getColLevelMax() {
        return this.field_4_col_level_max;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[GUTS]\n");
        buffer.append("    .leftgutter     = ").append(Integer.toHexString(this.getLeftRowGutter())).append("\n");
        buffer.append("    .topgutter      = ").append(Integer.toHexString(this.getTopColGutter())).append("\n");
        buffer.append("    .rowlevelmax    = ").append(Integer.toHexString(this.getRowLevelMax())).append("\n");
        buffer.append("    .collevelmax    = ").append(Integer.toHexString(this.getColLevelMax())).append("\n");
        buffer.append("[/GUTS]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, offset, (short)128);
        LittleEndian.putShort(data, 2 + offset, (short)8);
        LittleEndian.putShort(data, 4 + offset, this.getLeftRowGutter());
        LittleEndian.putShort(data, 6 + offset, this.getTopColGutter());
        LittleEndian.putShort(data, 8 + offset, this.getRowLevelMax());
        LittleEndian.putShort(data, 10 + offset, this.getColLevelMax());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 12;
    }

    public short getSid() {
        return 128;
    }

    public Object clone() {
        GutsRecord rec = new GutsRecord();
        rec.field_1_left_row_gutter = this.field_1_left_row_gutter;
        rec.field_2_top_col_gutter = this.field_2_top_col_gutter;
        rec.field_3_row_level_max = this.field_3_row_level_max;
        rec.field_4_col_level_max = this.field_4_col_level_max;
        return rec;
    }

    public GutsRecord() {
    }

    public GutsRecord(RecordInputStream in) {
        super(in);
    }
}

