/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.SubRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class NoteStructureSubRecord
extends SubRecord {
    public static final short sid = 13;
    private byte[] reserved;

    protected void validateSid(short id) {
        if (id != 13) {
            throw new RecordFormatException("Not a Note Structure record");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.reserved = in.readRemainder();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buffer.append("[ftNts ]" + nl);
        buffer.append("  size     = ").append(this.getRecordSize()).append(nl);
        buffer.append("  reserved = ").append(HexDump.toHex(this.reserved)).append(nl);
        buffer.append("[/ftNts ]" + nl);
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, offset, (short)13);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        System.arraycopy(this.reserved, 0, data, offset + 4, this.getRecordSize() - 4);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 4 + this.reserved.length;
    }

    public short getSid() {
        return 13;
    }

    public NoteStructureSubRecord() {
        this.reserved = new byte[22];
    }

    public NoteStructureSubRecord(RecordInputStream in) {
        super(in);
    }
}

