/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.io.PrintWriter;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hssf.model.Sheet;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.EscherAggregate;
import org.apache.poi.hssf.record.HCenterRecord;
import org.apache.poi.hssf.record.PageBreakRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.SCLRecord;
import org.apache.poi.hssf.record.VCenterRecord;
import org.apache.poi.hssf.record.WSBoolRecord;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.PaneInformation;
import org.apache.poi.hssf.util.Region;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HSSFSheet {
    private static final int DEBUG = 1;
    public static final short LeftMargin = 0;
    public static final short RightMargin = 1;
    public static final short TopMargin = 2;
    public static final short BottomMargin = 3;
    public static final byte PANE_LOWER_RIGHT = 0;
    public static final byte PANE_UPPER_RIGHT = 1;
    public static final byte PANE_LOWER_LEFT = 2;
    public static final byte PANE_UPPER_LEFT = 3;
    public static final int INITIAL_CAPACITY = 20;
    private static POILogger log;
    private Sheet sheet;
    private TreeMap rows;
    private Workbook book;
    private int firstrow;
    private int lastrow;
    static /* synthetic */ Class class$org$apache$poi$hssf$usermodel$HSSFSheet;

    HSSFSheet cloneSheet(Workbook book) {
        return new HSSFSheet(book, this.sheet.cloneSheet());
    }

    private final void setPropertiesFromSheet(Sheet sheet) {
        int sloc = sheet.getLoc();
        RowRecord row = sheet.getNextRow();
        while (row != null) {
            this.createRowFromRecord(row);
            row = sheet.getNextRow();
        }
        sheet.setLoc(sloc);
        CellValueRecordInterface cval = sheet.getNextValueRecord();
        long timestart = System.currentTimeMillis();
        if (log.check(1)) {
            log.log(1, (Object)"Time at start of cell creating in HSSF sheet = ", new Long(timestart));
        }
        HSSFRow lastrow = null;
        while (cval != null) {
            long cellstart = System.currentTimeMillis();
            HSSFRow hrow = lastrow;
            if (lastrow == null || lastrow.getRowNum() != cval.getRow()) {
                hrow = this.getRow(cval.getRow());
            }
            if (hrow != null) {
                lastrow = hrow;
                if (log.check(1)) {
                    log.log(1, "record id = " + Integer.toHexString(((Record)((Object)cval)).getSid()));
                }
                hrow.createCellFromRecord(cval);
                cval = sheet.getNextValueRecord();
                if (!log.check(1)) continue;
                log.log(1, (Object)"record took ", new Long(System.currentTimeMillis() - cellstart));
                continue;
            }
            cval = null;
        }
        if (log.check(1)) {
            log.log(1, (Object)"total sheet cell creation took ", new Long(System.currentTimeMillis() - timestart));
        }
    }

    public HSSFRow createRow(int rownum) {
        HSSFRow row = new HSSFRow(this.book, this.sheet, rownum);
        this.addRow(row, true);
        return row;
    }

    private final HSSFRow createRowFromRecord(RowRecord row) {
        HSSFRow hrow = new HSSFRow(this.book, this.sheet, row);
        this.addRow(hrow, false);
        return hrow;
    }

    public void removeRow(HSSFRow row) {
        this.sheet.setLoc(this.sheet.getDimsLoc());
        if (this.rows.size() > 0) {
            this.rows.remove(row);
            if (row.getRowNum() == this.getLastRowNum()) {
                this.lastrow = this.findLastRow(this.lastrow);
            }
            if (row.getRowNum() == this.getFirstRowNum()) {
                this.firstrow = this.findFirstRow(this.firstrow);
            }
            Iterator iter = row.cellIterator();
            while (iter.hasNext()) {
                HSSFCell cell = (HSSFCell)iter.next();
                this.sheet.removeValueRecord(row.getRowNum(), cell.getCellValueRecord());
            }
            this.sheet.removeRow(row.getRowRecord());
        }
    }

    private final int findLastRow(int lastrow) {
        int rownum = lastrow - 1;
        HSSFRow r = this.getRow(rownum);
        while (r == null && rownum > 0) {
            r = this.getRow(--rownum);
        }
        if (r == null) {
            return -1;
        }
        return rownum;
    }

    private final int findFirstRow(int firstrow) {
        int rownum = firstrow + 1;
        HSSFRow r = this.getRow(rownum);
        while (r == null && rownum <= this.getLastRowNum()) {
            r = this.getRow(++rownum);
        }
        if (rownum > this.getLastRowNum()) {
            return -1;
        }
        return rownum;
    }

    private final void addRow(HSSFRow row, boolean addLow) {
        this.rows.put(row, row);
        if (addLow) {
            this.sheet.addRow(row.getRowRecord());
        }
        if (row.getRowNum() > this.getLastRowNum()) {
            this.lastrow = row.getRowNum();
        }
        if (row.getRowNum() < this.getFirstRowNum()) {
            this.firstrow = row.getRowNum();
        }
    }

    public HSSFRow getRow(int rownum) {
        HSSFRow row = new HSSFRow();
        row.setRowNum(rownum);
        return (HSSFRow)this.rows.get(row);
    }

    public int getPhysicalNumberOfRows() {
        return this.rows.size();
    }

    public int getFirstRowNum() {
        return this.firstrow;
    }

    public int getLastRowNum() {
        return this.lastrow;
    }

    public void setColumnHidden(short column, boolean hidden) {
        this.sheet.setColumnHidden(column, hidden);
    }

    public boolean isColumnHidden(short column) {
        return this.sheet.isColumnHidden(column);
    }

    public void setColumnWidth(short column, short width) {
        this.sheet.setColumnWidth(column, width);
    }

    public short getColumnWidth(short column) {
        return this.sheet.getColumnWidth(column);
    }

    public short getDefaultColumnWidth() {
        return this.sheet.getDefaultColumnWidth();
    }

    public short getDefaultRowHeight() {
        return this.sheet.getDefaultRowHeight();
    }

    public float getDefaultRowHeightInPoints() {
        return this.sheet.getDefaultRowHeight() / 20;
    }

    public void setDefaultColumnWidth(short width) {
        this.sheet.setDefaultColumnWidth(width);
    }

    public void setDefaultRowHeight(short height) {
        this.sheet.setDefaultRowHeight(height);
    }

    public void setDefaultRowHeightInPoints(float height) {
        this.sheet.setDefaultRowHeight((short)(height * 20.0f));
    }

    public boolean isGridsPrinted() {
        return this.sheet.isGridsPrinted();
    }

    public void setGridsPrinted(boolean value) {
        this.sheet.setGridsPrinted(value);
    }

    public int addMergedRegion(Region region) {
        return this.sheet.addMergedRegion(region.getRowFrom(), region.getColumnFrom(), region.getRowTo(), region.getColumnTo());
    }

    public void setVerticallyCenter(boolean value) {
        VCenterRecord record = (VCenterRecord)this.sheet.findFirstRecordBySid((short)132);
        record.setVCenter(value);
    }

    public boolean getVerticallyCenter(boolean value) {
        VCenterRecord record = (VCenterRecord)this.sheet.findFirstRecordBySid((short)132);
        return record.getVCenter();
    }

    public void setHorizontallyCenter(boolean value) {
        HCenterRecord record = (HCenterRecord)this.sheet.findFirstRecordBySid((short)131);
        record.setHCenter(value);
    }

    public boolean getHorizontallyCenter() {
        HCenterRecord record = (HCenterRecord)this.sheet.findFirstRecordBySid((short)131);
        return record.getHCenter();
    }

    public void removeMergedRegion(int index) {
        this.sheet.removeMergedRegion(index);
    }

    public int getNumMergedRegions() {
        return this.sheet.getNumMergedRegions();
    }

    public Region getMergedRegionAt(int index) {
        return new Region(this.sheet.getMergedRegionAt(index));
    }

    public Iterator rowIterator() {
        return this.rows.values().iterator();
    }

    protected Sheet getSheet() {
        return this.sheet;
    }

    public void setAlternativeExpression(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setAlternateExpression(b);
    }

    public void setAlternativeFormula(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setAlternateFormula(b);
    }

    public void setAutobreaks(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setAutobreaks(b);
    }

    public void setDialog(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setDialog(b);
    }

    public void setDisplayGuts(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setDisplayGuts(b);
    }

    public void setFitToPage(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setFitToPage(b);
    }

    public void setRowSumsBelow(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setRowSumsBelow(b);
    }

    public void setRowSumsRight(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setRowSumsRight(b);
    }

    public boolean getAlternateExpression() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getAlternateExpression();
    }

    public boolean getAlternateFormula() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getAlternateFormula();
    }

    public boolean getAutobreaks() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getAutobreaks();
    }

    public boolean getDialog() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getDialog();
    }

    public boolean getDisplayGuts() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getDisplayGuts();
    }

    public boolean getFitToPage() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getFitToPage();
    }

    public boolean getRowSumsBelow() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getRowSumsBelow();
    }

    public boolean getRowSumsRight() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getRowSumsRight();
    }

    public boolean isPrintGridlines() {
        return this.getSheet().getPrintGridlines().getPrintGridlines();
    }

    public void setPrintGridlines(boolean newPrintGridlines) {
        this.getSheet().getPrintGridlines().setPrintGridlines(newPrintGridlines);
    }

    public HSSFPrintSetup getPrintSetup() {
        return new HSSFPrintSetup(this.getSheet().getPrintSetup());
    }

    public HSSFHeader getHeader() {
        return new HSSFHeader(this.getSheet().getHeader());
    }

    public HSSFFooter getFooter() {
        return new HSSFFooter(this.getSheet().getFooter());
    }

    public void setSelected(boolean sel) {
        this.getSheet().setSelected(sel);
    }

    public double getMargin(short margin) {
        return this.getSheet().getMargin(margin);
    }

    public void setMargin(short margin, double size) {
        this.getSheet().setMargin(margin, size);
    }

    public boolean getProtect() {
        return this.getSheet().getProtect().getProtect();
    }

    public void setProtect(boolean protect) {
        this.getSheet().getProtect().setProtect(protect);
    }

    public void setZoom(int numerator, int denominator) {
        if (numerator < 1 || numerator > (char)-1) {
            throw new IllegalArgumentException("Numerator must be greater than 1 and less than 65536");
        }
        if (denominator < 1 || denominator > (char)-1) {
            throw new IllegalArgumentException("Denominator must be greater than 1 and less than 65536");
        }
        SCLRecord sclRecord = new SCLRecord();
        sclRecord.setNumerator((short)numerator);
        sclRecord.setDenominator((short)denominator);
        this.getSheet().setSCLRecord(sclRecord);
    }

    public short getTopRow() {
        return this.sheet.getTopRow();
    }

    public short getLeftCol() {
        return this.sheet.getLeftCol();
    }

    public void showInPane(short toprow, short leftcol) {
        this.sheet.setTopRow(toprow);
        this.sheet.setLeftCol(leftcol);
    }

    protected void shiftMerged(int startRow, int endRow, int n, boolean isRow) {
        ArrayList<Region> shiftedRegions = new ArrayList<Region>();
        int i = 0;
        while (i < this.getNumMergedRegions()) {
            boolean inEnd;
            Region merged = this.getMergedRegionAt(i);
            boolean bl = false;
            if (merged.getRowFrom() >= startRow || merged.getRowTo() >= startRow) {
                bl = true;
            }
            boolean inStart = bl;
            boolean bl2 = false;
            if (merged.getRowTo() <= endRow || merged.getRowFrom() <= endRow) {
                bl2 = inEnd = true;
            }
            if (inStart && inEnd && !merged.contains(startRow - 1, (short)0) && !merged.contains(endRow + 1, (short)0)) {
                merged.setRowFrom(merged.getRowFrom() + n);
                merged.setRowTo(merged.getRowTo() + n);
                shiftedRegions.add(merged);
                this.removeMergedRegion(i);
                --i;
            }
            ++i;
        }
        Iterator iterator = shiftedRegions.iterator();
        while (iterator.hasNext()) {
            Region region = (Region)iterator.next();
            this.addMergedRegion(region);
        }
    }

    public void shiftRows(int startRow, int endRow, int n) {
        this.shiftRows(startRow, endRow, n, false, false);
    }

    public void shiftRows(int startRow, int endRow, int n, boolean copyRowHeight, boolean resetOriginalRowHeight) {
        int inc;
        int e;
        int s;
        if (n < 0) {
            s = startRow;
            e = endRow;
            inc = 1;
        } else {
            s = endRow;
            e = startRow;
            inc = -1;
        }
        this.shiftMerged(startRow, endRow, n, true);
        this.sheet.shiftRowBreaks(startRow, endRow, n);
        int rowNum = s;
        while (rowNum >= startRow && rowNum <= endRow && rowNum >= 0 && rowNum < 65536) {
            HSSFCell cell;
            HSSFRow row = this.getRow(rowNum);
            HSSFRow row2Replace = this.getRow(rowNum + n);
            if (row2Replace == null) {
                row2Replace = this.createRow(rowNum + n);
            }
            short col = row2Replace.getFirstCellNum();
            while (col <= row2Replace.getLastCellNum()) {
                cell = row2Replace.getCell(col);
                if (cell != null) {
                    row2Replace.removeCell(cell);
                }
                col = (short)(col + 1);
            }
            if (row != null) {
                if (copyRowHeight) {
                    row2Replace.setHeight(row.getHeight());
                }
                if (resetOriginalRowHeight) {
                    row.setHeight((short)255);
                }
                col = row.getFirstCellNum();
                while (col <= row.getLastCellNum()) {
                    cell = row.getCell(col);
                    if (cell != null) {
                        row.removeCell(cell);
                        CellValueRecordInterface cellRecord = cell.getCellValueRecord();
                        cellRecord.setRow(rowNum + n);
                        row2Replace.createCellFromRecord(cellRecord);
                        this.sheet.addValueRecord(rowNum + n, cellRecord);
                    }
                    col = (short)(col + 1);
                }
            }
            rowNum += inc;
        }
        if (endRow == this.lastrow || endRow + n > this.lastrow) {
            this.lastrow = Math.min(endRow + n, (char)-1);
        }
        if (startRow == this.firstrow || startRow + n < this.firstrow) {
            this.firstrow = Math.max(startRow + n, 0);
        }
    }

    protected void insertChartRecords(List records) {
        int window2Loc = this.sheet.findFirstRecordLocBySid((short)574);
        this.sheet.getRecords().addAll(window2Loc, records);
    }

    public void createFreezePane(int colSplit, int rowSplit, int leftmostColumn, int topRow) {
        if (colSplit < 0 || colSplit > 255) {
            throw new IllegalArgumentException("Column must be between 0 and 255");
        }
        if (rowSplit < 0 || rowSplit > (char)-1) {
            throw new IllegalArgumentException("Row must be between 0 and 65535");
        }
        if (leftmostColumn < colSplit) {
            throw new IllegalArgumentException("leftmostColumn parameter must not be less than colSplit parameter");
        }
        if (topRow < rowSplit) {
            throw new IllegalArgumentException("topRow parameter must not be less than leftmostColumn parameter");
        }
        this.getSheet().createFreezePane(colSplit, rowSplit, topRow, leftmostColumn);
    }

    public void createFreezePane(int colSplit, int rowSplit) {
        this.createFreezePane(colSplit, rowSplit, colSplit, rowSplit);
    }

    public void createSplitPane(int xSplitPos, int ySplitPos, int leftmostColumn, int topRow, int activePane) {
        this.getSheet().createSplitPane(xSplitPos, ySplitPos, topRow, leftmostColumn, activePane);
    }

    public PaneInformation getPaneInformation() {
        return this.getSheet().getPaneInformation();
    }

    public void setDisplayGridlines(boolean show) {
        this.sheet.setDisplayGridlines(show);
    }

    public boolean isDisplayGridlines() {
        return this.sheet.isDisplayGridlines();
    }

    public void setDisplayFormulas(boolean show) {
        this.sheet.setDisplayFormulas(show);
    }

    public boolean isDisplayFormulas() {
        return this.sheet.isDisplayFormulas();
    }

    public void setDisplayRowColHeadings(boolean show) {
        this.sheet.setDisplayRowColHeadings(show);
    }

    public boolean isDisplayRowColHeadings() {
        return this.sheet.isDisplayRowColHeadings();
    }

    public void setRowBreak(int row) {
        this.validateRow(row);
        this.sheet.setRowBreak(row, (short)0, (short)255);
    }

    public boolean isRowBroken(int row) {
        return this.sheet.isRowBroken(row);
    }

    public void removeRowBreak(int row) {
        this.sheet.removeRowBreak(row);
    }

    public int[] getRowBreaks() {
        int count = this.sheet.getNumRowBreaks();
        if (count > 0) {
            int[] returnValue = new int[count];
            Iterator iterator = this.sheet.getRowBreaks();
            int i = 0;
            while (iterator.hasNext()) {
                PageBreakRecord.Break breakItem = (PageBreakRecord.Break)iterator.next();
                returnValue[i++] = breakItem.main;
            }
            return returnValue;
        }
        return null;
    }

    public short[] getColumnBreaks() {
        int count = this.sheet.getNumColumnBreaks();
        if (count > 0) {
            short[] returnValue = new short[count];
            Iterator iterator = this.sheet.getColumnBreaks();
            int i = 0;
            while (iterator.hasNext()) {
                PageBreakRecord.Break breakItem = (PageBreakRecord.Break)iterator.next();
                returnValue[i++] = breakItem.main;
            }
            return returnValue;
        }
        return null;
    }

    public void setColumnBreak(short column) {
        this.validateColumn(column);
        this.sheet.setColumnBreak(column, (short)0, (short)-1);
    }

    public boolean isColumnBroken(short column) {
        return this.sheet.isColumnBroken(column);
    }

    public void removeColumnBreak(short column) {
        this.sheet.removeColumnBreak(column);
    }

    protected void validateRow(int row) {
        if (row > (char)-1) {
            throw new IllegalArgumentException("Maximum row number is 65535");
        }
        if (row < 0) {
            throw new IllegalArgumentException("Minumum row number is 0");
        }
    }

    protected void validateColumn(short column) {
        if (column > 255) {
            throw new IllegalArgumentException("Maximum column number is 255");
        }
        if (column < 0) {
            throw new IllegalArgumentException("Minimum column number is 0");
        }
    }

    public void dumpDrawingRecords(boolean fat) {
        this.sheet.aggregateDrawingRecords(this.book.getDrawingManager());
        EscherAggregate r = (EscherAggregate)this.getSheet().findFirstRecordBySid((short)9876);
        List escherRecords = r.getEscherRecords();
        PrintWriter w = new PrintWriter(System.out);
        Iterator iterator = escherRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            if (fat) {
                System.out.println(escherRecord.toString());
                continue;
            }
            escherRecord.display(w, 0);
        }
        w.flush();
    }

    public HSSFPatriarch createDrawingPatriarch() {
        this.book.createDrawingGroup();
        this.sheet.aggregateDrawingRecords(this.book.getDrawingManager());
        EscherAggregate agg = (EscherAggregate)this.sheet.findFirstRecordBySid((short)9876);
        HSSFPatriarch patriarch = new HSSFPatriarch(this);
        agg.clear();
        agg.setPatriarch(patriarch);
        return patriarch;
    }

    public void setColumnGroupCollapsed(short columnNumber, boolean collapsed) {
        this.sheet.setColumnGroupCollapsed(columnNumber, collapsed);
    }

    public void groupColumn(short fromColumn, short toColumn) {
        this.sheet.groupColumnRange(fromColumn, toColumn, true);
    }

    public void ungroupColumn(short fromColumn, short toColumn) {
        this.sheet.groupColumnRange(fromColumn, toColumn, false);
    }

    public void groupRow(int fromRow, int toRow) {
        this.sheet.groupRowRange(fromRow, toRow, true);
    }

    public void ungroupRow(int fromRow, int toRow) {
        this.sheet.groupRowRange(fromRow, toRow, false);
    }

    public void setRowGroupCollapsed(int row, boolean collapse) {
        this.sheet.setRowGroupCollapsed(row, collapse);
    }

    public void setDefaultColumnStyle(short column, HSSFCellStyle style) {
        this.sheet.setColumn(column, new Short(style.getIndex()), null, null, null, null);
    }

    public void autoSizeColumn(short column) {
        char defaultChar = '0';
        FontRenderContext frc = new FontRenderContext(null, true, true);
        HSSFWorkbook wb = new HSSFWorkbook(this.book);
        HSSFFont defaultFont = wb.getFontAt((short)0);
        AttributedString str = new AttributedString("" + defaultChar);
        str.addAttribute(TextAttribute.FAMILY, defaultFont.getFontName());
        str.addAttribute(TextAttribute.SIZE, new Float(defaultFont.getFontHeightInPoints()));
        TextLayout layout = new TextLayout(str.getIterator(), frc);
        int defaultCharWidth = (int)layout.getAdvance();
        double width = -1.0;
        Iterator it = this.rowIterator();
        while (it.hasNext()) {
            HSSFRow row = (HSSFRow)it.next();
            HSSFCell cell = row.getCell(column);
            if (cell == null) continue;
            HSSFCellStyle style = cell.getCellStyle();
            HSSFFont font = wb.getFontAt(style.getFontIndex());
            if (cell.getCellType() == 1) {
                HSSFRichTextString rt = cell.getRichStringCellValue();
                String[] lines = this.splitLines(rt.getString());
                int i = 0;
                while (i < lines.length) {
                    str = new AttributedString(lines[i] + defaultChar);
                    str.addAttribute(TextAttribute.FAMILY, font.getFontName());
                    str.addAttribute(TextAttribute.SIZE, new Float(font.getFontHeightInPoints()));
                    if (font.getBoldweight() == 700) {
                        str.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                    }
                    if (rt.numFormattingRuns() > 0) {
                        int j = 0;
                        while (j < lines[i].length()) {
                            short idx = rt.getFontAtIndex(j);
                            if (idx != 0) {
                                HSSFFont fnt = wb.getFontAt(idx);
                                str.addAttribute(TextAttribute.FAMILY, fnt.getFontName(), j, j + 1);
                                str.addAttribute(TextAttribute.SIZE, new Float(fnt.getFontHeightInPoints()), j, j + 1);
                            }
                            ++j;
                        }
                    }
                    layout = new TextLayout(str.getIterator(), frc);
                    width = Math.max(width, (double)(layout.getAdvance() / (float)defaultCharWidth));
                    ++i;
                }
            } else {
                String sval = null;
                if (cell.getCellType() == 0) {
                    HSSFDataFormat dataformat = wb.createDataFormat();
                    short idx = style.getDataFormat();
                    String rawFormat = dataformat.getFormat(idx);
                    String format = this.stripQuotes(rawFormat);
                    double value = cell.getNumericCellValue();
                    try {
                        DecimalFormat fmt = "General".equals(format) ? new DecimalFormat() : new DecimalFormat(format);
                        sval = fmt.format(value);
                    }
                    catch (Exception e) {
                        sval = "" + value;
                    }
                } else if (cell.getCellType() == 4) {
                    sval = String.valueOf(cell.getBooleanCellValue());
                }
                str = new AttributedString(sval + defaultChar);
                str.addAttribute(TextAttribute.FAMILY, font.getFontName());
                str.addAttribute(TextAttribute.SIZE, new Float(font.getFontHeightInPoints()));
                layout = new TextLayout(str.getIterator(), frc);
                width = Math.max(width, (double)(layout.getAdvance() / (float)defaultCharWidth));
            }
            if (width == -1.0) continue;
            this.sheet.setColumnWidth(column, (short)(width * 256.0));
        }
    }

    public HSSFComment getCellComment(int row, int column) {
        return HSSFCell.findCellComment(this.sheet, row, column);
    }

    private final String stripQuotes(String text) {
        if (text == null) {
            throw new NullPointerException("Text is null");
        }
        StringBuffer buffer = new StringBuffer(text.length());
        char[] chars = text.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c != '\"') {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    private final String[] splitLines(String text) {
        StringTokenizer strTok = new StringTokenizer(text, "\n");
        int size = strTok.countTokens();
        String[] retval = new String[size];
        int i = 0;
        while (i < retval.length) {
            retval[i] = strTok.nextToken();
            ++i;
        }
        return retval;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected HSSFSheet(Workbook book) {
        this.sheet = Sheet.createSheet();
        this.rows = new TreeMap();
        this.book = book;
    }

    protected HSSFSheet(Workbook book, Sheet sheet) {
        this.sheet = sheet;
        this.rows = new TreeMap();
        this.book = book;
        this.setPropertiesFromSheet(sheet);
    }

    static {
        Class clazz = class$org$apache$poi$hssf$usermodel$HSSFSheet;
        if (clazz == null) {
            clazz = class$org$apache$poi$hssf$usermodel$HSSFSheet = HSSFSheet.class("[Lorg.apache.poi.hssf.usermodel.HSSFSheet;", false);
        }
        log = POILogFactory.getLogger(clazz);
    }
}

