/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BinaryTree
extends AbstractMap {
    private static final int _KEY = 0;
    private static final int _VALUE = 1;
    private static final int _INDEX_SUM = 1;
    private static final int _MINIMUM_INDEX = 0;
    private static final int _INDEX_COUNT = 2;
    private static final String[] _data_name = new String[]{"key", "value"};
    private Node[] _root;
    private int _size;
    private int _modifications;
    private Set[] _key_set;
    private Set[] _entry_set;
    private Collection[] _value_collection;

    public final Object getKeyForValue(Object value) throws ClassCastException, NullPointerException {
        return this.doGet((Comparable)value, 1);
    }

    public final Object removeValue(Object value) {
        return this.doRemove((Comparable)value, 1);
    }

    public final Set entrySetByValue() {
        if (this._entry_set[1] == null) {
            this._entry_set[1] = new AbstractSet(){

                public final Iterator iterator() {
                    return new BinaryTreeIterator(BinaryTree.this, 1){

                        protected final Object doGetNext() {
                            return this._last_returned_node;
                        }
                    };
                }

                public final boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Node node = BinaryTree.this.lookup((Comparable)entry.getValue(), 1);
                    boolean bl = false;
                    if (node != null && node.getData(0).equals(key)) {
                        bl = true;
                    }
                    return bl;
                }

                public final boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Node node = BinaryTree.this.lookup((Comparable)entry.getValue(), 1);
                    if (node != null && node.getData(0).equals(key)) {
                        BinaryTree.this.doRedBlackDelete(node);
                        return true;
                    }
                    return false;
                }

                public final int size() {
                    return BinaryTree.this.size();
                }

                public final void clear() {
                    BinaryTree.this.clear();
                }
            };
        }
        return this._entry_set[1];
    }

    public final Set keySetByValue() {
        if (this._key_set[1] == null) {
            this._key_set[1] = new AbstractSet(){

                public final Iterator iterator() {
                    return new BinaryTreeIterator(BinaryTree.this, 1){

                        protected final Object doGetNext() {
                            return this._last_returned_node.getData(0);
                        }
                    };
                }

                public final int size() {
                    return BinaryTree.this.size();
                }

                public final boolean contains(Object o) {
                    return BinaryTree.this.containsKey(o);
                }

                public final boolean remove(Object o) {
                    int old_size = BinaryTree.this._size;
                    BinaryTree.this.remove(o);
                    boolean bl = false;
                    if (BinaryTree.this._size != old_size) {
                        bl = true;
                    }
                    return bl;
                }

                public final void clear() {
                    BinaryTree.this.clear();
                }
            };
        }
        return this._key_set[1];
    }

    public final Collection valuesByValue() {
        if (this._value_collection[1] == null) {
            this._value_collection[1] = new AbstractCollection(){

                public final Iterator iterator() {
                    return new BinaryTreeIterator(BinaryTree.this, 1){

                        protected final Object doGetNext() {
                            return this._last_returned_node.getData(1);
                        }
                    };
                }

                public final int size() {
                    return BinaryTree.this.size();
                }

                public final boolean contains(Object o) {
                    return BinaryTree.this.containsValue(o);
                }

                public final boolean remove(Object o) {
                    int old_size = BinaryTree.this._size;
                    BinaryTree.this.removeValue(o);
                    boolean bl = false;
                    if (BinaryTree.this._size != old_size) {
                        bl = true;
                    }
                    return bl;
                }

                public final boolean removeAll(Collection c) {
                    boolean modified = false;
                    Iterator iter = c.iterator();
                    while (iter.hasNext()) {
                        if (BinaryTree.this.removeValue(iter.next()) == null) continue;
                        modified = true;
                    }
                    return modified;
                }

                public final void clear() {
                    BinaryTree.this.clear();
                }
            };
        }
        return this._value_collection[1];
    }

    private final Object doRemove(Comparable o, int index) {
        Node node = this.lookup(o, index);
        Comparable rval = null;
        if (node != null) {
            rval = node.getData(this.oppositeIndex(index));
            this.doRedBlackDelete(node);
        }
        return rval;
    }

    private final Object doGet(Comparable o, int index) {
        BinaryTree.checkNonNullComparable(o, index);
        Node node = this.lookup(o, index);
        return node == null ? null : node.getData(this.oppositeIndex(index));
    }

    private final int oppositeIndex(int index) {
        return 1 - index;
    }

    private final Node lookup(Comparable data, int index) {
        Node rval = null;
        Node node = this._root[index];
        while (node != null) {
            int cmp = BinaryTree.compare(data, node.getData(index));
            if (cmp == 0) {
                rval = node;
                break;
            }
            Node node2 = node = cmp < 0 ? node.getLeft(index) : node.getRight(index);
        }
        return rval;
    }

    private static final int compare(Comparable o1, Comparable o2) {
        return o1.compareTo(o2);
    }

    private static final Node leastNode(Node node, int index) {
        Node rval = node;
        if (rval != null) {
            while (rval.getLeft(index) != null) {
                rval = rval.getLeft(index);
            }
        }
        return rval;
    }

    private final Node nextGreater(Node node, int index) {
        Node rval = null;
        if (node == null) {
            rval = null;
        } else if (node.getRight(index) != null) {
            rval = BinaryTree.leastNode(node.getRight(index), index);
        } else {
            Node parent = node.getParent(index);
            Node child = node;
            while (parent != null && child == parent.getRight(index)) {
                child = parent;
                parent = parent.getParent(index);
            }
            rval = parent;
        }
        return rval;
    }

    private static final void copyColor(Node from, Node to, int index) {
        if (to != null) {
            if (from == null) {
                to.setBlack(index);
            } else {
                to.copyColor(from, index);
            }
        }
    }

    private static final boolean isRed(Node node, int index) {
        boolean bl = false;
        if (node != null) {
            bl = node.isRed(index);
        }
        return bl;
    }

    private static final boolean isBlack(Node node, int index) {
        boolean bl = true;
        if (node != null) {
            bl = node.isBlack(index);
        }
        return bl;
    }

    private static final void makeRed(Node node, int index) {
        if (node != null) {
            node.setRed(index);
        }
    }

    private static final void makeBlack(Node node, int index) {
        if (node != null) {
            node.setBlack(index);
        }
    }

    private static final Node getGrandParent(Node node, int index) {
        return BinaryTree.getParent(BinaryTree.getParent(node, index), index);
    }

    private static final Node getParent(Node node, int index) {
        return node == null ? null : node.getParent(index);
    }

    private static final Node getRightChild(Node node, int index) {
        return node == null ? null : node.getRight(index);
    }

    private static final Node getLeftChild(Node node, int index) {
        return node == null ? null : node.getLeft(index);
    }

    private static final boolean isLeftChild(Node node, int index) {
        boolean bl = true;
        if (node != null) {
            bl = false;
            if (node.getParent(index) != null) {
                bl = false;
                if (node == node.getParent(index).getLeft(index)) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private static final boolean isRightChild(Node node, int index) {
        boolean bl = true;
        if (node != null) {
            bl = false;
            if (node.getParent(index) != null) {
                bl = false;
                if (node == node.getParent(index).getRight(index)) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private final void rotateLeft(Node node, int index) {
        Node right_child = node.getRight(index);
        node.setRight(right_child.getLeft(index), index);
        if (right_child.getLeft(index) != null) {
            right_child.getLeft(index).setParent(node, index);
        }
        right_child.setParent(node.getParent(index), index);
        if (node.getParent(index) == null) {
            this._root[index] = right_child;
        } else if (node.getParent(index).getLeft(index) == node) {
            node.getParent(index).setLeft(right_child, index);
        } else {
            node.getParent(index).setRight(right_child, index);
        }
        right_child.setLeft(node, index);
        node.setParent(right_child, index);
    }

    private final void rotateRight(Node node, int index) {
        Node left_child = node.getLeft(index);
        node.setLeft(left_child.getRight(index), index);
        if (left_child.getRight(index) != null) {
            left_child.getRight(index).setParent(node, index);
        }
        left_child.setParent(node.getParent(index), index);
        if (node.getParent(index) == null) {
            this._root[index] = left_child;
        } else if (node.getParent(index).getRight(index) == node) {
            node.getParent(index).setRight(left_child, index);
        } else {
            node.getParent(index).setLeft(left_child, index);
        }
        left_child.setRight(node, index);
        node.setParent(left_child, index);
    }

    private final void doRedBlackInsert(Node inserted_node, int index) {
        Node current_node = inserted_node;
        BinaryTree.makeRed(current_node, index);
        while (current_node != null && current_node != this._root[index] && BinaryTree.isRed(current_node.getParent(index), index)) {
            Node y;
            if (BinaryTree.isLeftChild(BinaryTree.getParent(current_node, index), index)) {
                y = BinaryTree.getRightChild(BinaryTree.getGrandParent(current_node, index), index);
                if (BinaryTree.isRed(y, index)) {
                    BinaryTree.makeBlack(BinaryTree.getParent(current_node, index), index);
                    BinaryTree.makeBlack(y, index);
                    BinaryTree.makeRed(BinaryTree.getGrandParent(current_node, index), index);
                    current_node = BinaryTree.getGrandParent(current_node, index);
                    continue;
                }
                if (BinaryTree.isRightChild(current_node, index)) {
                    current_node = BinaryTree.getParent(current_node, index);
                    this.rotateLeft(current_node, index);
                }
                BinaryTree.makeBlack(BinaryTree.getParent(current_node, index), index);
                BinaryTree.makeRed(BinaryTree.getGrandParent(current_node, index), index);
                if (BinaryTree.getGrandParent(current_node, index) == null) continue;
                this.rotateRight(BinaryTree.getGrandParent(current_node, index), index);
                continue;
            }
            y = BinaryTree.getLeftChild(BinaryTree.getGrandParent(current_node, index), index);
            if (BinaryTree.isRed(y, index)) {
                BinaryTree.makeBlack(BinaryTree.getParent(current_node, index), index);
                BinaryTree.makeBlack(y, index);
                BinaryTree.makeRed(BinaryTree.getGrandParent(current_node, index), index);
                current_node = BinaryTree.getGrandParent(current_node, index);
                continue;
            }
            if (BinaryTree.isLeftChild(current_node, index)) {
                current_node = BinaryTree.getParent(current_node, index);
                this.rotateRight(current_node, index);
            }
            BinaryTree.makeBlack(BinaryTree.getParent(current_node, index), index);
            BinaryTree.makeRed(BinaryTree.getGrandParent(current_node, index), index);
            if (BinaryTree.getGrandParent(current_node, index) == null) continue;
            this.rotateLeft(BinaryTree.getGrandParent(current_node, index), index);
        }
        BinaryTree.makeBlack(this._root[index], index);
    }

    private final void doRedBlackDelete(Node deleted_node) {
        int index = 0;
        while (index < 2) {
            Node replacement;
            if (deleted_node.getLeft(index) != null && deleted_node.getRight(index) != null) {
                this.swapPosition(this.nextGreater(deleted_node, index), deleted_node, index);
            }
            Node node = replacement = deleted_node.getLeft(index) != null ? deleted_node.getLeft(index) : deleted_node.getRight(index);
            if (replacement != null) {
                replacement.setParent(deleted_node.getParent(index), index);
                if (deleted_node.getParent(index) == null) {
                    this._root[index] = replacement;
                } else if (deleted_node == deleted_node.getParent(index).getLeft(index)) {
                    deleted_node.getParent(index).setLeft(replacement, index);
                } else {
                    deleted_node.getParent(index).setRight(replacement, index);
                }
                deleted_node.setLeft(null, index);
                deleted_node.setRight(null, index);
                deleted_node.setParent(null, index);
                if (BinaryTree.isBlack(deleted_node, index)) {
                    this.doRedBlackDeleteFixup(replacement, index);
                }
            } else if (deleted_node.getParent(index) == null) {
                this._root[index] = null;
            } else {
                if (BinaryTree.isBlack(deleted_node, index)) {
                    this.doRedBlackDeleteFixup(deleted_node, index);
                }
                if (deleted_node.getParent(index) != null) {
                    if (deleted_node == deleted_node.getParent(index).getLeft(index)) {
                        deleted_node.getParent(index).setLeft(null, index);
                    } else {
                        deleted_node.getParent(index).setRight(null, index);
                    }
                    deleted_node.setParent(null, index);
                }
            }
            ++index;
        }
        this.shrink();
    }

    private final void doRedBlackDeleteFixup(Node replacement_node, int index) {
        Node current_node = replacement_node;
        while (current_node != this._root[index] && BinaryTree.isBlack(current_node, index)) {
            Node sibling_node;
            if (BinaryTree.isLeftChild(current_node, index)) {
                sibling_node = BinaryTree.getRightChild(BinaryTree.getParent(current_node, index), index);
                if (BinaryTree.isRed(sibling_node, index)) {
                    BinaryTree.makeBlack(sibling_node, index);
                    BinaryTree.makeRed(BinaryTree.getParent(current_node, index), index);
                    this.rotateLeft(BinaryTree.getParent(current_node, index), index);
                    sibling_node = BinaryTree.getRightChild(BinaryTree.getParent(current_node, index), index);
                }
                if (BinaryTree.isBlack(BinaryTree.getLeftChild(sibling_node, index), index) && BinaryTree.isBlack(BinaryTree.getRightChild(sibling_node, index), index)) {
                    BinaryTree.makeRed(sibling_node, index);
                    current_node = BinaryTree.getParent(current_node, index);
                    continue;
                }
                if (BinaryTree.isBlack(BinaryTree.getRightChild(sibling_node, index), index)) {
                    BinaryTree.makeBlack(BinaryTree.getLeftChild(sibling_node, index), index);
                    BinaryTree.makeRed(sibling_node, index);
                    this.rotateRight(sibling_node, index);
                    sibling_node = BinaryTree.getRightChild(BinaryTree.getParent(current_node, index), index);
                }
                BinaryTree.copyColor(BinaryTree.getParent(current_node, index), sibling_node, index);
                BinaryTree.makeBlack(BinaryTree.getParent(current_node, index), index);
                BinaryTree.makeBlack(BinaryTree.getRightChild(sibling_node, index), index);
                this.rotateLeft(BinaryTree.getParent(current_node, index), index);
                current_node = this._root[index];
                continue;
            }
            sibling_node = BinaryTree.getLeftChild(BinaryTree.getParent(current_node, index), index);
            if (BinaryTree.isRed(sibling_node, index)) {
                BinaryTree.makeBlack(sibling_node, index);
                BinaryTree.makeRed(BinaryTree.getParent(current_node, index), index);
                this.rotateRight(BinaryTree.getParent(current_node, index), index);
                sibling_node = BinaryTree.getLeftChild(BinaryTree.getParent(current_node, index), index);
            }
            if (BinaryTree.isBlack(BinaryTree.getRightChild(sibling_node, index), index) && BinaryTree.isBlack(BinaryTree.getLeftChild(sibling_node, index), index)) {
                BinaryTree.makeRed(sibling_node, index);
                current_node = BinaryTree.getParent(current_node, index);
                continue;
            }
            if (BinaryTree.isBlack(BinaryTree.getLeftChild(sibling_node, index), index)) {
                BinaryTree.makeBlack(BinaryTree.getRightChild(sibling_node, index), index);
                BinaryTree.makeRed(sibling_node, index);
                this.rotateLeft(sibling_node, index);
                sibling_node = BinaryTree.getLeftChild(BinaryTree.getParent(current_node, index), index);
            }
            BinaryTree.copyColor(BinaryTree.getParent(current_node, index), sibling_node, index);
            BinaryTree.makeBlack(BinaryTree.getParent(current_node, index), index);
            BinaryTree.makeBlack(BinaryTree.getLeftChild(sibling_node, index), index);
            this.rotateRight(BinaryTree.getParent(current_node, index), index);
            current_node = this._root[index];
        }
        BinaryTree.makeBlack(current_node, index);
    }

    private final void swapPosition(Node x, Node y, int index) {
        boolean y_was_left_child;
        Node x_old_parent = x.getParent(index);
        Node x_old_left_child = x.getLeft(index);
        Node x_old_right_child = x.getRight(index);
        Node y_old_parent = y.getParent(index);
        Node y_old_left_child = y.getLeft(index);
        Node y_old_right_child = y.getRight(index);
        boolean bl = false;
        if (x.getParent(index) != null && x == x.getParent(index).getLeft(index)) {
            bl = true;
        }
        boolean x_was_left_child = bl;
        boolean bl2 = false;
        if (y.getParent(index) != null && y == y.getParent(index).getLeft(index)) {
            bl2 = y_was_left_child = true;
        }
        if (x == y_old_parent) {
            x.setParent(y, index);
            if (y_was_left_child) {
                y.setLeft(x, index);
                y.setRight(x_old_right_child, index);
            } else {
                y.setRight(x, index);
                y.setLeft(x_old_left_child, index);
            }
        } else {
            x.setParent(y_old_parent, index);
            if (y_old_parent != null) {
                if (y_was_left_child) {
                    y_old_parent.setLeft(x, index);
                } else {
                    y_old_parent.setRight(x, index);
                }
            }
            y.setLeft(x_old_left_child, index);
            y.setRight(x_old_right_child, index);
        }
        if (y == x_old_parent) {
            y.setParent(x, index);
            if (x_was_left_child) {
                x.setLeft(y, index);
                x.setRight(y_old_right_child, index);
            } else {
                x.setRight(y, index);
                x.setLeft(y_old_left_child, index);
            }
        } else {
            y.setParent(x_old_parent, index);
            if (x_old_parent != null) {
                if (x_was_left_child) {
                    x_old_parent.setLeft(y, index);
                } else {
                    x_old_parent.setRight(y, index);
                }
            }
            x.setLeft(y_old_left_child, index);
            x.setRight(y_old_right_child, index);
        }
        if (x.getLeft(index) != null) {
            x.getLeft(index).setParent(x, index);
        }
        if (x.getRight(index) != null) {
            x.getRight(index).setParent(x, index);
        }
        if (y.getLeft(index) != null) {
            y.getLeft(index).setParent(y, index);
        }
        if (y.getRight(index) != null) {
            y.getRight(index).setParent(y, index);
        }
        x.swapColors(y, index);
        if (this._root[index] == x) {
            this._root[index] = y;
        } else if (this._root[index] == y) {
            this._root[index] = x;
        }
    }

    private static final void checkNonNullComparable(Object o, int index) {
        if (o == null) {
            throw new NullPointerException(_data_name[index] + " cannot be null");
        }
        if (!(o instanceof Comparable)) {
            throw new ClassCastException(_data_name[index] + " must be Comparable");
        }
    }

    private static final void checkKey(Object key) {
        BinaryTree.checkNonNullComparable(key, 0);
    }

    private static final void checkValue(Object value) {
        BinaryTree.checkNonNullComparable(value, 1);
    }

    private static final void checkKeyAndValue(Object key, Object value) {
        BinaryTree.checkKey(key);
        BinaryTree.checkValue(value);
    }

    private final void modify() {
        ++this._modifications;
    }

    private final void grow() {
        this.modify();
        ++this._size;
    }

    private final void shrink() {
        this.modify();
        --this._size;
    }

    private final void insertValue(Node newNode) throws IllegalArgumentException {
        block4: {
            Node node = this._root[1];
            while (true) {
                int cmp;
                if ((cmp = BinaryTree.compare(newNode.getData(1), node.getData(1))) == 0) {
                    throw new IllegalArgumentException("Cannot store a duplicate value (\"" + newNode.getData(1) + "\") in this Map");
                }
                if (cmp < 0) {
                    if (node.getLeft(1) != null) {
                        node = node.getLeft(1);
                        continue;
                    }
                    node.setLeft(newNode, 1);
                    newNode.setParent(node, 1);
                    this.doRedBlackInsert(newNode, 1);
                    break block4;
                }
                if (node.getRight(1) == null) break;
                node = node.getRight(1);
            }
            node.setRight(newNode, 1);
            newNode.setParent(node, 1);
            this.doRedBlackInsert(newNode, 1);
        }
    }

    public final int size() {
        return this._size;
    }

    public final boolean containsKey(Object key) throws ClassCastException, NullPointerException {
        BinaryTree.checkKey(key);
        boolean bl = false;
        if (this.lookup((Comparable)key, 0) != null) {
            bl = true;
        }
        return bl;
    }

    public final boolean containsValue(Object value) {
        BinaryTree.checkValue(value);
        boolean bl = false;
        if (this.lookup((Comparable)value, 1) != null) {
            bl = true;
        }
        return bl;
    }

    public final Object get(Object key) throws ClassCastException, NullPointerException {
        return this.doGet((Comparable)key, 0);
    }

    public final Object put(Object key, Object value) throws ClassCastException, NullPointerException, IllegalArgumentException {
        block6: {
            BinaryTree.checkKeyAndValue(key, value);
            Node node = this._root[0];
            if (node == null) {
                Node root;
                this._root[0] = root = new Node((Comparable)key, (Comparable)value);
                this._root[1] = root;
                this.grow();
            } else {
                while (true) {
                    int cmp;
                    if ((cmp = BinaryTree.compare((Comparable)key, node.getData(0))) == 0) {
                        throw new IllegalArgumentException("Cannot store a duplicate key (\"" + key + "\") in this Map");
                    }
                    if (cmp < 0) {
                        if (node.getLeft(0) != null) {
                            node = node.getLeft(0);
                            continue;
                        }
                        Node newNode = new Node((Comparable)key, (Comparable)value);
                        this.insertValue(newNode);
                        node.setLeft(newNode, 0);
                        newNode.setParent(node, 0);
                        this.doRedBlackInsert(newNode, 0);
                        this.grow();
                        break block6;
                    }
                    if (node.getRight(0) == null) break;
                    node = node.getRight(0);
                }
                Node newNode = new Node((Comparable)key, (Comparable)value);
                this.insertValue(newNode);
                node.setRight(newNode, 0);
                newNode.setParent(node, 0);
                this.doRedBlackInsert(newNode, 0);
                this.grow();
            }
        }
        return null;
    }

    public final Object remove(Object key) {
        return this.doRemove((Comparable)key, 0);
    }

    public final void clear() {
        this.modify();
        this._size = 0;
        this._root[0] = null;
        this._root[1] = null;
    }

    public final Set keySet() {
        if (this._key_set[0] == null) {
            this._key_set[0] = new AbstractSet(){

                public final Iterator iterator() {
                    return new BinaryTreeIterator(BinaryTree.this, 0){

                        protected final Object doGetNext() {
                            return this._last_returned_node.getData(0);
                        }
                    };
                }

                public final int size() {
                    return BinaryTree.this.size();
                }

                public final boolean contains(Object o) {
                    return BinaryTree.this.containsKey(o);
                }

                public final boolean remove(Object o) {
                    int old_size = BinaryTree.this._size;
                    BinaryTree.this.remove(o);
                    boolean bl = false;
                    if (BinaryTree.this._size != old_size) {
                        bl = true;
                    }
                    return bl;
                }

                public final void clear() {
                    BinaryTree.this.clear();
                }
            };
        }
        return this._key_set[0];
    }

    public final Collection values() {
        if (this._value_collection[0] == null) {
            this._value_collection[0] = new AbstractCollection(){

                public final Iterator iterator() {
                    return new BinaryTreeIterator(BinaryTree.this, 0){

                        protected final Object doGetNext() {
                            return this._last_returned_node.getData(1);
                        }
                    };
                }

                public final int size() {
                    return BinaryTree.this.size();
                }

                public final boolean contains(Object o) {
                    return BinaryTree.this.containsValue(o);
                }

                public final boolean remove(Object o) {
                    int old_size = BinaryTree.this._size;
                    BinaryTree.this.removeValue(o);
                    boolean bl = false;
                    if (BinaryTree.this._size != old_size) {
                        bl = true;
                    }
                    return bl;
                }

                public final boolean removeAll(Collection c) {
                    boolean modified = false;
                    Iterator iter = c.iterator();
                    while (iter.hasNext()) {
                        if (BinaryTree.this.removeValue(iter.next()) == null) continue;
                        modified = true;
                    }
                    return modified;
                }

                public final void clear() {
                    BinaryTree.this.clear();
                }
            };
        }
        return this._value_collection[0];
    }

    public final Set entrySet() {
        if (this._entry_set[0] == null) {
            this._entry_set[0] = new AbstractSet(){

                public final Iterator iterator() {
                    return new BinaryTreeIterator(BinaryTree.this, 0){

                        protected final Object doGetNext() {
                            return this._last_returned_node;
                        }
                    };
                }

                public final boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object value = entry.getValue();
                    Node node = BinaryTree.this.lookup((Comparable)entry.getKey(), 0);
                    boolean bl = false;
                    if (node != null && node.getData(1).equals(value)) {
                        bl = true;
                    }
                    return bl;
                }

                public final boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object value = entry.getValue();
                    Node node = BinaryTree.this.lookup((Comparable)entry.getKey(), 0);
                    if (node != null && node.getData(1).equals(value)) {
                        BinaryTree.this.doRedBlackDelete(node);
                        return true;
                    }
                    return false;
                }

                public final int size() {
                    return BinaryTree.this.size();
                }

                public final void clear() {
                    BinaryTree.this.clear();
                }
            };
        }
        return this._entry_set[0];
    }

    static final /* synthetic */ int access$0() {
        return 1;
    }

    static final /* synthetic */ int access$2() {
        return 0;
    }

    private final /* synthetic */ void this() {
        this._root = new Node[2];
        this._size = 0;
        this._modifications = 0;
        this._key_set = new Set[2];
        this._entry_set = new Set[2];
        this._value_collection = new Collection[2];
    }

    public BinaryTree() {
        this.this();
    }

    public BinaryTree(Map map) throws ClassCastException, NullPointerException, IllegalArgumentException {
        this.this();
        this.putAll(map);
    }

    private static final class Node
    implements Map.Entry {
        private Comparable[] _data;
        private Node[] _left;
        private Node[] _right;
        private Node[] _parent;
        private boolean[] _black;
        private int _hashcode;
        private boolean _calculated_hashcode;

        private final Comparable getData(int index) {
            return this._data[index];
        }

        private final void setLeft(Node node, int index) {
            this._left[index] = node;
        }

        private final Node getLeft(int index) {
            return this._left[index];
        }

        private final void setRight(Node node, int index) {
            this._right[index] = node;
        }

        private final Node getRight(int index) {
            return this._right[index];
        }

        private final void setParent(Node node, int index) {
            this._parent[index] = node;
        }

        private final Node getParent(int index) {
            return this._parent[index];
        }

        private final void swapColors(Node node, int index) {
            int n = index;
            this._black[n] = this._black[n] ^ node._black[index];
            int n2 = index;
            node._black[n2] = node._black[n2] ^ this._black[index];
            int n3 = index;
            this._black[n3] = this._black[n3] ^ node._black[index];
        }

        private final boolean isBlack(int index) {
            return this._black[index];
        }

        private final boolean isRed(int index) {
            return this._black[index] ^ true;
        }

        private final void setBlack(int index) {
            this._black[index] = true;
        }

        private final void setRed(int index) {
            this._black[index] = false;
        }

        private final void copyColor(Node node, int index) {
            this._black[index] = node._black[index];
        }

        public final Object getKey() {
            return this._data[0];
        }

        public final Object getValue() {
            return this._data[1];
        }

        public final Object setValue(Object ignored) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Map.Entry.setValue is not supported");
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            boolean bl = false;
            if (this._data[0].equals(e.getKey()) && this._data[1].equals(e.getValue())) {
                bl = true;
            }
            return bl;
        }

        public final int hashCode() {
            if (!this._calculated_hashcode) {
                this._hashcode = this._data[0].hashCode() ^ this._data[1].hashCode();
                this._calculated_hashcode = true;
            }
            return this._hashcode;
        }

        Node(Comparable key, Comparable value) {
            this._data = new Comparable[]{key, value};
            this._left = new Node[2];
            this._right = new Node[2];
            this._parent = new Node[2];
            this._black = new boolean[]{true, true};
            this._calculated_hashcode = false;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private abstract class BinaryTreeIterator
    implements Iterator {
        private int _expected_modifications;
        protected Node _last_returned_node;
        private Node _next_node;
        private int _type;

        protected abstract Object doGetNext();

        public final boolean hasNext() {
            boolean bl = false;
            if (this._next_node != null) {
                bl = true;
            }
            return bl;
        }

        public final Object next() throws NoSuchElementException, ConcurrentModificationException {
            if (this._next_node == null) {
                throw new NoSuchElementException();
            }
            if (BinaryTree.this._modifications != this._expected_modifications) {
                throw new ConcurrentModificationException();
            }
            this._last_returned_node = this._next_node;
            this._next_node = BinaryTree.this.nextGreater(this._next_node, this._type);
            return this.doGetNext();
        }

        public final void remove() throws IllegalStateException, ConcurrentModificationException {
            if (this._last_returned_node == null) {
                throw new IllegalStateException();
            }
            if (BinaryTree.this._modifications != this._expected_modifications) {
                throw new ConcurrentModificationException();
            }
            BinaryTree.this.doRedBlackDelete(this._last_returned_node);
            ++this._expected_modifications;
            this._last_returned_node = null;
        }

        BinaryTreeIterator(int type) {
            this._type = type;
            this._expected_modifications = BinaryTree.this._modifications;
            this._last_returned_node = null;
            this._next_node = BinaryTree.leastNode(BinaryTree.this._root[this._type], this._type);
        }
    }
}

