/* fep.c generated by valac 0.14.2, the Vala compiler
 * generated from fep.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Daiki Ueno <ueno@unixuser.org>
 * Copyright (C) 2011-2012 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <stdio.h>
#include <libskk/libskk.h>
#include <gee.h>
#include <libfep-glib/libfep-glib.h>


#define SKK_TYPE_TOOL (skk_tool_get_type ())
#define SKK_TOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_TOOL, SkkTool))
#define SKK_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_TOOL, SkkToolClass))
#define SKK_IS_TOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_TOOL))
#define SKK_IS_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_TOOL))
#define SKK_TOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_TOOL, SkkToolClass))

typedef struct _SkkTool SkkTool;
typedef struct _SkkToolClass SkkToolClass;
typedef struct _SkkToolPrivate SkkToolPrivate;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SKK_TYPE_FEP_TOOL (skk_fep_tool_get_type ())
#define SKK_FEP_TOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_FEP_TOOL, SkkFepTool))
#define SKK_FEP_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_FEP_TOOL, SkkFepToolClass))
#define SKK_IS_FEP_TOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_FEP_TOOL))
#define SKK_IS_FEP_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_FEP_TOOL))
#define SKK_FEP_TOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_FEP_TOOL, SkkFepToolClass))

typedef struct _SkkFepTool SkkFepTool;
typedef struct _SkkFepToolClass SkkFepToolClass;
typedef struct _SkkFepToolPrivate SkkFepToolPrivate;

#define SKK_FEP_TOOL_TYPE_ENTRY (skk_fep_tool_entry_get_type ())
typedef struct _SkkFepToolEntry SkkFepToolEntry;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))

struct _SkkTool {
	GObject parent_instance;
	SkkToolPrivate * priv;
};

struct _SkkToolClass {
	GObjectClass parent_class;
	gboolean (*run) (SkkTool* self);
};

struct _SkkFepTool {
	SkkTool parent_instance;
	SkkFepToolPrivate * priv;
};

struct _SkkFepToolClass {
	SkkToolClass parent_class;
};

struct _SkkFepToolPrivate {
	SkkContext* context;
	FepGClient* client;
	gchar** LOOKUP_TABLE_LABELS;
	gint LOOKUP_TABLE_LABELS_length1;
	gint _LOOKUP_TABLE_LABELS_size_;
	gboolean lookup_table_visible;
	gchar* preedit;
	gchar* status;
	FepGAttribute* status_attr;
	SkkInputMode input_mode;
};

struct _SkkFepToolEntry {
	gpointer key;
	gpointer value;
};


static gpointer skk_tool_parent_class = NULL;
static gchar* skk_tool_file_dict;
static gchar* skk_tool_file_dict = NULL;
static gchar* skk_tool_user_dict;
static gchar* skk_tool_user_dict = NULL;
static gchar* skk_tool_skkserv;
static gchar* skk_tool_skkserv = NULL;
static gchar* skk_tool_typing_rule;
static gchar* skk_tool_typing_rule = NULL;
static gboolean skk_tool_list_typing_rules;
static gboolean skk_tool_list_typing_rules = FALSE;
static gpointer skk_fep_tool_parent_class = NULL;

GType skk_tool_get_type (void) G_GNUC_CONST;
enum  {
	SKK_TOOL_DUMMY_PROPERTY
};
gint skk_tool_main (gchar** args, int args_length1);
static void _vala_SkkRuleMetadata_array_free (SkkRuleMetadata* array, gint array_length);
SkkFepTool* skk_fep_tool_new (SkkContext* context, GError** error);
SkkFepTool* skk_fep_tool_construct (GType object_type, SkkContext* context, GError** error);
GType skk_fep_tool_get_type (void) G_GNUC_CONST;
gboolean skk_tool_run (SkkTool* self);
static gboolean skk_tool_real_run (SkkTool* self);
SkkTool* skk_tool_construct (GType object_type);
static void skk_tool_finalize (GObject* obj);
#define SKK_FEP_TOOL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SKK_TYPE_FEP_TOOL, SkkFepToolPrivate))
enum  {
	SKK_FEP_TOOL_DUMMY_PROPERTY
};
static GType skk_fep_tool_entry_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SkkFepToolEntry* skk_fep_tool_entry_dup (const SkkFepToolEntry* self);
static void skk_fep_tool_entry_free (SkkFepToolEntry* self);
static void skk_fep_tool_entry_copy (const SkkFepToolEntry* self, SkkFepToolEntry* dest);
static void skk_fep_tool_entry_destroy (SkkFepToolEntry* self);
static gboolean skk_fep_tool_process_lookup_table_key_event (SkkFepTool* self, guint keyval, guint state);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void skk_fep_tool_set_lookup_table_cursor_pos (SkkFepTool* self);
static void skk_fep_tool_update_preedit (SkkFepTool* self);
static gboolean skk_fep_tool_filter_key_event (SkkFepTool* self, guint keyval, guint modifiers);
static void skk_fep_tool_update_status (SkkFepTool* self);
static FepGAttribute* _fep_g_attribute_dup (FepGAttribute* self);
static gboolean _fep_g_attribute_equal (const FepGAttribute* s1, const FepGAttribute* s2);
static void skk_fep_tool_populate_lookup_table (SkkFepTool* self);
static gboolean skk_fep_tool_watch_func (SkkFepTool* self, GIOChannel* source, GIOCondition condition);
static gboolean skk_fep_tool_real_run (SkkTool* base);
static gboolean __lambda0_ (SkkFepTool* self, guint keyval, guint _modifiers);
static gboolean ___lambda0__fep_g_client_filter_key_event (FepGClient* _sender, guint keyval, guint modifiers, gpointer self);
static void __lambda1_ (SkkFepTool* self);
static void ___lambda1__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda2_ (SkkFepTool* self);
static void ___lambda2__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda3_ (SkkFepTool* self);
static void ___lambda3__skk_candidate_list_populated (SkkCandidateList* _sender, gpointer self);
static void __lambda4_ (SkkFepTool* self);
static void ___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda5_ (SkkFepTool* self);
static void ___lambda5__skk_candidate_list_selected (SkkCandidateList* _sender, SkkCandidate* candidate, gpointer self);
static gboolean _skk_fep_tool_watch_func_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static void skk_fep_tool_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry SKK_TOOL_options[6] = {{"file-dict", 'f', 0, G_OPTION_ARG_STRING, &skk_tool_file_dict, "Path to a file dictionary", NULL}, {"user-dict", 'u', 0, G_OPTION_ARG_STRING, &skk_tool_user_dict, "Path to a user dictionary", NULL}, {"skkserv", 's', 0, G_OPTION_ARG_STRING, &skk_tool_skkserv, "Host and port running skkserv (HOST:PORT)", NULL}, {"rule", 'r', 0, G_OPTION_ARG_STRING, &skk_tool_typing_rule, "Typing rule (default: \"default\")", NULL}, {"list-rules", 'l', 0, G_OPTION_ARG_NONE, &skk_tool_list_typing_rules, "List typing rules", NULL}, {NULL}};
static const SkkFepToolEntry SKK_FEP_TOOL_input_mode_labels[5] = {{SKK_INPUT_MODE_HIRAGANA, "あ"}, {SKK_INPUT_MODE_KATAKANA, "ア"}, {SKK_INPUT_MODE_HANKAKU_KATAKANA, "_ｱ"}, {SKK_INPUT_MODE_LATIN, "_A"}, {SKK_INPUT_MODE_WIDE_LATIN, "Ａ"}};

static void _vala_SkkRuleMetadata_array_free (SkkRuleMetadata* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			skk_rule_metadata_destroy (&array[i]);
		}
	}
	g_free (array);
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


gint skk_tool_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_;
	GOptionContext* option_context;
	GOptionContext* _tmp2_;
	gboolean _tmp7_;
	GeeArrayList* _tmp19_;
	GeeArrayList* dictionaries;
	const gchar* _tmp20_;
	const gchar* _tmp30_;
	const gchar* _tmp58_;
	GeeArrayList* _tmp86_;
	gint _tmp87_ = 0;
	gpointer* _tmp88_ = NULL;
	SkkDict** _tmp89_;
	gint _tmp89__length1;
	SkkContext* _tmp90_;
	SkkContext* _tmp91_;
	SkkContext* context;
	const gchar* _tmp92_;
	SkkContext* _tmp102_;
	SkkFepTool* _tmp103_;
	SkkFepTool* tool;
	SkkFepTool* _tmp104_;
	gboolean _tmp105_ = FALSE;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = _ ("- emulate SKK input method on the command line");
	_tmp1_ = g_option_context_new (_tmp0_);
	option_context = _tmp1_;
	_tmp2_ = option_context;
	g_option_context_add_main_entries (_tmp2_, SKK_TOOL_options, "libskk");
	{
		GOptionContext* _tmp3_;
		_tmp3_ = option_context;
		g_option_context_parse (_tmp3_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (option_context);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (option_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	skk_init ();
	_tmp7_ = skk_tool_list_typing_rules;
	if (_tmp7_) {
		gint _tmp8_ = 0;
		SkkRuleMetadata* _tmp9_ = NULL;
		SkkRuleMetadata* rules;
		gint rules_length1;
		gint _rules_size_;
		SkkRuleMetadata* _tmp10_;
		gint _tmp10__length1;
		_tmp9_ = skk_rule_list (&_tmp8_);
		rules = _tmp9_;
		rules_length1 = _tmp8_;
		_rules_size_ = rules_length1;
		_tmp10_ = rules;
		_tmp10__length1 = rules_length1;
		{
			SkkRuleMetadata* rule_collection = NULL;
			gint rule_collection_length1 = 0;
			gint _rule_collection_size_ = 0;
			gint rule_it = 0;
			rule_collection = _tmp10_;
			rule_collection_length1 = _tmp10__length1;
			for (rule_it = 0; rule_it < _tmp10__length1; rule_it = rule_it + 1) {
				SkkRuleMetadata _tmp11_ = {0};
				SkkRuleMetadata rule = {0};
				skk_rule_metadata_copy (&rule_collection[rule_it], &_tmp11_);
				rule = _tmp11_;
				{
					FILE* _tmp12_;
					SkkRuleMetadata _tmp13_;
					const gchar* _tmp14_;
					SkkRuleMetadata _tmp15_;
					const gchar* _tmp16_;
					SkkRuleMetadata _tmp17_;
					const gchar* _tmp18_;
					_tmp12_ = stdout;
					_tmp13_ = rule;
					_tmp14_ = _tmp13_.name;
					_tmp15_ = rule;
					_tmp16_ = _tmp15_.label;
					_tmp17_ = rule;
					_tmp18_ = _tmp17_.description;
					fprintf (_tmp12_, "%s - %s: %s\n", _tmp14_, _tmp16_, _tmp18_);
					skk_rule_metadata_destroy (&rule);
				}
			}
		}
		result = 0;
		rules = (_vala_SkkRuleMetadata_array_free (rules, rules_length1), NULL);
		_g_option_context_free0 (option_context);
		return result;
	}
	_tmp19_ = gee_array_list_new (SKK_TYPE_DICT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	dictionaries = _tmp19_;
	_tmp20_ = skk_tool_user_dict;
	if (_tmp20_ != NULL) {
		{
			const gchar* _tmp21_;
			SkkUserDict* _tmp22_;
			SkkUserDict* _tmp23_;
			GeeArrayList* _tmp24_;
			SkkUserDict* _tmp25_;
			_tmp21_ = skk_tool_user_dict;
			_tmp22_ = skk_user_dict_new (_tmp21_, "UTF-8", &_inner_error_);
			_tmp23_ = _tmp22_;
			if (_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
			_tmp24_ = dictionaries;
			_tmp25_ = _tmp23_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, (SkkDict*) _tmp25_);
			_g_object_unref0 (_tmp25_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			FILE* _tmp26_;
			const gchar* _tmp27_;
			GError* _tmp28_;
			const gchar* _tmp29_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp26_ = stderr;
			_tmp27_ = skk_tool_user_dict;
			_tmp28_ = e;
			_tmp29_ = _tmp28_->message;
			fprintf (_tmp26_, "can't open user dict %s: %s", _tmp27_, _tmp29_);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp30_ = skk_tool_file_dict;
	if (_tmp30_ != NULL) {
		const gchar* _tmp31_;
		gboolean _tmp32_ = FALSE;
		_tmp31_ = skk_tool_file_dict;
		_tmp32_ = g_str_has_suffix (_tmp31_, ".cdb");
		if (_tmp32_) {
			{
				const gchar* _tmp33_;
				SkkCdbDict* _tmp34_;
				SkkCdbDict* _tmp35_;
				GeeArrayList* _tmp36_;
				SkkCdbDict* _tmp37_;
				_tmp33_ = skk_tool_file_dict;
				_tmp34_ = skk_cdb_dict_new (_tmp33_, "EUC-JP", &_inner_error_);
				_tmp35_ = _tmp34_;
				if (_inner_error_ != NULL) {
					goto __catch2_g_error;
				}
				_tmp36_ = dictionaries;
				_tmp37_ = _tmp35_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp36_, (SkkDict*) _tmp37_);
				_g_object_unref0 (_tmp37_);
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* e = NULL;
				FILE* _tmp38_;
				const gchar* _tmp39_;
				GError* _tmp40_;
				const gchar* _tmp41_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp38_ = stderr;
				_tmp39_ = skk_tool_file_dict;
				_tmp40_ = e;
				_tmp41_ = _tmp40_->message;
				fprintf (_tmp38_, "can't open CDB dict %s: %s", _tmp39_, _tmp41_);
				result = 1;
				_g_error_free0 (e);
				_g_object_unref0 (dictionaries);
				_g_option_context_free0 (option_context);
				return result;
			}
			__finally2:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (dictionaries);
				_g_option_context_free0 (option_context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		} else {
			{
				const gchar* _tmp42_;
				SkkFileDict* _tmp43_;
				SkkFileDict* _tmp44_;
				GeeArrayList* _tmp45_;
				SkkFileDict* _tmp46_;
				_tmp42_ = skk_tool_file_dict;
				_tmp43_ = skk_file_dict_new (_tmp42_, "EUC-JP", &_inner_error_);
				_tmp44_ = _tmp43_;
				if (_inner_error_ != NULL) {
					goto __catch3_g_error;
				}
				_tmp45_ = dictionaries;
				_tmp46_ = _tmp44_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp45_, (SkkDict*) _tmp46_);
				_g_object_unref0 (_tmp46_);
			}
			goto __finally3;
			__catch3_g_error:
			{
				GError* e = NULL;
				FILE* _tmp47_;
				const gchar* _tmp48_;
				GError* _tmp49_;
				const gchar* _tmp50_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp47_ = stderr;
				_tmp48_ = skk_tool_file_dict;
				_tmp49_ = e;
				_tmp50_ = _tmp49_->message;
				fprintf (_tmp47_, "can't open file dict %s: %s", _tmp48_, _tmp50_);
				result = 1;
				_g_error_free0 (e);
				_g_object_unref0 (dictionaries);
				_g_option_context_free0 (option_context);
				return result;
			}
			__finally3:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (dictionaries);
				_g_option_context_free0 (option_context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	} else {
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_;
		SkkFileDict* _tmp53_;
		SkkFileDict* _tmp54_;
		SkkFileDict* _tmp55_;
		GeeArrayList* _tmp56_;
		SkkFileDict* _tmp57_;
		_tmp51_ = g_build_filename (DATADIR, "skk", "SKK-JISYO.L", NULL);
		_tmp52_ = _tmp51_;
		_tmp53_ = skk_file_dict_new (_tmp52_, "EUC-JP", &_inner_error_);
		_tmp54_ = _tmp53_;
		_g_free0 (_tmp52_);
		_tmp55_ = _tmp54_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp56_ = dictionaries;
		_tmp57_ = _tmp55_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, (SkkDict*) _tmp57_);
		_g_object_unref0 (_tmp57_);
	}
	_tmp58_ = skk_tool_skkserv;
	if (_tmp58_ != NULL) {
		const gchar* _tmp59_;
		gint _tmp60_ = 0;
		gint index;
		gchar* host = NULL;
		guint16 port = 0U;
		gint _tmp61_;
		_tmp59_ = skk_tool_skkserv;
		_tmp60_ = string_last_index_of (_tmp59_, ":", 0);
		index = _tmp60_;
		_tmp61_ = index;
		if (_tmp61_ < 0) {
			const gchar* _tmp62_;
			gchar* _tmp63_;
			_tmp62_ = skk_tool_skkserv;
			_tmp63_ = g_strdup (_tmp62_);
			_g_free0 (host);
			host = _tmp63_;
			port = (guint16) 1178;
		} else {
			const gchar* _tmp64_;
			gint _tmp65_;
			gchar* _tmp66_ = NULL;
			const gchar* _tmp67_;
			gint _tmp68_;
			const gchar* _tmp69_;
			gint _tmp70_;
			gint _tmp71_;
			gchar* _tmp72_ = NULL;
			gchar* _tmp73_;
			gint _tmp74_ = 0;
			_tmp64_ = skk_tool_skkserv;
			_tmp65_ = index;
			_tmp66_ = string_slice (_tmp64_, (glong) 0, (glong) _tmp65_);
			_g_free0 (host);
			host = _tmp66_;
			_tmp67_ = skk_tool_skkserv;
			_tmp68_ = index;
			_tmp69_ = skk_tool_skkserv;
			_tmp70_ = strlen (_tmp69_);
			_tmp71_ = _tmp70_;
			_tmp72_ = string_slice (_tmp67_, (glong) (_tmp68_ + 1), (glong) _tmp71_);
			_tmp73_ = _tmp72_;
			_tmp74_ = atoi (_tmp73_);
			port = (guint16) _tmp74_;
			_g_free0 (_tmp73_);
		}
		{
			const gchar* _tmp75_;
			guint16 _tmp76_;
			SkkSkkServ* _tmp77_;
			SkkSkkServ* _tmp78_;
			GeeArrayList* _tmp79_;
			SkkSkkServ* _tmp80_;
			_tmp75_ = host;
			_tmp76_ = port;
			_tmp77_ = skk_skk_serv_new (_tmp75_, _tmp76_, "EUC-JP", &_inner_error_);
			_tmp78_ = _tmp77_;
			if (_inner_error_ != NULL) {
				goto __catch4_g_error;
			}
			_tmp79_ = dictionaries;
			_tmp80_ = _tmp78_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp79_, (SkkDict*) _tmp80_);
			_g_object_unref0 (_tmp80_);
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			FILE* _tmp81_;
			const gchar* _tmp82_;
			guint16 _tmp83_;
			GError* _tmp84_;
			const gchar* _tmp85_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp81_ = stderr;
			_tmp82_ = host;
			_tmp83_ = port;
			_tmp84_ = e;
			_tmp85_ = _tmp84_->message;
			fprintf (_tmp81_, "can't connect to skkserv at %s:%d: %s", _tmp82_, (gint) _tmp83_, _tmp85_);
			result = 1;
			_g_error_free0 (e);
			_g_free0 (host);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally4:
		if (_inner_error_ != NULL) {
			_g_free0 (host);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_free0 (host);
	}
	_tmp86_ = dictionaries;
	_tmp88_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp86_, &_tmp87_);
	_tmp89_ = _tmp88_;
	_tmp89__length1 = _tmp87_;
	_tmp90_ = skk_context_new (_tmp89_, _tmp87_);
	_tmp91_ = _tmp90_;
	_tmp89_ = (_vala_array_free (_tmp89_, _tmp89__length1, (GDestroyNotify) g_object_unref), NULL);
	context = _tmp91_;
	_tmp92_ = skk_tool_typing_rule;
	if (_tmp92_ != NULL) {
		{
			const gchar* _tmp93_;
			SkkRule* _tmp94_;
			SkkRule* _tmp95_;
			SkkContext* _tmp96_;
			SkkRule* _tmp97_;
			_tmp93_ = skk_tool_typing_rule;
			_tmp94_ = skk_rule_new (_tmp93_, &_inner_error_);
			_tmp95_ = _tmp94_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
					goto __catch5_skk_rule_parse_error;
				}
				_g_object_unref0 (context);
				_g_object_unref0 (dictionaries);
				_g_option_context_free0 (option_context);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_tmp96_ = context;
			_tmp97_ = _tmp95_;
			skk_context_set_typing_rule (_tmp96_, _tmp97_);
			_g_object_unref0 (_tmp97_);
		}
		goto __finally5;
		__catch5_skk_rule_parse_error:
		{
			GError* e = NULL;
			FILE* _tmp98_;
			const gchar* _tmp99_;
			GError* _tmp100_;
			const gchar* _tmp101_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp98_ = stderr;
			_tmp99_ = skk_tool_typing_rule;
			_tmp100_ = e;
			_tmp101_ = _tmp100_->message;
			fprintf (_tmp98_, "can't load rule \"%s\": %s\n", _tmp99_, _tmp101_);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (context);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally5:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (context);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp102_ = context;
	_tmp103_ = skk_fep_tool_new (_tmp102_, &_inner_error_);
	tool = _tmp103_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (context);
		_g_object_unref0 (dictionaries);
		_g_option_context_free0 (option_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp104_ = tool;
	_tmp105_ = skk_tool_run ((SkkTool*) _tmp104_);
	if (!_tmp105_) {
		result = 1;
		_g_object_unref0 (tool);
		_g_object_unref0 (context);
		_g_object_unref0 (dictionaries);
		_g_option_context_free0 (option_context);
		return result;
	}
	result = 0;
	_g_object_unref0 (tool);
	_g_object_unref0 (context);
	_g_object_unref0 (dictionaries);
	_g_option_context_free0 (option_context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return skk_tool_main (argv, argc);
}


static gboolean skk_tool_real_run (SkkTool* self) {
	g_critical ("Type `%s' does not implement abstract method `skk_tool_run'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean skk_tool_run (SkkTool* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return SKK_TOOL_GET_CLASS (self)->run (self);
}


SkkTool* skk_tool_construct (GType object_type) {
	SkkTool * self = NULL;
	self = (SkkTool*) g_object_new (object_type, NULL);
	return self;
}


static void skk_tool_class_init (SkkToolClass * klass) {
	skk_tool_parent_class = g_type_class_peek_parent (klass);
	SKK_TOOL_CLASS (klass)->run = skk_tool_real_run;
	G_OBJECT_CLASS (klass)->finalize = skk_tool_finalize;
}


static void skk_tool_instance_init (SkkTool * self) {
}


static void skk_tool_finalize (GObject* obj) {
	SkkTool * self;
	self = SKK_TOOL (obj);
	G_OBJECT_CLASS (skk_tool_parent_class)->finalize (obj);
}


GType skk_tool_get_type (void) {
	static volatile gsize skk_tool_type_id__volatile = 0;
	if (g_once_init_enter (&skk_tool_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkTool), 0, (GInstanceInitFunc) skk_tool_instance_init, NULL };
		GType skk_tool_type_id;
		skk_tool_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkTool", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&skk_tool_type_id__volatile, skk_tool_type_id);
	}
	return skk_tool_type_id__volatile;
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gboolean skk_fep_tool_process_lookup_table_key_event (SkkFepTool* self, guint keyval, guint state) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
	gboolean _tmp6_;
	guint _tmp31_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = state;
	if (_tmp1_ == ((guint) 0)) {
		guint _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		_tmp2_ = keyval;
		_tmp3_ = g_unichar_to_string ((gunichar) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->LOOKUP_TABLE_LABELS;
		_tmp5__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
		_tmp0_ = _vala_string_array_contains (_tmp5_, _tmp5__length1, _tmp4_);
		_g_free0 (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		guint _tmp7_;
		gunichar _tmp8_ = 0U;
		gchar* _tmp9_ = NULL;
		gchar* label;
		SkkContext* _tmp10_;
		SkkCandidateList* _tmp11_;
		SkkCandidateList* _tmp12_;
		guint _tmp13_;
		guint _tmp14_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		gint _tmp16_ = 0;
		gint end;
		_tmp7_ = keyval;
		_tmp8_ = g_unichar_tolower ((gunichar) _tmp7_);
		_tmp9_ = g_unichar_to_string (_tmp8_);
		label = _tmp9_;
		_tmp10_ = self->priv->context;
		_tmp11_ = skk_context_get_candidates (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = skk_candidate_list_get_page_size (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = self->priv->LOOKUP_TABLE_LABELS;
		_tmp15__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
		_tmp16_ = MIN ((gint) _tmp14_, _tmp15__length1);
		end = _tmp16_;
		{
			gint index;
			index = 0;
			{
				gboolean _tmp17_;
				_tmp17_ = TRUE;
				while (TRUE) {
					gboolean _tmp18_;
					gint _tmp20_;
					gint _tmp21_;
					gchar** _tmp22_;
					gint _tmp22__length1;
					gint _tmp23_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					_tmp18_ = _tmp17_;
					if (!_tmp18_) {
						gint _tmp19_;
						_tmp19_ = index;
						index = _tmp19_ + 1;
					}
					_tmp17_ = FALSE;
					_tmp20_ = index;
					_tmp21_ = end;
					if (!(_tmp20_ < _tmp21_)) {
						break;
					}
					_tmp22_ = self->priv->LOOKUP_TABLE_LABELS;
					_tmp22__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
					_tmp23_ = index;
					_tmp24_ = _tmp22_[_tmp23_];
					_tmp25_ = label;
					if (g_strcmp0 (_tmp24_, _tmp25_) == 0) {
						SkkContext* _tmp26_;
						SkkCandidateList* _tmp27_;
						SkkCandidateList* _tmp28_;
						gint _tmp29_;
						gboolean _tmp30_ = FALSE;
						_tmp26_ = self->priv->context;
						_tmp27_ = skk_context_get_candidates (_tmp26_);
						_tmp28_ = _tmp27_;
						_tmp29_ = index;
						_tmp30_ = skk_candidate_list_select_at (_tmp28_, (guint) _tmp29_);
						result = _tmp30_;
						_g_free0 (label);
						return result;
					}
				}
			}
		}
		result = FALSE;
		_g_free0 (label);
		return result;
	}
	_tmp31_ = state;
	if (_tmp31_ == ((guint) 0)) {
		gboolean retval;
		guint _tmp32_;
		gboolean _tmp49_;
		retval = FALSE;
		_tmp32_ = keyval;
		switch (_tmp32_) {
			case SKK_KEYSYMS_Page_Up:
			case SKK_KEYSYMS_KP_Page_Up:
			{
				SkkContext* _tmp33_;
				SkkCandidateList* _tmp34_;
				SkkCandidateList* _tmp35_;
				gboolean _tmp36_ = FALSE;
				_tmp33_ = self->priv->context;
				_tmp34_ = skk_context_get_candidates (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = skk_candidate_list_page_up (_tmp35_);
				retval = _tmp36_;
				break;
			}
			case SKK_KEYSYMS_Page_Down:
			case SKK_KEYSYMS_KP_Page_Down:
			{
				SkkContext* _tmp37_;
				SkkCandidateList* _tmp38_;
				SkkCandidateList* _tmp39_;
				gboolean _tmp40_ = FALSE;
				_tmp37_ = self->priv->context;
				_tmp38_ = skk_context_get_candidates (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = skk_candidate_list_page_down (_tmp39_);
				retval = _tmp40_;
				break;
			}
			case SKK_KEYSYMS_Up:
			case SKK_KEYSYMS_Left:
			{
				SkkContext* _tmp41_;
				SkkCandidateList* _tmp42_;
				SkkCandidateList* _tmp43_;
				gboolean _tmp44_ = FALSE;
				_tmp41_ = self->priv->context;
				_tmp42_ = skk_context_get_candidates (_tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = skk_candidate_list_cursor_up (_tmp43_);
				retval = _tmp44_;
				break;
			}
			case SKK_KEYSYMS_Down:
			case SKK_KEYSYMS_Right:
			{
				SkkContext* _tmp45_;
				SkkCandidateList* _tmp46_;
				SkkCandidateList* _tmp47_;
				gboolean _tmp48_ = FALSE;
				_tmp45_ = self->priv->context;
				_tmp46_ = skk_context_get_candidates (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = skk_candidate_list_cursor_down (_tmp47_);
				retval = _tmp48_;
				break;
			}
			default:
			{
				break;
			}
		}
		_tmp49_ = retval;
		if (_tmp49_) {
			skk_fep_tool_set_lookup_table_cursor_pos (self);
			skk_fep_tool_update_preedit (self);
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gboolean skk_fep_tool_filter_key_event (SkkFepTool* self, guint keyval, guint modifiers) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp5_;
	SkkKeyEvent* key = NULL;
	SkkContext* _tmp10_;
	SkkKeyEvent* _tmp11_;
	gboolean _tmp12_ = FALSE;
	gboolean retval;
	SkkContext* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* output;
	const gchar* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->lookup_table_visible;
	if (_tmp1_) {
		guint _tmp2_;
		guint _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = keyval;
		_tmp3_ = modifiers;
		_tmp4_ = skk_fep_tool_process_lookup_table_key_event (self, _tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		result = TRUE;
		return result;
	}
	{
		guint _tmp6_;
		guint _tmp7_;
		SkkKeyEvent* _tmp8_;
		SkkKeyEvent* _tmp9_;
		_tmp6_ = keyval;
		_tmp7_ = modifiers;
		_tmp8_ = skk_key_event_new_from_x_keysym (_tmp6_, (SkkModifierType) _tmp7_, &_inner_error_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SKK_KEY_EVENT_FORMAT_ERROR) {
				goto __catch6_skk_key_event_format_error;
			}
			_g_object_unref0 (key);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (key);
		key = _tmp9_;
	}
	goto __finally6;
	__catch6_skk_key_event_format_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (key);
		return result;
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp10_ = self->priv->context;
	_tmp11_ = key;
	_tmp12_ = skk_context_process_key_event (_tmp10_, _tmp11_);
	retval = _tmp12_;
	_tmp13_ = self->priv->context;
	_tmp14_ = skk_context_poll_output (_tmp13_);
	output = _tmp14_;
	_tmp15_ = output;
	_tmp16_ = strlen (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ > 0) {
		FepGClient* _tmp18_;
		const gchar* _tmp19_;
		_tmp18_ = self->priv->client;
		_tmp19_ = output;
		fep_g_client_send_text (_tmp18_, _tmp19_);
	}
	result = retval;
	_g_free0 (output);
	_g_object_unref0 (key);
	return result;
}


static void skk_fep_tool_update_preedit (SkkFepTool* self) {
	SkkContext* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	FepGClient* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_preedit (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->preedit);
	self->priv->preedit = _tmp3_;
	_tmp4_ = self->priv->client;
	_tmp5_ = self->priv->preedit;
	fep_g_client_set_cursor_text (_tmp4_, _tmp5_, NULL);
}


static FepGAttribute* _fep_g_attribute_dup (FepGAttribute* self) {
	FepGAttribute* dup;
	dup = g_new0 (FepGAttribute, 1);
	memcpy (dup, self, sizeof (FepGAttribute));
	return dup;
}


static gpointer __fep_g_attribute_dup0 (gpointer self) {
	return self ? _fep_g_attribute_dup (self) : NULL;
}


static gboolean _fep_g_attribute_equal (const FepGAttribute* s1, const FepGAttribute* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->type != s2->type) {
		return FALSE;
	}
	if (s1->value != s2->value) {
		return FALSE;
	}
	if (s1->start_index != s2->start_index) {
		return FALSE;
	}
	if (s1->end_index != s2->end_index) {
		return FALSE;
	}
	return TRUE;
}


static void skk_fep_tool_update_status (SkkFepTool* self) {
	GString* _tmp0_;
	GString* builder;
	FepGAttribute* attr;
	SkkContext* _tmp1_;
	SkkInputMode _tmp2_;
	SkkInputMode _tmp3_;
	gboolean _tmp14_;
	gboolean _tmp92_ = FALSE;
	const gchar* _tmp93_;
	GString* _tmp94_;
	const gchar* _tmp95_;
	gboolean _tmp98_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	attr = NULL;
	_tmp1_ = self->priv->context;
	_tmp2_ = skk_context_get_input_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->input_mode = _tmp3_;
	{
		SkkFepToolEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = SKK_FEP_TOOL_input_mode_labels;
		entry_collection_length1 = G_N_ELEMENTS (SKK_FEP_TOOL_input_mode_labels);
		for (entry_it = 0; entry_it < G_N_ELEMENTS (SKK_FEP_TOOL_input_mode_labels); entry_it = entry_it + 1) {
			SkkFepToolEntry entry = {0};
			entry = entry_collection[entry_it];
			{
				SkkFepToolEntry _tmp4_;
				gconstpointer _tmp5_;
				SkkInputMode _tmp6_;
				_tmp4_ = entry;
				_tmp5_ = _tmp4_.key;
				_tmp6_ = self->priv->input_mode;
				if (GPOINTER_TO_INT (_tmp5_) == _tmp6_) {
					GString* _tmp7_;
					SkkFepToolEntry _tmp8_;
					gconstpointer _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp7_ = builder;
					_tmp8_ = entry;
					_tmp9_ = _tmp8_.value;
					_tmp10_ = g_strconcat ("[", (const gchar*) _tmp9_, NULL);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_strconcat (_tmp11_, "] ", NULL);
					_tmp13_ = _tmp12_;
					g_string_append (_tmp7_, _tmp13_);
					_g_free0 (_tmp13_);
					_g_free0 (_tmp11_);
					break;
				}
			}
		}
	}
	_tmp14_ = self->priv->lookup_table_visible;
	if (_tmp14_) {
		SkkContext* _tmp15_;
		SkkCandidateList* _tmp16_;
		SkkCandidateList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		SkkContext* _tmp20_;
		SkkCandidateList* _tmp21_;
		SkkCandidateList* _tmp22_;
		guint _tmp23_;
		guint _tmp24_;
		SkkContext* _tmp25_;
		SkkCandidateList* _tmp26_;
		SkkCandidateList* _tmp27_;
		guint _tmp28_;
		guint _tmp29_;
		guint pages;
		guint _tmp30_;
		SkkContext* _tmp31_;
		SkkCandidateList* _tmp32_;
		SkkCandidateList* _tmp33_;
		guint _tmp34_;
		guint _tmp35_;
		SkkContext* _tmp36_;
		SkkCandidateList* _tmp37_;
		SkkCandidateList* _tmp38_;
		guint _tmp39_;
		guint _tmp40_;
		guint start;
		guint _tmp41_;
		SkkContext* _tmp42_;
		SkkCandidateList* _tmp43_;
		SkkCandidateList* _tmp44_;
		guint _tmp45_;
		guint _tmp46_;
		SkkContext* _tmp47_;
		SkkCandidateList* _tmp48_;
		SkkCandidateList* _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		guint _tmp52_ = 0U;
		guint end;
		_tmp15_ = self->priv->context;
		_tmp16_ = skk_context_get_candidates (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = skk_candidate_list_get_cursor_pos (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = self->priv->context;
		_tmp21_ = skk_context_get_candidates (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = skk_candidate_list_get_page_start (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->context;
		_tmp26_ = skk_context_get_candidates (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = skk_candidate_list_get_page_size (_tmp27_);
		_tmp29_ = _tmp28_;
		pages = (_tmp19_ - _tmp24_) / _tmp29_;
		_tmp30_ = pages;
		_tmp31_ = self->priv->context;
		_tmp32_ = skk_context_get_candidates (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = skk_candidate_list_get_page_size (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = self->priv->context;
		_tmp37_ = skk_context_get_candidates (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = skk_candidate_list_get_page_start (_tmp38_);
		_tmp40_ = _tmp39_;
		start = (_tmp30_ * _tmp35_) + _tmp40_;
		_tmp41_ = start;
		_tmp42_ = self->priv->context;
		_tmp43_ = skk_context_get_candidates (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = skk_candidate_list_get_page_size (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = self->priv->context;
		_tmp48_ = skk_context_get_candidates (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = skk_candidate_list_get_size (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = MIN (_tmp41_ + _tmp46_, (guint) _tmp51_);
		end = _tmp52_;
		{
			guint _tmp53_;
			guint index;
			_tmp53_ = start;
			index = _tmp53_;
			{
				gboolean _tmp54_;
				_tmp54_ = TRUE;
				while (TRUE) {
					gboolean _tmp55_;
					guint _tmp57_;
					guint _tmp58_;
					SkkContext* _tmp59_;
					SkkCandidateList* _tmp60_;
					SkkCandidateList* _tmp61_;
					guint _tmp62_;
					SkkCandidate* _tmp63_ = NULL;
					SkkCandidate* candidate;
					gchar** _tmp64_;
					gint _tmp64__length1;
					guint _tmp65_;
					guint _tmp66_;
					const gchar* _tmp67_;
					SkkCandidate* _tmp68_;
					const gchar* _tmp69_;
					const gchar* _tmp70_;
					gchar* _tmp71_ = NULL;
					gchar* text;
					guint _tmp72_;
					SkkContext* _tmp73_;
					SkkCandidateList* _tmp74_;
					SkkCandidateList* _tmp75_;
					gint _tmp76_;
					gint _tmp77_;
					GString* _tmp87_;
					const gchar* _tmp88_;
					guint _tmp89_;
					guint _tmp90_;
					_tmp55_ = _tmp54_;
					if (!_tmp55_) {
						guint _tmp56_;
						_tmp56_ = index;
						index = _tmp56_ + 1;
					}
					_tmp54_ = FALSE;
					_tmp57_ = index;
					_tmp58_ = end;
					if (!(_tmp57_ < _tmp58_)) {
						break;
					}
					_tmp59_ = self->priv->context;
					_tmp60_ = skk_context_get_candidates (_tmp59_);
					_tmp61_ = _tmp60_;
					_tmp62_ = index;
					_tmp63_ = skk_candidate_list_get (_tmp61_, (gint) _tmp62_);
					candidate = _tmp63_;
					_tmp64_ = self->priv->LOOKUP_TABLE_LABELS;
					_tmp64__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
					_tmp65_ = index;
					_tmp66_ = start;
					_tmp67_ = _tmp64_[_tmp65_ - _tmp66_];
					_tmp68_ = candidate;
					_tmp69_ = skk_candidate_get_text (_tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = g_strdup_printf ("%s: %s", _tmp67_, _tmp70_);
					text = _tmp71_;
					_tmp72_ = index;
					_tmp73_ = self->priv->context;
					_tmp74_ = skk_context_get_candidates (_tmp73_);
					_tmp75_ = _tmp74_;
					_tmp76_ = skk_candidate_list_get_cursor_pos (_tmp75_);
					_tmp77_ = _tmp76_;
					if (_tmp72_ == ((guint) _tmp77_)) {
						GString* _tmp78_;
						const gchar* _tmp79_;
						gint _tmp80_ = 0;
						gint start_index;
						gint _tmp81_;
						gint _tmp82_;
						const gchar* _tmp83_;
						gint _tmp84_ = 0;
						FepGAttribute _tmp85_ = {0};
						FepGAttribute* _tmp86_;
						_tmp78_ = builder;
						_tmp79_ = _tmp78_->str;
						_tmp80_ = g_utf8_strlen (_tmp79_, (gssize) (-1));
						start_index = _tmp80_;
						_tmp81_ = start_index;
						_tmp82_ = start_index;
						_tmp83_ = text;
						_tmp84_ = g_utf8_strlen (_tmp83_, (gssize) (-1));
						memset (&_tmp85_, 0, sizeof (FepGAttribute));
						_tmp85_.type = FEP_G_ATTR_TYPE_STANDOUT;
						_tmp85_.value = (guint) 1;
						_tmp85_.start_index = (guint) _tmp81_;
						_tmp85_.end_index = (guint) (_tmp82_ + _tmp84_);
						_tmp86_ = __fep_g_attribute_dup0 (&_tmp85_);
						_g_free0 (attr);
						attr = _tmp86_;
					}
					_tmp87_ = builder;
					_tmp88_ = text;
					g_string_append (_tmp87_, _tmp88_);
					_tmp89_ = index;
					_tmp90_ = end;
					if (_tmp89_ < (_tmp90_ - 1)) {
						GString* _tmp91_;
						_tmp91_ = builder;
						g_string_append_c (_tmp91_, ' ');
					}
					_g_free0 (text);
					_g_object_unref0 (candidate);
				}
			}
		}
	}
	_tmp93_ = self->priv->status;
	_tmp94_ = builder;
	_tmp95_ = _tmp94_->str;
	if (g_strcmp0 (_tmp93_, _tmp95_) != 0) {
		_tmp92_ = TRUE;
	} else {
		FepGAttribute* _tmp96_;
		FepGAttribute* _tmp97_;
		_tmp96_ = self->priv->status_attr;
		_tmp97_ = attr;
		_tmp92_ = _fep_g_attribute_equal (_tmp96_, _tmp97_) != TRUE;
	}
	_tmp98_ = _tmp92_;
	if (_tmp98_) {
		FepGClient* _tmp99_;
		GString* _tmp100_;
		const gchar* _tmp101_;
		FepGAttribute* _tmp102_;
		GString* _tmp103_;
		const gchar* _tmp104_;
		gchar* _tmp105_;
		FepGAttribute* _tmp106_;
		FepGAttribute* _tmp107_;
		_tmp99_ = self->priv->client;
		_tmp100_ = builder;
		_tmp101_ = _tmp100_->str;
		_tmp102_ = attr;
		fep_g_client_set_status_text (_tmp99_, _tmp101_, _tmp102_);
		_tmp103_ = builder;
		_tmp104_ = _tmp103_->str;
		_tmp105_ = g_strdup (_tmp104_);
		_g_free0 (self->priv->status);
		self->priv->status = _tmp105_;
		_tmp106_ = attr;
		_tmp107_ = __fep_g_attribute_dup0 (_tmp106_);
		_g_free0 (self->priv->status_attr);
		self->priv->status_attr = _tmp107_;
	}
	_g_free0 (attr);
	_g_string_free0 (builder);
}


static void skk_fep_tool_populate_lookup_table (SkkFepTool* self) {
	g_return_if_fail (self != NULL);
}


static void skk_fep_tool_set_lookup_table_cursor_pos (SkkFepTool* self) {
	SkkContext* _tmp0_;
	SkkCandidateList* _tmp1_;
	SkkCandidateList* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = skk_candidate_list_get_page_visible (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		self->priv->lookup_table_visible = TRUE;
	} else {
		gboolean _tmp5_;
		_tmp5_ = self->priv->lookup_table_visible;
		if (_tmp5_) {
			self->priv->lookup_table_visible = FALSE;
		}
	}
	skk_fep_tool_update_status (self);
}


static gboolean skk_fep_tool_watch_func (SkkFepTool* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	FepGClient* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = self->priv->client;
	fep_g_client_dispatch (_tmp0_);
	result = TRUE;
	return result;
}


static gboolean __lambda0_ (SkkFepTool* self, guint keyval, guint _modifiers) {
	gboolean result = FALSE;
	guint _tmp0_;
	guint _tmp1_;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = keyval;
	_tmp1_ = _modifiers;
	_tmp2_ = skk_fep_tool_filter_key_event (self, _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static gboolean ___lambda0__fep_g_client_filter_key_event (FepGClient* _sender, guint keyval, guint modifiers, gpointer self) {
	gboolean result;
	result = __lambda0_ (self, keyval, modifiers);
	return result;
}


static void __lambda1_ (SkkFepTool* self) {
	SkkContext* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_preedit (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->preedit;
	if (g_strcmp0 (_tmp2_, _tmp3_) != 0) {
		skk_fep_tool_update_preedit (self);
	}
}


static void ___lambda1__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda1_ (self);
}


static void __lambda2_ (SkkFepTool* self) {
	SkkContext* _tmp0_;
	SkkInputMode _tmp1_;
	SkkInputMode _tmp2_;
	SkkInputMode _tmp3_;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_input_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->input_mode;
	if (_tmp2_ != _tmp3_) {
		skk_fep_tool_update_status (self);
	}
}


static void ___lambda2__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda2_ (self);
}


static void __lambda3_ (SkkFepTool* self) {
	skk_fep_tool_populate_lookup_table (self);
}


static void ___lambda3__skk_candidate_list_populated (SkkCandidateList* _sender, gpointer self) {
	__lambda3_ (self);
}


static void __lambda4_ (SkkFepTool* self) {
	skk_fep_tool_set_lookup_table_cursor_pos (self);
}


static void ___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda4_ (self);
}


static void __lambda5_ (SkkFepTool* self) {
	SkkContext* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* output;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_poll_output (_tmp0_);
	output = _tmp1_;
	_tmp2_ = output;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		FepGClient* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = self->priv->client;
		_tmp6_ = output;
		fep_g_client_send_text (_tmp5_, _tmp6_);
	}
	self->priv->lookup_table_visible = FALSE;
	skk_fep_tool_update_status (self);
	_g_free0 (output);
}


static void ___lambda5__skk_candidate_list_selected (SkkCandidateList* _sender, SkkCandidate* candidate, gpointer self) {
	__lambda5_ (self);
}


static gboolean _skk_fep_tool_watch_func_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = skk_fep_tool_watch_func (self, source, condition);
	return result;
}


static gboolean skk_fep_tool_real_run (SkkTool* base) {
	SkkFepTool * self;
	gboolean result = FALSE;
	FepGClient* _tmp0_;
	SkkContext* _tmp1_;
	SkkContext* _tmp2_;
	SkkContext* _tmp3_;
	SkkCandidateList* _tmp4_;
	SkkCandidateList* _tmp5_;
	SkkContext* _tmp6_;
	SkkCandidateList* _tmp7_;
	SkkCandidateList* _tmp8_;
	SkkContext* _tmp9_;
	SkkCandidateList* _tmp10_;
	SkkCandidateList* _tmp11_;
	FepGClient* _tmp12_;
	gint _tmp13_ = 0;
	GIOChannel* _tmp14_;
	GIOChannel* channel;
	GMainLoop* _tmp15_;
	GMainLoop* loop;
	self = (SkkFepTool*) base;
	_tmp0_ = self->priv->client;
	g_signal_connect_object (_tmp0_, "filter-key-event", (GCallback) ___lambda0__fep_g_client_filter_key_event, self, 0);
	_tmp1_ = self->priv->context;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::preedit", (GCallback) ___lambda1__g_object_notify, self, 0);
	_tmp2_ = self->priv->context;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::input-mode", (GCallback) ___lambda2__g_object_notify, self, 0);
	_tmp3_ = self->priv->context;
	_tmp4_ = skk_context_get_candidates (_tmp3_);
	_tmp5_ = _tmp4_;
	g_signal_connect_object (_tmp5_, "populated", (GCallback) ___lambda3__skk_candidate_list_populated, self, 0);
	_tmp6_ = self->priv->context;
	_tmp7_ = skk_context_get_candidates (_tmp6_);
	_tmp8_ = _tmp7_;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::cursor-pos", (GCallback) ___lambda4__g_object_notify, self, 0);
	_tmp9_ = self->priv->context;
	_tmp10_ = skk_context_get_candidates (_tmp9_);
	_tmp11_ = _tmp10_;
	g_signal_connect_object (_tmp11_, "selected", (GCallback) ___lambda5__skk_candidate_list_selected, self, 0);
	skk_fep_tool_update_preedit (self);
	skk_fep_tool_update_status (self);
	_tmp12_ = self->priv->client;
	_tmp13_ = fep_g_client_get_poll_fd (_tmp12_);
	_tmp14_ = g_io_channel_unix_new (_tmp13_);
	channel = _tmp14_;
	g_io_add_watch (channel, G_IO_IN, _skk_fep_tool_watch_func_gio_func, self);
	_tmp15_ = g_main_loop_new (NULL, TRUE);
	loop = _tmp15_;
	g_main_loop_run (loop);
	result = TRUE;
	_g_main_loop_unref0 (loop);
	_g_io_channel_unref0 (channel);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


SkkFepTool* skk_fep_tool_construct (GType object_type, SkkContext* context, GError** error) {
	SkkFepTool * self = NULL;
	SkkContext* _tmp0_;
	SkkContext* _tmp1_;
	FepGClient* _tmp2_;
	FepGClient* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (context != NULL, NULL);
	self = (SkkFepTool*) skk_tool_construct (object_type);
	_tmp0_ = context;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp1_;
	_tmp2_ = fep_g_client_new (NULL, NULL, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_g_object_unref0 (self->priv->client);
	self->priv->client = _tmp3_;
	return self;
}


SkkFepTool* skk_fep_tool_new (SkkContext* context, GError** error) {
	return skk_fep_tool_construct (SKK_TYPE_FEP_TOOL, context, error);
}


static void skk_fep_tool_entry_copy (const SkkFepToolEntry* self, SkkFepToolEntry* dest) {
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	_tmp0_ = (*self).key;
	(*dest).key = _tmp0_;
	_tmp1_ = (*self).value;
	(*dest).value = _tmp1_;
}


static void skk_fep_tool_entry_destroy (SkkFepToolEntry* self) {
}


static SkkFepToolEntry* skk_fep_tool_entry_dup (const SkkFepToolEntry* self) {
	SkkFepToolEntry* dup;
	dup = g_new0 (SkkFepToolEntry, 1);
	skk_fep_tool_entry_copy (self, dup);
	return dup;
}


static void skk_fep_tool_entry_free (SkkFepToolEntry* self) {
	skk_fep_tool_entry_destroy (self);
	g_free (self);
}


static GType skk_fep_tool_entry_get_type (void) {
	static volatile gsize skk_fep_tool_entry_type_id__volatile = 0;
	if (g_once_init_enter (&skk_fep_tool_entry_type_id__volatile)) {
		GType skk_fep_tool_entry_type_id;
		skk_fep_tool_entry_type_id = g_boxed_type_register_static ("SkkFepToolEntry", (GBoxedCopyFunc) skk_fep_tool_entry_dup, (GBoxedFreeFunc) skk_fep_tool_entry_free);
		g_once_init_leave (&skk_fep_tool_entry_type_id__volatile, skk_fep_tool_entry_type_id);
	}
	return skk_fep_tool_entry_type_id__volatile;
}


static void skk_fep_tool_class_init (SkkFepToolClass * klass) {
	skk_fep_tool_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SkkFepToolPrivate));
	SKK_TOOL_CLASS (klass)->run = skk_fep_tool_real_run;
	G_OBJECT_CLASS (klass)->finalize = skk_fep_tool_finalize;
}


static void skk_fep_tool_instance_init (SkkFepTool * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_;
	self->priv = SKK_FEP_TOOL_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("a");
	_tmp1_ = g_strdup ("s");
	_tmp2_ = g_strdup ("d");
	_tmp3_ = g_strdup ("f");
	_tmp4_ = g_strdup ("j");
	_tmp5_ = g_strdup ("k");
	_tmp6_ = g_strdup ("l");
	_tmp7_ = g_strdup ("q");
	_tmp8_ = g_strdup ("w");
	_tmp9_ = g_strdup ("e");
	_tmp10_ = g_strdup ("r");
	_tmp11_ = g_strdup ("u");
	_tmp12_ = g_strdup ("i");
	_tmp13_ = g_strdup ("o");
	_tmp14_ = g_new0 (gchar*, 14 + 1);
	_tmp14_[0] = _tmp0_;
	_tmp14_[1] = _tmp1_;
	_tmp14_[2] = _tmp2_;
	_tmp14_[3] = _tmp3_;
	_tmp14_[4] = _tmp4_;
	_tmp14_[5] = _tmp5_;
	_tmp14_[6] = _tmp6_;
	_tmp14_[7] = _tmp7_;
	_tmp14_[8] = _tmp8_;
	_tmp14_[9] = _tmp9_;
	_tmp14_[10] = _tmp10_;
	_tmp14_[11] = _tmp11_;
	_tmp14_[12] = _tmp12_;
	_tmp14_[13] = _tmp13_;
	self->priv->LOOKUP_TABLE_LABELS = _tmp14_;
	self->priv->LOOKUP_TABLE_LABELS_length1 = 14;
	self->priv->_LOOKUP_TABLE_LABELS_size_ = self->priv->LOOKUP_TABLE_LABELS_length1;
	self->priv->lookup_table_visible = FALSE;
	_tmp15_ = g_strdup ("");
	self->priv->preedit = _tmp15_;
	_tmp16_ = g_strdup ("");
	self->priv->status = _tmp16_;
	self->priv->status_attr = NULL;
	self->priv->input_mode = SKK_INPUT_MODE_HIRAGANA;
}


static void skk_fep_tool_finalize (GObject* obj) {
	SkkFepTool * self;
	self = SKK_FEP_TOOL (obj);
	_g_object_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->client);
	self->priv->LOOKUP_TABLE_LABELS = (_vala_array_free (self->priv->LOOKUP_TABLE_LABELS, self->priv->LOOKUP_TABLE_LABELS_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->preedit);
	_g_free0 (self->priv->status);
	_g_free0 (self->priv->status_attr);
	G_OBJECT_CLASS (skk_fep_tool_parent_class)->finalize (obj);
}


GType skk_fep_tool_get_type (void) {
	static volatile gsize skk_fep_tool_type_id__volatile = 0;
	if (g_once_init_enter (&skk_fep_tool_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkFepToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_fep_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkFepTool), 0, (GInstanceInitFunc) skk_fep_tool_instance_init, NULL };
		GType skk_fep_tool_type_id;
		skk_fep_tool_type_id = g_type_register_static (SKK_TYPE_TOOL, "SkkFepTool", &g_define_type_info, 0);
		g_once_init_leave (&skk_fep_tool_type_id__volatile, skk_fep_tool_type_id);
	}
	return skk_fep_tool_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



